(******************************************************************************)
(* Copyright (c) 1988 by GMD Karlruhe, Germany				      *)
(* Gesellschaft fuer Mathematik und Datenverarbeitung			      *)
(* (German National Research Center for Computer Science)		      *)
(* Forschungsstelle fuer Programmstrukturen an Universitaet Karlsruhe	      *)
(* All rights reserved.							      *)
(* Don't modify this file under any circumstances			      *)
(******************************************************************************)

FOREIGN MODULE Signals;

  FROM SysLib IMPORT
     SIGNED;
  
  CONST
     SIGHUP    = 1;      (* hangup *)
     SIGINT    = 2;      (* interrupt *)
     SIGQUIT   = 3;      (* quit *)
     SIGILL    = 4;      (* illegal instruction *)
     SIGTRAP   = 5;      (* trace or breakpoint *)
     SIGIOT    = 6;      (* IOT instruction *)
     SIGABRT   = 6;      (* abort *)
     SIGEMT    = 7;      (* ETT instruction *)
     SIGFPE    = 8;      (* floating exception *)
     SIGKILL   = 9;      (* kill, uncatchable termination *)
     SIGBUS    = 10;     (* bus error *)
     SIGSEGV   = 11;     (* segmentation violation *)
     SIGSYS    = 12;     (* bad argument to system call *)
     SIGPIPE   = 13;     (* end of pipe *)
     SIGALRM   = 14;     (* alarm clock *)
     SIGTERM   = 15;     (* software termination signal *)
     SIGURG    = 16;     (* urgent condition on IO channel *)
     SIGSTOP   = 17;     (* sendable stop signal not from tty *)
     SIGTSTP   = 18;     (* stop signal from tty *)
     SIGCONT   = 19;     (* continue a stopped process *)
     SIGCHLD   = 20;     (* to parent on child stop or exit *)
     SIGCLD    = 20;     (* System V name for SIGCHLD *)
     SIGTTIN   = 21;     (* to readers pgrp upon background tty read *)
     SIGTTOU   = 22;     (* like TTIN for output *)
     SIGIO     = 23;     (* input/output possible signal *)
     SIGPOLL   = 23;     (* System V name for SIGIO *)
     SIGXCPU   = 24;     (* exceeded CPU time limit *)
     SIGXFSZ   = 25;     (* exceeded file size limit *)
     SIGVTALRM = 26;	 (* virtual time alarm *)
     SIGPROF   = 27;     (* profiling time alarm *)
     SIGWINCH  = 28;	 (* window changed *)
     SIGLOST   = 29;     (* resource lost (eg, record-lock lost) *)
     SIGUSR1   = 30;     (* user defined signal 1 *)
     SIGUSR2   = 31;     (* user defined signal 2 *)

  TYPE
     SigNum     = SIGNED [1 .. 31];
     SigHandler = PROCEDURE (SigNum);

  PROCEDURE signal (sig  : SigNum; func : SigHandler) : SigHandler;
     (* Defines the handler procedure for the specified signal 'sig' *)
     (* as 'func'. Returns the previous (or initial) handler procedure *)
     (* of the particular signal. Upon recept of the signal 'sig' the *)
     (* handler procedure 'func' is executed. Before entering 'func', *)
     (* the handler procedure of 'sig' is reset to it's initial value. *)
     (* Upon return from 'func', execution continues at the interrupted *)
     (* point. *)

END Signals.
