  global KeyWindows
  set n [Unique]
  set win .key$n
  set KeyWindows [linsert $KeyWindows 0 $win]

  LinkWindow $head.key $win
  LinkWindow $win.head $head

  toplevel $win -screen $display

  SetHelp $win Window

  wm title $win {SimCity Key}
  wm iconname $win {SimCity Key}
  wm geometry $win 400x425+5+5
  wm positionfrom $win user
  wm sizefrom $win user
  wm maxsize $win 1000 1000
  wm minsize $win 100 100
  wm protocol $win WM_DELETE_WINDOW "DeleteWindow key KeyWindows $win"


  frame $win.top \
    -relief raised \
    -borderwidth 2
  LinkWindow $win.background $win.top

  label $win.top.title \
    -borderwidth 4 \
    -relief raised \
    -font [Font $win Large] \
    -background [Color $win #00bf00 #ffffff] \
    -text "Get SimCity License Key"
  LinkWindow $win.title $win.top.title

  text $win.top.text \
    -borderwidth 4 \
    -relief flat \
    -wrap word \
    -state normal \
    -height 10 \
    -font [Font $win Large]
  LinkWindow $win.text $win.top.text
  $win.top.text delete 0.0 end
  $win.top.text insert end "\
To purchase SimCity Classic for UNIX, 
contact M & W Consulting, Ltd.

    Phone:	713/627-9229
    FAX:		713/626-7566
    EMail:	RonnieW252@aol.com
    Mail:		M & W Consulting, Ltd.       
		4600 Post Oak Place
		Suite 103            
		Houston, TX 77027
"
  $win.top.text configure -state disabled

  text $win.top.intro \
    -borderwidth 4 \
    -relief flat \
    -wrap word \
    -state normal \
    -height 8 \
    -font [Font $win Medium]
  LinkWindow $win.intro $win.top.intro
  $win.top.intro delete 0.0 end
  $win.top.intro insert end {\
SimCity runs in demo mode if you don't have a license key:
The city melts after 15 minutes, or if you try to save it.}

  $win.top.intro configure -state disabled

  frame $win.top.controls \
    -relief flat \
    -borderwidth 0

  frame $win.top.controls.left \
    -relief flat \
    -borderwidth 4

  label $win.top.controls.left.current \
    -borderwidth 0 \
    -relief flat \
    -font [Font $win Large] \
    -text "Current License:"

  label $win.top.controls.left.key \
    -borderwidth 0 \
    -relief flat \
    -font [Font $win Large] \
    -text "Enter Key:"

  pack append $win.top.controls.left \
    $win.top.controls.left.current	{top frame e expand pady 4} \
    $win.top.controls.left.key		{top frame e expand pady 4}

  frame $win.top.controls.right \
    -relief flat \
    -borderwidth 4

  label $win.top.controls.right.current \
    -borderwidth 0 \
    -relief flat \
    -font [Font $win Large] \
    -text "None"
  LinkWindow $win.current $win.top.controls.right.current

  entry $win.top.controls.right.key \
    -relief sunken \
    -font [Font $win Large] \
    -text ""
  bind $win.top.controls.right.key <Return> "DoInstallKey $win"
  bind $win.top.controls.right.key <Any-Enter> {focus %W}
  LinkWindow $win.key $win.top.controls.right.key

  pack append $win.top.controls.right \
    $win.top.controls.right.current	{top frame w expand pady 4 fillx} \
    $win.top.controls.right.key		{top frame w expand pady 4 fillx}

  pack append $win.top.controls \
    $win.top.controls.left		{left frame center fill} \
    $win.top.controls.right		{right frame center expand fill}

  pack append $win.top\
    $win.top.title	{top frame n fillx} \
    $win.top.text	{top frame n expand fill}\
    $win.top.intro	{top frame n expand fill}\
    $win.top.controls	{top frame n fill}

  button $win.dismiss\
    -font [Font $win Large] \
    -text {Dismiss}\
    -command "wm withdraw $win"

  pack append $win\
    $win.top		{top frame center expand fill} \
    $win.dismiss	{bottom frame s fillx} 

  InitKey $win

  update idletasks
  return $win
