.TH afft 1 "Jan. 22, 1993"  "afft Version 3.0"
.SH Name
afft - A Realtime FFT display client
.SH SYNOPSIS
.B
afft
[\fB\-color\fP]
[\fB\-d\fP \fIdevice\fP]
[\fB\-file\fP \fIfile\fP]
[\fB\-gain\fP \fIgainvalue\fP]
[\fB\-length\fB \fIfftlength]
[\fB\-log\fP]
[\fB\-min\fP \fIminvalue\fP]
[\fB\-max\fP \fImaxvalue\fP]
[\fB\-nodc\fP]
[\fB\-noscope\fP]
[\fB\-nowindow\fP]
[\fB\-realtime\fP]
[\fB\-sine\fP]
[\fB\-spec\fP]
[\fB\-stride\fP \fIstridelength\fP]

.SH Description
.PP
\fIafft\fP accepts mu-law audio data from one of several sources, executes
a running Fourier transform on the data, and displays the transform result.
The display is updated continuously in either "waterfall" or "spectrogram"
format.

\fIafft\fP is initially configured through command line switches.  Many of
the parameters can be changed while the progogram is running via the graphical
user interface, as described below.

The source of the audio that is displayed depends on the configuration as folows:
If the \fB\-file\fP switch is given, then the audio source is a file of mu-law
samples.  Otherwise, if the \fB\-sine\fP switch is given, the audio source
is a "canned" sine wave that sweeps up and down the frequency spectrum.  If
neither \fB\-file\fP or \fB\-sine\fP are given, then \fIafft\fP takes its
audio data from the audio server local input.
.SH Options
.TP
.B \-color
.IP
Specifies that the display is to be in color.  The default is grayscale.
The color scheme can be changed while \fIafft\fP is running by means
of a pull-down menu labeled "\fIColors\fP".
.TP
.B \-d \fIdevice\fP
.IP
Specifies the name of the audio device.  If not given, \fIafft\fP defaults
to the local audio device.
.TP
.B \-file \fIfile\fP
.IP
Input will be taken from \fIfile\fP, which should contain raw mu-law samples
of audio data.  \fIafft\fP will continuously loop through the file from
beginning to end, rewind the file, and repeat.  If \fIfile\fP is given as
"-", input is taken from stdin.  Since it is not possible to rewind stdin,
\fIafft\fP will terminate on end-of-file in this case.

If \fIafft\fP can connect to the audio server, then the file is played
through the audio output device in synchronization with the fft display.
.TP
.B \-gain \fIgainvalue\fP
.IP
Sets the gain in DB to be applied to the audio samples.  Should be in the
range of \-100 to \-5, and represents a level down from a theoretical peak
value of 0DB.  Applies only when log mode is selected, see \fB\-log\fP
switch.  Default value is \-20.  The gain value may be controlled while
\fIafft\fP is running by a slider labeled "\fIGain\fP".
.TP
.B \-length \fIfftlength\fP
.IP
Sets the number of samples over which each FFT transform is computed.
Legal values are 512, 256, 128, and 64.  Default value is 512.  The
length can be changed while \fIafft\fP is running by means of a pull-down
menu labeled "\fIFFT Length\fP"
.TP
.B \-log
.IP
Selects the initial display mode to be logarithmic.  If not specified,
the initial display mode is linear.  The selection between log and
linear mode may be changed while \fIafft\fP is running by a
pair of radio buttons labeled "\fILog\fP" and "\fILinear\fP".
.TP
.B \-min \fIminvalue\fP
.IP
Sets the lowest audio level that will be displayed.  Value is in DB for log
mode, or in percent of peak value in linear mode.  Default is \-100 in log
mode, and 0 in linear.  The minimum value may be controlled while
\fIafft\fP is running by a slider labeled "\fIMinimum\fP".
.TP
.B \-max \fImaxvalue\fP
.IP
Sets the hightest audio level that will be displayed.  Value is in DB
for log mode, or in percent of peak value in linear mode.  Default is 0
in log mode, and  100 in linear.  The maximum value may be controlled while
\fIafft\fP is running by a slider
labeled "\fIMaximum\fP".
.TP
.B \-nodc
.IP
Supresses display of the DC component.  Default is to include the DC
component in the fft display.  Inclusion or supression of the DC
component may be changed while \fIafft\fP is running by a
pair of radio buttons labeled "\fINoDC\fP" and "\fIDC\fP".
.TP
.B \-noscope
.IP
Suppresses display of the audio stream in an oscilloscope-like form.
The default is to show this display.  Oscilloscope display can also
be turned on and off while \fIafft\fP is running by a pair of
radio buttons labeled "\fIScope On\fP" and "\fIScope Off\fP".
.TP
.B \-nowindow
.IP
Supresses the window function.  By default, a Hamming window is used.
Other window functions can be selected through a
pulldown menu labeled "\fIWindows\fP".
Additional window functions include Hanning, and Triangular.
.TP
.B \-realtime
If this switch is given, \fIafft\fP attempts to stay synchronized
with the audio server in real time.  If \fIafft\fP cannot get enough
CPU cycles to keep up with the incoming audio stream, it may fall behind
enough that it no longer captures valid audio data.  In non-realtime mode
(the default), \fIafft\fP will discard audio samples in order to keep up
with real time.
.TP
.B \-sine
.IP
Causes \fIafft\fP to begin operation in demo mode, which displays a
sine curve sweep from the minimum frequency up to the Nyquist cut-off
frequency.  \fIafft\fP can operate in this mode even if the audio
server is not running or no audio hardware is available.  \fIafft\fP
can be switched between demonstration mode and live mode (input from
the audio server) by a pair of radio buttons
labeled "\fILive\fP" and "\fIDemo\fP.
.TP
.B \-spec
.IP
Selects spectrogram display.  Otherwise, a waterfall style of display
is used.  You can switch at will between spectrogram and waterfall by
a pair of radio buttons labeled "\fIWaterfall\fP" and "\fISpec\fP".
.TP
.B \-stride \fIstridelength\fP
.IP
Sets the number of samples that \fIafft\fP advances between FFT frames.
Legal values are 512, 256, 128, and 64.  Default value is 512.
However, the stride will never be greater than the FFT length
(see above).
The stride can be changed while \fIafft\fP is running by means of
a pull-down menu labeled "\fIStride\fP"
.SH Owner
.IP
Original by L. Stewart
.IP
User Interface by J. Morse
.SH Copyright
Copyright 1992-1994 Digital Equipment Corporation
