.ds xL AFUtillib \- C Language AF Utilities
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
.tm \\n%:\\$1:\\$2:\\$3
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de PN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH AF_sine_int 3 "Release 1" "AF Version 3" 
.SH NAME
\fBAF_sine_int, AF_sine_float\fP \- sine wave tables, for frequency synthesis
.SH SYNTAX
\fB#include <AF/AFUtils.h>\fP
.LP
extern int \fBAF_sine_int\fP[];
.LP
extern float \fBAF_sine_float\fP[];
.SH DESCRIPTION
.PN AF_sine_int
and
.PN AF_sine_float
are precomputed tables you can link with your application.
Each table contains 1024 equally spaced samples of a single sine wave
cycle.
.PN AF_sine_int
contains 16 bit integers scaled so that the peaks of the sine
wave are at +32767 and -32767.
.PN AF_sine_float
contains single precision floating point numbers scaled so that
the peaks of the sine wave are at +1.0 and -1.0.
.LP
The general idea of direct digital frequency synthesis is to step through
the sine wave table using a \fIphase accumulator\fP.  Each sample time,
add into the phase accumulator a value (the \fIphase increment\fP) which
is the desired frequency divided by the sample rate and multiplied by
the number of samples in the sine table (1024).  The phase accumulator
must be wrapped MOD 1024.  Each sample time the output value is the
value in the sine table indexed by the integer part of the phase accumulator.
.SH EXAMPLES
Typical usage is:
.LP
.Ds 0
.TA .5i 3i
.ta .5i 3i
float frequency, sample_rate;	/* input parameters */
float phase_inc, phase;
float output;
/* first compute the phase increment */
phase_inc = (frequency / sample_rate) * 1024.0;
phase = 0;
/* then generate */
for (;;)
{
  output = AF_sine_float[phase];
  phase += phase_inc;
  if (phase >= 1024.0) phase -= 1024.0;
}
.De
.SH DIAGNOSTICS
If you index the table with an out-of-range value you
may cause a protection fault and crash your application.
.SH "SEE ALSO"
AF(1)
.SH BUGS
If you encounter a \fBreproducible\fP bug, please 
submit a problem report to (af-bugs@crl.dec.com).
.SH COPYRIGHT
Copyright 1990-1994, Digital Equipment Corporation.
.br
See \fIAF(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Larry Stewart, 
Digital Cambridge Research Lab
