<HTML>
<HEAD>
<TITLE>SRC Modula-3: C/src/FreeBSD/Cstdio.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>C/src/FreeBSD/Cstdio.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                            </EM></BLOCKQUOTE><PRE>
</PRE>      Olaf Wagner 16.09.1994                                

<P><PRE>INTERFACE <interface><A HREF="#x1">Cstdio</A></interface>;

FROM <A HREF="../Common/Ctypes.i3">Ctypes</A> IMPORT int, void_star, char_star,
                   unsigned_char_star, short_int, unsigned_char;

CONST
  NIOBRW = 100;
  NSTDBUF= 3;
  EOF    = VAL(-1, int);

TYPE
  SBUF = RECORD
            base : unsigned_char_star;
            size : int;
         END;

  FILE = RECORD
        p     : unsigned_char_star;  (* current position in (some) buffer *)
        r     : int;                 (* read space left for getc() *)
        w     : int;                 (* write space left for putc() *)
        flags : short_int;           (* flags, below; this FILE is free if 0 *)
        file  : short_int;           (* fileno, if Unix descriptor, else -1 *)
        bf    : SBUF;                (* the buffer (at least 1 byte, if !NULL) *)
        lbfsize : int;               (* 0 or -_bf._size, for inline putc *)

        (* operations *)
        cookie : void_star;          (* cookie passed to io functions *)
        xxclose: void_star;
        xxread : void_star;
        xxseek : void_star;
        xxwrite: void_star;

        (* separate buffer for long sequences of ungetc() *)
        ub : SBUF;               (* ungetc buffer *)
        up : unsigned_char_star; (* saved _p when _p is doing ungetc data *)
        ur : int;                (* saved _r when _r is counting ungetc data *)

        (* tricks to meet minimum requirements even when malloc() fails *)
        ubuf : ARRAY[0..2] OF unsigned_char; (* guarantee an ungetc() buffer *)
        nbuf : ARRAY[0..0] OF unsigned_char; (* guarantee a getc() buffer *)

        (* separate buffer for fgetln() when line crosses buffer boundary *)
        lb   : SBUF;         (* buffer for fgetln() *)

        (* Unix stdio files get aligned to block boundaries on fseek() *)
        blksize : int;        (* stat.st_blksize (may be != _bf._size) *)
        offset  : int;        (* current lseek offset *)

        END;

  FILE_star = UNTRACED REF FILE;

&lt;*EXTERNAL &quot;__sF&quot;*&gt; VAR sF : ARRAY [0..NSTDBUF-1] OF FILE;
                    VAR iF : ARRAY [0..NIOBRW-1]  OF FILE_star;

&lt;*EXTERNAL fbsd_feof*&gt;      PROCEDURE feof (f: FILE_star): int;
&lt;*EXTERNAL fbsd_getc*&gt;      PROCEDURE getc (f: FILE_star): int;
&lt;*EXTERNAL fbsd_ungetc*&gt;    PROCEDURE ungetc (c: int; f: FILE_star): int;
&lt;*EXTERNAL fbsd_putc*&gt;      PROCEDURE putc (c: int; f: FILE_star): int;
&lt;*EXTERNAL fbsd_fflush*&gt;    PROCEDURE fflush (f: FILE_star): int;
&lt;*EXTERNAL fbsd_fdopen*&gt;    PROCEDURE fdopen (fd: int; mode: char_star): FILE_star;
&lt;*EXTERNAL fbsd_fclose*&gt;    PROCEDURE fclose (f: FILE_star): int;

END Cstdio.
</PRE>
</inInterface>
<HR>
<A NAME="x1">Cstdio's implementation  is in:
</A><UL>
<LI><A HREF="Cstdio.m3#0TOP0">C/src/FreeBSD/Cstdio.m3</A>
<LI><A HREF="../FreeBSD2/Cstdio.m3#0TOP0">C/src/FreeBSD2/Cstdio.m3</A>
<LI><A HREF="../LINUX/Cstdio.m3#0TOP0">C/src/LINUX/Cstdio.m3</A>
<LI><A HREF="../LINUXELF/Cstdio.m3#0TOP0">C/src/LINUXELF/Cstdio.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
