<HTML>
<HEAD>
<TITLE>SRC Modula-3: PEX/src/PEX.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>PEX/src/PEX.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Thu Feb 17 19:11:40 PST 1994 by najork                   

<P>
<P><PRE>UNSAFE MODULE <module><implements><A HREF="PEX.i3">PEX</A></implements></module>;

IMPORT <A HREF="../../word/src/Word.i3">Word</A>;
IMPORT <A HREF="../../X11R4/src/Common/X.i3">X</A>;
IMPORT <A HREF="../../C/src/Common/Ctypes.i3">Ctypes</A>;
</PRE>***************************************************************************
 The following procedures mimic a set of (#define) C macros in PEX.h.      
 C Macros are a tricky thing: They do not contain type information, and    
 can thereby realize ad-hoc polymorphism which Modula-3 cannot reproduce,  
 and worse, they have an Algol-like call-by-name semantics, which can be   
 nasty. Example: given                                                     
    #define FOO(x) ((x)+(x))                                               
 after executing                                                           
    i = 3; j = FOO(i++);                                                   
 j is not 6, but 7, and i is not 4, but 5.                                 
 I recommend to look at your code very carefully when you replace one of   
 these C macros with a Modula-3 function!                                  
***************************************************************************

<P>
 * #define PEX_BITNUM_TO_BITMASK(bitIndex, maskNum, maskValue) \
 *     maskNum	= (bitIndex) / 32; \
 *     maskValue = ((unsigned)1L &lt;&lt; ((bitIndex) % 32));
 
<PRE>PROCEDURE <A NAME="PEX_BITNUM_TO_BITMASK"><procedure>PEX_BITNUM_TO_BITMASK</procedure></A>(bitIndex : Ctypes.int;
                                VAR maskNum : Ctypes.int;
                                VAR maskValue : Ctypes.int
                               ) =
  BEGIN
    maskNum	:= bitIndex DIV 32;
    maskValue	:= Word.LeftShift(1,bitIndex MOD 32);
  END PEX_BITNUM_TO_BITMASK;
</PRE> <P>
 * This is not a function, but just a stub of code (an if-statement with 
 * the condition, but where the then- and else part are missing).
 *
 * #define CHECK_BITMASK_ARRAY(mask,bitIndex) \
 *    if (mask[((bitIndex)/32)] &amp; ((unsigned)1L &lt;&lt; ((bitIndex) % 32)))
 

<P>
 * #define PEX_BITMASK(i) ((unsigned)1 &lt;&lt; ((i) &amp; 31))
 
<PRE>PROCEDURE <A NAME="PEX_BITMASK"><procedure>PEX_BITMASK</procedure></A>(i : Ctypes.int) : Ctypes.int =
  BEGIN
    RETURN Word.LeftShift(1,Word.And(i,31));
  END PEX_BITMASK;
</PRE><P>
 * #define PEX_MASKIDX(i) ((i) &gt;&gt; 5)
 
<PRE>PROCEDURE <A NAME="PEX_MASKIDX"><procedure>PEX_MASKIDX</procedure></A>(i : Ctypes.int) : Ctypes.int =
  BEGIN
    RETURN Word.RightShift(i,5);
  END PEX_MASKIDX;
</PRE><P>
 * #define PEX_MASKWORD(buf, i) buf[PEX_MASKIDX(i)]
 
<PRE>PROCEDURE <A NAME="PEX_MASKWORD"><procedure>PEX_MASKWORD</procedure></A> (READONLY buf : ARRAY OF Ctypes.int ;
                        i : Ctypes.int) : Ctypes.int =
  BEGIN
    RETURN buf[PEX_MASKIDX(i)];
  END  PEX_MASKWORD;
</PRE><P>
 * #define PEX_BITSET(buf, i) PEX_MASKWORD(buf, i) |= PEX_BITMASK(i)
 
<PRE>PROCEDURE <A NAME="PEX_BITSET"><procedure>PEX_BITSET</procedure></A>(VAR buf : ARRAY OF Ctypes.int ; i : Ctypes.int) =
  BEGIN
    buf[PEX_MASKIDX(i)] := Word.Or (buf[PEX_MASKIDX(i)], PEX_BITMASK(i));
  END PEX_BITSET;
</PRE><P>
 * #define PEX_BITCLEAR(buf, i) PEX_MASKWORD(buf, i) &amp;= ~PEX_BITMASK(i)
 
<PRE>PROCEDURE <A NAME="PEX_BITCLEAR"><procedure>PEX_BITCLEAR</procedure></A>(VAR buf : ARRAY OF Ctypes.int ; i : Ctypes.int) =
  BEGIN
     buf[PEX_MASKIDX(i)] :=
             Word.And (buf[PEX_MASKIDX(i)], Word.Not (PEX_BITMASK(i)));
  END PEX_BITCLEAR;
</PRE><P>
 * #define PEX_GETBIT(buf, i) (PEX_MASKWORD(buf, i) &amp; PEX_BITMASK(i))
 
<PRE>PROCEDURE <A NAME="PEX_GETBIT"><procedure>PEX_GETBIT</procedure></A> (READONLY buf : ARRAY OF Ctypes.int ; i : Ctypes.int) :
  Ctypes.int =
  BEGIN
    RETURN Word.And (PEX_MASKWORD(buf, i), PEX_BITMASK(i));
  END PEX_GETBIT;
</PRE>********* From PEXlib.h *********

<P>
 * #define PEX_SetPCAttrMaskBit(mask, attrNum) \
 *    mask[((attrNum)) &gt;&gt; 5] |= 1L &lt;&lt; ( ((attrNum)) &amp; 0x1F)
 
<PRE>PROCEDURE <A NAME="PEX_SetPCAttrMaskBit"><procedure>PEX_SetPCAttrMaskBit</procedure></A>(VAR mask : ARRAY [0 .. 1] OF Ctypes.int;
                               attrNum : Ctypes.int) =
  BEGIN
    mask[Word.RightShift(attrNum,5)] :=
      Word.Or(mask[Word.RightShift(attrNum,5)],
              Word.LeftShift(1,Word.And(attrNum,16_1F)));
  END PEX_SetPCAttrMaskBit;
</PRE>********* From PEXocbuf.h *********

<P>
 * #define PEXAllocateOCBuffer(_dpy_,_typ_,_targ_,_bufTyp_,_errFn_,_initSiz_)\
 * ( (_bufTyp_ == PEXDefaultTransientOCBuffer) ?\
 *       (PEXAllocateTransientOCBuffer(_dpy_,_typ_,_targ_,_errFn_,_initSiz_)) :\
 *       (PEXAllocateRetainedOCBuffer(_dpy_,_typ_,_targ_,_errFn_,_initSiz_)) )
 
<PRE>PROCEDURE <A NAME="PEXAllocateOCBuffer"><procedure>PEXAllocateOCBuffer</procedure></A>(display : X.DisplayStar;
                              type    : Ctypes.int;
                              target  : X.XID;
                              bufTyp  : PROCEDURE () : Ctypes.int;
                              errorFn : ErrorFunctionType;
                              initSize: Ctypes.int)
          : pxlOCBufStar =
  BEGIN
    IF bufTyp = PEXDefaultTransientOCBuffer THEN
      RETURN PEXAllocateTransientOCBuffer(display,type,target,errorFn,initSize)
    ELSE
      RETURN PEXAllocateRetainedOCBuffer(display,type,target,errorFn,initSize);
    END;
  END PEXAllocateOCBuffer;
</PRE><P>
 * #define PEXFlushOCBuffer(_ocbuf_) ( *(_ocbuf_)-&gt;FlushOCBuf)(_ocbuf_)
 
<PRE>PROCEDURE <A NAME="PEXFlushOCBuffer"><procedure>PEXFlushOCBuffer</procedure></A>(ocbuf : pxlOCBufStar) =
  BEGIN
    ocbuf^.FlushOCBuf(ocbuf);
  END PEXFlushOCBuffer;
</PRE><P>
 * #define PEXSendOCBuffer(_ocbuf_) ( *(_ocbuf_)-&gt;SendOCBuf)(_ocbuf_)
 
<PRE>PROCEDURE <A NAME="PEXSendOCBuffer"><procedure>PEXSendOCBuffer</procedure></A>(ocbuf : pxlOCBufStar) =
  BEGIN
    ocbuf^.SendOCBuf(ocbuf);
  END PEXSendOCBuffer;
</PRE>********* END OF MACROS *********

<P><PRE>BEGIN
  (* no main module bodule *)
END PEX.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
