<HTML>
<HEAD>
<TITLE>SRC Modula-3: X11R4/src/Common/X.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>X11R4/src/Common/X.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: X.i3							

<P>
<P><PRE>UNSAFE INTERFACE <interface>X</interface>;
</PRE>==============================================================
	The X11 R4 Interface for Modula 3			
								
	contains:	/usr/include/X11/X.h			
			/usr/include/X11/Xlib.h			
			/usr/include/X11/Xutil.h		
==============================================================

<P>**********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.
<P>
                        All Rights Reserved
<P>
Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  
<P>
DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
<P>
*****************************************************************

<P><PRE>FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT char, char_star, char_star_star, char_star_star_star,
                   const_char_star, const_unsigned_char_star,
                   int, int_star, long, long_star, short,
                   unsigned_char, unsigned_char_star, unsigned_char_star_star,
                   unsigned_int, unsigned_int_star, unsigned_long,
                   unsigned_long_star, unsigned_short, void_star;
IMPORT <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="#x1">XMachine</A>;

EXCEPTION Error;
</PRE><BLOCKQUOTE><EM> If a Modula-3 client (like Trestle) registers an error handler with
   X, then the handler may raise this exception.  Most X calls
   can then result in Error being raised </EM></BLOCKQUOTE><PRE>
</PRE>**************************************************************
<P>
                /usr/include/X11/X.h
<P>
 **************************************************************

<P> Definitions for the X window system likely to be used by applications 

<P><PRE>CONST
  X_PROTOCOL 		=        11;             (* current protocol version *)
  X_PROTOCOL_REVISION 	=        0;             (* current minor version *)
</PRE> Resources 

<P><PRE>TYPE
  Int = int; Short = short; Long = long; Char = char;

  Argv = UNTRACED REF ARRAY [0..255] OF char_star;

  Enumeration		=  Int;

  XID			=  XMachine.XID;

  Window		=  XID;
  WindowStar    	=  UNTRACED REF Window;
  WindowStarStar	=  UNTRACED REF WindowStar;

  Drawable		=  XID;
  Font		  	=  XID;
  Pixmap	  	=  XID;
  PixmapStar		=  UNTRACED REF Pixmap;
  Cursor	  	=  XID;
  Colormap	  	=  XID;
  ColormapStar		=  UNTRACED REF Colormap;
  GContext	  	=  XID;
  KeySym	  	=  XMachine.KeySym;
  KeySymStar		=  UNTRACED REF KeySym;

  Mask		  	=  unsigned_long;

  Atom		  	=  unsigned_long;
  AtomStar		=  UNTRACED REF Atom;
  AtomStarStar		=  UNTRACED REF AtomStar;

  VisualID		=  unsigned_long;

  Time			=  XMachine.Time;
  TimeStar		=  UNTRACED REF Time;

  KeyCode		=  unsigned_char;
  KeyCodeStar		=  UNTRACED REF KeyCode;
  KeyCodeStarStar	=  UNTRACED REF KeyCodeStar;

TYPE
  RetIntProc    	=  PROCEDURE (): Int;
  Retchar_starProc	=  PROCEDURE (): char_star;
</PRE>****************************************************************
 * RESERVED RESOURCE AND CONSTANT DEFINITIONS
 ****************************************************************

<P><PRE>CONST
  None  =                       0;      (* universal null resource or null atom *)
  ParentRelative  =             1;      (* background pixmap in CreateWindow
                                           and ChangeWindowAttributes *)
  CopyFromParent  =             0;      (* border pixmap in CreateWindow
                                           and ChangeWindowAttributes
                                           special VisualID and special window
                                           class passed to CreateWindow *)
  PointerWindow  =              0;      (* destination window in SendEvent *)
  InputFocus  =                 1;      (* destination window in SendEvent *)
  PointerRoot  =                1;      (* focus window in SetInputFocus *)
  AnyPropertyType  =            0;      (* special Atom, passed to GetProperty *)
  AnyKey  =                     0;      (* special Key Code, passed to GrabKey *)
  AnyButton  =                  0;      (* special Button Code, passed to GrabButton *)
  AllTemporary  =               0;      (* special Resource ID passed to KillClient *)
  CurrentTime  =                0;      (* special Time *)
  NoSymbol  =                   0;      (* special KeySym *)
</PRE>**************************************************************** 
 * EVENT DEFINITIONS 
 ****************************************************************

<P> Input Event Masks. Used as event-mask window attribute and as arguments
   to Grab requests.  Not to be confused with event names.  

<P>  <PRE>NoEventMask =                 0 ;
  KeyPressMask =                Word.Shift (1, 0)  ;
  KeyReleaseMask =              Word.Shift (1, 1)  ;
  ButtonPressMask =             Word.Shift (1, 2)  ;
  ButtonReleaseMask =           Word.Shift (1, 3)  ;
  EnterWindowMask =             Word.Shift (1, 4)  ;
  LeaveWindowMask =             Word.Shift (1, 5)  ;
  PointerMotionMask =           Word.Shift (1, 6)  ;
  PointerMotionHintMask =       Word.Shift (1, 7)  ;
  Button1MotionMask =           Word.Shift (1, 8)  ;
  Button2MotionMask =           Word.Shift (1, 9)  ;
  Button3MotionMask =           Word.Shift (1, 10) ;
  Button4MotionMask =           Word.Shift (1, 11) ;
  Button5MotionMask =           Word.Shift (1, 12) ;
  ButtonMotionMask =            Word.Shift (1, 13) ;
  KeymapStateMask =             Word.Shift (1, 14) ;
  ExposureMask =                Word.Shift (1, 15) ;
  VisibilityChangeMask =        Word.Shift (1, 16) ;
  StructureNotifyMask =         Word.Shift (1, 17) ;
  ResizeRedirectMask =          Word.Shift (1, 18) ;
  SubstructureNotifyMask =      Word.Shift (1, 19) ;
  SubstructureRedirectMask =    Word.Shift (1, 20) ;
  FocusChangeMask =             Word.Shift (1, 21) ;
  PropertyChangeMask =          Word.Shift (1, 22) ;
  ColormapChangeMask =          Word.Shift (1, 23) ;
  OwnerGrabButtonMask =         Word.Shift (1, 24) ;
</PRE> Event names.  Used in <CODE>type</CODE> field in XEvent structures.  Not to be
confused with event masks above.  They start from 2 because 0 and 1
are reserved in the protocol for errors and replies. 

<P>  <PRE>KeyPress =                    2;
  KeyRelease =                  3;
  ButtonPress =                 4;
  ButtonRelease =               5;
  MotionNotify =                6;
  EnterNotify =                 7;
  LeaveNotify =                 8;
  FocusIn =                     9;
  FocusOut =                    10;
  KeymapNotify =                11;
  Expose =                      12;
  GraphicsExpose =              13;
  NoExpose =                    14;
  VisibilityNotify =            15;
  CreateNotify =                16;
  DestroyNotify =               17;
  UnmapNotify =                 18;
  MapNotify =                   19;
  MapRequest =                  20;
  ReparentNotify =              21;
  ConfigureNotify =             22;
  ConfigureRequest =            23;
  GravityNotify =               24;
  ResizeRequest =               25;
  CirculateNotify =             26;
  CirculateRequest =            27;
  PropertyNotify =              28;
  SelectionClear =              29;
  SelectionRequest =            30;
  SelectionNotify =             31;
  ColormapNotify =              32;
  ClientMessage =               33;
  MappingNotify =               34;
  LASTEvent =                   35;     (* must be bigger than any event # *)
</PRE> Key masks. Used as modifiers to GrabButton and GrabKey, results of QueryPointer,
   state in various key-, mouse-, and button-related events. 

<P>  <PRE>ShiftMask =                   Word.Shift (1, 0);
  LockMask =                    Word.Shift (1, 1);
  ControlMask =                 Word.Shift (1, 2);
  Mod1Mask =                    Word.Shift (1, 3);
  Mod2Mask =                    Word.Shift (1, 4);
  Mod3Mask =                    Word.Shift (1, 5);
  Mod4Mask =                    Word.Shift (1, 6);
  Mod5Mask =                    Word.Shift (1, 7);
</PRE> modifier names.  Used to build a SetModifierMapping request or
   to read a GetModifierMapping request.  These correspond to the
   masks defined above. 

<P>  <PRE>ShiftMapIndex =               0;
  LockMapIndex =                1;
  ControlMapIndex =             2;
  Mod1MapIndex =                3;
  Mod2MapIndex =                4;
  Mod3MapIndex =                5;
  Mod4MapIndex =                6;
  Mod5MapIndex =                7;
</PRE> button masks.  Used in same manner as Key masks above. Not to be confused
   with button names below. 

<P>  <PRE>Button1Mask =                 Word.Shift (1, 8);
  Button2Mask =                 Word.Shift (1, 9);
  Button3Mask =                 Word.Shift (1, 10);
  Button4Mask =                 Word.Shift (1, 11);
  Button5Mask =                 Word.Shift (1, 12);

  AnyModifier =                 Word.Shift (1, 15)  (* used in GrabButton, GrabKey *);
</PRE> button names. Used as arguments to GrabButton and as detail in ButtonPress
   and ButtonRelease events.  Not to be confused with button masks above.
   Note that 0 is already defined above as <CODE>AnyButton</CODE>.  

<P>  <PRE>Button1 =                     1;
  Button2 =                     2;
  Button3 =                     3;
  Button4 =                     4;
  Button5 =                     5;
</PRE> Notify modes 

<P>  <PRE>NotifyNormal =                0;
  NotifyGrab =                  1;
  NotifyUngrab =                2;
  NotifyWhileGrabbed =          3;

  NotifyHint =                  1;      (* for MotionNotify events *)
</PRE> Notify detail 

<P>  <PRE>NotifyAncestor =              0;
  NotifyVirtual =               1;
  NotifyInferior =              2;
  NotifyNonlinear =             3;
  NotifyNonlinearVirtual =      4;
  NotifyPointer =               5;
  NotifyPointerRoot =           6;
  NotifyDetailNone =            7;
</PRE> Visibility notify 

<P>  <PRE>VisibilityUnobscured =        0;
  VisibilityPartiallyObscured = 1;
  VisibilityFullyObscured =     2;
</PRE> Circulation request 

<P>  <PRE>PlaceOnTop =                  0;
  PlaceOnBottom =               1;
</PRE> protocol families 

<P>  <PRE>FamilyInternet =              0;
  FamilyDECnet =                1;
  FamilyChaos =                 2;
  FamilyGeneric =               128;
</PRE> Property notification 

<P>  <PRE>PropertyNewValue =            0;
  PropertyDelete =              1;
</PRE> Color Map notification 

<P>  <PRE>ColormapUninstalled =         0;
  ColormapInstalled =           1;
</PRE> GrabPointer, GrabButton, GrabKeyboard, GrabKey Modes 

<P>  <PRE>GrabModeSync =                0;
  GrabModeAsync =               1;
</PRE> GrabPointer, GrabKeyboard reply status 

<P>  <PRE>GrabSuccess =                 0;
  AlreadyGrabbed =              1;
  GrabInvalidTime =             2;
  GrabNotViewable =             3;
  GrabFrozen =                  4;
</PRE> AllowEvents modes 

<P>  <PRE>AsyncPointer =                0;
  SyncPointer =                 1;
  ReplayPointer =               2;
  AsyncKeyboard =               3;
  SyncKeyboard =                4;
  ReplayKeyboard =              5;
  AsyncBoth =                   6;
  SyncBoth =                    7;
</PRE> Used in SetInputFocus, GetInputFocus 

<P>  <PRE>RevertToNone =                None;
  RevertToPointerRoot =         PointerRoot;
  RevertToParent =              2;
</PRE>****************************************************************
 * ERROR CODES 
 ****************************************************************

<P>  <PRE>Success =                     0;      (* everything's okay *)
  BadRequest =                  1;      (* bad request code *)
  BadValue =                    2;      (* int parameter out of range *)
  BadWindow =                   3;      (* parameter not a Window *)
  BadPixmap =                   4;      (* parameter not a Pixmap *)
  BadAtom =                     5;      (* parameter not an Atom *)
  BadCursor =                   6;      (* parameter not a Cursor *)
  BadFont =                     7;      (* parameter not a Font *)
  BadMatch =                    8;      (* parameter mismatch *)
  BadDrawable =                 9;      (* parameter not a Pixmap or Window *)
  BadAccess =                   10;     (* depending on context:
                                         - key/button already grabbed
                                         - attempt to free an illegal
                                           cmap entry
                                        - attempt to store into a read-only
                                           color map entry.
                                        - attempt to modify the access control
                                           list from other than the local host.
                                        *)
  BadAlloc =                    11;     (* insufficient resources *)
  BadColor =                    12;     (* no such colormap *)
  BadGC =                       13;     (* parameter not a GC *)
  BadIDChoice =                 14;     (* choice not in range or already used *)
  BadName =                     15;     (* font or color name doesn't exist *)
  BadLength =                   16;     (* Request length incorrect *)
  BadImplementation =           17;     (* server is defective *)

  FirstExtensionError =         128;
  LastExtensionError =          255;
</PRE>****************************************************************
 * WINDOW DEFINITIONS 
 ****************************************************************

<P> Window classes used by CreateWindow 
 Note that CopyFromParent is already defined as 0 above 

<P>  <PRE>InputOutput =                 1;
  InputOnly =                   2;
</PRE> Window attributes for CreateWindow and ChangeWindowAttributes 

<P>  <PRE>CWBackPixmap =                Word.Shift (1, 0);
  CWBackPixel =                 Word.Shift (1, 1);
  CWBorderPixmap =              Word.Shift (1, 2);
  CWBorderPixel =               Word.Shift (1, 3);
  CWBitGravity =                Word.Shift (1, 4);
  CWWinGravity =                Word.Shift (1, 5);
  CWBackingStore =              Word.Shift (1, 6);
  CWBackingPlanes =             Word.Shift (1, 7);
  CWBackingPixel =              Word.Shift (1, 8);
  CWOverrideRedirect =          Word.Shift (1, 9);
  CWSaveUnder =                 Word.Shift (1, 10);
  CWEventMask =                 Word.Shift (1, 11);
  CWDontPropagate =             Word.Shift (1, 12);
  CWColormap =                  Word.Shift (1, 13);
  CWCursor =                    Word.Shift (1, 14);
</PRE> ConfigureWindow structure 

<P>  <PRE>CWX =                         Word.Shift (1, 0);
  CWY =                         Word.Shift (1, 1);
  CWWidth =                     Word.Shift (1, 2);
  CWHeight =                    Word.Shift (1, 3);
  CWBorderWidth =               Word.Shift (1, 4);
  CWSibling =                   Word.Shift (1, 5);
  CWStackMode =                 Word.Shift (1, 6);
</PRE> Bit Gravity 

<P>  <PRE>ForgetGravity =               0;
  NorthWestGravity =            1;
  NorthGravity =                2;
  NorthEastGravity =            3;
  WestGravity =                 4;
  CenterGravity =               5;
  EastGravity =                 6;
  SouthWestGravity =            7;
  SouthGravity =                8;
  SouthEastGravity =            9;
  StaticGravity =               10;
</PRE> Window gravity + bit gravity above 

<P>  <PRE>UnmapGravity =                0;
</PRE> Used in CreateWindow for backing-store hint 

<P>  <PRE>NotUseful =                   0;
  WhenMapped =                  1;
  Always =                      2;
</PRE> Used in GetWindowAttributes reply 

<P>  <PRE>IsUnmapped =                  0;
  IsUnviewable =                1;
  IsViewable =                  2;
</PRE> Used in ChangeSaveSet 

<P>  <PRE>SetModeInsert =               0;
  SetModeDelete =               1;
</PRE> Used in ChangeCloseDownMode 

<P>  <PRE>DestroyAll =                  0;
  RetainPermanent =             1;
  RetainTemporary =             2;
</PRE> Window stacking method (in configureWindow) 

<P>  <PRE>Above =                       0;
  Below =                       1;
  TopIf =                       2;
  BottomIf =                    3;
  Opposite =                    4;
</PRE> Circulation direction 

<P>  <PRE>RaiseLowest =                 0;
  LowerHighest =                1;
</PRE> Property modes 

<P>  <PRE>PropModeReplace =             0;
  PropModePrepend =             1;
  PropModeAppend =              2;
</PRE>****************************************************************
 * GRAPHICS DEFINITIONS
 ****************************************************************

<P> graphics functions, as in GC.alu 

<P>  <PRE>GXclear =                     16_0;           (* 0 *)
  GXand =                       16_1;           (* src AND dst *)
  GXandReverse =                16_2;           (* src AND NOT dst *)
  GXcopy =                      16_3;           (* src *)
  GXandInverted =               16_4;           (* NOT src AND dst *)
  GXnoop =                      16_5;           (* dst *)
  GXxor =                       16_6;           (* src XOR dst *)
  GXor =                        16_7;           (* src OR dst *)
  GXnor =                       16_8;           (* NOT src AND NOT dst *)
  GXequiv =                     16_9;           (* NOT src XOR dst *)
  GXinvert =                    16_a;           (* NOT dst *)
  GXorReverse =                 16_b;           (* src OR NOT dst *)
  GXcopyInverted =              16_c;           (* NOT src *)
  GXorInverted =                16_d;           (* NOT src OR dst *)
  GXnand =                      16_e;           (* NOT src OR NOT dst *)
  GXset =                       16_f;           (* 1 *)
</PRE> LineStyle 

<P>  <PRE>LineSolid =                   0;
  LineOnOffDash =               1;
  LineDoubleDash =              2;
</PRE> capStyle 

<P>  <PRE>CapNotLast =                  0;
  CapButt =                     1;
  CapRound =                    2;
  CapProjecting =               3;
</PRE> joinStyle 

<P>  <PRE>JoinMiter =                   0;
  JoinRound =                   1;
  JoinBevel =                   2;
</PRE> fillStyle 

<P>  <PRE>FillSolid =                   0;
  FillTiled =                   1;
  FillStippled =                2;
  FillOpaqueStippled =          3;
</PRE> fillRule 

<P>  <PRE>EvenOddRule =                 0;
  WindingRule =                 1;
</PRE> subwindow mode 

<P>  <PRE>ClipByChildren =              0;
  IncludeInferiors =            1;
</PRE> SetClipRectangles ordering 

<P>  <PRE>Unsorted =                    0;
  YSorted =                     1;
  YXSorted =                    2;
  YXBanded =                    3;
</PRE> CoordinateMode for drawing routines 

<P>  <PRE>CoordModeOrigin =             0;      (* relative to the origin *)
  CoordModePrevious =           1;      (* relative to previous point *)
</PRE> Polygon shapes 

<P>  <PRE>Complex =                     0;      (* paths may intersect *)
  Nonconvex =                   1;      (* no paths intersect, but not convex *)
  Convex =                      2;      (* wholly convex *)
</PRE> Arc modes for PolyFillArc 

<P>  <PRE>ArcChord =                    0;      (* join endpoints of arc *)
  ArcPieSlice =                 1;      (* join endpoints to center of arc *)
</PRE> GC components: masks used in CreateGC, CopyGC, ChangeGC, OR'ed into
   GC.stateChanges 

<P>  <PRE>GCFunction =                  Word.Shift (1, 0);
  GCPlaneMask =                 Word.Shift (1, 1);
  GCForeground =                Word.Shift (1, 2);
  GCBackground =                Word.Shift (1, 3);
  GCLineWidth =                 Word.Shift (1, 4);
  GCLineStyle =                 Word.Shift (1, 5);
  GCCapStyle =                  Word.Shift (1, 6);
  GCJoinStyle =                 Word.Shift (1, 7);
  GCFillStyle =                 Word.Shift (1, 8);
  GCFillRule =                  Word.Shift (1, 9);
  GCTile =                      Word.Shift (1, 10);
  GCStipple =                   Word.Shift (1, 11);
  GCTileStipXOrigin =           Word.Shift (1, 12);
  GCTileStipYOrigin =           Word.Shift (1, 13);
  GCFont =                      Word.Shift (1, 14);
  GCSubwindowMode =             Word.Shift (1, 15);
  GCGraphicsExposures =         Word.Shift (1, 16);
  GCClipXOrigin =               Word.Shift (1, 17);
  GCClipYOrigin =               Word.Shift (1, 18);
  GCClipMask =                  Word.Shift (1, 19);
  GCDashOffset =                Word.Shift (1, 20);
  GCDashList =                  Word.Shift (1, 21);
  GCArcMode =                   Word.Shift (1, 22);

  GCLastBit =                   22;
</PRE>****************************************************************
 * FONTS 
 ****************************************************************

<P> used in QueryFont -- draw direction 

<P>  <PRE>FontLeftToRight =             0;
  FontRightToLeft =             1;

  FontChange =                  255;
</PRE>****************************************************************
 *  IMAGING 
 ****************************************************************

<P> ImageFormat -- PutImage, GetImage 

<P>  <PRE>XYBitmap =                    0;      (* depth 1, XYFormat *)
  XYPixmap =                    1;      (* depth == drawable depth *)
  ZPixmap =                     2;      (* depth == drawable depth *)
</PRE>****************************************************************
 *  COLOR MAP STUFF 
 ****************************************************************

<P> For CreateColormap 

<P>  <PRE>AllocNone =                   0;      (* create map with no entries *)
  AllocAll =                    1;      (* allocate entire map writeable *)
</PRE> Flags used in StoreNamedColor, StoreColors 

<P>  <PRE>DoRed =                       Word.Shift (1, 0);
  DoGreen =                     Word.Shift (1, 1);
  DoBlue =                      Word.Shift (1, 2);
</PRE>****************************************************************
 * CURSOR STUFF
 ****************************************************************

<P> QueryBestSize Class 

<P>  <PRE>CursorShape =                 0;      (* largest size that can be displayed *)
  TileShape =                   1;      (* size tiled fastest *)
  StippleShape =                2;      (* size stippled fastest *)
</PRE>**************************************************************** 
 * KEYBOARD/POINTER STUFF
 ****************************************************************

<P>  <PRE>AutoRepeatModeOff =           0;
  AutoRepeatModeOn =            1;
  AutoRepeatModeDefault =       2;

  LedModeOff =                  0;
  LedModeOn =                   1;
</PRE> masks for ChangeKeyboardControl 

<P>  <PRE>KBKeyClickPercent =           Word.Shift (1, 0);
  KBBellPercent =               Word.Shift (1, 1);
  KBBellPitch =                 Word.Shift (1, 2);
  KBBellDuration =              Word.Shift (1, 3);
  KBLed =                       Word.Shift (1, 4);
  KBLedMode =                   Word.Shift (1, 5);
  KBKey =                       Word.Shift (1, 6);
  KBAutoRepeatMode =            Word.Shift (1, 7);

  MappingSuccess =              0;
  MappingBusy =                 1;
  MappingFailed =               2;

  MappingModifier =             0;
  MappingKeyboard =             1;
  MappingPointer =              2;
</PRE>****************************************************************
 * SCREEN SAVER STUFF 
 ****************************************************************

<P>  <PRE>DontPreferBlanking =          0;
  PreferBlanking =              1;
  DefaultBlanking =             2;

  DisableScreenSaver =          0;
  DisableScreenInterval =       0;

  DontAllowExposures =          0;
  AllowExposures =              1;
  DefaultExposures =            2;
</PRE> for ForceScreenSaver 

<P>  <PRE>ScreenSaverReset =            0;
  ScreenSaverActive =           1;
</PRE>****************************************************************
 * HOSTS AND CONNECTIONS
 ****************************************************************

<P> for ChangeHosts 

<P>  <PRE>HostInsert =                  0;
  HostDelete =                  1;
</PRE> for ChangeAccessControl 

<P>  <PRE>EnableAccess =                1;
  DisableAccess =               0;
</PRE> Display classes  used in opening the connection 
 * Note that the statically allocated ones are even numbered and the
 * dynamically changeable ones are odd numbered 

<P>  <PRE>StaticGray =                  0;
  GrayScale =                   1;
  StaticColor =                 2;
  PseudoColor =                 3;
  TrueColor =                   4;
  DirectColor =                 5;
</PRE> Byte order  used in imageByteOrder and bitmapBitOrder 

<P>  <PRE>LSBFirst =                    0;
  MSBFirst =                    1;
</PRE> For users of XMultiplexInput.  This routine is VMS only 

<P>  <PRE>XMINoBlock =                  1;
  XMINewInput =                 2;
</PRE>**************************************************************
<P>
                /usr/include/X11/Xlib.h
<P>
 **************************************************************

<P> $XConsortium: Xlib.h,v 11.179 89/12/12 13:57:19 jim Exp $ 
 
 * Copyright 1985, 1986, 1987 by the Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided 
 * that the above copyright notice appear in all copies and that both that 
 * copyright notice and this permission notice appear in supporting 
 * documentation, and that the name of M.I.T. not be used in advertising
 * or publicity pertaining to distribution of the software without specific, 
 * written prior permission. M.I.T. makes no representations about the 
 * suitability of this software for any purpose.  It is provided <CODE>as is</CODE>
 * without express or implied warranty.
 *
 * The X Window System is a Trademark of MIT.
 *
 

<P>
<P>
 *      Xlib.h - Header definition and support file for the C subroutine
 *      interface library (Xlib) to the X Window System Protocol (V11).
 *      Structures and symbols starting with <CODE>_</CODE> are private to the library.
 

<P><PRE>TYPE
  Bool		= Int;
  BoolStar	= UNTRACED REF Bool;
  Status	= Int;

CONST
  True   	= 1;
  False  	= 0;

CONST
  QueuedAlready        = 0;
  QueuedAfterReading   = 1;
  QueuedAfterFlush     = 2;
</PRE> ?!?!?!?!
#define ConnectionNumber(dpy)   ((dpy)-&gt;fd)
#define RootWindow(dpy, scr)    (((dpy)-&gt;screens[(scr)]).root)
#define DefaultScreen(dpy)      ((dpy)-&gt;default_screen)
#define DefaultRootWindow(dpy)  (((dpy)-&gt;screens[(dpy)-&gt;default_screen]).root)
#define DefaultVisual(dpy, scr) (((dpy)-&gt;screens[(scr)]).root_visual)
#define DefaultGC(dpy, scr)     (((dpy)-&gt;screens[(scr)]).default_gc)
#define BlackPixel(dpy, scr)    (((dpy)-&gt;screens[(scr)]).black_pixel)
#define WhitePixel(dpy, scr)    (((dpy)-&gt;screens[(scr)]).white_pixel)
#define AllPlanes               (~0)
#define QLength(dpy)            ((dpy)-&gt;qlen)
#define DisplayWidth(dpy, scr)  (((dpy)-&gt;screens[(scr)]).width)
#define DisplayHeight(dpy, scr) (((dpy)-&gt;screens[(scr)]).height)
#define DisplayWidthMM(dpy, scr)(((dpy)-&gt;screens[(scr)]).mwidth)
#define DisplayHeightMM(dpy, scr)(((dpy)-&gt;screens[(scr)]).mheight)
#define DisplayPlanes(dpy, scr) (((dpy)-&gt;screens[(scr)]).root_depth)
#define DisplayCells(dpy, scr)  (DefaultVisual((dpy), (scr))-&gt;map_entries)
#define ScreenCount(dpy)        ((dpy)-&gt;nscreens)
#define ServerVendor(dpy)       ((dpy)-&gt;vendor)
#define ProtocolVersion(dpy)    ((dpy)-&gt;proto_major_version)
#define ProtocolRevision(dpy)   ((dpy)-&gt;proto_minor_version)
#define VendorRelease(dpy)      ((dpy)-&gt;release)
#define DisplayString(dpy)      ((dpy)-&gt;display_name)
#define DefaultDepth(dpy, scr)  (((dpy)-&gt;screens[(scr)]).root_depth)
#define DefaultColormap(dpy, scr)(((dpy)-&gt;screens[(scr)]).cmap)
#define BitmapUnit(dpy)         ((dpy)-&gt;bitmap_unit)
#define BitmapBitOrder(dpy)     ((dpy)-&gt;bitmap_bit_order)
#define BitmapPad(dpy)          ((dpy)-&gt;bitmap_pad)
#define ImageByteOrder(dpy)     ((dpy)-&gt;byte_order)
#define NextRequest(dpy)        ((dpy)-&gt;request + 1)
#define LastKnownRequestProcessed(dpy)  ((dpy)-&gt;last_request_read)
<P>
(* macros for screen oriented applications (toolkit) 
<PRE>#define ScreenOfDisplay(dpy, scr)(&amp;((dpy)-&gt;screens[(scr)]))
#define DefaultScreenOfDisplay(dpy) (&amp;((dpy)-&gt;screens[(dpy)-&gt;default_screen]))
#define DisplayOfScreen(s)      ((s)-&gt;display)
#define RootWindowOfScreen(s)   ((s)-&gt;root)
#define BlackPixelOfScreen(s)   ((s)-&gt;black_pixel)
#define WhitePixelOfScreen(s)   ((s)-&gt;white_pixel)
#define DefaultColormapOfScreen(s)((s)-&gt;cmap)
#define DefaultDepthOfScreen(s) ((s)-&gt;root_depth)
#define DefaultGCOfScreen(s)    ((s)-&gt;default_gc)
#define DefaultVisualOfScreen(s)((s)-&gt;root_visual)
#define WidthOfScreen(s)        ((s)-&gt;width)
#define HeightOfScreen(s)       ((s)-&gt;height)
#define WidthMMOfScreen(s)      ((s)-&gt;mwidth)
#define HeightMMOfScreen(s)     ((s)-&gt;mheight)
#define PlanesOfScreen(s)       ((s)-&gt;root_depth)
#define CellsOfScreen(s)        (DefaultVisualOfScreen((s))-&gt;map_entries)
#define MinCmapsOfScreen(s)     ((s)-&gt;min_maps)
#define MaxCmapsOfScreen(s)     ((s)-&gt;max_maps)
#define DoesSaveUnders(s)       ((s)-&gt;save_unders)
#define DoesBackingStore(s)     ((s)-&gt;backing_store)
#define EventMaskOfScreen(s)    ((s)-&gt;root_input_mask)
?!?!?! *)
</PRE><P>
 * Extensions need a way to hang private data on some structures.
 

<P><PRE>TYPE
  XExtData = RECORD
        number: Int;              (* number returned by XRegisterExtension *)
        next: XExtDataStar;	  (* next item on list of data for structure *)
        free_private: RetIntProc; (* called to free private storage *)
        private_data: char_star;   (* data private to this extension. *)
  END;
  XExtDataStar     =  UNTRACED REF XExtData;
  XExtDataStarStar =  UNTRACED REF XExtDataStar;
</PRE><P>
 * This file contains structures used by the extension mechanism.
 

<P><PRE>TYPE
  XExtCodes = RECORD
        extension: Int;           (* extension number *)
        major_opcode: Int;        (* major op-code assigned by server *)
        first_event: Int;         (* first event number for the extension *)
        first_error: Int;         (* first error number for the extension *)
  END;
  XExtCodesStar  =  UNTRACED REF XExtCodes;
</PRE><P>
 * This structure is private to the library.
 

<P><PRE>TYPE
  XExtension = RECORD             (* private to extension mechanism *)
        next: XExtensionStar;     (* next in list *)
        codes: XExtCodes;         (* public information, all extension told *)
        create_GC: RetIntProc;    (* routine to call when GC created *)
        copy_GC: RetIntProc;      (* routine to call when GC copied *)
        flush_GC: RetIntProc;     (* routine to call when GC flushed *)
        free_GC: RetIntProc;      (* routine to call when GC freed *)
        create_Font: RetIntProc;  (* routine to call when Font created *)
        free_Font: RetIntProc;    (* routine to call when Font freed *)
        close_display: RetIntProc;(* routine to call when connection closed *)
        error: RetIntProc;        (* who to call when an error occurs *)
        error_string: Retchar_starProc;  (* routine to supply error string *)
        name: char_star;           (* name of this extension *)
  END;
  XExtensionStar = UNTRACED REF XExtension;
</PRE><P>
 * Data structure for retrieving info about pixmap formats.
 

<P><PRE>TYPE
  XPixmapFormatValues = RECORD
    depth: Int;
    bits_per_pixel: Int;
    scanline_pad: Int;
  END;
  XPixmapFormatValuesStar  =  UNTRACED REF XPixmapFormatValues;
</PRE><P>
 * Data structure for setting graphics context.
 
<PRE>TYPE
  XGCValues = RECORD
        function: Int;           (* logical operation *)
        plane_mask: unsigned_long;(* plane mask *)
        foreground: unsigned_long;(* foreground pixel *)
        background: unsigned_long;(* background pixel *)
        line_width: Int;         (* line width *)
        line_style: Int;         (* LineSolid, LineOnOffDash, LineDoubleDash *)
        cap_style: Int;          (* CapNotLast, CapButt,
                                   CapRound, CapProjecting *)
        join_style: Int;         (* JoinMiter, JoinRound, JoinBevel *)
        fill_style: Int;         (* FillSolid, FillTiled,
                                   FillStippled, FillOpaeueStippled *)
        fill_rule: Int;          (* EvenOddRule, WindingRule *)
        arc_mode: Int;           (* ArcChord, ArcPieSlice *)
        tile: Pixmap;            (* tile pixmap for tiling operations *)
        stipple: Pixmap;         (* stipple 1 plane pixmap for stipping *)
        ts_x_origin: Int;        (* offset for tile or stipple operations *)
        ts_y_origin: Int;
        font: Font;              (* default text font for text operations *)
        subwindow_mode: Int;     (* ClipByChildren, IncludeInferiors *)
        graphics_exposures: Bool;(* boolean, should exposures be generated *)
        clip_x_origin: Int;      (* origin for clipping *)
        clip_y_origin: Int;
        clip_mask: Pixmap;       (* bitmap clipping; other calls for rects *)
        dash_offset: Int;        (* patterned/dashed line information *)
        dashes: Char;
  END;

TYPE
  XGCValuesStar  =  UNTRACED REF XGCValues;
</PRE><P>
 * Graphics context.  All Xlib routines deal in this rather than
 * in raw protocol GContext ID's.  This is so that the library can keep
 * a <CODE>shadow</CODE> set of values, and thus avoid passing values over the
 * wire which are not in fact changing. 
 

<P><PRE>TYPE
  GC = UNTRACED REF RECORD
    ext_data: XExtDataStar;      (* hook for extension to hang data *)
    gid: GContext;               (* protocol ID for graphics context *)
    rects: Bool;          (* boolean: TRUE if clipmask is list of rectangles *)
    dashes: Bool;             (* boolean: TRUE if dash-list is really a list *)
    dirty: unsigned_long;         (* cache dirty bits *)
    values: XGCValues;           (* shadow structure of values *)
  END;
</PRE><P>
 * Visual structure; contains information about colormapping possible.
 

<P><PRE>TYPE
  Visual = RECORD
        ext_data: XExtDataStar;  (* hook for extension to hang data *)
        visualid: VisualID;      (* visual id of this visual *)
        class: Int;              (* class of screen (monochrome, etc.) *)
        red_mask, green_mask, blue_mask: unsigned_long;  (* mask values *)
        bits_per_rgb: Int;       (* log base 2 of distinct color values *)
        map_entries: Int;        (* color map entries *)
  END;
  VisualStar   =  UNTRACED REF Visual;
</PRE><P>
 * Depth structure; contains information for each possible depth.
      

<P><PRE>TYPE
  Depth = RECORD
        depth: Int;              (* this depth (Z) of the depth *)
        nvisuals: Int;           (* number of Visual types at this depth *)
        visuals: VisualStar;     (* list of visuals possible at this depth *)
  END;
  DepthStar    =  UNTRACED REF Depth;
</PRE><P>
 * Information about the screen.
 

<P><PRE>TYPE Screen = RECORD
        ext_data: XExtDataStar;  (* hook for extension to hang data *)
        display: DisplayStar;    (* back pointer to display structure *)
        root: Window;            (* Root window id. *)
        width, height: Int;      (* width and height of screen *)
        mwidth, mheight: Int;    (* width and height of  in millimeters *)
        ndepths: Int;            (* number of depths possible *)
        depths: DepthStar;       (* list of allowable depths on the screen *)
        root_depth: Int;         (* bits per pixel *)
        root_visual: VisualStar; (* root visual *)
        default_gc: GC;          (* GC for the root root visual *)
        cmap: Colormap;          (* default color map *)
        white_pixel: unsigned_long;
        black_pixel: unsigned_long; (* White and Black pixel values *)
        max_maps, min_maps: Int; (* max and min color maps *)
        backing_store: Int;      (* Never, WhenMapped, Always *)
        save_unders: Bool;
        root_input_mask: Long;   (* initial root input mask *)
  END;
  ScreenStar    =  UNTRACED REF Screen;
</PRE><P>
 * Format structure; describes ZFormat data the screen will understand.
 

<P><PRE>TYPE
  ScreenFormat = RECORD
        ext_data: XExtDataStar;  (* hook for extension to hang data *)
        depth: Int;              (* depth of this image format *)
        bits_per_pixel: Int;     (* bits/pixel at this depth *)
        scanline_pad: Int;       (* scanline must padded to this multiple *)
  END;
  ScreenFormatStar     =  UNTRACED REF ScreenFormat;
</PRE><P>
 * Data structure for setting window attributes.
 

<P><PRE>TYPE
  XSetWindowAttributes = RECORD
    background_pixmap: Pixmap;   (* background or None or ParentRelative *)
    background_pixel: unsigned_long;     (* background pixel *)
    border_pixmap: Pixmap;       (* border of the window *)
    border_pixel: unsigned_long;  (* border pixel value *)
    bit_gravity: Int;            (* one of bit gravity values *)
    win_gravity: Int;            (* one of the window gravity values *)
    backing_store: Int;          (* NotUseful, WhenMapped, Always *)
    backing_planes: unsigned_long;(* planes to be preseved if possible *)
    backing_pixel: unsigned_long; (* value to use in restoring planes *)
    save_under: Bool;            (* should bits under be saved? (popups) *)
    event_mask: Long;            (* set of events that should be saved *)
    do_not_propagate_mask: Long; (* set of events that should not propagate *)
    override_redirect: Bool;     (* boolean value for override-redirect *)
    colormap: Colormap;          (* color map to be associated with window *)
    cursor: Cursor;              (* cursor to be displayed (or None) *)
  END;

  XWindowAttributes = RECORD
    x, y: Int;                   (* location of window *)
    width, height: Int;          (* width and height of window *)
    border_width: Int;           (* border width of window *)
    depth: Int;                  (* depth of window *)
    visual: VisualStar;          (* the associated visual structure *)
    root: Window;                (* root of screen containing window *)
    class: Int;                  (* InputOutput, InputOnly*)
    bit_gravity: Int;            (* one of bit gravity values *)
    win_gravity: Int;            (* one of the window gravity values *)
    backing_store: Int;          (* NotUseful, WhenMapped, Always *)
    backing_planes: unsigned_long;(* planes to be preserved if possible *)
    backing_pixel: unsigned_long; (* value to be used when restoring planes *)
    save_under: Bool;            (* boolean, should bits under be saved? *)
    colormap: Colormap;          (* color map to be associated with window *)
    map_installed: Bool;         (* boolean, is color map currently installed*)
    map_state: Int;              (* IsUnmapped, IsUnviewable, IsViewable *)
    all_event_masks: Long;       (* set of events all people have interest in*)
    your_event_mask: Long;       (* my event mask *)
    do_not_propagate_mask: Long; (* set of events that should not propagate *)
    override_redirect: Bool;     (* boolean value for override-redirect *)
    screen: ScreenStar;          (* back pointer to correct screen *)
  END;

TYPE
  XSetWindowAttributesStar    =  UNTRACED REF XSetWindowAttributes;
  XWindowAttributesStar       =  UNTRACED REF XWindowAttributes;
</PRE><P>
 * Data structure for host setting; getting routines.
 *
 

<P><PRE>TYPE
  XHostAddress = RECORD
        family: Int;             (* for example AF_DNET *)
        length: Int;             (* length of address, in bytes *)
        address: char_star;       (* pointer to where to find the bytes *)
  END;
  XHostAddressStar   =  UNTRACED REF XHostAddress;
</PRE><P>
 * Data structure for <CODE>image</CODE> data, used by image manipulation routines.
 

<P><PRE>TYPE
  CreateImageProc = PROCEDURE (): XImageStar;
  DestroyImageProc = PROCEDURE (i: XImageStar): Int;
  GetPixelProc = PROCEDURE (i: XImageStar; x, y: Int): unsigned_long;
  PutPixelProc = PROCEDURE (i: XImageStar; x, y: Int; p: unsigned_long): Int;
  SubImageProc = PROCEDURE (i: XImageStar;
                            x, y: Int; w, h: unsigned_int): XImageStar;
  AddPixelProc = PROCEDURE(i: XImageStar): Int;

  XImage = RECORD
    width, height: Int;          (* size of image *)
    xoffset: Int;                (* number of pixels offset in X direction *)
    format: Int;                 (* XYBitmap, XYPixmap, ZPixmap *)
    data: char_star;              (* pointer to image data *)
    byte_order: Int;             (* data byte order, LSBFirst, MSBFirst *)
    bitmap_unit: Int;            (* quant. of scanline 8, 16, 32 *)
    bitmap_bit_order: Int;       (* LSBFirst, MSBFirst *)
    bitmap_pad: Int;             (* 8, 16, 32 either XY or ZPixmap *)
    depth: Int;                  (* depth of image *)
    bytes_per_line: Int;         (* accelarator to next line *)
    bits_per_pixel: Int;         (* bits per pixel (ZPixmap) *)
    red_mask: unsigned_long;      (* bits in z arrangment *)
    green_mask: unsigned_long;
    blue_mask: unsigned_long;
    obdata: char_star;            (* hook for the object routines to hang on *)
    f: RECORD                    (* image manipulation routines *)
        create_image: CreateImageProc;
        destroy_image: DestroyImageProc;
        get_pixel: GetPixelProc;
        put_pixel: PutPixelProc;
        sub_image: SubImageProc;
        add_pixel: AddPixelProc;
    END;
  END;
  XImageStar  =  UNTRACED REF XImage;
</PRE> <P>
 * Data structure for XReconfigureWindow
 

<P><PRE>TYPE
  XWindowChanges = RECORD
    x, y: Int;
    width, height: Int;
    border_width: Int;
    sibling: Window;
    stack_mode: Int;
  END;
  XWindowChangesStar  =  UNTRACED REF XWindowChanges;
</PRE><P>
 * Data structure used by color operations
 

<P><PRE>TYPE
  XColor = RECORD
    pixel: unsigned_long;
    red, green, blue: unsigned_short;
    flags: Char;               (* do_red, do_green, do_blue *)
    pad: Char;
  END;
  XColorStar = UNTRACED REF XColor;
</PRE> <P>
 * Data structures for graphics operations.  On most machines, these are
 * congruent with the wire protocol structures, so reformatting the data
 * can be avoided on these architectures.
 

<P><PRE>TYPE

  XSegment	=  RECORD
		     x1, y1, x2, y2: Short;
		   END;
  XSegmentStar	=  UNTRACED REF XSegment;

  XPoint	=  RECORD
		     x, y: Short;
		   END;
  XPoint_star	=  UNTRACED REF XPoint;

  XRectangle	=  RECORD
		     x, y: Short;
		     width, height: unsigned_short;
		   END;
  XRectangleStar=  UNTRACED REF XRectangle;

  XArc		=  RECORD
		     x, y: Short;
		     width, height: unsigned_short;
		     angle1, angle2: Short;
		   END;
  XArcStar	=  UNTRACED REF XArc;
</PRE> Data structure for XChangeKeyboardControl 

<P><PRE>TYPE
  XKeyboardControl = RECORD
        key_click_percent: Int;
        bell_percent: Int;
        bell_pitch: Int;
        bell_duration: Int;
        led: Int;
        led_mode: Int;
        key: Int;
        auto_repeat_mode: Int;   (* On, Off, Default *)
  END;
  XKeyboardControlStar = UNTRACED REF XKeyboardControl;
</PRE> Data structure for XGetKeyboardControl 

<P><PRE>TYPE
  XKeyboardState = RECORD
        key_click_percent: Int;
        bell_percent: Int;
        bell_pitch, bell_duration: unsigned_int;
        led_mask: unsigned_long;
        global_auto_repeat: Int;
        auto_repeats: ARRAY [0 .. 31] OF Char;
  END;
  XKeyboardStateStar  =  UNTRACED REF XKeyboardState;
</PRE> Data structure for XGetMotionEvents.  

<P><PRE>TYPE
  XTimeCoord = RECORD
        time: Time;
        x, y: Short;
  END;
  XTimeCoordStar  = UNTRACED REF XTimeCoord;
</PRE> Data structure for X{Set,Get}ModifierMapping 

<P><PRE>TYPE
  XModifierKeymap = RECORD
        max_keypermod: Int;      (* The server's max # of keys per modifier *)
        modifiermap: KeyCodeStar;(* An 8 by max_keypermod array of modifiers *)
  END;
  XModifierKeymapStar  =  UNTRACED REF XModifierKeymap;
</PRE><P>
 * internal atoms used for ICCCM things; not to be used by client
 

<P><PRE>TYPE
  DisplayAtoms = RECORD
    text: Atom;
    wm_state: Atom;
    wm_protocols: Atom;
    wm_save_yourself: Atom;
    wm_change_state: Atom;
    wm_colormap_windows: Atom;
    (* add new atoms to end of list *)
  END;
  DisplayAtomsStar = UNTRACED REF DisplayAtoms;
</PRE><P>
 * Display datatype maintaining display specific data.
 

<P><PRE>TYPE
  Display = RECORD
        ext_data: XExtDataStar;  (* hook for extension to hang data *)
        next: DisplayStar;       (* next open Display on list *)
        fd: Int;                 (* Network socket. *)
        lock: Int;               (* is someone in critical section? *)
        proto_major_version: Int;(* maj. version of server's X protocol *)
        proto_minor_version: Int;(* minor version of servers X protocol *)
        vendor: char_star;        (* vendor of the server hardware *)
        resource_base: Long;     (* resource ID base *)
        resource_mask: Long;     (* resource ID mask bits *)
        resource_id: Long;       (* allocator current ID *)
        resource_shift: Int;     (* allocator shift to correct bits *)
        resource_alloc: PROCEDURE(): XID; (* allocator function *)
        byte_order: Int;         (* screen byte order, LSBFirst, MSBFirst *)
        bitmap_unit: Int;        (* padding and data requirements *)
        bitmap_pad: Int;         (* padding requirements on bitmaps *)
        bitmap_bit_order: Int;   (* LeastSignificant or MostSignificant *)
        nformats: Int;           (* number of pixmap formats in list *)
        pixmap_format: ScreenFormatStar;    (* pixmap format list *)
        vnumber: Int;            (* Xlib's X protocol version number. *)
        release: Int;            (* release of the server *)
        head, tail: XQEventStar; (* Input event queue. *)
        qlen: Int;               (* Length of input event queue *)
        last_request_read: unsigned_long; (* seq number of last event read *)
        request: unsigned_long;   (* sequence number of last request. *)
        last_req: char_star;      (* beginning of last request, or dummy *)
        buffer: char_star;        (* Output buffer starting address. *)
        bufptr: char_star;        (* Output buffer index pointer. *)
        bufmax: char_star;        (* Output buffer maximum+1 address. *)
        max_request_size: unsigned_int; (* max number 32 bit words in request*)
        db: ADDRESS;		 (*?!? wrong ?!?*)
        synchandler: XSynchronize;(* Synchronization handler *)
        display_name: char_star; (* &quot;host:display&quot; string used on this connect*)
        default_screen: Int;     (* default screen for operations *)
        nscreens: Int;           (* number of screens on this server*)
        screens: ScreenStar;     (* pointer to list of screens *)
        motion_buffer: unsigned_long;    (* size of motion buffer *)
        current: Window;         (* for use internally for Keymap notify *)
        min_keycode: Int;        (* minimum defined keycode *)
        max_keycode: Int;        (* maximum defined keycode *)
        keysyms: KeySymStar;     (* This server's keysyms *)
        modifiermap: XModifierKeymapStar;   (* This server's modifier keymap *)
        keysyms_per_keycode: Int;(* number of rows *)
        xdefaults: char_star;     (* contents of defaults from server *)
        scratch_buffer: char_star;(* place to hang scratch buffer *)
        scratch_length: unsigned_long;   (* length of scratch buffer *)
        ext_number: Int;         (* extension number on this display *)
        ext_procs: XExtensionStar; (* extensions initialized on this display *)
        (*
         * the following can be fixed size, as the protocol defines how
         * much address space is available.
         * While this could be done using the extension vector, there
         * may be MANY events processed, so a search through the extension
         * list to find the right procedure for each event might be
         * expensive if many extensions are being used.
         *)
        event_vec: ARRAY [0 .. 127] OF PROCEDURE(): Bool;
        wire_vec: ARRAY [0 .. 127] OF PROCEDURE(): Status;
        lock_meaning: KeySym;       (* for XLookupString *)
        key_bindings: ADDRESS;      (* for XLookupString *) (*?!? wrong ?!?*)
        cursor_font: Font;          (* for XCreateFontCursor *)
        (*
         * ICCCM information, version 1
         *)
        atoms: DisplayAtomsStar;
        reconfigure_wm_window: RECORD (* for XReconfigureWMWindow *)
            sequence_number: Long;
            old_handler: PROCEDURE(): Int;
            succeeded: Bool;
        END;
        (*
         * additional connection info
         *)
        flags: unsigned_long;       (* internal connection flags *)
        mode_switch: unsigned_int;  (* keyboard group modifiers *)
  END;
  DisplayStar   =   UNTRACED REF Display;
</PRE><P>
 * A <CODE>XEvent</CODE> structure always  has type as the first entry.  This 
 * uniquely identifies what  kind of event it is.  The second entry
 * is always a pointer to the display the event was read from.
 * The third entry is always a window of one type or another,
 * carefully selected to be useful to toolkit dispatchers.  (Except
 * for keymap events, which have no window.) You
 * must not change the order of the three elements or toolkits will
 * break! The pointer to the generic event must be cast before use to 
 * access any other information in the structure.
 

<P>
 * Definitions of specific events.
 
<PRE>TYPE
  XKeyEvent = RECORD
     type: Int;                (* of event *)
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;           (* &quot;event&quot; window it is reported relative to *)
     root: Window;             (* root window that the event occured on *)
     subwindow: Window;        (* child window *)
     time: Time;               (* milliseconds *)
     x, y: Int;                (* pointer x, y coordinates in event window *)
     x_root, y_root: Int;      (* coordinates relative to root *)
     state: unsigned_int;       (* key or button mask *)
     keycode: unsigned_int;     (* detail *)
     same_screen: Bool         (* same screen flag *)
              END;

  XKeyEventStar			= UNTRACED REF XKeyEvent;
  XKeyPressedEvent		= XKeyEvent;
  XKeyPressedEventStar		= UNTRACED REF XKeyPressedEvent;
  XKeyReleasedEvent		= XKeyEvent;
  XKeyReleasedEventStar		= UNTRACED REF XKeyReleasedEvent;

TYPE
  XButtonEvent = RECORD
     type: Int;                (* of event *)
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;           (* &quot;event&quot; window it is reported relative to *)
     root: Window;             (* root window that the event occured on *)
     subwindow: Window;        (* child window *)
     time: Time;               (* milliseconds *)
     x, y: Int;                (* poInter x, y coordinates in event window *)
     x_root, y_root: Int;      (* coordinates relative to root *)
     state: unsigned_int;       (* key or button mask *)
     button: unsigned_int;      (* detail *)
     same_screen: Bool         (* same screen flag *)
              END;

  XButtonEventStar		= UNTRACED REF   XButtonEvent;
  XButtonPressedEvent		= XButtonEvent;
  XButtonPressedEventStar	= UNTRACED REF  XButtonPressedEvent;
  XButtonReleasedEvent		= XButtonEvent;
  XButtonReleasedEventStar	= UNTRACED REF  XButtonReleasedEvent;

TYPE
  XMotionEvent = RECORD
     type: Int;                (* of event *)
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;           (* &quot;event&quot; window reported relative to *)
     root: Window;             (* root window that the event occured on *)
     subwindow: Window;        (* child window *)
     time: Time;               (* milliseconds *)
     x, y: Int;                (* pointer x, y coordinates in event window *)
     x_root, y_root: Int;      (* coordinates relative to root *)
     state: unsigned_int;       (* key or button mask *)
     is_hint: Char;            (* detail *)
     same_screen: Bool         (* same screen flag *)
              END;

  XMotionEventStar		= UNTRACED REF   XMotionEvent;
  XPointerMovedEvent		= XMotionEvent ;
  XPointerMovedEventStar	= UNTRACED REF  XPointerMovedEvent;

TYPE
  XCrossingEvent = RECORD
     type: Int;                (* of event *)
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;           (* &quot;event&quot; window reported relative to *)
     root: Window;             (* root window that the event occured on *)
     subwindow: Window;        (* child window *)
     time: Time;               (* milliseconds *)
     x, y: Int;                (* pointer x, y coordinates in event window *)
     x_root, y_root: Int;      (* coordinates relative to root *)
     mode: Int;                (* NotifyNormal, NotifyGrab, NotifyUngrab *)
     detail: Int;
    (*
     * NotifyAncestor, NotifyVirtual, NotifyInferior,
     * NotifyNonLinear,NotifyNonLinearVirtual
     *)
     same_screen: Bool;        (* same screen flag *)
     focus: Bool;              (* boolean focus *)
     state: unsigned_int        (* key or button mask *)
              END;

  XCrossingEventStar		= UNTRACED REF   XCrossingEvent;
  XEnterWindowEvent		= XCrossingEvent;
  XEnterWindowEventStar		= UNTRACED REF XEnterWindowEvent;
  XLeaveWindowEvent		= XCrossingEvent;
  XLeaveWindowEventStar		= UNTRACED REF XLeaveWindowEvent;

TYPE
  XFocusChangeEvent = RECORD
     type: Int;                (* FocusIn or FocusOut *)
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;           (* window of event *)
     mode: Int;                (* NotifyNormal, NotifyGrab, NotifyUngrab *)
     detail: Int
    (*
     * NotifyAncestor, NotifyVirtual, NotifyInferior,
     * NotifyNonLinear,NotifyNonLinearVirtual, NotifyPointer,
     * NotifyPointerRoot, NotifyDetailNone
     *)
              END;

  XFocusChangeEventStar		= UNTRACED REF   XFocusChangeEvent;
  XFocusInEvent			= XFocusChangeEvent;
  XFocusInEventStar		= UNTRACED REF XFocusInEvent;
  XFocusOutEvent		= XFocusChangeEvent;
  XFocusOutEventStar		= UNTRACED REF XFocusOutEvent;
</PRE> generated on EnterWindow and FocusIn  when KeyMapState selected 

<P><PRE>TYPE
  XKeymapEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     key_vector: ARRAY [0..31] OF Char
              END;

  XKeymapEventStar		= UNTRACED REF   XKeymapEvent;

TYPE
  XExposeEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     x, y: Int;
     width, height: Int;
     count: Int                (* if non-zero, at least this many more *)
              END;

  XExposeEventStar		= UNTRACED REF   XExposeEvent;

TYPE
  XGraphicsExposeEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     drawable: Drawable;
     x, y: Int;
     width, height: Int;
     count: Int;               (* if non-zero, at least this many more *)
     major_code: Int;          (* core is CopyArea or CopyPlane *)
     minor_code: Int           (* not defined in the core *)
              END;

  XGraphicsExposeEventStar	= UNTRACED REF   XGraphicsExposeEvent;

TYPE
  XNoExposeEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     drawable: Drawable;
     major_code: Int;          (* core is CopyArea or CopyPlane *)
     minor_code: Int           (* not defined in the core *)
              END;

  XNoExposeEventStar		= UNTRACED REF   XNoExposeEvent;

TYPE
  XVisibilityEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     state: Int                (* Visibility state *)
              END;

  XVisibilityEventStar		= UNTRACED REF   XVisibilityEvent;

TYPE
  XCreateWindowEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     parent: Window;           (* parent of the window *)
     window: Window;           (* window id of window created *)
     x, y: Int;                (* window location *)
     width, height: Int;       (* size of window *)
     border_width: Int;        (* border width *)
     override_redirect: Bool   (* creation should be overridden *)
              END;

  XCreateWindowEventStar	= UNTRACED REF   XCreateWindowEvent;

TYPE
  XDestroyWindowEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     event: Window;
     window: Window
              END;

  XDestroyWindowEventStar	= UNTRACED REF   XDestroyWindowEvent;

TYPE
  XUnmapEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     event: Window;
     window: Window;
     from_configure: Bool
              END;

  XUnmapEventStar		= UNTRACED REF   XUnmapEvent;

TYPE
  XMapEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     event: Window;
     window: Window;
     override_redirect: Bool (* boolean, is override set... *)
              END;

  XMapEventStar			= UNTRACED REF   XMapEvent;

TYPE
  XMapRequestEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     parent: Window;
     window: Window
              END;

  XMapRequestEventStar		= UNTRACED REF   XMapRequestEvent;

TYPE
  XReparentEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     event: Window;
     window: Window;
     parent: Window;
     x, y: Int;
     override_redirect: Bool
              END;

  XReparentEventStar		= UNTRACED REF   XReparentEvent;

TYPE
  XConfigureEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     event: Window;
     window: Window;
     x, y: Int;
     width, height: Int;
     border_width: Int;
     above: Window;
     override_redirect: Bool
              END;

  XConfigureEventStar		= UNTRACED REF   XConfigureEvent;

TYPE
  XGravityEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     event: Window;
     window: Window;
     x, y: Int
              END;

  XGravityEventStar		= UNTRACED REF   XGravityEvent;

TYPE
  XResizeRequestEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     width, height: Int
              END;

  XResizeRequestEventStar	= UNTRACED REF   XResizeRequestEvent;

TYPE
  XConfigureRequestEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     parent: Window;
     window: Window;
     x, y: Int;
     width, height: Int;
     border_width: Int;
     above: Window;
     detail: Int;              (* Above, Below, TopIf, BottomIf, Opposite *)
     value_mask: unsigned_long
              END;

  XConfigureRequestEventStar	= UNTRACED REF   XConfigureRequestEvent;

TYPE
  XCirculateEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     event: Window;
     window: Window;
     place: Int                (* PlaceOnTop, PlaceOnBottom *)
              END;

  XCirculateEventStar		= UNTRACED REF   XCirculateEvent;

TYPE
  XCirculateRequestEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     parent: Window;
     window: Window;
     place: Int                (* PlaceOnTop, PlaceOnBottom *)
              END;

  XCirculateRequestEventStar	= UNTRACED REF   XCirculateRequestEvent;

TYPE
  XPropertyEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     atom: Atom;
     time: Time;
     state: Int                (* NewValue, Deleted *)
              END;

  XPropertyEventStar		= UNTRACED REF   XPropertyEvent;

TYPE
  XSelectionClearEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     selection: Atom;
     time: Time
              END;

  XSelectionClearEventStar	= UNTRACED REF   XSelectionClearEvent;

TYPE
  XSelectionRequestEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     owner: Window;
     requestor: Window;
     selection: Atom;
     target: Atom;
     property: Atom;
     time: Time
              END;

  XSelectionRequestEventStar	= UNTRACED REF   XSelectionRequestEvent;

TYPE
  XSelectionEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     requestor: Window;
     selection: Atom;
     target: Atom;
     property: Atom;           (* ATOM or None *)
     time: Time
              END;

  XSelectionEventStar		= UNTRACED REF   XSelectionEvent;

TYPE
  XColormapEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     colormap: Colormap;       (* COLORMAP or None *)
     new: Bool;
     state: Int                (* ColormapInstalled, ColormapUninstalled *)
              END;

  XColormapEventStar		= UNTRACED REF   XColormapEvent;

TYPE
  XClientMessageEvent = RECORD
     type: int;
     serial: unsigned_long;    (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     message_type: Atom;
     format: int;
     alignment: ARRAY [0..-1] OF long;
     data: ARRAY [0..MAX (20 * BYTESIZE (char),
                          MAX (10 * BYTESIZE (short),
                               5 * BYTESIZE (long))) - 1] OF char; END;

  XClientMessageEvent_b = RECORD
     type: int;
     serial: unsigned_long;    (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     message_type: Atom;
     format: int;
     alignment: ARRAY [0..-1] OF long;
     data: ARRAY [0.. 19] OF char; END;

  XClientMessageEvent_s = RECORD
     type: int;
     serial: unsigned_long;    (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     message_type: Atom;
     format: int;
     alignment: ARRAY [0..-1] OF long;
     data: ARRAY [0..9] OF short; END;

  XClientMessageEvent_l = RECORD
     type: int;
     serial: unsigned_long;    (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;
     message_type: Atom;
     format: int;
     data: ARRAY [0..4] OF long; END;

  XClientMessageEventStar	= UNTRACED REF XClientMessageEvent;
  XClientMessageEvent_b_star	= UNTRACED REF XClientMessageEvent_b;
  XClientMessageEvent_s_star	= UNTRACED REF XClientMessageEvent_s;
  XClientMessageEvent_l_star	= UNTRACED REF XClientMessageEvent_l;

TYPE
  XMappingEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;         (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window;           (* unused *)
     request: Int;             (* one of MappingModifier, MappingKeyboard,
                                  MappingPointer *)
     first_keycode: Int;       (* first keycode *)
     count: Int                (* defines range of change w. first_keycode*)
              END;

  XMappingEventStar		= UNTRACED REF   XMappingEvent;

TYPE
  XErrorEvent = RECORD
     type: Int;
     display: DisplayStar;      (* Display the event was read from *)
     resourceid: XID;           (* resource id *)
     serial: unsigned_long;      (* serial number of failed request *)
     error_code: unsigned_char;  (* error code of failed request *)
     request_code: unsigned_char;(* Major op-code of failed request *)
     minor_code: unsigned_char   (* Minor op-code of failed request *)
                 END;

   XErrorEventStar		=  UNTRACED REF XErrorEvent;

TYPE
  XAnyEvent = RECORD
     type: Int;
     serial: unsigned_long;     (* # of last request processed by server *)
     send_event: Bool;	       (* true if this came from a SendEvent request *)
     display: DisplayStar;     (* Display the event was read from *)
     window: Window	(* window on which event was requested in event mask *)
              END;

  XAnyEventStar			= UNTRACED REF   XAnyEvent;
</PRE><P>
 * This type is defined so Xlib can always use the same sized
 * event structure internally, to avoid memory fragmentation.
 

<P><PRE>CONST XEventSize =
  MAX (BYTESIZE (Int),
  MAX (BYTESIZE (XAnyEvent),
  MAX (BYTESIZE (XKeyEvent),
  MAX (BYTESIZE (XButtonEvent),
  MAX (BYTESIZE (XMotionEvent),
  MAX (BYTESIZE (XCrossingEvent),
  MAX (BYTESIZE (XFocusChangeEvent),
  MAX (BYTESIZE (XExposeEvent),
  MAX (BYTESIZE (XGraphicsExposeEvent),
  MAX (BYTESIZE (XNoExposeEvent),
  MAX (BYTESIZE (XVisibilityEvent),
  MAX (BYTESIZE (XCreateWindowEvent),
  MAX (BYTESIZE (XDestroyWindowEvent),
  MAX (BYTESIZE (XUnmapEvent),
  MAX (BYTESIZE (XMapEvent),
  MAX (BYTESIZE (XMapRequestEvent),
  MAX (BYTESIZE (XReparentEvent),
  MAX (BYTESIZE (XConfigureEvent),
  MAX (BYTESIZE (XGravityEvent),
  MAX (BYTESIZE (XResizeRequestEvent),
  MAX (BYTESIZE (XConfigureRequestEvent),
  MAX (BYTESIZE (XCirculateEvent),
  MAX (BYTESIZE (XCirculateRequestEvent),
  MAX (BYTESIZE (XPropertyEvent),
  MAX (BYTESIZE (XSelectionClearEvent),
  MAX (BYTESIZE (XSelectionRequestEvent),
  MAX (BYTESIZE (XSelectionEvent),
  MAX (BYTESIZE (XColormapEvent),
  MAX (BYTESIZE (XClientMessageEvent),
  MAX (BYTESIZE (XMappingEvent),
  MAX (BYTESIZE (XErrorEvent),
  MAX (BYTESIZE (XKeymapEvent),
       BYTESIZE (ARRAY [1..24] OF Long)))))))))))))))))))))))))))))))));

TYPE
  XEvent = ARRAY [0 .. XEventSize - 1] OF Char;
  XEventStar  =  UNTRACED REF XEvent;
</PRE><P>
 * _QEvent datatype for use in input queueing.
 

<P><PRE>TYPE
  XQEvent = RECORD
    next: XQEventStar;
    event: XEvent
  END;
  XQEventStar = UNTRACED REF XQEvent;
</PRE> ?!?!?!
#define XAllocID(dpy) (( *(dpy)-&gt;resource_alloc)((dpy)))
?!?!?! 

<P>
 * per character font metric information.
 

<P><PRE>TYPE
  XCharStruct = RECORD
    lbearing: Short;            (* origin to left edge of raster *)
    rbearing: Short;            (* origin to right edge of raster *)
    width: Short;               (* advance to next char's origin *)
    ascent: Short;              (* baseline to top edge of raster *)
    descent: Short;             (* baseline to bottom edge of raster *)
    attributes: unsigned_short  (* per char flags (not predefined) *)
  END;
  XCharStructStar  =  UNTRACED REF XCharStruct;
</PRE><P>
 * To allow arbitrary information with fonts, there are additional properties
 * returned.
 

<P><PRE>TYPE
  XFontProp = RECORD
    name: Atom;
    card32: unsigned_long;
  END;
  XFontPropStar = UNTRACED REF XFontProp;

  XFontStruct = RECORD
    ext_data: XExtDataStar;      (* hook for extension to hang data *)
    fid: Font;            (* Font id for this font *)
    direction: unsigned_int;      (* hint about direction the font is painted *)
    min_char_or_byte2: unsigned_int;(* first character *)
    max_char_or_byte2: unsigned_int;(* last character *)
    min_byte1: unsigned_int;      (* first row that exists *)
    max_byte1: unsigned_int;      (* last row that exists *)
    all_chars_exist: Bool;(* flag if all characters have non-zero size*)
    default_char: unsigned_int;   (* char to print for undefined character *)
    n_properties: Int;   (* how many properties there are *)
    properties: XFontPropStar;    (* pointer to array of additional properties*)
    min_bounds: XCharStruct;     (* minimum bounds over all existing char *)
    max_bounds: XCharStruct;     (* maximum bounds over all existing char *)
    per_char: XCharStructStar;      (* first_char to last_char information *)
    ascent: Int;         (* log. extent above baseline for spacing *)
    descent: Int;        (* log. descent below baseline for spacing *)
  END;
  XFontStructStar      =  UNTRACED REF XFontStruct;
  XFontStructStarStar  =  UNTRACED REF XFontStructStar;
</PRE><P>
 * PolyText routines take these as arguments.
 

<P><PRE>TYPE
  XTextItem = RECORD
    chars: char_star;                (* pointer to string *)
    nchars: Int;                 (* number of characters *)
    delta: Int;                  (* delta between strings *)
    font: Font;                  (* font to print it in, None don't change *)
  END;

  XChar2b = RECORD
    byte1: unsigned_char;
    byte2: unsigned_char;
  END;

  XTextItem16 = RECORD
    chars: XChar2bStar;             (* two byte characters *)
    nchars: Int;                 (* number of characters *)
    delta: Int;                  (* delta between strings *)
    font: Font;                  (* font to print it in, None don't change *)
  END;

TYPE
  XTextItemStar    =  UNTRACED REF XTextItem;
  XChar2bStar      =  UNTRACED REF XChar2b;
  XTextItem16Star  =  UNTRACED REF XTextItem16;
</PRE> ?!?!?!
typedef union { DisplayStar display;
                GC gc;
                VisualStar visual;
                ScreenStar screen;
                ScreenFormatStar pixmap_format;
                XFontStructStar font; } XEDataObject;
?!?!?! 

<P><PRE>TYPE
  XEDataObject  =  ADDRESS;

&lt;*EXTERNAL*&gt; PROCEDURE XLoadQueryFont(
        display:          DisplayStar;
        name:             const_char_star
): XFontStructStar RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XQueryFont(
        display:          DisplayStar;
        font:             XID
): XFontStructStar RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetMotionEvents(
        display:          DisplayStar;
        w:                Window;
        start:            Time;
        stop:             Time;
        nevents:          int_star
): XTimeCoordStar RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDeleteModifiermapEntry(
        modmap:           XModifierKeymapStar;
        keycode:          unsigned_int
): XModifierKeymapStar RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetModifierMapping(
        display:          DisplayStar
): XModifierKeymapStar RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XInsertModifiermapEntry(
        modmap:           XModifierKeymapStar;
        keycode:          KeyCode
): XModifierKeymapStar RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XNewModifiermap(
        max:              Int
): XModifierKeymapStar RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCreateImage(
        display:          DisplayStar;
        visual:           VisualStar;
        depth:            unsigned_int;
        format:           Int;
        offset:           Int;
        data:             char_star;
        width:            unsigned_int;
        height:           unsigned_int;
        bitmap:           Int;
        bytes:            Int
): XImageStar RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetImage(
        display:          DisplayStar;
        d:                Drawable;
        x:                Int;
        y:                Int;
        width:            unsigned_int;
        height:           unsigned_int;
        plane:            unsigned_long;
        format:           Int
): XImageStar RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetSubImage(
        display:          DisplayStar;
        d:                Drawable;
        x:                Int;
        y:                Int;
        width:            unsigned_int;
        height:           unsigned_int;
        plane:            unsigned_long;
        format:           Int;
        dest_image:       XImageStar;
        dest_x:           Int;
        dest_y:           Int
): XImageStar RAISES {Error};
</PRE> <P>
 * X function declarations.
 

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE XOpenDisplay(
        display:          const_char_star;
): DisplayStar RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XrmInitialize(
);

&lt;*EXTERNAL*&gt; PROCEDURE XFetchBytes(
        display:          DisplayStar;
        nbytes:           int_star
): char_star RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFetchBuffer(
        display:          DisplayStar;
        nbytes:           int_star;
        buffer:           Int
): char_star RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetAtomName(
        display:          DisplayStar;
        atom:             Atom
): char_star RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetDefault(
        display:          DisplayStar;
        program:          const_char_star;
        option:           const_char_star
): char_star RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDisplayName(
        string:           const_char_star;
): char_star RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XKeysymToString(
        keysym:           KeySym;
): char_star RAISES {Error};

TYPE
  XSynchronize   =  PROCEDURE (
        display:    DisplayStar;
        onoff:      Bool
): Int RAISES {Error};

TYPE
  XSetLocalProc      =  PROCEDURE (display: DisplayStar): Int;
  XSetAfterFunction  =  PROCEDURE (
			        display:    DisplayStar;
			        procedure:  XSetLocalProc
): Int;

&lt;*EXTERNAL*&gt; PROCEDURE XInternAtom(
        display:          DisplayStar;
        atom:             const_char_star;
        only:             Bool
): Atom RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCopyColormapAndFree(
        display:          DisplayStar;
        colormap:         Colormap
): Colormap RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCreateColormap(
        display:          DisplayStar;
        w:                Window;
        visual:           VisualStar;
        alloc:            Int
): Colormap RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCreatePixmapCursor(
        display:          DisplayStar;
        source:           Pixmap;
        mask:             Pixmap;
        foreground:       XColorStar;
        background:       XColorStar;
        x:                unsigned_int;
        y:                unsigned_int
): Cursor RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCreateGlyphCursor(
        display:          DisplayStar;
        source_font:      Font;
        mask_font:        Font;
        source_char:      unsigned_int;
        mask_char:        unsigned_int;
        foreground:       XColorStar;
        background:       XColorStar
): Cursor RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCreateFontCursor(
        display:          DisplayStar;
        shape:            unsigned_int
): Cursor RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XLoadFont(
        display:          DisplayStar;
        name:             const_char_star
): Font RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCreateGC(
        display:          DisplayStar;
        d:                Drawable;
        valuemask:        unsigned_long;
        values:           XGCValuesStar
): GC RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGContextFromGC(
        gc:               GC
): GContext RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCreatePixmap(
        display:          DisplayStar;
        d:                Drawable;
        width:            unsigned_int;
        height:           unsigned_int;
        depth:            unsigned_int
): Pixmap RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCreateBitmapFromData(
        display:          DisplayStar;
        d:                Drawable;
        data:             const_char_star;
        width:            unsigned_int;
        height:           unsigned_int
): Pixmap RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCreatePixmapFromBitmapData(
        display:          DisplayStar;
        d:                Drawable;
        data:             char_star;
        width:            unsigned_int;
        height:           unsigned_int;
        fg:               unsigned_long;
        bg:               unsigned_long;
        depth:            unsigned_int
): Pixmap RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCreateSimpleWindow(
        display:          DisplayStar;
        parent:           Window;
        x:                Int;
        y:                Int;
        width:            unsigned_int;
        height:           unsigned_int;
        border_width:     unsigned_int;
        border:           unsigned_long;
        background:       unsigned_long
): Window RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetSelectionOwner(
        display:          DisplayStar;
        selection:        Atom
): Window RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCreateWindow(
        display:          DisplayStar;
        parent:           Window;
        x:                Int;
        y:                Int;
        width:            unsigned_int;
        height:           unsigned_int;
        border:           unsigned_int;
        depth:            Int;
        class:            unsigned_int;
        visual:           VisualStar;
        valuemask:        unsigned_long;
        attributes:       XSetWindowAttributesStar
): Window RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XListInstalledColormaps(
        display:          DisplayStar;
        w:                Window;
        num:              int_star
): ColormapStar RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XListFonts(
        display:          DisplayStar;
        pattern:          const_char_star;
        maxnames:         Int;
        actual:           int_star
): char_star_star RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XListFontsWithInfo(
        display:          DisplayStar;
        pattern:          const_char_star;
        maxnames:         Int;
        count:            int_star;
        info:             XFontStructStarStar
): char_star_star RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetFontPath(
        display:          DisplayStar;
        npaths:           int_star
): char_star_star RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XListExtensions(
        display:          DisplayStar;
        nextensions:      int_star
): char_star_star RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XListProperties(
        display:          DisplayStar;
        w:                Window;
        num:              int_star
): AtomStar RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XListHosts(
        display:          DisplayStar;
        nhosts:           int_star;
        state:            BoolStar;
): XHostAddressStar RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XKeycodeToKeysym(
        display:          DisplayStar;
        keycode:          KeyCode
): KeySym RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XLookupKeysym(
        key:              XKeyEventStar;
        index:            Int
): KeySym RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetKeyboardMapping(
        display:          DisplayStar;
        first:            KeyCode;
        keycode:          Int;
        keysyms:          int_star
): KeySymStar RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XStringToKeysym(
        string:           const_char_star
): KeySym;

&lt;*EXTERNAL*&gt; PROCEDURE XMaxRequestSize(
        display:          DisplayStar
): Long;

&lt;*EXTERNAL*&gt; PROCEDURE XResourceManagerString(
        display:          DisplayStar
): char_star RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDisplayMotionBufferSize(
        display:          DisplayStar
): unsigned_long;

&lt;*EXTERNAL*&gt; PROCEDURE XVisualIDFromVisual(
        visual:           VisualStar
): VisualID;
</PRE> routines for dealing with extensions 

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE XInitExtension(
        display:          DisplayStar;
        name:             const_char_star
): XExtCodesStar;

&lt;*EXTERNAL*&gt; PROCEDURE XAddExtension(
        display:          DisplayStar
): XExtCodesStar;

&lt;*EXTERNAL*&gt; PROCEDURE XFindOnExtensionList(
        structure:        XExtDataStarStar;
        number:           Int
): XExtDataStar;

&lt;*EXTERNAL*&gt; PROCEDURE XEHeadOfExtensionList(
        object:           XEDataObject
): XExtDataStarStar;
</PRE> these are routines for which there are also macros 

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE XRootWindow(
        display:          DisplayStar;
        screen:           Int
): Window;

&lt;*EXTERNAL*&gt; PROCEDURE XDefaultRootWindow(
        display:          DisplayStar
): Window;

&lt;*EXTERNAL*&gt; PROCEDURE XRootWindowOfScreen(
        screen:           ScreenStar
): Window;

&lt;*EXTERNAL*&gt; PROCEDURE XDefaultVisual(
        display:          DisplayStar;
        screen:           Int
): VisualStar;

&lt;*EXTERNAL*&gt; PROCEDURE XDefaultVisualOfScreen(
        screen:           ScreenStar
): VisualStar;

&lt;*EXTERNAL*&gt; PROCEDURE XDefaultGC(
        display:          DisplayStar;
        screen:           Int
): GC;

&lt;*EXTERNAL*&gt; PROCEDURE XDefaultGCOfScreen(
        screen:           ScreenStar
): GC;

&lt;*EXTERNAL*&gt; PROCEDURE XBlackPixel(
        display:          DisplayStar;
        screen:           Int
): unsigned_long;

&lt;*EXTERNAL*&gt; PROCEDURE XWhitePixel(
        display:          DisplayStar;
        screen:           Int
): unsigned_long;

&lt;*EXTERNAL*&gt; PROCEDURE XAllPlanes(
): unsigned_long;

&lt;*EXTERNAL*&gt; PROCEDURE XBlackPixelOfScreen(
        screen:           ScreenStar
): unsigned_long;

&lt;*EXTERNAL*&gt; PROCEDURE XWhitePixelOfScreen(
        screen:           ScreenStar
): unsigned_long;

&lt;*EXTERNAL*&gt; PROCEDURE XNextRequest(
        display:          DisplayStar
): unsigned_long;
</PRE> ---- double definition ------
&lt;*EXTERNAL*&gt; PROCEDURE XLastKnownRequestProcessed(
        display:          DisplayStar
): unsigned_long;  

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE XServerVendor(
        display:          DisplayStar
): char_star;

&lt;*EXTERNAL*&gt; PROCEDURE XDisplayString(
        display:          DisplayStar
): char_star;

&lt;*EXTERNAL*&gt; PROCEDURE XDefaultColormap(
        display:          DisplayStar;
        screen:           Int
): Colormap;

&lt;*EXTERNAL*&gt; PROCEDURE XDefaultColormapOfScreen(
        screen:           ScreenStar
): Colormap;

&lt;*EXTERNAL*&gt; PROCEDURE XDisplayOfScreen(
        screen:           ScreenStar
): DisplayStar;

&lt;*EXTERNAL*&gt; PROCEDURE XScreenOfDisplay(
        display:          DisplayStar;
        screen:           Int
): ScreenStar;

&lt;*EXTERNAL*&gt; PROCEDURE XDefaultScreenOfDisplay(
        display:          DisplayStar
): ScreenStar;

&lt;*EXTERNAL*&gt; PROCEDURE XEventMaskOfScreen(
        screen:           ScreenStar
): Long RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XScreenNumberOfScreen(
        screen:           ScreenStar
): Int;

TYPE XErrorHandler = PROCEDURE (      (* WARNING, this type not in Xlib spec *)
        display:          DisplayStar;
        error:            XErrorEventStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetErrorHandler (
        handler:          XErrorHandler
): XErrorHandler;

TYPE XIOErrorHandler = PROCEDURE (    (* WARNING, this type not in Xlib spec *)
        display:          DisplayStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetIOErrorHandler (
        handler:          XIOErrorHandler
): XIOErrorHandler;

&lt;*EXTERNAL*&gt; PROCEDURE XListPixmapFormats(
        display:          DisplayStar;
        count:            int_star
): XPixmapFormatValuesStar;

&lt;*EXTERNAL*&gt; PROCEDURE XListDepths(
        display:          DisplayStar;
        screen:           Int;
        count:            int_star
): int_star;
</PRE> ICCCM routines for things that don't require special include files; 
 other declarations are given in Xutil.h                             

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE XReconfigureWMWindow(
        display:          DisplayStar;
        w:                Window;
        screen:           Int;
        mask:             unsigned_int;
        changes:          XWindowChangesStar
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetWMProtocols(
        display:          DisplayStar;
        w:                Window;
        protocols:        AtomStarStar;
        count:            int_star
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetWMProtocols(
        display:          DisplayStar;
        w:                Window;
        protocols:        AtomStar;
        count:            Int
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XIconifyWindow(
        display:          DisplayStar;
        w:                Window;
        screen:           Int
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XWithdrawWindow(
        display:          DisplayStar;
        w:                Window;
        screen:           Int
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetCommand(
        display:          DisplayStar;
        w:                Window;
        argv:             Argv;
        argc:             int_star
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetWMColormapWindows(
        display:          DisplayStar;
        w:                Window;
        windows:          WindowStarStar;
        count:            int_star
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetWMColormapWindows(
        display:          DisplayStar;
        w:                Window;
        colormap:         WindowStar;
        count:            Int
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFreeStringList(
        list:             char_star_star
): void_star  RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetTransientForHint(
        display:          DisplayStar;
        w:                Window;
        prop:             Window
) RAISES {Error};
</PRE> The following are given in alphabetical order 

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE XActivateScreenSaver(
        display:          DisplayStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XAddHost(
        display:          DisplayStar;
        host:             XHostAddressStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XAddHosts(
        display:          DisplayStar;
        hosts:            XHostAddressStar;
        num:              Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XAddToExtensionList(
        structure:        ADDRESS;
        ext:              XExtDataStar
);

&lt;*EXTERNAL*&gt; PROCEDURE XAddToSaveSet(
        display:          DisplayStar;
        w:                Window
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XAllocColor(
        display:          DisplayStar;
        colormap:         Colormap;
        color:            XColorStar
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XAllocColorCells(
        display:          DisplayStar;
        colormap:         Colormap;
        contig:           Bool;
        plane:            unsigned_long_star;
        nplanes:          unsigned_int;
        pixels:           unsigned_long_star;
        npixels:          unsigned_int
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XAllocColorPlanes(
        display:          DisplayStar;
        colormap:         Colormap;
        contig:           Bool;
        pixels:           unsigned_long_star;
        ncolors:          Int;
        nreds:            Int;
        ngreens:          Int;
        nblues:           Int;
        rmask:            unsigned_long_star;
        gmask:            unsigned_long_star;
        bmask:            unsigned_long_star
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XAllocNamedColor(
        display:          DisplayStar;
        colormap:         Colormap;
        color:            const_char_star;
        screen:           XColorStar;
        exact:            XColorStar
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XAllowEvents(
        display:          DisplayStar;
        event:            Int;
        time:             Time
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XAutoRepeatOff(
        display:          DisplayStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XAutoRepeatOn(
        display:          DisplayStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XBell(
        display:          DisplayStar;
        percent:          Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XBitmapBitOrder(
        display:          DisplayStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XBitmapPad(
        display:          DisplayStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XBitmapUnit(
        display:          DisplayStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCellsOfScreen(
        screen:           ScreenStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XChangeActivePointerGrab(
        display:          DisplayStar;
        event:            unsigned_int;
        cursor:           Cursor;
        time:             Time
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XChangeGC(
        display:          DisplayStar;
        gc:               GC;
        valuemask:        unsigned_long;
        values:           XGCValuesStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XChangeKeyboardControl(
        display:          DisplayStar;
        value:            unsigned_long;
        values:           XKeyboardControlStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XChangeKeyboardMapping(
        display:          DisplayStar;
        first:            Int;
        keysyms_per_key:  Int;
        keysyms:          KeySymStar;
        num:              Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XChangePointerControl(
        display:          DisplayStar;
        do_accel:         Bool;
        do_threshold:     Bool;
        accel_num:        Int;
        accel_den:        Int;
        threshold:        Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XChangeProperty(
        display:          DisplayStar;
        w:                Window;
        property:         Atom;
        type:             Atom;
        format:           Int;
        mode:             Int;
        data:             const_unsigned_char_star;
        nelements:        Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XChangeSaveSet(
        display:          DisplayStar;
        w:                Window;
        change:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XChangeWindowAttributes(
        display:          DisplayStar;
        w:                Window;
        valuemask:        unsigned_long;
        attributes:       XSetWindowAttributesStar
) RAISES {Error};

TYPE XIfEventProc = PROCEDURE (
        display:          DisplayStar;
        event:            XEventStar;
        arg:              char_star
  ): Bool RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCheckIfEvent(
        display:          DisplayStar;
        event:            XEventStar;
        predicate:        XIfEventProc;
        arg:              char_star;
):  Bool RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCheckMaskEvent(
        display:          DisplayStar;
        event_mask:       Long;
        event_return:     XEventStar
): Bool RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCheckTypedEvent(
        display:          DisplayStar;
        event_type:       Int;
        event_return:     XEventStar
): Bool RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCheckTypedWindowEvent(
        display:          DisplayStar;
        w:                Window;
        event_type:       Int;
        event_return:     XEventStar
): Bool RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCheckWindowEvent(
        display:          DisplayStar;
        w:                Window;
        event_mask:       Long;
        event_return:     XEventStar
): Bool RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCirculateSubwindows(
        display:          DisplayStar;
        w:                Window;
        direction:        Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCirculateSubwindowsDown(
        display:          DisplayStar;
        w:                Window
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCirculateSubwindowsUp(
        display:          DisplayStar;
        w:                Window
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XClearArea(
        display:          DisplayStar;
        w:                Window;
        x:                Int;
        y:                Int;
        width:            unsigned_int;
        height:           unsigned_int;
        exposures:        Bool
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XClearWindow(
        display:          DisplayStar;
        w:                Window
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCloseDisplay(
        display:          DisplayStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XConfigureWindow(
        display:          DisplayStar;
        w:                Window;
        value:            unsigned_int;
        values:           XWindowChangesStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XConnectionNumber(
        display:          DisplayStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XConvertSelection(
        display:          DisplayStar;
        selection:        Atom;
        target:           Atom;
        property:         Atom;
        requestor:        Window;
        time:             Time
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCopyArea(
        display:          DisplayStar;
        src:              Drawable;
        dest:             Drawable;
        gc:               GC;
        src_x:            Int;
        src_y:            Int;
        width:            unsigned_int;
        height:           unsigned_int;
        dest_x:           Int;
        dest_y:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCopyGC(
        display:          DisplayStar;
        src:              GC;
        valuemask:        unsigned_long;
        dest:             GC
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCopyPlane(
        display:          DisplayStar;
        src:              Drawable;
        dest:             Drawable;
        gc:               GC;
        src_x:            Int;
        src_y:            Int;
        width:            unsigned_int;
        height:           unsigned_int;
        dest_x:           Int;
        dest_y:           Int;
        plane:            unsigned_long
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDefaultDepth(
        display:          DisplayStar;
        screen:           Int
): Int;

&lt;*EXTERNAL*&gt; PROCEDURE XDefaultDepthOfScreen(
        screen:           ScreenStar
): Int;

&lt;*EXTERNAL*&gt; PROCEDURE XDefaultScreen(
        display:          DisplayStar
): Int;

&lt;*EXTERNAL*&gt; PROCEDURE XDefineCursor(
        display:          DisplayStar;
        w:                Window;
        cursor:           Cursor
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDeleteProperty(
        display:          DisplayStar;
        w:                Window;
        property:         Atom
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDestroyWindow(
        display:          DisplayStar;
        w:                Window
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDestroySubwindows(
        display:          DisplayStar;
        w:                Window
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDoesBackingStore(
        screen:           ScreenStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDoesSaveUnders(
        screen:           ScreenStar
): Bool RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDisableAccessControl(
        display:          DisplayStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDisplayCells(
        display:          DisplayStar;
        screen:           Int
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDisplayHeight(
        display:          DisplayStar;
        screen:           Int
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDisplayHeightMM(
        display:          DisplayStar;
        screen:           Int
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDisplayKeycodes(
        display:          DisplayStar;
        min:              int_star;
        max:              int_star
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDisplayPlanes(
        display:          DisplayStar;
        screen:           Int
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDisplayWidth(
        display:          DisplayStar;
        screen:           Int
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDisplayWidthMM(
        display:          DisplayStar;
        screen:           Int
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDrawArc(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        width:            unsigned_int;
        height:           unsigned_int;
        angle1:           Int;
        angle2:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDrawArcs(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        arcs:             XArcStar;
        narcs:            Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDrawImageString(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        string:           const_char_star;
        length:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDrawImageString16(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        string:           XChar2bStar;
        length:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDrawLine(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x1:               Int;
        x2:               Int;
        y1:               Int;
        y2:               Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDrawLines(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        points:           XPoint_star;
        npoints:          Int;
        mode:             Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDrawPoint(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDrawPoints(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        points:           XPoint_star;
        npoints:          Int;
        mode:             Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDrawRectangle(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        width:            unsigned_int;
        height:           unsigned_int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDrawRectangles(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        rectangles:       XRectangleStar;
        nrectangles:      Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDrawSegments(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        segments:         XSegmentStar;
        nsegments:        Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDrawString(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        string:           const_char_star;
        length:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDrawString16(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        string:           XChar2bStar;
        length:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDrawText(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        items:            XTextItemStar;
        nitems:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDrawText16(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        items:            XTextItem16Star;
        nitems:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XEnableAccessControl(
        display:          DisplayStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XEventsQueued(
        display:          DisplayStar;
        mode:             Int
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFetchName(
        display:          DisplayStar;
        w:                Window;
        window:           char_star_star
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFillArc(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        width:            unsigned_int;
        height:           unsigned_int;
        angle1:           Int;
        angle2:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFillArcs(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        arcs:             XArcStar;
        narcs:            Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFillPolygon(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        points:           XPoint_star;
        npoints:          Int;
        shape:            Int;
        mode:             Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFillRectangle(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        x:                Int;
        y:                Int;
        width:            unsigned_int;
        height:           unsigned_int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFillRectangles(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        rectangles:       XRectangleStar;
        nrectangles:      Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFlush(
        display:          DisplayStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XForceScreenSaver(
        display:          DisplayStar;
        mode:             Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFree(
        data:             char_star
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFreeColormap(
        display:          DisplayStar;
        colormap:         Colormap
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFreeColors(
        display:          DisplayStar;
        colormap:         Colormap;
        pixels:           unsigned_long_star;
        npixels:          Int;
        planes:           unsigned_long
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFreeCursor(
        display:          DisplayStar;
        cursor:           Cursor
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFreeExtensionList(
        list:             char_star_star
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFreeFont(
        display:          DisplayStar;
        font:             XFontStructStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFreeFontInfo(
        names:            char_star_star;
        free:             XFontStructStar;
        actual:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFreeFontNames(
        list:             char_star_star
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFreeFontPath(
        list:             char_star_star
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFreeGC(
        display:          DisplayStar;
        gc:               GC
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFreeModifiermap(
        modmap:           XModifierKeymapStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFreePixmap(
        display:          DisplayStar;
        pixmap:           Pixmap
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGeometry(
        display:          DisplayStar;
        screen:           Int;
        position:         const_char_star;
        default:          const_char_star;
        bwidth:           unsigned_int;
        fwidth:           unsigned_int;
        fheight:          unsigned_int;
        xadder:           Int;
        yadder:           Int;
        x:                int_star;
        y:                int_star;
        width:            int_star;
        height:           int_star
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetErrorDatabaseText(
        display:          DisplayStar;
        name:             const_char_star;
        message:          const_char_star;
        default:          const_char_star;
        buffer:           char_star;
        length:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetErrorText(
        display:          DisplayStar;
        code:             Int;
        buffer:           char_star;
        length:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetFontProperty(
        font:             XFontStructStar;
        atom:             Atom;
        value:            unsigned_long_star
): Bool RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetGCValues(
        display:          DisplayStar;
        gc:               GC;
        valuemask:        unsigned_long;
        values:           XGCValuesStar
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetGeometry(
        display:          DisplayStar;
        d:                Drawable;
        root:             WindowStar;
        x:                int_star;
        y:                int_star;
        width:            unsigned_int_star;
        height:           unsigned_int_star;
        border:           unsigned_int_star;
        depth:            unsigned_int_star
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetIconName(
        display:          DisplayStar;
        w:                Window;
        icon:             char_star_star
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetInputFocus(
        display:          DisplayStar;
        focus:            WindowStar;
        revert:           int_star
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetKeyboardControl(
        display:          DisplayStar;
        values:           XKeyboardStateStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetPointerControl(
        display:          DisplayStar;
        accel_num_ret:    int_star;
        accel_den_ret:    int_star;
        threshold_ret:    int_star
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetPointerMapping(
        display:          DisplayStar;
        map:              unsigned_char_star;
        nmap:             Int
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetScreenSaver(
        display:          DisplayStar;
        timeout:          int_star;
        interval:         int_star;
        prefer:           int_star;
        allow:            int_star
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetTransientForHint(
        display:          DisplayStar;
        w:                Window;
        prop:             WindowStar
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetWindowProperty(
        display:          DisplayStar;
        w:                Window;
        property:         Atom;
        long_offset:      Long;
        long_length:      Long;
        delete:           Bool;
        req:              Atom;
        actual_type:      AtomStar;
        actual_format:    int_star;
        nitems:           unsigned_long_star;
        bytes:            unsigned_long_star;
        prop:             unsigned_char_star_star
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetWindowAttributes(
        display:          DisplayStar;
        w:                Window;
        window:           XWindowAttributesStar
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGrabButton(
        display:          DisplayStar;
        button:           unsigned_int;
        modifiers:        unsigned_int;
        grab:             Window;
        owner:            Bool;
        event:            unsigned_int;
        pointer:          Int;
        keyboard:         Int;
        confine:          Window;
        cursor:           Cursor
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGrabKey(
        display:          DisplayStar;
        keycode:          Int;
        modifiers:        unsigned_int;
        grab:             Window;
        owner:            Bool;
        pointer:          Int;
        keyboard:         Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGrabKeyboard(
        display:          DisplayStar;
        grab:             Window;
        owner:            Bool;
        pointer:          Int;
        keyboard:         Int;
        time:             Time
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGrabPointer(
        display:          DisplayStar;
        grab:             Window;
        owner:            Bool;
        event:            unsigned_int;
        pointer:          Int;
        keyboard:         Int;
        confine:          Window;
        cursor:           Cursor;
        time:             Time
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGrabServer(
        display:          DisplayStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XHeightMMOfScreen(
        screen:           ScreenStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XHeightOfScreen(
        screen:           ScreenStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XIfEvent(
        display:          DisplayStar;
        event:            XEventStar;
        predicate:        XIfEventProc;
        arg:              char_star
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XImageByteOrder(
        display:          DisplayStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XInstallColormap(
        display:          DisplayStar;
        colormap:         Colormap
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XKeysymToKeycode(
        display:          DisplayStar;
        keysym:           KeySym
): KeyCode RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XKillClient(
        display:          DisplayStar;
        resource:         XID
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XLastKnownRequestProcessed(
        display:          DisplayStar
): unsigned_long  RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XLookupColor(
        display:          DisplayStar;
        colormap:         Colormap;
        color:            const_char_star;
        exact:            XColorStar;
        screen:           XColorStar
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XLowerWindow(
        display:          DisplayStar;
        w:                Window
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XMapRaised(
        display:          DisplayStar;
        w:                Window
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XMapSubwindows(
        display:          DisplayStar;
        w:                Window
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XMapWindow(
        display:          DisplayStar;
        w:                Window
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XMaskEvent(
        display:          DisplayStar;
        event_mask:       Long;
        event_return:     XEventStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XMaxCmapsOfScreen(
        screen:           ScreenStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XMinCmapsOfScreen(
        screen:           ScreenStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XMoveResizeWindow(
        display:          DisplayStar;
        w:                Window;
        x:                Int;
        y:                Int;
        width:            unsigned_int;
        height:           unsigned_int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XMoveWindow(
        display:          DisplayStar;
        w:                Window;
        x:                Int;
        y:                Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XNextEvent(
        display:          DisplayStar;
        event:            XEventStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XNoOp(
        display:          DisplayStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XParseColor(
        display:          DisplayStar;
        colormap:         Colormap;
        spec:             const_char_star;
        exact:            XColorStar
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XParseGeometry(
        parsestring:      const_char_star;
        x:                int_star;
        y:                int_star;
        width:            unsigned_int_star;
        height:           unsigned_int_star
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XPeekEvent(
        display:          DisplayStar;
        event:            XEventStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XPeekIfEvent(
        display:          DisplayStar;
        event:            XEventStar;
        predicate:        XIfEventProc;
        arg:              char_star
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XPending(
        display:          DisplayStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XPlanesOfScreen(
        screen:           ScreenStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XProtocolRevision(
        display:          DisplayStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XProtocolVersion(
        display:          DisplayStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XPutBackEvent(
        display:          DisplayStar;
        event:            XEventStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XPutImage(
        display:          DisplayStar;
        d:                Drawable;
        gc:               GC;
        image:            XImageStar;
        src_x:            Int;
        src_y:            Int;
        dest_x:           Int;
        dest_y:           Int;
        width:            unsigned_int;
        height:           unsigned_int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XQLength(
        display:          DisplayStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XQueryBestCursor(
        display:          DisplayStar;
        d:                Drawable;
        width:            unsigned_int;
        height:           unsigned_int;
        width_return:     unsigned_int_star;
        height_return:    unsigned_int_star
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XQueryBestSize(
        display:          DisplayStar;
        class:            Int;
        which:            Drawable;
        width:            unsigned_int;
        height:           unsigned_int;
        width_return:     unsigned_int_star;
        height_return:    unsigned_int_star
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XQueryBestStipple(
        display:          DisplayStar;
        which:            Drawable;
        width:            unsigned_int;
        height:           unsigned_int;
        width_return:     unsigned_int_star;
        height_return:    unsigned_int_star
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XQueryBestTile(
        display:          DisplayStar;
        which:            Drawable;
        width:            unsigned_int;
        height:           unsigned_int;
        width_return:     unsigned_int_star;
        height_return:    unsigned_int_star
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XQueryColor(
        display:          DisplayStar;
        colormap:         Colormap;
        def:              XColorStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XQueryColors(
        display:          DisplayStar;
        colormap:         Colormap;
        defs:             XColorStar;
        ncolors:          Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XQueryExtension(
        display:          DisplayStar;
        name:             const_char_star;
        major_opcode:     int_star;
        first_event:      int_star;
        first_error:      int_star
): Bool RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XQueryKeymap(
        display:          DisplayStar;
        keys:             Char
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XQueryPointer(
        display:          DisplayStar;
        w:                Window;
        root:             WindowStar;
        child:            WindowStar;
        root_x:           int_star;
        root_y:           int_star;
        win_x:            int_star;
        win_y:            int_star;
        mask:             unsigned_int_star
): Bool RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XQueryTextExtents(
        display:          DisplayStar;
        font_ID:          XID;
        string:           const_char_star;
        nchars:           Int;
        direction:        int_star;
        font_ascent:      int_star;
        font_descent:     int_star;
        overall:          XCharStructStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XQueryTextExtents16(
        display:          DisplayStar;
        font_ID:          XID;
        string:           XChar2bStar;
        nchars:           Int;
        direction:        int_star;
        font_ascent:      int_star;
        font_descent:     int_star;
        overall:          XCharStructStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XQueryTree(
        display:          DisplayStar;
        w:                Window;
        root:             WindowStar;
        parent:           WindowStar;
        children:         WindowStarStar;
        nchildren:        unsigned_int_star
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XRaiseWindow(
        display:          DisplayStar;
        w:                Window
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XReadBitmapFile(
        display:          DisplayStar;
        d:                Drawable;
        filename:         const_char_star;
        width:            unsigned_int_star;
        height:           unsigned_int_star;
        bitmap:           PixmapStar;
        x:                int_star;
        y:                int_star
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XRebindKeysym(
        display:          DisplayStar;
        keysym:           KeySym;
        list:             KeySymStar;
        mod:              Int;
        string:           const_unsigned_char_star;
        bytes:            Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XRecolorCursor(
        display:          DisplayStar;
        cursor:           Cursor;
        foreground:       XColorStar;
        background:       XColorStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XRefreshKeyboardMapping(
        event:            XMappingEventStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XRemoveFromSaveSet(
        display:          DisplayStar;
        w:                Window
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XRemoveHost(
        display:          DisplayStar;
        host:             XHostAddressStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XRemoveHosts(
        display:          DisplayStar;
        hosts:            XHostAddressStar;
        num:              Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XReparentWindow(
        display:          DisplayStar;
        w:                Window;
        parent:           Window;
        x:                Int;
        y:                Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XResetScreenSaver(
        display:          DisplayStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XResizeWindow(
        display:          DisplayStar;
        w:                Window;
        width:            unsigned_int;
        height:           unsigned_int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XRestackWindows(
        display:          DisplayStar;
        windows:          WindowStar;
        nwindows:         Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XRotateBuffers(
        display:          DisplayStar;
        rotate:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XRotateWindowProperties(
        display:          DisplayStar;
        w:                Window;
        properties:       AtomStar;
        num:              Int;
        npositions:       Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XScreenCount(
        display:          DisplayStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSelectInput(
        display:          DisplayStar;
        w:                Window;
        event:            Long
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSendEvent(
        display:          DisplayStar;
        w:                Window;
        propagate:        Bool;
        event_mask:       Long;
        event_send:       XEventStar
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetAccessControl(
        display:          DisplayStar;
        mode:             Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetArcMode(
        display:          DisplayStar;
        gc:               GC;
        arc:              Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetBackground(
        display:          DisplayStar;
        gc:               GC;
        background:       unsigned_long
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetClipMask(
        display:          DisplayStar;
        gc:               GC;
        pixmap:           Pixmap
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetClipOrigin(
        display:          DisplayStar;
        gc:               GC;
        clip_x:           Int;
        clip_y:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetClipRectangles(
        display:          DisplayStar;
        gc:               GC;
        clip_x:           Int;
        clip_y:           Int;
        rectangles:       XRectangleStar;
        n:                Int;
        ordering:         Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetCloseDownMode(
        display:          DisplayStar;
        close:            Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetCommand(
        display:          DisplayStar;
        w:                Window;
        argv:             Argv;
        argc:             Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetDashes(
        display:          DisplayStar;
        gc:               GC;
        dash_offset:      Int;
        dash_list:        const_char_star;
        n:                Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetFillRule(
        display:          DisplayStar;
        gc:               GC;
        fill:             Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetFillStyle(
        display:          DisplayStar;
        gc:               GC;
        fill:             Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetFont(
        display:          DisplayStar;
        gc:               GC;
        font:             Font
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetFontPath(
        display:          DisplayStar;
        directories:      char_star_star;
        ndirs:            Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetForeground(
        display:          DisplayStar;
        gc:               GC;
        foreground:       unsigned_long
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetFunction(
        display:          DisplayStar;
        gc:               GC;
        function:         Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetGraphicsExposures(
        display:          DisplayStar;
        gc:               GC;
        graphics:         Bool
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetIconName(
        display:          DisplayStar;
        w:                Window;
        icon:             const_char_star
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetInputFocus(
        display:          DisplayStar;
        focus:            Window;
        revert_to:        Int;
        time:             Time
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetLineAttributes(
        display:          DisplayStar;
        gc:               GC;
        line_width:       unsigned_int;
        line_style:       Int;
        cap_style:        Int;
        join_style:       Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetModifierMapping(
        display:          DisplayStar;
        modmap:           XModifierKeymapStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetPlaneMask(
        display:          DisplayStar;
        gc:               GC;
        plane:            unsigned_long
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetPointerMapping(
        display:          DisplayStar;
        map:              const_unsigned_char_star;
        nmap:             Int
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetScreenSaver(
        display:          DisplayStar;
        timeout:          Int;
        interval:         Int;
        prefer:           Int;
        allow:            Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetSelectionOwner(
        display:          DisplayStar;
        selection:        Atom;
        owner:            Window;
        time:             Time
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetState(
        display:          DisplayStar;
        gc:               GC;
        foreground:       unsigned_long;
        background:       unsigned_long;
        function:         Int;
        plane:            unsigned_long
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetStipple(
        display:          DisplayStar;
        gc:               GC;
        stipple:          Pixmap
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetSubwindowMode(
        display:          DisplayStar;
        gc:               GC;
        subwindow:        Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetTSOrigin(
        display:          DisplayStar;
        gc:               GC;
        ts_x_origin:      Int;
        ts_y_origin:      Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetTile(
        display:          DisplayStar;
        gc:               GC;
        tile:             Pixmap
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetWindowBackground(
        display:          DisplayStar;
        w:                Window;
        background:       unsigned_long
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetWindowBackgroundPixmap(
        display:          DisplayStar;
        w:                Window;
        background:       Pixmap
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetWindowBorder(
        display:          DisplayStar;
        w:                Window;
        border:           unsigned_long
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetWindowBorderPixmap(
        display:          DisplayStar;
        w:                Window;
        border:           Pixmap
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetWindowBorderWidth(
        display:          DisplayStar;
        w:                Window;
        width:            unsigned_int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetWindowColormap(
        display:          DisplayStar;
        w:                Window;
        colormap:         Colormap
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XStoreBuffer(
        display:          DisplayStar;
        bytes:            const_char_star;
        nbytes:           Int;
        buffer:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XStoreBytes(
        display:          DisplayStar;
        bytes:            const_char_star;
        nbytes:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XStoreColor(
        display:          DisplayStar;
        colormap:         Colormap;
        color:            XColorStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XStoreColors(
        display:          DisplayStar;
        colormap:         Colormap;
        color:            XColorStar;
        ncolors:          Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XStoreName(
        display:          DisplayStar;
        w:                Window;
        window:           const_char_star
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XStoreNamedColor(
        display:          DisplayStar;
        colormap:         Colormap;
        color:            const_char_star;
        pixel:            unsigned_long;
        flags:            Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSync(
        display:          DisplayStar;
        discard:          Bool
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XTextExtents(
        font:             XFontStructStar;
        string:           const_char_star;
        nchars:           Int;
        direction_ret:    int_star;
        font_ascent_ret:  int_star;
        font_descent_ret: int_star;
        overall_ret:      XCharStructStar
);

&lt;*EXTERNAL*&gt; PROCEDURE XTextExtents16(
        font:             XFontStructStar;
        string:           XChar2bStar;
        nchars:           Int;
        direction:        int_star;
        font_ascent:      int_star;
        font_descent:     int_star;
        overall:          XCharStructStar
);

&lt;*EXTERNAL*&gt; PROCEDURE XTextWidth(
        font:             XFontStructStar;
        string:           const_char_star;
        count:            Int
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XTextWidth16(
        font:             XFontStructStar;
        string:           XChar2bStar;
        count:            Int
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XTranslateCoordinates(
        display:          DisplayStar;
        src_w:            Window;
        dest_w:           Window;
        src_x:            Int;
        src_y:            Int;
        dest_x_return:    int_star;
        dest_y_return:    int_star;
        child_return:     WindowStar
): Bool RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XUndefineCursor(
        display:          DisplayStar;
        w:                Window
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XUngrabButton(
        display:          DisplayStar;
        button:           unsigned_int;
        modifiers:        unsigned_int;
        grab:             Window
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XUngrabKey(
        display:          DisplayStar;
        keycode:          Int;
        modifiers:        unsigned_int;
        grab:             Window
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XUngrabKeyboard(
        display:          DisplayStar;
        time:             Time
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XUngrabPointer(
        display:          DisplayStar;
        time:             Time
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XUngrabServer(
        display:          DisplayStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XUninstallColormap(
        display:          DisplayStar;
        colormap:         Colormap
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XUnloadFont(
        display:          DisplayStar;
        font:             Font
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XUnmapSubwindows(
        display:          DisplayStar;
        w:                Window
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XUnmapWindow(
        display:          DisplayStar;
        w:                Window
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XVendorRelease(
        display:          DisplayStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XWarpPointer(
        display:          DisplayStar;
        src_w:            Window;
        dest_w:           Window;
        src_x:            Int;
        src_y:            Int;
        src_width:        unsigned_int;
        src_height:       unsigned_int;
        dest_x:           Int;
        dest_y:           Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XWidthMMOfScreen(
        screen:           ScreenStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XWidthOfScreen(
        screen:           ScreenStar
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE  XWindowEvent(
        display:          DisplayStar;
        w:                Window;
        event_mask:       Long;
        event_return:     XEventStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XWriteBitmapFile(
        display:          DisplayStar;
        filename:         char_star;
        bitmap:           Pixmap;
        width:            unsigned_int;
        height:           unsigned_int;
        x_hot:            Int;
        y_hot:            Int
): Int RAISES {Error};
</PRE>**************************************************************
<P>
                /usr/include/X11/Xutil.h
<P>
/* $XConsortium: Xutil.h,v 11.58 89/12/12 20:15:40 jim Exp $ */
 **************************************************************

<P>
<P> 
 * Bitmask returned by XParseGeometry().  Each bit tells if the corresponding
 * value (x, y, width, height) was found in the parsed string.
 

<P><PRE>CONST
  NoValue =		16_0000;
  XValue = 	 	16_0001;
  YValue =		16_0002;
  WidthValue =  	16_0004;
  HeightValue =  	16_0008;
  AllValues = 		16_000F;
  XNegative = 		16_0010;
  YNegative = 		16_0020;
</PRE><P>
 * new version containing base_width, base_height, and win_gravity fields;
 * used with WM_NORMAL_HINTS.
 

<P><PRE>TYPE
  XSizeHints = RECORD
    	flags: Long;	(* marks which fields in this structure are defined *)
	x, y: Int;		(* obsolete for new window mgrs, but clients *)
	width, height: Int;	(* should set so old wm's don't mess up *)
	min_width, min_height: Int;
	max_width, max_height: Int;
    	width_inc, height_inc: Int;
	min_aspect, max_aspect: RECORD
		x: Int;	(* numerator *)
		y: Int;	(* denominator *)
	END;
	base_width, base_height: Int;		(* added by ICCCM version 1 *)
	win_gravity: Int;			(* added by ICCCM version 1 *)
  END;
  XSizeHintsStar = UNTRACED REF XSizeHints;
</PRE><P>
 * The next block of definitions are for window manager properties that
 * clients and applications use for communication.
 

<P> flags argument in size hints 
<PRE>CONST
  USPosition =	Word.Shift(1, 0); (* user specified x, y *)
  USSize =	Word.Shift(1, 1); (* user specified width, height *)

  PPosition =	Word.Shift(1, 2); (* program specified position *)
  PSize	=	Word.Shift(1, 3); (* program specified size *)
  PMinSize =	Word.Shift(1, 4); (* program specified minimum size *)
  PMaxSize =	Word.Shift(1, 5); (* program specified maximum size *)
  PResizeInc =	Word.Shift(1, 6); (* program specified resize increments *)
  PAspect =	Word.Shift(1, 7); (* program specified min and max aspect ratios *)
  PBaseSize =	Word.Shift(1, 8); (* program specified base for incrementing *)
  PWinGravity =	Word.Shift(1, 9); (* program specified window gravity *)
</PRE>?!?!?!
(* obsolete 
<PRE>#define PAllHints (PPosition|PSize|PMinSize|PMaxSize|PResizeInc|PAspect)
?!?!?!?!*)

TYPE
  XWMHints = RECORD
	flags: Long;	(* marks which fields in this structure are defined *)
	input: Bool;	(* does this application rely on the window manager to
			get keyboard input? *)
	initial_state: Int;	(* see below *)
	icon_pixmap: Pixmap;	(* pixmap to be used as icon *)
	icon_window: Window; 	(* window to be used as icon *)
	icon_x, icon_y: Int; 	(* initial position of icon *)
	icon_mask: Pixmap;	(* icon mask bitmap *)
	window_group: XID;	(* id of related window group *)
	(* this structure may be extended in the future *)
  END;
  XWMHintsStar = UNTRACED REF XWMHints;
</PRE> definition for flags of XWMHints 

<P><PRE>CONST
  InputHint = 		Word.Shift(1, 0);
  StateHint =		Word.Shift(1, 1);
  IconPixmapHint =	Word.Shift(1, 2);
  IconWindowHint =	Word.Shift(1, 3);
  IconPositionHint = 	Word.Shift(1, 4);
  IconMaskHint =	Word.Shift(1, 5);
  WindowGroupHint =	Word.Shift(1, 6);
  AllHints = 		Word.Or(InputHint, Word.Or(StateHint, Word.Or(IconPixmapHint, Word.Or(IconWindowHint, Word.Or(IconPositionHint, Word.Or(IconMaskHint, WindowGroupHint))))));
</PRE> definitions for initial window state 
  <PRE>WithdrawnState = 0;	(* for windows that are not mapped *)
  NormalState = 1;	(* most applications want to start this way *)
  IconicState = 3;	(* application wants to start as an icon *)
</PRE><P>
 * Obsolete states no longer defined by ICCCM
 
  <PRE>DontCareState = 0;	(* don't know or care *)
  ZoomState = 2;	(* application wants to start zoomed *)
  InactiveState = 4;	(* application believes it is seldom used; *)
			(* some wm's may put it on inactive menu *)
</PRE><P>
 * new structure for manipulating TEXT properties; used with WM_NAME, 
 * WM_ICON_NAME, WM_CLIENT_MACHINE, and WM_COMMAND.
 
<PRE>TYPE
  XTextProperty = RECORD
    value: unsigned_char_star;		(* same as Property routines *)
    encoding: Atom;			(* prop type *)
    format: Int;			(* prop data format: 8, 16, or 32 *)
    nitems: unsigned_long;		(* number of data items in value *)
  END;
  XTextPropertyStar = UNTRACED REF XTextProperty;

  XIconSize = RECORD
	        min_width, min_height: Int;
	        max_width, max_height: Int;
	        width_inc, height_inc: Int
              END;
  XIconSizeStar		= UNTRACED REF XIconSize;
  XIconSizeStarStar	= UNTRACED REF XIconSizeStar;

  XClassHint = RECORD
	         res_name: char_star;
	         res_class: char_star
               END;

  XClassHint_star	= UNTRACED REF XClassHint;
</PRE> ?!?!?!
(*
 * These macros are used to give some sugar to the image routines so that
 * naive people are more comfortable with them.
 
<PRE>#define XDestroyImage(ximage) \
	(( *((ximage)-&gt;f.destroy_image))((ximage)))
#define XGetPixel(ximage, x, y) \
	(( *((ximage)-&gt;f.get_pixel))((ximage), (x), (y)))
#define XPutPixel(ximage, x, y, pixel) \
	(( *((ximage)-&gt;f.put_pixel))((ximage), (x), (y), (pixel)))
#define XSubImage(ximage, x, y, width, height)  \
	(( *((ximage)-&gt;f.sub_image))((ximage), (x), (y), (width), (height)))
#define XAddPixel(ximage, value) \
	(( *((ximage)-&gt;f.add_pixel))((ximage), (value)))

?!?!?! *)
</PRE><P>
 * Compose sequence status structure, used in calling XLookupString.
 

<P><PRE>TYPE
  XComposeStatus = RECORD
    compose_ptr: char_star;	(* state table pointer *)
    chars_matched: Int;		(* match state *)
  END;
  XComposeStatusStar = UNTRACED REF XComposeStatus;
</PRE> ?!?!?!
(*
 * Keysym macros, used on Keysyms to test for classes of symbols
 
<PRE>#define IsKeypadKey(keysym) \
  (((unsigned)(keysym) &gt;= XK_KP_Space) &amp;&amp; ((unsigned)(keysym) &lt;= XK_KP_Equal))

#define IsCursorKey(keysym) \
  (((unsigned)(keysym) &gt;= XK_Home)     &amp;&amp; ((unsigned)(keysym) &lt;  XK_Select))

#define IsPFKey(keysym) \
  (((unsigned)(keysym) &gt;= XK_KP_F1)     &amp;&amp; ((unsigned)(keysym) &lt;= XK_KP_F4))

#define IsFunctionKey(keysym) \
  (((unsigned)(keysym) &gt;= XK_F1)       &amp;&amp; ((unsigned)(keysym) &lt;= XK_F35))

#define IsMiscFunctionKey(keysym) \
  (((unsigned)(keysym) &gt;= XK_Select)   &amp;&amp; ((unsigned)(keysym) &lt;  XK_KP_Space))

#define IsModifierKey(keysym) \
  (((unsigned)(keysym) &gt;= XK_Shift_L)  &amp;&amp; ((unsigned)(keysym) &lt;= XK_Hyper_R))
</PRE><P>
 * opaque reference to Region data type 
 
<PRE>typedef struct _XRegion *Region;
?!?!? *)

TYPE
  Region = ADDRESS;
</PRE> Return values from XRectInRegion() 
 
<P><PRE>CONST
  RectangleOut = 0;
  RectangleIn =  1;
  RectanglePart = 2;
</PRE><P>
 * Information used by the visual utility routines to find desired visual
 * type from the many visuals a display may support.
 

<P><PRE>TYPE
  XVisualInfo = RECORD
    visual: VisualStar;
    visualid: VisualID;
    screen: Int;
    depth: Int;
    class: Int;
    red_mask: unsigned_long;
    green_mask: unsigned_long;
    blue_mask: unsigned_long;
    colormap_size: Int;
    bits_per_rgb: Int;
  END;
  XVisualInfoStar = UNTRACED REF XVisualInfo;

CONST
  VisualNoMask =		16_0;
  VisualIDMask = 		16_1;
  VisualScreenMask =		16_2;
  VisualDepthMask =		16_4;
  VisualClassMask =		16_8;
  VisualRedMaskMask =		16_10;
  VisualGreenMaskMask =		16_20;
  VisualBlueMaskMask =		16_40;
  VisualColormapSizeMask =	16_80;
  VisualBitsPerRGBMask =	16_100;
  VisualAllMask =		16_1FF;
</PRE><P>
 * This defines a window manager property that clients may use to
 * share standard color maps of type RGB_COLOR_MAP:
 

<P><PRE>TYPE
  XStandardColormap = RECORD
	colormap: Colormap;
	red_max: unsigned_long;
	red_mult: unsigned_long;
	green_max: unsigned_long;
	green_mult: unsigned_long;
	blue_max: unsigned_long;
	blue_mult: unsigned_long;
	base_pixel: unsigned_long;
	visualid: VisualID;		(* added by ICCCM version 1 *)
	killid: XID;			(* added by ICCCM version 1 *)
  END;
  XStandardColormapStar   = UNTRACED REF XStandardColormap;
  XStandardColormapStarStar   = UNTRACED REF XStandardColormapStar;

CONST
  ReleaseByFreeingColormap: XID = 1;  (* for killid field above *)
</PRE><P>
 * return codes for XReadBitmapFile and XWriteBitmapFile
 

<P><PRE>CONST
  BitmapSuccess =		0;
  BitmapOpenFailed = 		1;
  BitmapFileInvalid = 		2;
  BitmapNoMemory =		3;
</PRE><P>
 * Declare the routines that don't return int.
 

<P>***************************************************************
 *
 * Context Management
 *
 ***************************************************************

<P>
<P> Associative lookup table return codes 

<P><PRE>CONST
  XCSUCCESS = 0;	(* No error. *)
  XCNOMEM =   1;	(* Out of memory *)
  XCNOENT =   2;    	(* No entry in table *)

TYPE
  XContext = Int;
</PRE> ?!?!?!?
#define XUniqueContext()       ((XContext) XrmUniqueQuark())
#define XStringToContext(string)   ((XContext) XrmStringToQuark(string))
?!?!?! 

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE XSaveContext (
        display:                    DisplayStar;
        w:                          Window;
        context:                    XContext;
        data:                       ADDRESS
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XFindContext (
        display:                    DisplayStar;
        w:                          Window;
        context:                    XContext;
        data_return:                ADDRESS
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XDeleteContext (
        display:                    DisplayStar;
        w:                          Window;
        context:                    XContext
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetWMHints (
        display:                    DisplayStar;
        w:                          Window
): XWMHintsStar RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XCreateRegion (): Region;

&lt;*EXTERNAL*&gt; PROCEDURE XPolygonRegion (
        points:                     XPoint_star;
        n:                          Int;
        fill_rule:                  Int
): Region;

&lt;*EXTERNAL*&gt; PROCEDURE XGetVisualInfo (
        display:                    DisplayStar;
        vinfo_mask:                 Long;
        vinfo_template:             XVisualInfoStar;
        nitems_return:              int_star
): XVisualInfoStar RAISES {Error};
</PRE> Allocation routines for properties that may get longer 

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE XAllocSizeHints  (): XSizeHintsStar;

&lt;*EXTERNAL*&gt; PROCEDURE XAllocStandardColormap (): XStandardColormapStar;

&lt;*EXTERNAL*&gt; PROCEDURE XAllocWMHints  (): XWMHintsStar;

&lt;*EXTERNAL*&gt; PROCEDURE XAllocClassHint  (): XClassHint_star;

&lt;*EXTERNAL*&gt; PROCEDURE XAllocIconSize  (): XIconSizeStar;
</PRE> ICCCM routines for data structures defined in this file 
<PRE>&lt;*EXTERNAL*&gt; PROCEDURE XGetWMSizeHints (
        display:                    DisplayStar;
        w:                          Window;
        hints_return:               XSizeHintsStar;
        supplied_return:            long_star;
        property:                   Atom
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetWMNormalHints (
        display:                    DisplayStar;
        w:                          Window;
        hints_return:               XSizeHintsStar;
        supplied_return:            long_star
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetRGBColormaps (
        display:                    DisplayStar;
        w:                          Window;
        stdcmap_return:             XStandardColormapStarStar;
        count_return:               int_star;
        property:                   Atom
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetTextProperty (
        display:                    DisplayStar;
        window:                     Window;
        text_prop_return:           XTextPropertyStar;
        property:                   Atom
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetWMName (
        display:                    DisplayStar;
        w:                          Window;
        text_prop_return:           XTextPropertyStar
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetWMIconName (
        display:                    DisplayStar;
        w:                          Window;
        text_prop_return:           XTextPropertyStar
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetWMClientMachine (
        display:                    DisplayStar;
        w:                          Window;
        text_prop_return:           XTextPropertyStar
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetWMProperties (
        display:                    DisplayStar;
        w:                          Window;
        window_name:                XTextPropertyStar;
        icon_name:                  XTextPropertyStar;
        argv:                       Argv;
        argc:                       Int;
        normal_hints:               XSizeHintsStar;
        wm_hints:                   XWMHintsStar;
        class_hints:                XClassHint_star
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetWMSizeHints (
        display:                    DisplayStar;
        w:                          Window;
        hints:                      XSizeHintsStar;
        property:                   Atom
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetWMNormalHints (
        display:                    DisplayStar;
        w:                          Window;
        hints:                      XSizeHintsStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetRGBColormaps (
        display:                    DisplayStar;
        w:                          Window;
        stdcmaps:                   XStandardColormapStar;
        count:                      Int;
        property:                   Atom
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetTextProperty (
        display:                    DisplayStar;
        w:                          Window;
        text_prop:                  XTextPropertyStar;
        property:                   Atom
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetWMName (
        display:                    DisplayStar;
        w:                          Window;
        text_prop:                  XTextPropertyStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetWMIconName (
        display:                    DisplayStar;
        w:                          Window;
        text_prop:                  XTextPropertyStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetWMClientMachine (
        display:                    DisplayStar;
        w:                          Window;
        text_prop:                  XTextPropertyStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XStringListToTextProperty (
        list:                       char_star_star;
        count:                      Int;
        text_prop_return:           XTextPropertyStar
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XTextPropertyToStringList (
        text_prop:                  XTextPropertyStar;
        list_return:                char_star_star_star;
        count_return:               int_star
): Status RAISES {Error};
</PRE> The following declarations are alphabetized. 

<P><PRE>&lt;*EXTERNAL*&gt; PROCEDURE XClipBox (
        r:                          Region;
        rect_return:                XRectangleStar
);

&lt;*EXTERNAL*&gt; PROCEDURE XDestroyRegion (
        r:                          Region
);

&lt;*EXTERNAL*&gt; PROCEDURE XEmptyRegion (
        r:                          Region
);

&lt;*EXTERNAL*&gt; PROCEDURE XEqualRegion (
        r1:                         Region;
        r2:                         Region
);

&lt;*EXTERNAL*&gt; PROCEDURE XGetClassHint (
        display:                    DisplayStar;
        w:                          Window;
        class_hints_return:         XClassHint_star
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetIconSizes (
        display:                    DisplayStar;
        w:                          Window;
        size_list_return:           XIconSizeStarStar;
        count_return:               int_star
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetNormalHints (
        display:                    DisplayStar;
        w:                          Window;
        hints_return:               XSizeHintsStar
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetSizeHints (
        display:                    DisplayStar;
        w:                          Window;
        hints_return:               XSizeHintsStar;
        property:                   Atom
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetStandardColormap (
        display:                    DisplayStar;
        w:                          Window;
        colormap_return:            XStandardColormapStar;
        property:                   Atom
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XGetZoomHints (
        display:                    DisplayStar;
        w:                          Window;
        zhints_return:              XSizeHintsStar
): Status RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XIntersectRegion (
        sra:                        Region;
        srb:                        Region;
        dr_return:                  Region
);

&lt;*EXTERNAL*&gt; PROCEDURE XLookupString (
        event_struct:               XKeyEventStar;
        buffer_return:              char_star;
        bytes_buffer:               Int;
        keysym_return:              KeySymStar;
        status_in_out:              XComposeStatusStar
): Int;

&lt;*EXTERNAL*&gt; PROCEDURE XMatchVisualInfo (
        display:                    DisplayStar;
        screen:                     Int;
        depth:                      Int;
        class:                      Int;
        vinfo_return:               XVisualInfoStar
): Status;

&lt;*EXTERNAL*&gt; PROCEDURE XOffsetRegion (
        r:                          Region;
        dx:                         Int;
        dy:                         Int
);

&lt;*EXTERNAL*&gt; PROCEDURE XPointInRegion (
        r:                          Region;
        x:                          Int;
        y:                          Int
): Bool RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XRectInRegion (
        r:                          Region;
        x:                          Int;
        y:                          Int;
        width:                      unsigned_int;
        height:                     unsigned_int
): Int;

&lt;*EXTERNAL*&gt; PROCEDURE XSetClassHint (
        display:                    DisplayStar;
        w:                          Window;
        class_hints:                XClassHint_star
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetIconSizes (
        display:                    DisplayStar;
        w:                          Window;
        size_list:                  XIconSizeStar;
        count:                      Int
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetNormalHints (
        display:                    DisplayStar;
        w:                          Window;
        hints:                      XSizeHintsStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetSizeHints (
        display:                    DisplayStar;
        w:                          Window;
        hints:                      XSizeHintsStar;
        property:                   Atom
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetStandardProperties (
        display:                    DisplayStar;
        w:                          Window;
        window_name:                const_char_star;
        icon_name:                  const_char_star;
        icon_pixmap:                Pixmap;
        argv:                       Argv;
        argc:                       Int;
        hints:                      XSizeHintsStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetWMHints (
        display:                    DisplayStar;
        w:                          Window;
        wm_hints:                   XWMHintsStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetRegion (
        display:                    DisplayStar;
        gc:                         GC;
        r:                          Region
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetStandardColormap (
        display:                    DisplayStar;
        w:                          Window;
        colormap:                   XStandardColormapStar;
        property:                   Atom
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XSetZoomHints (
        display:                    DisplayStar;
        w:                          Window;
        zhints:                     XSizeHintsStar
) RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XShrinkRegion (
        r:                          Region;
        dx:                         Int;
        dy:                         Int
);

&lt;*EXTERNAL*&gt; PROCEDURE XSubtractRegion (
        sra:                        Region;
        srb:                        Region;
        dr_return:                  Region
);

&lt;*EXTERNAL*&gt; PROCEDURE XUnionRectWithRegion (
        rectangle:                  XRectangleStar;
        src_region:                 Region;
        dest_region_return:         Region
);

&lt;*EXTERNAL*&gt; PROCEDURE XUnionRegion (
        sra:                        Region;
        srb:                        Region;
        dr_return:                  Region
);

&lt;*EXTERNAL*&gt; PROCEDURE XWMGeometry (
        display:                    DisplayStar;
        screen_number:              Int;
        user_geometry:              const_char_star;
        default_geometry:           const_char_star;
        border_width:               unsigned_int;
        hints:                      XSizeHintsStar;
        x_return:                   int_star;
        y_return:                   int_star;
        width_return:               int_star;
        height_return:              int_star;
        gravity_return:             int_star
): Int RAISES {Error};

&lt;*EXTERNAL*&gt; PROCEDURE XXorRegion (
        sra:                        Region;
        srb:                        Region;
        dr_return:                  Region
);

END X.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface XMachine is in:
</A><UL>
<LI><A HREF="../ALPHA_OSF/XMachine.i3#0TOP0">X11R4/src/ALPHA_OSF/XMachine.i3</A>
<LI><A HREF="../Vanilla/XMachine.i3#0TOP0">X11R4/src/Vanilla/XMachine.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
