<HTML>
<HEAD>
<TITLE>SRC Modula-3: X11R4/src/Common/Xct.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>X11R4/src/Common/Xct.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Xct.i3							

<P><PRE>INTERFACE <interface>Xct</interface>;
</PRE>==============================================================
	The X11 R4 Interface for Modula 3			
								
	The Compound Text Functions Library			
	contains:						
								
			../include/Xmu/Xct.h			
==============================================================

<P>
 *
 * Copyright 1988 by the Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided 
 * that the above copyright notice appear in all copies and that both that 
 * copyright notice and this permission notice appear in supporting 
 * documentation, and that the name of M.I.T. not be used in advertising
 * or publicity pertaining to distribution of the software without specific, 
 * written prior permission. M.I.T. makes no representations about the 
 * suitability of this software for any purpose.  It is provided <CODE>as is</CODE>
 * without express or implied warranty.
 *
 * The X Window System is a Trademark of MIT.
 *
 * The interfaces described by this header file are for miscellaneous utilities
 * and are not part of the Xlib standard.
 

<P>======================================================================
 * $XConsortium: Xct.h,v 1.3 89/11/21 12:03:47 rws Exp $
 *======================================================================

<P><PRE>FROM  <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>	IMPORT char_star, int, unsigned_long;

CONST
  Version	= 1;

TYPE
  String	= char_star;
  Enumeration   = int;
  Int = int;

TYPE
  HDirection	= Enumeration;
CONST
  Unspecified	= 0;
  LeftToRight	= 1;
  RightToLeft	= 2;

TYPE
  Flags   	= unsigned_long;
</PRE> These are bits in Xct.Flags. 

<P><PRE>CONST
  SingleSetSegments	= 16_0001;
   (* This means that returned segments should contain characters from only
    * one set (C0, C1, GL, GR).  When this is requested, Xct.Segment is never
    * returned, instead Xct.C0Segment, Xct.C1Segment, Xct.GlSegment, and
    * Xct.GRSegment are returned.  C0 and C1 segments are always returned as
    * singleton characters.
    *)

  ProvideExtensions	= 16_0002;
   (* This means that if the Compound Text string is from a higher version
    * than this code is implemented to, then syntactically correct but unknown
    * control sequences should be returned as Xct.Extension items.  If this
    * flag is not set, and the Compound Text string version indicates that
    * extensions cannot be ignored, then each unknown control sequence will be
    * reported as an Xct.Error.
    *)

  AcceptC0Extensions	= 16_0004;
   (* This means that if the Compound Text string is from a higher version
    * than this code is implemented to, then unknown C0 characters should be
    * treated as if they were legal, and returned as C0 characters (regardless
    * of how Xct.ProvideExtensions is set).  If this flag is not set, then all
    * unknown C0 characters are treated according to Xct.ProvideExtensions.
    *)

  AcceptC1Extensions	= 16_0008;
   (* This means that if the Compound Text string is from a higher version
    * than this code is implemented to, then unknown C0 characters should be
    * treated as if they were legal, and returned as C0 characters (regardless
    * of how Xct.ProvideExtensions is set).  If this flag is not set, then all
    * unknown C0 characters are treated according to Xct.ProvideExtensions.
    *)

  HideDirection		= 16_0010;
   (* This means that horizontal direction changes should be reported as
    * Xct.Horizontal items. If this flag is not set, then direction changes are
    * not returned as items, but the current direction is still maintained and
    * reported for other items.
    *)

  FreeString		= 16_0020;
   (* This means that Xct.Free should free the Compound Text string (that was
    * passed to Xct.Create.  If this flag is not set, the string is not freed.
    *)

  ShiftMultiGRToGL	= 16_0040;
   (* Translate GR segments on-the-fly into GL segments for the GR sets:
    * GB2312.1980-1, JISX0208.1983-1, and KSC5601.1987-1.
    *)
</PRE> This is the return type for Xct.NextItem. 

<P><PRE>TYPE
  Result	= Enumeration;
CONST
  Segment	= 0;	(* used when Xct.SingleSetSegments is not requested *)
  C0Segment	= 1;	(* used when Xct.SingleSetSegments is requested *)
  GLSegment	= 2;	(* used when Xct.SingleSetSegments is requested *)
  C1Segment	= 3;	(* used when Xct.SingleSetSegments is requested *)
  GRSegment	= 4;	(* used when Xct.SingleSetSegments is requested *)
  ExtendedSegment = 5;	(* an extended segment *)
  Extension	= 6;	(* used when Xct.ProvideExtensions is requested *)
  Horizontal	= 7;	(* horizontal direction or depth change *)
  EndOfText	= 8;	(* end of text string *)
  Error		= 9;	(* syntactic or semantic error *)

TYPE
  Data = RECORD
    total_string: String;	(* as given to Xct.Create *)
    total_length: Int;		(* as given to Xct.Create *)
    flags: Flags;		(* as given to Xct.Create *)
    version: Int;		(* indicates the version of the CT spec
				 * the  string was produced from *)
    can_ignore_exts: Int; 	(* non-zero if ignoring extensions is
				 * acceptable, else zero *)
    item: String;		(* item returned from Xct.NextItem *)
    item_length: Int;		(* length of item in bytes *)
    char_size: Int;		(* number of bytes per character in
				 * item, with zero meaning variable *)
    encoding: char_star;		(* Encoding name for item *)
    horizontal: HDirection;	(* direction of item *)
    horz_depth: Int;		(* current direction nesting depth *)
    GL: char_star;		(* &quot;{I} F&quot; string for current GL *)
    GL_encoding: char_star;	(* Encoding name for current GL *)
    GL_set_size: Int;		(* 94 or 96 *)
    GL_char_size: Int;		(* number of bytes per GL character *)
    GR: char_star;		(* &quot;{I} F&quot; string for current GR *)
    GR_encoding: char_star;	(* Encoding name for current GR *)
    GR_set_size: Int;		(* 94 or 96 *)
    GR_char_size: Int;		(* number of bytes per GR character *)
    GLGR_encoding: char_star;	(* Encoding name for current GL+GR,
				 * if known *)
    priv: ADDRESS		(* private to parser, don't peek *)
  END;
</PRE> these are the external routines 

<P><PRE>&lt;* EXTERNAL XctCreate *&gt;
   PROCEDURE Create (string: String; length: Int; flags: Flags): Data;
</PRE> parses the next item from the CT string 
<PRE>&lt;* EXTERNAL XctNextItem *&gt;
   PROCEDURE NextItem (data: Data): Result;
</PRE> frees all data associated with the Data structure 
<PRE>&lt;* EXTERNAL XctFree *&gt;
   PROCEDURE Free (data: Data);
</PRE> resets the Data structure to reparse the CT string from the beginning 
<PRE>&lt;* EXTERNAL XctReset *&gt;
   PROCEDURE Reset (data: Data);

END Xct.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
