<HTML>
<HEAD>
<TITLE>SRC Modula-3: X11R4/src/Common/Xmbuf.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>X11R4/src/Common/Xmbuf.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Thu Feb 17 19:21:28 PST 1994 by najork                   

<P>
<P>***************************************************************************
 Some selected X extensions                                                
 based on /usr/include/X11/extensions/multibuf.h                           
***************************************************************************

<P><PRE>UNSAFE INTERFACE <interface>Xmbuf</interface>;

IMPORT <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="X.i3">X</A>;

FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT char, int, int_star, long_int, short,
                   unsigned_int, unsigned_long;

CONST
  X_MbufGetBufferVersion         = 0;
  X_MbufCreateImageBuffers       = 1;
  X_MbufDestroyImageBuffers      = 2;
  X_MbufDisplayImageBuffers      = 3;
  X_MbufSetMultiBufferAttributes = 4;
  X_MbufGetMultiBufferAttributes = 5;
  X_MbufSetBufferAttributes      = 6;
  X_MbufGetBufferAttributes      = 7;
  X_MbufGetBufferInfo            = 8;
  X_MbufCreateStereoWindow       = 9;
  X_MbufClearImageBufferArea     = 10;
</PRE><P>
 * update_action field
 

<P><PRE>CONST
  MultibufferActionUndefined  = 0;
  MultibufferActionBackground = 1;
  MultibufferActionUntouched  = 2;
  MultibufferActionCopied     = 3;
</PRE><P>
 * update_hint field
 

<P>  <PRE>MultibufferHintFrequent     = 0;
  MultibufferHintIntermittent = 1;
  MultibufferHintStatic       = 2;
</PRE><P>
 * valuemask fields
 

<P>  <PRE>MultibufferWindowUpdateHint : long_int = 1;
  MultibufferBufferEventMask  : long_int = 1;
</PRE><P>
 * mono vs. stereo and left vs. right
 

<P>  <PRE>MultibufferModeMono   = 0;
  MultibufferModeStereo = 1;

  MultibufferSideMono   = 0;
  MultibufferSideLeft   = 1;
  MultibufferSideRight  = 2;
</PRE><P>
 * clobber state
 

<P>  <PRE>MultibufferUnclobbered        = 0;
  MultibufferPartiallyClobbered = 1;
  MultibufferFullyClobbered     = 2;
</PRE><P>
 * event stuff
 

<P>  <PRE>MultibufferClobberNotifyMask = 16_02000000;
  MultibufferUpdateNotifyMask  = 16_04000000;

  MultibufferClobberNotify  = 0;
  MultibufferUpdateNotify   = 1;
  MultibufferNumberOfEvents = MultibufferUpdateNotify + 1;

  MultibufferBadBuffer      = 0;
  MultibufferNumberOfErrors = MultibufferBadBuffer + 1;
</PRE><P>
 * per-screen buffer info (there will be lists of them)
 

<P><PRE>TYPE
  XmbufBufferInfo = RECORD
    visualid    : X.VisualID;   (* visual usuable at this depth *)
    max_buffers : short;        (* most buffers for this visual *)
    depth       : char;          (* depth of buffers to be created *)
    pad         : char;
  END;
  XmbufBufferInfoStar     = UNTRACED REF XmbufBufferInfo;
  XmbufBufferInfoStarStar = UNTRACED REF XmbufBufferInfoStar;
</PRE><P>
 * Extra definitions that will only be needed in the client
 

<P>  <PRE>Multibuffer = X.XID;
  MultibufferStar = UNTRACED REF Multibuffer;

  XmbufClobberNotifyEvent = RECORD
    type       : int;            (* of event *)
    serial     : unsigned_long;  (* # of last request processed by server *)
    send_event : int;         (* true if this came frome a SendEvent request *)
    display    : X.DisplayStar;  (* Display the event was read from *)
    buffer     : Multibuffer;    (* buffer of event *)
    state      : int;            (* see Clobbered constants above *)
  END;

  XmbufUpdateNotifyEvent = RECORD
    type       : int;            (* of event *)
    serial     : unsigned_long;  (* # of last request processed by server *)
    send_event : int;         (* true if this came frome a SendEvent request *)
    display    : X.DisplayStar;  (* Display the event was read from *)
    buffer     : Multibuffer;    (* buffer of event *)
  END;
</PRE><P>
 * per-window attributes that can be got
 

<P>  <PRE>XmbufWindowAttributes = RECORD
    displayed_index : int;    (* which buffer is being displayed *)
    update_action   : int;    (* Undefined, Background, Untouched, Copied *)
    update_hint     : int;    (* Frequent, Intermittent, Static *)
    window_mode     : int;    (* Mono, Stereo *)
  END;
  XmbufWindowAttributesStar = UNTRACED REF XmbufWindowAttributes;
</PRE><P>
 * per-window attributes that can be set
 

<P>  <PRE>XmbufSetWindowAttributes = RECORD
    update_hint : int;        (* Frequent, Intermittent, Static *)
  END;
  XmbufSetWindowAttributesStar = UNTRACED REF XmbufSetWindowAttributes;
</PRE><P>
 * per-buffer attributes that can be got
 

<P>  <PRE>XmbufBufferAttributes = RECORD
    window       : X.Window;         (* which window this belongs to *)
    event_mask   : unsigned_long;    (* events that have been selected *)
    buffer_index : int;              (* which buffer is this *)
    side         : int;              (* Mono, Left, Right *)
  END;
  XmbufBufferAttributesStar = UNTRACED REF XmbufBufferAttributes;
</PRE><P>
 * per-buffer attributes that can be set
 

<P>  <PRE>XmbufSetBufferAttributes = RECORD
    event_mask : unsigned_long;      (* events that have been selected *)
  END;
  XmbufSetBufferAttributesStar = UNTRACED REF XmbufSetBufferAttributes;
</PRE>** is extension on server? **

<P><PRE>&lt;* EXTERNAL *&gt; PROCEDURE XmbufQueryExtension (
                    display           : X.DisplayStar;
                    event_base_return : int_star;
                    error_base_return : int_star) : X.Bool;
</PRE>** what is extension rev **

<P><PRE>&lt;* EXTERNAL *&gt; PROCEDURE XmbufGetVersion (
                    display              : X.DisplayStar;
                    major_version_return : int_star;
                    minor_version_return : int_star) : X.Status;
</PRE>** create buffers for window **

<P><PRE>&lt;* EXTERNAL *&gt; PROCEDURE XmbufCreateBuffers (
                    display      : X.DisplayStar;
                    window       : X.Window;
                    count        : Ctypes.int;
                    updateAction : Ctypes.int;
                    updateHint   : Ctypes.int;
                    xmbBuffers   : MultibufferStar) : Ctypes.int;
</PRE>** destroy buffers for window **

<P><PRE>&lt;* EXTERNAL *&gt; PROCEDURE XmbufDestroyBuffers (
                    display : X.DisplayStar;
                    window  : X.Window);
</PRE>** make buffers current **

<P><PRE>&lt;* EXTERNAL *&gt; PROCEDURE XmbufDisplayBuffers (
                    display   : X.DisplayStar;
                    count     : Ctypes.int;
                    xmbBuffer : MultibufferStar;
                    min_delay : Ctypes.int;
                    max_delay : Ctypes.int);	
</PRE>** get extension window attrs **

<P><PRE>&lt;* EXTERNAL *&gt; PROCEDURE XmbufGetWindowAttributes (
                    display    : X.DisplayStar;
                    window     : X.Window;
                    attributes : XmbufWindowAttributesStar) : X.Status;
</PRE>** set extension window attrs **

<P><PRE>&lt;* EXTERNAL *&gt; PROCEDURE XmbufChangeWindowAttributes (
                    display    : X.DisplayStar;
                    window     : X.Window;
                    valuemask  : unsigned_long;
                    attributes : XmbufSetWindowAttributesStar);
</PRE>** get buffer attrs **

<P><PRE>&lt;* EXTERNAL *&gt; PROCEDURE XmbufGetBufferAttributes(
                    display    : X.DisplayStar;
                    buffer     : Multibuffer;
                    attributes : XmbufBufferAttributesStar) : X.Status;
</PRE>** set buffer attrs **

<P><PRE>&lt;* EXTERNAL *&gt; PROCEDURE XmbufChangeBufferAttributes (
                    display    : X.DisplayStar;
                    buffer     : Multibuffer;
                    valuemask  : unsigned_long;
                    attributes : XmbufSetBufferAttributesStar);
</PRE>** get mono and stereo parameters **

<P><PRE>&lt;* EXTERNAL *&gt; PROCEDURE XmbufGetScreenInfo (
                    display            : X.DisplayStar;
                    drawable           : X.Drawable;
                    nmono_return       : int_star;
                    mono_info_return   : XmbufBufferInfoStarStar;
                    nstereo_return     : int_star;
                    stereo_info_return : XmbufBufferInfoStarStar) : X.Status;
</PRE>** stereo version of XCreateWindow **

<P><PRE>&lt;* EXTERNAL *&gt; PROCEDURE XmbufCreateStereoWindow(
                    display      : X.DisplayStar;
                    parent       : X.Window;
                    x            : int;
                    y            : int;
                    width        : unsigned_int;
                    height       : unsigned_int;
                    border_width : unsigned_int;
                    depth        : int;
                    class        : unsigned_int; (* InputOutput, InputOnly *)
                    visual       : X.VisualStar;
                    valuemask    : unsigned_long;
                    attributes   : X.XSetWindowAttributes;
                    left_return  : MultibufferStar;
                    right_return : MultibufferStar) : X.Window;

END Xmbuf.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
