<HTML>
<HEAD>
<TITLE>SRC Modula-3: X11R4/src/Common/Xrm.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>X11R4/src/Common/Xrm.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Xrm.i3							

<P>
<P>
<P><PRE>UNSAFE INTERFACE <interface>Xrm</interface>;
</PRE>==============================================================
	The X11 R4 Interface for Modula 3			
								
	contains:	/usr/include/X11/Xresource.h		
==============================================================

<P>
<P><PRE>FROM <A HREF="X.i3">X</A>		IMPORT	Bool, Enumeration;
FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>	IMPORT	const_char_star, char_star, char_star_star, int,
			int_star, unsigned_int;
</PRE> $XConsortium: Xresource.h,v 1.26 89/12/12 12:12:12 jim Exp $ 

<P>**********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.
<P>
                        All Rights Reserved
<P>
Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  
<P>
DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
<P>
*****************************************************************

<P> 
    Size of a <CODE>regular</CODE> List of objects


<P><PRE>CONST
  MaxSizeList  = 63;

TYPE Int = int;
</PRE>***************************************************************
 ****************************************************************
 ***                                                          ***
 ***                                                          ***
 ***          X Resource Manager Intrinsics                   ***
 ***                                                          ***
 ***                                                          ***
 ****************************************************************
 ***************************************************************

<P>***************************************************************
 *
 * Quark Management
 *
 ***************************************************************

<P><PRE>TYPE
  Quark       =  Int;
  QuarkList   =  UNTRACED REF ARRAY [0..MaxSizeList] OF Quark;

CONST
  NULLQUARK   = 0;

TYPE
  String      = char_star;

CONST
  NULLSTRING  = 0;
</PRE> find quark for string, create new quark if none already exists 
<PRE>&lt;* EXTERNAL  XrmStringToQuark *&gt;
   PROCEDURE StringToQuark (string: const_char_star): Quark;
</PRE> find string for quark 
<PRE>&lt;* EXTERNAL XrmQuarkToString *&gt;
   PROCEDURE QuarkToString (quark: Quark): String;

&lt;* EXTERNAL XrmUniqueQuark *&gt;
   PROCEDURE UniqueQuark (): Quark;
</PRE> ?!?!?! Has to be defined in <CODE>Xrm.m3</CODE> if needed.
#define XrmStringsEqual(a1, a2) (strcmp(a1, a2) == 0)
?!?!?! 

<P>
<P>***************************************************************
 *
 * Conversion of Strings to Lists
 *
 ***************************************************************

<P>
<P><PRE>TYPE
  Binding     = Enumeration;
  BindingList = UNTRACED REF ARRAY [0..MaxSizeList] OF Binding;

CONST
  BindTightly	= 0;
  BindLoosely	= 1;

&lt;* EXTERNAL XrmStringToQuarkList *&gt;
   PROCEDURE StringToQuarkList (
		string:               const_char_star;
		quarks_return:        QuarkList);

&lt;* EXTERNAL XrmStringToBindingQuarkList *&gt;
   PROCEDURE StringToBindingQuarkList (
		string:               const_char_star;
		bindings_return:      BindingList;
		quarks_return:        QuarkList);
</PRE>***************************************************************
 *
 * Name and Class lists.
 *
 ***************************************************************

<P><PRE>TYPE
  Name      =  Quark;
  NameList  =  QuarkList;
</PRE> ?!?! still not allowed in Modula-3 R^1 ... waiting for R^2.
CONST
  NameToString      =  QuarkToString;
  StringToName      =  StringToQuark;
  StringToNameList  =  StringToQuarkList;
?!?!? 

<P><PRE>&lt;* EXTERNAL XrmQuarkToString *&gt;
   PROCEDURE NameToString (quark: Quark): String;

&lt;* EXTERNAL  XrmStringToQuark *&gt;
   PROCEDURE StringToName (string: const_char_star): Quark;

&lt;* EXTERNAL XrmStringToQuarkList *&gt;
   PROCEDURE StringToNameList (string: const_char_star;
                               quarks_return: QuarkList);

TYPE
  Class              =  Quark;
  ClassList          =  QuarkList;
</PRE> ?!?! still not allowed in Modula-3 R^1 ... waiting for R^2.
CONST
  ClassToString      =  QuarkToString;
  StringToClass      =  StringToQuark;
  StringToClassList  =  StringToQuarkList;
?!?!?! 

<P><PRE>&lt;* EXTERNAL XrmQuarkToString *&gt;
   PROCEDURE ClassToString (quark: Quark): String;

&lt;* EXTERNAL  XrmStringToQuark *&gt;
   PROCEDURE StringToClass (string: const_char_star): Quark;

&lt;* EXTERNAL XrmStringToQuarkList *&gt;
   PROCEDURE StringToClassList (string: const_char_star;
                                quarks_return: QuarkList);
</PRE>***************************************************************
 *
 * Resource Representation Types and Values
 *
 ***************************************************************

<P><PRE>TYPE
  Representation      =  Quark;
  RepresentationStar  =  UNTRACED REF Representation;

&lt;* EXTERNAL  XrmStringToQuark *&gt;
   PROCEDURE StringToRepresentation (string: const_char_star): Quark;

&lt;* EXTERNAL XrmQuarkToString *&gt;
   PROCEDURE RepresentationToString (quark: Quark): String;

TYPE
  Value     = RECORD size: unsigned_int; addr: ADDRESS END;
  ValueStar = UNTRACED REF Value;
  ValuePtr  = UNTRACED REF Value;
</PRE>***************************************************************
 *
 * Resource Manager Functions
 *
 ***************************************************************

<P>
<P><PRE>TYPE
  HashBucket      =  ADDRESS;
  SearchList      =  UNTRACED REF ARRAY [0..MaxSizeList] OF HashBucket;
  Database        =  ADDRESS;
  DatabaseStar    =  ADDRESS;

&lt;* EXTERNAL XrmDestroyDatabase *&gt;
   PROCEDURE DestroyDatabase (database: Database);

&lt;* EXTERNAL XrmQPutResource *&gt;
   PROCEDURE QPutResource (
		database:             DatabaseStar;
		bindings:             BindingList;
		quarks:               QuarkList;
		type:                 Representation;
		value:                ValueStar);

&lt;* EXTERNAL XrmPutResource *&gt;
   PROCEDURE PutResource (
		database:             DatabaseStar;
		specifier:            const_char_star;
		type:                 const_char_star;
		value:                ValueStar);

&lt;* EXTERNAL XrmQPutStringResource *&gt;
   PROCEDURE QPutStringResource (
		database:             DatabaseStar;
		bindings:             BindingList;
		quarks:               QuarkList;
		value:                const_char_star);

&lt;* EXTERNAL XrmPutStringResource *&gt;
   PROCEDURE PutStringResource (
		database:             DatabaseStar;
		specifier:            const_char_star;
		value:                const_char_star);

&lt;* EXTERNAL XrmPutLineResource *&gt;
   PROCEDURE PutLineResource (
		database:             DatabaseStar;
		line:                 const_char_star);

&lt;* EXTERNAL XrmQGetResource *&gt;
   PROCEDURE QGetResource (
		database:             DatabaseStar;
		quark_name:           NameList;
		quark_class:          ClassList;
		quark_type_return:    RepresentationStar;
		value_return:         ValueStar);

&lt;* EXTERNAL XrmGetResource *&gt;
   PROCEDURE GetResource (
		database:             Database;
		str_name:             const_char_star;
		str_class:            const_char_star;
		str_type_return:      char_star_star;
		value_return:         ValueStar): Bool;

&lt;* EXTERNAL XrmQGetSearchList *&gt;
   PROCEDURE QGetSearchList (
		database:             Database;
		names:                NameList;
		classes:              ClassList;
		list_return:          SearchList;
		list_length:          Int):	Bool;

&lt;* EXTERNAL XrmQGetSearchResource *&gt;
   PROCEDURE QGetSearchResource (
		list:                 SearchList;
		name:                 Name;
		class:                Class;
		type_return:          RepresentationStar;
		value_return:         ValueStar): Bool;
</PRE>***************************************************************
 *
 * Resource Database Management
 *
 ***************************************************************

<P><PRE>&lt;* EXTERNAL XrmGetFileDatabase *&gt;
   PROCEDURE GetFileDatabase (filename:  const_char_star): Database;

&lt;* EXTERNAL XrmGetStringDatabase *&gt;
   PROCEDURE GetStringDatabase (data: const_char_star): Database;

&lt;* EXTERNAL XrmPutFileDatabase *&gt;
   PROCEDURE PutFileDatabase (database:  Database;
			      filename:  const_char_star);

&lt;* EXTERNAL XrmMergeDatabases *&gt;
   PROCEDURE MergeDatabases (source_db:     Database;
			     target_db:     DatabaseStar);
</PRE>***************************************************************
 *
 * Command line option mapping to resource entries
 *
 ***************************************************************

<P><PRE>TYPE
  OptionKind = Enumeration;

CONST
  optionNoArg	   = 0;	(* Value is specified in OptionDescRec.value	    *)
  optionIsArg	   = 1;	(* Value is the option string itself		    *)
  optionStickyArg  = 2;	(* Value is characters immediately following option *)
  optionSepArg	   = 3;	(* Value is next argument in argv		    *)
  optionResArg	   = 4;	(* Resource and value in next argument in argv      *)
  optionSkipArg	   = 5;	(* Ignore this option and the next argument in argv *)
  optionSkipLine   = 6;	(* Ignore this option and the rest of argv	    *)
  optionSkipNArgs  = 7;	(* Ignore this option and the next
			   OptionDescRes.value arguments in argv *)

TYPE
  OptionDescRec = RECORD
		    optionn: char_star;	 (* Option abbreviation in argv *)
		    specifier: char_star; (* Resource specifier  *)
		    argKind: OptionKind; (* Which style of option it is *)
		    value: ADDRESS;	 (* Value to provide if XrmoptionNoArg *)
		  END;
  OptionDescList    = UNTRACED REF ARRAY [0..MaxSizeList] OF OptionDescRec;

CONST
  voidOptionDescList  =  NIL;

&lt;* EXTERNAL XrmParseCommand *&gt;
   PROCEDURE ParseCommand (
		database:             DatabaseStar;
		table:                OptionDescList;
		table_count:          Int;
		name:                 const_char_star;
		argc_in_out:          int_star;
		argv_in_out:          char_star_star);

END Xrm.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
