<HTML>
<HEAD>
<TITLE>SRC Modula-3: X11R4/src/Common/Xt.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>X11R4/src/Common/Xt.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Xt.i3							

<P>
<P>
<P><PRE>UNSAFE INTERFACE <interface>Xt</interface>;
</PRE>==============================================================
	The X11 R4 Interface for Modula 3			
								
	contains:	/usr/include/X11/Intrinsic.h		
			/usr/include/X11/Composite.h		
			/usr/include/X11/Geometry.h ??		
==============================================================

<P>
<P><PRE>FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>  IMPORT	char, char_star, char_star_star,
			const_char_star, const_char_star_star,
			int, int_star, short,
			unsigned_char, unsigned_int,
			unsigned_long, unsigned_long_star;

FROM <A HREF="X.i3">X</A>       IMPORT	Atom, AtomStar, Cursor, DisplayStar, Enumeration,
			GC, XGCValuesStar, KeyCode, KeyCodeStar,
                        KeyCodeStarStar, KeySym, KeySymStar,
			Region, ScreenStar, Time, TimeStar, Window,
			XEventStar, XAnyEventStar, XSelectionRequestEventStar,
                        Argv;

IMPORT <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="Xrm.i3">Xrm</A>, <A HREF="#x1">XMachine</A>;

TYPE Int = int; Short = short; Char = char;
</PRE> <P>
    Size of a <CODE>regular</CODE> List of objects


<P><PRE>CONST
  MaxSizeList  = 63;
</PRE>**********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.
<P>
			All Rights Reserved
<P>
Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  
<P>
DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
<P>
*****************************************************************

<P>
<P>===================================================================
 * $XConsortium: Intrinsic.h,v 1.130 89/12/15 17:20:05 swick Exp $
 * $oHeader: Intrinsic.h,v 1.10 88/09/01 10:33:34 asente Exp $
 ====================================================================

<P><PRE>CONST
  SpecificationRelease   = 4;

TYPE
  String            =  char_star;
  StringStar        =  char_star_star;
  ConstString       =  const_char_star;
  ConstStringStar   =  const_char_star_star;
  StringList        =  UNTRACED REF ARRAY [0..MaxSizeList] OF String;

  Widget            =  ADDRESS;
  WidgetStar        =  UNTRACED REF Widget;
  WidgetList        =  UNTRACED REF ARRAY [0..MaxSizeList] OF Widget;
  WidgetClass       =  ADDRESS;
  CompositeWidget   =  ADDRESS;

  ActionList        =  UNTRACED REF ARRAY [0..MaxSizeList] OF ActionsRec;
  EventTable        =  ADDRESS;
  BoundAccActions   =  ADDRESS;

  AppContext        =  ADDRESS;

  ValueMask         =  unsigned_long;
  IntervalId        =  unsigned_long;
  IntervalIdStar    =  UNTRACED REF IntervalId;
  InputId           =  unsigned_long;
  InputIdStar       =  UNTRACED REF InputId;
  WorkProcId        =  unsigned_long;
  GeometryMask      =  unsigned_int;
  GCMask            =  unsigned_long;(* Mask of values that are used by widget*)
  Pixel             =  unsigned_long;   (* Index into colormap		*)
</PRE> ?!?!?!
#define XtNumber(arr)		((Cardinal) (sizeof(arr) / sizeof(arr[0])))
?!?!?! 

<P><PRE>TYPE
  CacheType		=  Int;

CONST
  CacheNone		=	  16_001;
  CacheAll		=	  16_002;
  CacheByDisplay	=	  16_003;
  CacheRefCount		=	  16_100;
</PRE>***************************************************************
 *
 * System Dependent Definitions; see spec for specific range
 * requirements.  Do not assume every implementation uses the
 * same base types!
 *
 *
 * XtArgVal ought to be a union of XtPointer, char *, long, Int *, and proc *
 * but casting to union types is not really supported.
 *
 * So the typedef for XtArgVal should be chosen such that
 *
 *	sizeof (XtArgVal) &gt;=	sizeof(XtPointer)
 *				sizeof(char * )
 *				sizeof(long)
 *				sizeof(Int * )
 *				sizeof(proc * )
 *
 * ArgLists rely heavily on the above typedef.
 *
 ***************************************************************

<P><PRE>TYPE

  ArgVal               =  ADDRESS;(* and not Long because of the above union *)

  Boolean              =  Char;
  BooleanStar          =  UNTRACED REF Boolean;
  Cardinal             =  unsigned_int;
  CardinalStar         =  UNTRACED REF Cardinal;
  Dimension            =  XMachine.Dimension; (* size in pixels *)
  DimensionStar        =  UNTRACED REF Dimension;
  Enum                 =  unsigned_char;
  Opaque               =  char_star;
  Pointer              =  char_star;
  PointerStar          =  UNTRACED REF Pointer;
  Position             =  Short ;   (* Offset from 0 coordinate	*)
  PositionStar         =  UNTRACED REF Position;

TYPE

  Translations       =  ADDRESS;
  Accelerators       =  ADDRESS;
  Modifiers          =  unsigned_int;
  ModifiersStar      =  UNTRACED REF Modifiers;

  ActionProc         =  PROCEDURE (
     widget:                 Widget;
     event:                  XAnyEventStar;
     params:                 StringStar;
     num_params:             CardinalStar);

  ActionsRec         =  RECORD
			    string: String;
			    proc: ActionProc;
			END;

TYPE
  AddressMode		=  Enumeration;
</PRE><BLOCKQUOTE><EM> address mode		parameter representation    </EM></BLOCKQUOTE><PRE>
</PRE> ------------		------------------------    
<PRE>CONST
    Address		= 0; (* address			    *)
    BaseOffset		= 1; (* offset			    *)
    Immediate		= 2; (* constant		    *)
    ResourceString	= 3; (* resource name string	    *)
    ResourceQuark	= 4; (* resource name quark	    *)
    WidgetBaseOffset	= 5; (* offset from ancestor	    *)
    ProcedureArg	= 6; (* procedure to invoke	    *)

TYPE
  ConvertArgRec   =  RECORD
			address_mode: AddressMode;
			address_id: Pointer;
			size: Cardinal;
		     END;

  ConvertArgList  =  UNTRACED REF ARRAY [0..MaxSizeList] OF ConvertArgRec;

TYPE
  ConvertArgProc  =  PROCEDURE (
     widget:                 Widget;
     size:                   CardinalStar;
     value:                  Xrm.ValueStar);

TYPE
  WidgetGeometry   = RECORD
			request_mode: GeometryMask;
			x, y: Position;
			width, height, border_width: Dimension;
			sibling: Widget;
			stack_mode: Int   (* Above, Below, TopIf, BottomIf,
					     Opposite, DontChange *)
		     END;
  WidgetGeometryStar  =  UNTRACED REF WidgetGeometry;

CONST
  (* Additions to Xlib geometry requests: ask what would happen, don't do it *)
  CWQueryOnly      =   Word.Shift (1, 7);

  (* Additions to Xlib stack modes: don't change stack order *)
  SMDontChange	   =  5;

TYPE
  Converter  =  PROCEDURE (
     args:                   Xrm.ValueStar;
     num_args:               CardinalStar;
     from:                   Xrm.ValueStar;
     to:                     Xrm.ValueStar);

TYPE
  TypeConverter  =  PROCEDURE (
     dpy:                    DisplayStar;
     args:                   Xrm.ValueStar;
     num_args:               CardinalStar;
     from:                   Xrm.ValueStar;
     to:                     Xrm.ValueStar;
     converter_data:         PointerStar): Boolean;

TYPE
  Destructor  =  PROCEDURE (
     app:                    AppContext;
     to:                     Xrm.ValueStar;
     converter_data:         Pointer;
     args:                   Xrm.ValueStar;
     num_args:               CardinalStar);

TYPE
  CacheRef          =  Pointer;
  CacheRefStar      =  UNTRACED REF CacheRef;
  ActionHookId      =  Pointer;
  ActionHookIdStar  =  UNTRACED REF ActionHookId;

TYPE
  ActionHookProc  =  PROCEDURE (
     w:                      Widget;
     client_data:            Pointer;
     action_name:            String;
     event:                  XEventStar;
     params:                 StringStar;
     num_params:             CardinalStar);

TYPE
  KeyProc  =  PROCEDURE (
     dpy:                    DisplayStar;
     keycode:                KeyCodeStar;
     modifiers:              ModifiersStar;
     modifiers_return:       ModifiersStar;
     keysym_return:          KeySymStar);

TYPE
  CaseProc  =  PROCEDURE (
     keysym:                 KeySymStar;
     lower_return:           KeySymStar;
     upper_return:           KeySymStar);

TYPE
  EventHandler  =  PROCEDURE (
     widget:                 Widget;
     closure:                Pointer;
     event:                  XAnyEventStar;
     continue_to_dispatch:   BooleanStar);

TYPE
  EventMask      =  unsigned_long;
  InputMask      =  unsigned_long;
  ListPosition   =  Enumeration;

CONST
  ListHead       = 0;
  ListTail       = 1;

CONST
  InputNoneMask	   =  0;
  InputReadMask	   =  1;
  InputWriteMask   =  2;
  InputExceptMask  =  4;

TYPE
  TimerCallbackProc  =  PROCEDURE (
     closure:                Pointer;
     id:                     IntervalIdStar);

TYPE
  InputCallbackProc  =  PROCEDURE (
     closure:                Pointer;
     source:                 int_star;
     id:                     InputIdStar);

TYPE
  Arg                =  RECORD
				name: String;
				value: ArgVal;
			END;
  ArgList     	     =  UNTRACED REF ARRAY [0..MaxSizeList] OF Arg;
  VarArgsList        =  Pointer;

TYPE
  CallbackProc  =  PROCEDURE (
     widget:                 Widget;
     closure:                Pointer;	(* data the application registered *)
     call_data:              Pointer);	(* callback specific data *)

TYPE
  CallbackRec     =  RECORD
			callback: CallbackProc;
			closure: Pointer;
		     END;
  CallbackList    =  UNTRACED REF ARRAY [0..MaxSizeList] OF CallbackRec;

  CallbackStatus  =  Enumeration;

CONST
  CallbackNoList  = 0;
  CallbackHasNone = 1;
  CallbackHasSome = 2;

TYPE
  GeometryResult  =  Enumeration;

CONST
  GeometryYes	= 0;	  (* Request accepted. *)
  GeometryNo	= 1;	  (* Request denied. *)
  GeometryAlmost= 2;      (* Request denied, but willing to take replyBox. *)
  GeometryDone	= 3;	  (* Request accepted and done. *)

TYPE
  GrabKind        =  Enumeration;

CONST
  GrabNone		= 0;
  GrabNonexclusive	= 1;
  GrabExclusive		= 2;

TYPE
  PopdownIDRec   =  RECORD
			  shell_widget:	  Widget;
			  enable_widget:  Widget;
		    END;
  PopdownIDStar  =  UNTRACED REF PopdownIDRec;

TYPE
  Resource     =  RECORD
			resource_name: String;	   (* Resource name *)
			resource_class: String;	   (* Resource class *)
			resource_type: String;	   (* Representation type
                                                      desired *)
			resource_size: Cardinal;   (* Size in bytes of
                                                      representation *)
			resource_offset: Cardinal; (* Offset from base to put
                                                      resource value *)
			default_type: String;	   (* representation type of
                                                      specified default *)
			default_addr: Pointer;	   (* Address of default
                                                      resource *)
		 END;

  ResourceList      =  UNTRACED REF ARRAY [0..MaxSizeList] OF Resource;

TYPE
  ErrorMsgHandler  =  PROCEDURE (
     name:                   String;
     type:                   String;
     class:                  String;
     defaultp:               String;
     params:                 StringStar;
     num_params:             CardinalStar);

TYPE
  ErrorHandler  =  PROCEDURE (
     msg:                    String);

TYPE
  WorkProc  =  PROCEDURE (
     closure:                Pointer	(* data the application registered *)
): Boolean;

TYPE
  SubstitutionRec  =  RECORD
			match: Char;
			substitution: String;
		      END;
  SubstitutionStar =  UNTRACED REF SubstitutionRec;

TYPE
  FilePredicate  =  PROCEDURE (filename: String): Boolean;

TYPE
  RequestId       =  Pointer;
  RequestIdStar   =  UNTRACED REF RequestId;

TYPE
    FallbackRes		=  String;
    FallbackResList	=  UNTRACED REF ARRAY [0..MaxSizeList] OF FallbackRes;
</PRE><P>
 * Routine to get the value of a selection as a given type.  Returns
 * TRUE if it successfully got the value as requested, FALSE otherwise.  
 * selection is the atom describing the type of selection (e.g. 
 * primary or secondary). value is set to the pointer of the converted 
 * value, with length elements of data, each of size indicated by format.
 * (This pointer will be freed using XtFree when the selection has
 *  been delivered to the requestor.)  target is
 * the type that the conversion should use if possible; type is returned as
 * the actual type returned.  Format should be either 8, 16, or 32, and
 * specifies the word size of the selection, so that Xlib and the server can
 * convert it between different machine types. 

<P><PRE>TYPE
  ConvertSelectionProc  =  PROCEDURE (
     widget:                 Widget;
     selection:              AtomStar;
     target:                 AtomStar;
     type_return:            AtomStar;
     value_return:           PointerStar;
     length_return:          unsigned_long_star;
     format_return:          int_star): Boolean;
</PRE><P>
 * Routine to inform a widget that it no longer owns the given selection.
 

<P><PRE>TYPE
  LoseSelectionProc  =  PROCEDURE (
     widget:                 Widget;
     selection:              AtomStar);
</PRE><P>
 * Routine to inform the selection owner when a selection requestor
 * has successfully retrieved the selection value.
 

<P><PRE>TYPE
  SelectionDoneProc  =  PROCEDURE (
     widget:                 Widget;
     selection:              AtomStar;
     target:                 AtomStar);
</PRE><P>
 * Routine to call back when a requested value has been obtained for a
 *  selection.
 

<P><PRE>TYPE
  SelectionCallbackProc  =  PROCEDURE (
     widget:                 Widget;
     closure:                Pointer;
     selection:              AtomStar;
     type:                   AtomStar;
     value:                  Pointer;
     length:                 unsigned_long_star;
     format:                 int_star);

TYPE
  LoseSelectionIncrProc  =  PROCEDURE (
     widget:                 Widget;
     selection:              AtomStar;
     client_data:            Pointer);

TYPE
  SelectionDoneIncrProc  =  PROCEDURE (
     widget:                 Widget;
     selection:              AtomStar;
     target:                 AtomStar;
     receiver_id:            RequestIdStar;
     client_data:            Pointer);

TYPE
  ConvertSelectionIncrProc  =  PROCEDURE (
     widget:                 Widget;
     selection:              AtomStar;
     target:                 AtomStar;
     type:                   AtomStar;
     value:                  PointerStar;
     length:                 unsigned_long_star;
     format:                 int_star;
     max_length:             unsigned_long_star;
     client_data:            Pointer;
     receiver_id:            RequestIdStar): Boolean;

TYPE
  CancelConvertSelectionProc  =  PROCEDURE (
     widget:                 Widget;
     selection:              AtomStar;
     target:                 AtomStar;
     receiver_id:            RequestIdStar;
     client_data:            Pointer);
</PRE>**************************************************************
 *
 * Exported Interfaces
 *
 ***************************************************************

<P><PRE>&lt;* EXTERNAL XtConvertAndStore *&gt;
   PROCEDURE ConvertAndStore (
     widget:                 Widget;
     from_type:              ConstString;
     from:                   Xrm.ValueStar;
     to_type:                ConstString;
     to_in_out:              Xrm.ValueStar		
): Boolean;

&lt;* EXTERNAL XtCallConverter *&gt;
   PROCEDURE CallConverter (
     dpy:                    DisplayStar;
     converter:              TypeConverter;
     args:                   Xrm.ValuePtr;
     num_args:               Cardinal;
     from:                   Xrm.ValuePtr;
     to_return:              Xrm.ValueStar;
     cache_ref_return:       CacheRefStar		
): Boolean;

&lt;* EXTERNAL XtDispatchEvent *&gt;
   PROCEDURE DispatchEvent (
     event:                  XEventStar 		
): Boolean;

&lt;* EXTERNAL XtCallAcceptFocus *&gt;
   PROCEDURE CallAcceptFocus (
     widget:                 Widget;
     t:                      TimeStar		
): Boolean;

&lt;* EXTERNAL XtPeekEvent *&gt;
   PROCEDURE PeekEvent (
     event:                  XEventStar		
): Boolean;

&lt;* EXTERNAL XtAppPeekEvent *&gt;
   PROCEDURE AppPeekEvent (
     appContext:             AppContext;
     event:                  XEventStar		
): Boolean;

&lt;* EXTERNAL XtIsSubclass *&gt;
   PROCEDURE IsSubclass (
     widget:                 Widget;
     widgetClass:            WidgetClass 	
): Boolean;

&lt;* EXTERNAL XtIsObject *&gt;
   PROCEDURE IsObject (
     object:                 Widget 		
): Boolean;

&lt;* EXTERNAL &quot;_XtCheckSubclassFlag&quot; *&gt;
   PROCEDURE CheckSubclassFlag ( (* implementation-private *)
     object:                 Widget;
     type_flag:              Enum		
): Boolean;

&lt;* EXTERNAL &quot;_XtIsSubclassOf&quot; *&gt;
   PROCEDURE IsSubclassOf ( (* implementation-private *)
     object:                 Widget;
     widget_class:           WidgetClass;
     flag_class:             WidgetClass;
     type_flag:              Enum		
): Boolean;

&lt;* EXTERNAL XtIsManaged *&gt;
   PROCEDURE IsManaged (
     rectobj:                Widget 		
): Boolean;

&lt;* EXTERNAL XtIsRealized *&gt;
   PROCEDURE IsRealized (
     widget:                 Widget 		
): Boolean;

&lt;* EXTERNAL XtIsSensitive *&gt;
   PROCEDURE IsSensitive (
     widget:                 Widget 		
): Boolean;
</PRE><P>
 * Set the given widget to own the selection.  The convertProc should
 * be called when someone wants the current value of the selection. If it
 * is not NULL, the
 * losesSelection gets called whenever the window no longer owns the selection
 * (because someone else took it). If it is not NULL, the doneProc gets
 * called when the widget has provided the current value of the selection
 * to a requestor and the requestor has indicated that it has succeeded
 * in reading it by deleting the property.
 

<P><PRE>&lt;* EXTERNAL XtOwnSelection *&gt;
   PROCEDURE OwnSelection (
     widget:                 Widget;
     selection:              Atom;
     time:                   Time;
     convert:                ConvertSelectionProc;
     lose:                   LoseSelectionProc;
     done:                   SelectionDoneProc
): Boolean;
</PRE> incremental selection interface 

<P><PRE>&lt;* EXTERNAL XtOwnSelectionIncremental *&gt;
   PROCEDURE OwnSelectionIncremental (
     widget:                 Widget;
     selection:              Atom;
     time:                   Time;
     convert_callback:       ConvertSelectionIncrProc;
     lose_callback:          LoseSelectionIncrProc;
     done_callback:          SelectionDoneIncrProc;
     cancel_callback:        CancelConvertSelectionProc;
     client_data:            Pointer 		
): Boolean;

&lt;* EXTERNAL XtMakeResizeRequest *&gt;
   PROCEDURE MakeResizeRequest (
     widget:                 Widget;
     width:                  Dimension;
     height:                 Dimension;
     replyWidth:             DimensionStar;
     replyHeight:            DimensionStar		
): GeometryResult;

&lt;* EXTERNAL XtTransformCoords *&gt;
   PROCEDURE TransformCoords (
     widget:                 Widget;
     x:                      Position;
     y:                      Position;
     rootx:                  PositionStar;
     rooty:                  PositionStar		
);
</PRE> %%% Caution: don't declare any functions past this point that
 * return one of the following types or take a pointer to one of
 * the following types.
 

<P><PRE>&lt;* EXTERNAL XtStringConversionWarning *&gt;
   PROCEDURE StringConversionWarning (
     from:                   ConstString;
     toType:                 ConstString (* Type attempted to convert it to. *)
);

&lt;* EXTERNAL XtDisplayStringConversionWarning *&gt;
   PROCEDURE DisplayStringConversionWarning (
     dpy:                    DisplayStar;
     from:                   ConstString;  (* String attempted to convert. *)
     toType:                 ConstString   (* Type attempted to
                                              convert it to. *)
);
</PRE> ?!?!?!
externalref XtConvertArgRec colorConvertArgs[];
externalref XtConvertArgRec screenConvertArg[];
?!?!?! 

<P><PRE>&lt;* EXTERNAL XtAppAddConverter *&gt;
   PROCEDURE AppAddConverter ( (* obsolete *)
     app:                    AppContext;
     from_type:              ConstString;
     to_type:                ConstString;
     converter:              Converter;
     convert_args:           ConvertArgList;
     num_args:               Cardinal 		
);

&lt;* EXTERNAL XtAddConverter *&gt;
   PROCEDURE AddConverter ( (* obsolete *)
     from_type:              ConstString;
     to_type:                ConstString;
     converter:              Converter;
     convert_args:           ConvertArgList;
     num_args:               Cardinal 		
);

&lt;* EXTERNAL XtSetTypeConverter *&gt;
   PROCEDURE SetTypeConverter (
     from_type:              ConstString;
     to_type:                ConstString;
     converter:              TypeConverter;
     convert_args:           ConvertArgList;
     num_args:               Cardinal;
     cache_type:             CacheType;
     destructor:             Destructor 	
);

&lt;* EXTERNAL XtAppSetTypeConverter *&gt;
   PROCEDURE AppSetTypeConverter (
     app_context:            AppContext;
     from_type:              ConstString;
     to_type:                ConstString;
     converter:              TypeConverter;
     convert_args:           ConvertArgList;
     num_args:               Cardinal;
     cache_type:             CacheType;
     destructor:             Destructor 	
);

&lt;* EXTERNAL XtConvert *&gt;
   PROCEDURE Convert (
     widget:                 Widget;
     from_type:              ConstString;
     from:                   Xrm.ValueStar;
     to_type:                ConstString;
     to_return:              Xrm.ValueStar		
);

&lt;* EXTERNAL XtDirectConvert *&gt;
   PROCEDURE DirectConvert (
     converter:              Converter;
     args:                   Xrm.ValuePtr;
     num_args:               Cardinal;
     from:                   Xrm.ValuePtr;
     to_return:              Xrm.ValueStar		
);
</PRE>***************************************************************
 *
 * Translation Management
 *
 ***************************************************************

<P><PRE>&lt;* EXTERNAL XtParseTranslationTable *&gt;
   PROCEDURE ParseTranslationTable (
     source:                 ConstString	
): Translations;

&lt;* EXTERNAL XtParseAcceleratorTable *&gt;
   PROCEDURE ParseAcceleratorTable (
     source:                 ConstString	
): Accelerators;

&lt;* EXTERNAL XtOverrideTranslations *&gt;
   PROCEDURE OverrideTranslations (
     widget:                 Widget;
     new:                    Translations 	
);

&lt;* EXTERNAL XtAugmentTranslations *&gt;
   PROCEDURE AugmentTranslations (
     widget:                 Widget;
     new:                    Translations 	
);

&lt;* EXTERNAL XtInstallAccelerators *&gt;
   PROCEDURE InstallAccelerators (
     destination:            Widget;
     source:                 Widget		
);

&lt;* EXTERNAL XtInstallAllAccelerators *&gt;
   PROCEDURE InstallAllAccelerators (
     destination:            Widget;
     source:                 Widget		
);

&lt;* EXTERNAL XtUninstallTranslations *&gt;
   PROCEDURE UninstallTranslations (
     widget:                 Widget 		
);

&lt;* EXTERNAL XtAppAddActions *&gt;
   PROCEDURE AppAddActions (
     app:                    AppContext;
     actions:                ActionList;
     num_actions:            Cardinal
);

&lt;* EXTERNAL XtAddActions *&gt;
   PROCEDURE AddActions (
     actions:                ActionList;
     num_actions:            Cardinal 		
);

&lt;* EXTERNAL XtAppAddActionHook *&gt;
   PROCEDURE AppAddActionHook (
     app:                    AppContext;
     proc:                   ActionHookProc;
     client_data:            Pointer 		
): ActionHookId;

&lt;* EXTERNAL XtRemoveActionHook *&gt;
   PROCEDURE RemoveActionHook (
     id:                     ActionHookId 	
);

&lt;* EXTERNAL XtCallActionProc *&gt;
   PROCEDURE CallActionProc (
     widget:                 Widget;
     action:                 ConstString;
     event:                  XEventStar;
     params:                 StringStar;
     num_params:             Cardinal		
);

&lt;* EXTERNAL XtRegisterGrabAction *&gt;
   PROCEDURE RegisterGrabAction (
     action_proc:            ActionProc;
     owner_events:           Boolean;
     event_mask:             unsigned_int;
     pointer_mode:           Int;
     keyboard_mode:          Int	 		
);

&lt;* EXTERNAL XtSetMultiClickTime *&gt;
   PROCEDURE SetMultiClickTime (
     dpy:                    DisplayStar;
     milliseconds:           Int 		
);

&lt;* EXTERNAL XtGetMultiClickTime *&gt;
   PROCEDURE GetMultiClickTime (
     dpy:                    DisplayStar		
): Int;

&lt;* EXTERNAL XtGetActionKeysym *&gt;
   PROCEDURE GetActionKeysym (
     event:                  XEventStar;
     modifiers_return:       ModifiersStar		
): KeySym;
</PRE>**************************************************************
 *
 * Keycode and Keysym procedures for translation management
 *
 ***************************************************************

<P><PRE>&lt;* EXTERNAL XtTranslateKeycode *&gt;
   PROCEDURE TranslateKeycode (
     dpy:                    DisplayStar;
     keycode:                KeyCode;
     modifiers:              Modifiers;
     modifiers_return:       ModifiersStar;
     keysym_return:          KeySymStar		
);

&lt;* EXTERNAL XtTranslateKey *&gt;
   PROCEDURE TranslateKey (
     dpy:                    DisplayStar;
     keycode:                KeyCodeStar;
     modifiers:              ModifiersStar;
     modifiers_return:       ModifiersStar;
     keysym_return:          KeySymStar		
);

&lt;* EXTERNAL XtSetKeyTranslator *&gt;
   PROCEDURE SetKeyTranslator (
     dpy:                    DisplayStar;
     proc:                   KeyProc 		
);

&lt;* EXTERNAL XtRegisterCaseConverter *&gt;
   PROCEDURE RegisterCaseConverter (
     dpy:                    DisplayStar;
     proc:                   CaseProc;
     start:                  KeySym;
     stop:                   KeySym 		
);

&lt;* EXTERNAL XtConvertCase *&gt;
   PROCEDURE ConvertCase (
     dpy:                    DisplayStar;
     keysym:                 KeySym;
     lower_return:           KeySymStar;
     upper_return:           KeySymStar		
);

&lt;* EXTERNAL XtGetKeysymTable *&gt;
   PROCEDURE GetKeysymTable (
     dpy:                    DisplayStar;
     min_keycode_return:     KeyCodeStar;
     keysyms_per_keycode_return: int_star		
): KeySymStar;

&lt;* EXTERNAL XtKeysymToKeycodeList *&gt;
   PROCEDURE KeysymToKeycodeList (
     dpy:                    DisplayStar;
     keysym:                 KeySym;
     keycodes_return:        KeyCodeStarStar;
     keycount_return:        CardinalStar		
);
</PRE>***************************************************************
 *
 * Event Management
 *
 ***************************************************************

<P><PRE>CONST
  AllEvents  = -1;

&lt;* EXTERNAL XtInsertEventHandler *&gt;
   PROCEDURE InsertEventHandler (
     widget:                 Widget;
     eventMask:              EventMask;
     nonmaskable:            Boolean;
     proc:                   EventHandler;
     closure:                Pointer;
     position:               ListPosition 	
);

&lt;* EXTERNAL XtInsertRawEventHandler *&gt;
   PROCEDURE InsertRawEventHandler (
     widget:                 Widget;
     eventMask:              EventMask;
     nonmaskable:            Boolean;
     proc:                   EventHandler;
     closure:                Pointer;
     position:               ListPosition 	
);

&lt;* EXTERNAL XtAddEventHandler *&gt;
   PROCEDURE AddEventHandler (
     widget:                 Widget;
     eventMask:              EventMask;
     nonmaskable:            Boolean;
     proc:                   EventHandler;
     closure:                Pointer 		:= NIL
);

&lt;* EXTERNAL XtRemoveEventHandler *&gt;
   PROCEDURE RemoveEventHandler (
     widget:                 Widget;
     eventMask:              EventMask;
     nonmaskable:            Boolean;
     proc:                   EventHandler;
     closure:                Pointer 		:= NIL
);

&lt;* EXTERNAL XtAddRawEventHandler *&gt;
   PROCEDURE AddRawEventHandler (
     widget:                 Widget;
     eventMask:              EventMask;
     nonmaskable:            Boolean;
     proc:                   EventHandler;
     closure:                Pointer 		:= NIL
);

&lt;* EXTERNAL XtRemoveRawEventHandler *&gt;
   PROCEDURE RemoveRawEventHandler (
     widget:                 Widget;
     eventMask:              EventMask;
     nonmaskable:            Boolean;
     proc:                   EventHandler;
     closure:                Pointer 		:= NIL
);
</PRE> !!!!! double definition in Intrinsic.h !!!!!
&lt;* EXTERNAL XtInsertEventHandler *&gt;
   PROCEDURE InsertEventHandler (
     widget:                 Widget;
     eventMask:              EventMask;
     nonmaskable:            Boolean;
     proc:                   EventHandler;
     closure:                Pointer;
     position:               ListPosition 	
);
<P>
&lt;* EXTERNAL XtInsertRawEventHandler *&gt;
   PROCEDURE InsertRawEventHandler (
     widget:                 Widget;
     eventMask:              EventMask;
     nonmaskable:            Boolean;
     proc:                   EventHandler;
     closure:                Pointer;
     position:               ListPosition 	
);
   !!!!! double definition in Intrinsic.h !!!!! 

<P><PRE>&lt;* EXTERNAL XtBuildEventMask *&gt;
   PROCEDURE BuildEventMask (
     widget:                 Widget 		
): EventMask;

&lt;* EXTERNAL XtAddGrab *&gt;
   PROCEDURE AddGrab (
     widget:                 Widget;
     exclusive:              Boolean;
     spring_loaded:          Boolean 		
);

&lt;* EXTERNAL XtRemoveGrab *&gt;
   PROCEDURE RemoveGrab (
     widget:                 Widget 		
);

&lt;* EXTERNAL XtProcessEvent *&gt;
   PROCEDURE ProcessEvent (
     mask:                   InputMask 		
);

&lt;* EXTERNAL XtAppProcessEvent *&gt;
   PROCEDURE AppProcessEvent (
     app:                    AppContext;
     mask:                   InputMask 		
);

&lt;* EXTERNAL XtMainLoop *&gt;
   PROCEDURE MainLoop ();

&lt;* EXTERNAL XtAppMainLoop *&gt;
   PROCEDURE AppMainLoop (
     app:                    AppContext 		
);

&lt;* EXTERNAL XtAddExposureToRegion *&gt;
   PROCEDURE AddExposureToRegion (
     event:                  XEventStar;
     region:                 Region 		
);

&lt;* EXTERNAL XtSetKeyboardFocus *&gt;
   PROCEDURE SetKeyboardFocus (
     subtree:                Widget;
     descendent:             Widget 		
);

&lt;* EXTERNAL XtLastTimestampProcessed *&gt;
   PROCEDURE LastTimestampProcessed (
     dpy:                    DisplayStar		
): Time;
</PRE>***************************************************************
 *
 * Event Gathering Routines
 *
 ***************************************************************

<P><PRE>&lt;* EXTERNAL XtAddTimeOut *&gt;
   PROCEDURE AddTimeOut (
     interval:               unsigned_long;
     proc:                   TimerCallbackProc;
     closure:                Pointer 		:= NIL
): IntervalId;

&lt;* EXTERNAL XtAppAddTimeOut *&gt;
   PROCEDURE AppAddTimeOut (
     app:                    AppContext;
     interval:               unsigned_long;
     proc:                   TimerCallbackProc;
     closure:                Pointer 		:= NIL
): IntervalId;

&lt;* EXTERNAL XtRemoveTimeOut *&gt;
   PROCEDURE RemoveTimeOut (
     timer:                  IntervalId 	
);

&lt;* EXTERNAL XtAddInput *&gt;
   PROCEDURE AddInput (
     source:                 Int;
     condition:              Pointer;
     proc:                   InputCallbackProc;
     closure:                Pointer 		:= NIL
): InputId;

&lt;* EXTERNAL XtAppAddInput *&gt;
   PROCEDURE AppAddInput (
     app:                    AppContext;
     source:                 Int;
     condition:              Pointer;
     proc:                   InputCallbackProc;
     closure:                Pointer 		:= NIL
): InputId;

&lt;* EXTERNAL XtRemoveInput *&gt;
   PROCEDURE RemoveInput (
     id:                     InputId 		
);

&lt;* EXTERNAL XtNextEvent *&gt;
   PROCEDURE NextEvent (
     event:                  XEventStar 		
);

&lt;* EXTERNAL XtAppNextEvent *&gt;
   PROCEDURE AppNextEvent (
     appContext:             AppContext;
     event:                  XEventStar		
);

CONST
  IMXEvent		=  1;
  IMTimer		=  2;
  IMAlternateInput	=  4;
  IMAll			=  (IMXEvent + IMTimer + IMAlternateInput);

&lt;* EXTERNAL XtPending *&gt;
   PROCEDURE Pending (): InputMask;

&lt;* EXTERNAL XtAppPending *&gt;
   PROCEDURE AppPending (
     appContext:             AppContext 	
): InputMask;
</PRE>***************************************************************
 *
 * Random utility routines
 *
 ***************************************************************

<P> ?!?!?!?!
#define XtIsRectObj(object)	(_XtCheckSubclassFlag(object, (XtEnum)0x02))
#define XtIsWidget(object)	(_XtCheckSubclassFlag(object, (XtEnum)0x04))
#define XtIsComposite(widget)	(_XtCheckSubclassFlag(widget, (XtEnum)0x08))
#define XtIsConstraint(widget)	(_XtCheckSubclassFlag(widget, (XtEnum)0x10))
#define XtIsShell(widget)	(_XtCheckSubclassFlag(widget, (XtEnum)0x20))
#define XtIsOverrideShell(widget) \
    (_XtIsSubclassOf(widget, (WidgetClass)overrideShellWidgetClass, \
		     (WidgetClass)shellWidgetClass, (XtEnum)0x20))
#define XtIsWMShell(widget)	(_XtCheckSubclassFlag(widget, (XtEnum)0x40))
#define XtIsVendorShell(widget)	\
    (_XtIsSubclassOf(widget, (WidgetClass)vendorShellWidgetClass, \
		     (WidgetClass)wmShellWidgetClass, (XtEnum)0x40))
#define XtIsTransientShell(widget) \
    (_XtIsSubclassOf(widget, (WidgetClass)transientShellWidgetClass, \
		     (WidgetClass)wmShellWidgetClass, (XtEnum)0x40))
#define XtIsTopLevelShell(widget) (_XtCheckSubclassFlag(widget, (XtEnum)0x80))
#define XtIsApplicationShell(widget) \
    (_XtIsSubclassOf(widget, (WidgetClass)applicationShellWidgetClass, \
		     (WidgetClass)topLevelShellWidgetClass, (XtEnum)0x80))
?!?!?! 

<P><PRE>&lt;* EXTERNAL XtRealizeWidget *&gt;
   PROCEDURE RealizeWidget (
     widget:                 Widget 		
);

&lt;* EXTERNAL XtUnrealizeWidget *&gt;
   PROCEDURE UnrealizeWidget (
     widget:                 Widget 		
);

&lt;* EXTERNAL XtDestroyWidget *&gt;
   PROCEDURE DestroyWidget (
     widget:                 Widget 		
);

&lt;* EXTERNAL XtSetSensitive *&gt;
   PROCEDURE SetSensitive (
     widget:                 Widget;
     sensitive:              Boolean 		
);

&lt;* EXTERNAL XtSetMappedWhenManaged *&gt;
   PROCEDURE SetMappedWhenManaged (
     widget:                 Widget;
     mappedWhenManaged:      Boolean 		
);

&lt;* EXTERNAL XtNameToWidget *&gt;
   PROCEDURE NameToWidget (
     root:                   Widget;
     name:                   ConstString	
): Widget;

&lt;* EXTERNAL XtWindowToWidget *&gt;
   PROCEDURE WindowToWidget (
     display:                DisplayStar;
     window:                 Window 		
): Widget;
</PRE>**************************************************************
 *
 * Arg lists
 *
 ***************************************************************

<P> ?!?!?!
#define XtSetArg(arg, n, d) \
    ((void)( (arg).name = (n), (arg).value = (XtArgVal)(d) ))
?!?!?! 

<P><PRE>&lt;* EXTERNAL XtMergeArgLists *&gt;
   PROCEDURE MergeArgLists (
     args1:                  ArgList;
     num_args1:              Cardinal;
     args2:                  ArgList;
     num_args2:              Cardinal 		
): ArgList;
</PRE>**************************************************************
 *
 * Vararg lists
 *
 ***************************************************************

<P> ?!?!?!
#define XtVaNestedList  <CODE>XtVaNestedList</CODE>
#define XtVaTypedArg    <CODE>XtVaTypedArg</CODE>
<P>
&lt;* EXTERNAL XtVaCreateArgsList *&gt;
   PROCEDURE VaCreateArgsList (
    Pointer		(*unused<PRE>, ...
): XtVarArgsList;
?!?!?! *)
</PRE>************************************************************
 *
 * Information routines
 *
 ***********************************************************

<P> We're not included from the private file, so define these 

<P><PRE>&lt;* EXTERNAL XtDisplay *&gt;
   PROCEDURE Display (
     widget:                 Widget 		
): DisplayStar;

&lt;* EXTERNAL XtDisplayOfObject *&gt;
   PROCEDURE DisplayOfObject (
     object:                 Widget 		
): DisplayStar;

&lt;* EXTERNAL XtScreen *&gt;
   PROCEDURE Screen (
     widget:                 Widget 		
): ScreenStar;

&lt;* EXTERNAL XtScreenOfObject *&gt;
   PROCEDURE ScreenOfObject (
     object:                 Widget 		
): ScreenStar;

&lt;* EXTERNAL XtWindow *&gt;
   PROCEDURE XtWindow (
     widget:                 Widget 		
): Window;

&lt;* EXTERNAL XtWindowOfObject *&gt;
   PROCEDURE WindowOfObject (
     object:                 Widget 		
): Window;

&lt;* EXTERNAL XtName *&gt;
   PROCEDURE Name (
     object:                 Widget 		
): String;

&lt;* EXTERNAL XtSuperclass *&gt;
   PROCEDURE Superclass (
     object:                 Widget 		
): WidgetClass;

&lt;* EXTERNAL XtClass *&gt;
   PROCEDURE Class (
     object:                 Widget 		
): WidgetClass;

&lt;* EXTERNAL XtParent *&gt;
   PROCEDURE Parent (
     widget:                 Widget 		
): Widget;
</PRE> ?!?!?!?
#define XtMapWidget(widget)	XMapWindow(XtDisplay(widget), XtWindow(widget))
#define XtUnmapWidget(widget)	\
		XUnmapWindow(XtDisplay(widget), XtWindow(widget))
?!?!?! 

<P><PRE>&lt;* EXTERNAL XtAddCallback *&gt;
   PROCEDURE AddCallback (
     widget:                 Widget;
     callback_name:          ConstString;
     callback:               CallbackProc;
     closure:                Pointer 		:= NIL
);

&lt;* EXTERNAL XtRemoveCallback *&gt;
   PROCEDURE RemoveCallback (
     widget:                 Widget;
     callback_name:          ConstString;
     callback:               CallbackProc;
     closure:                Pointer 		:= NIL
);

&lt;* EXTERNAL XtAddCallbacks *&gt;
   PROCEDURE AddCallbacks (
     widget:                 Widget;
     callback_name:          ConstString;
     callbacks:              CallbackList 	
);

&lt;* EXTERNAL XtRemoveCallbacks *&gt;
   PROCEDURE RemoveCallbacks (
     widget:                 Widget;
     callback_name:          ConstString;
     callbacks:              CallbackList 	
);

&lt;* EXTERNAL XtRemoveAllCallbacks *&gt;
   PROCEDURE RemoveAllCallbacks (
     widget:                 Widget;
     callback_name:          ConstString 	
);

&lt;* EXTERNAL XtCallCallbacks *&gt;
   PROCEDURE CallCallbacks (
     widget:                 Widget;
     callback_name:          ConstString;
     call_data:              Pointer 		
);

&lt;* EXTERNAL XtCallCallbackList *&gt;
   PROCEDURE CallCallbackList (
     widget:                 Widget;
     callbacks:              CallbackList;
     call_data:              Pointer 		
);

&lt;* EXTERNAL XtHasCallbacks *&gt;
   PROCEDURE HasCallbacks (
     widget:                 Widget;
     callback_name:          ConstString 	
): CallbackStatus;
</PRE>***************************************************************
 *
 * Geometry Management
 *
 ***************************************************************

<P><PRE>&lt;* EXTERNAL XtMakeGeometryRequest *&gt;
   PROCEDURE MakeGeometryRequest (
     widget:                 Widget;
     request:                WidgetGeometryStar;
     reply_return:           WidgetGeometryStar	
): GeometryResult;

&lt;* EXTERNAL XtQueryGeometry *&gt;
   PROCEDURE QueryGeometry (
     widget:                 Widget;
     intended:               WidgetGeometryStar;
     reply_return:           WidgetGeometryStar	
): GeometryResult;

&lt;* EXTERNAL XtCreatePopupShell *&gt;
   PROCEDURE CreatePopupShell (
     name:                   ConstString;
     widgetClass:            WidgetClass;
     parent:                 Widget;
     args:                   ArgList		:= NIL;
     num_args:               Cardinal 		:= 0
): Widget;

&lt;* EXTERNAL XtVaCreatePopupShell *&gt;
   PROCEDURE VaCreatePopupShell (
     name:                   ConstString;
     widgetClass:            WidgetClass;
     parent:                 Widget;
</PRE><BLOCKQUOTE><EM>    ...   </EM></BLOCKQUOTE><PRE>
): Widget;

&lt;* EXTERNAL XtPopup *&gt;
   PROCEDURE Popup (
     widget:                 Widget;
     grab_kind:              GrabKind 		
);

&lt;* EXTERNAL XtPopupSpringLoaded *&gt;
   PROCEDURE PopupSpringLoaded (
     widget:                 Widget 		
);

&lt;* EXTERNAL XtCallbackNone *&gt;
   PROCEDURE CallbackNone (
     widget:                 Widget;
     closure:                Pointer		:= NIL;
     call_data:              Pointer 		:= NIL
);

&lt;* EXTERNAL XtCallbackNonexclusive *&gt;
   PROCEDURE CallbackNonexclusive (
     widget:                 Widget;
     closure:                Pointer		:= NIL;
     call_data:              Pointer 		:= NIL
);

&lt;* EXTERNAL XtCallbackExclusive *&gt;
   PROCEDURE CallbackExclusive (
     widget:                 Widget;
     closure:                Pointer		:= NIL;
     call_data:              Pointer 		:= NIL
);

&lt;* EXTERNAL XtPopdown *&gt;
   PROCEDURE Popdown (
     widget:                 Widget 		
);

&lt;* EXTERNAL XtCallbackPopdown *&gt;
   PROCEDURE CallbackPopdown (
     widget:                 Widget;
     closure:                Pointer		:= NIL;
     call_data:              Pointer 		:= NIL
);

&lt;* EXTERNAL XtMenuPopupAction *&gt;
   PROCEDURE MenuPopupAction (
     widget:                 Widget;
     event:                  XEventStar;
     params:                 StringStar;
     num_params:             CardinalStar		
);

&lt;* EXTERNAL XtCreateWidget *&gt;
   PROCEDURE CreateWidget (
     name:                   ConstString;
     widget_class:           WidgetClass;
     parent:                 Widget;
     args:                   ArgList		:= NIL;
     num_args:               Cardinal 		:= 0
): Widget;

&lt;* EXTERNAL XtCreateManagedWidget *&gt;
   PROCEDURE CreateManagedWidget (
     name:                   ConstString;
     widget_class:           WidgetClass;
     parent:                 Widget;
     args:                   ArgList		:= NIL;
     num_args:               Cardinal		:= 0
): Widget;

&lt;* EXTERNAL XtVaCreateWidget *&gt;
   PROCEDURE VaCreateWidget (
     name:                   ConstString;
     widget:                 WidgetClass;
     parent:                 Widget;
</PRE><BLOCKQUOTE><EM>    ...  </EM></BLOCKQUOTE><PRE>
): Widget;

&lt;* EXTERNAL XtVaCreateManagedWidget *&gt;
   PROCEDURE VaCreateManagedWidget (
     name:                   ConstString;
     widget_class:           WidgetClass;
     parent:                 Widget;
</PRE><BLOCKQUOTE><EM>    ...  </EM></BLOCKQUOTE><PRE>
): Widget;

&lt;* EXTERNAL XtCreateApplicationShell *&gt;
   PROCEDURE CreateApplicationShell (
     name:                   ConstString;
     widget_class:           WidgetClass;
     args:                   ArgList		:= NIL;
     num_args:               Cardinal 		:= 0
): Widget;

&lt;* EXTERNAL XtAppCreateShell *&gt;
   PROCEDURE AppCreateShell (
     name:                   ConstString;
     class:                  ConstString;
     widget_class:           WidgetClass;
     display:                DisplayStar;
     args:                   ArgList		:= NIL;
     num_args:               Cardinal 		:= 0
): Widget;

&lt;* EXTERNAL XtVaAppCreateShell *&gt;
   PROCEDURE VaAppCreateShell (
     name:                   ConstString;
     class:                  ConstString;
     widget_class:           WidgetClass;
     display:                DisplayStar;
</PRE><BLOCKQUOTE><EM>    ...  </EM></BLOCKQUOTE><PRE>
): Widget;
</PRE>***************************************************************
 *
 * Toolkit initialization
 *
 ***************************************************************

<P><PRE>&lt;* EXTERNAL XtToolkitInitialize *&gt;
   PROCEDURE ToolkitInitialize ();

&lt;* EXTERNAL XtDisplayInitialize *&gt;
   PROCEDURE DisplayInitialize (
     appContext:             AppContext;
     dpy:                    DisplayStar;
     name:                   ConstString;
     class:                  ConstString;
     options:                Xrm.OptionDescList;
     num_options:            Cardinal;
     VAR argc:               Cardinal;
     argv:                   Argv
);

&lt;* EXTERNAL XtAppInitialize *&gt;
   PROCEDURE AppInitialize (
     VAR app_context_return: AppContext;
     application_class:      ConstString;
     options:                Xrm.OptionDescList;
     num_options:            Cardinal;		
     VAR argc_in_out:        Cardinal;	
     argv_in_out:            Argv;		
     fallback_resources:     FallbackResList	:= NIL;
     args:                   ArgList		:= NIL;
     num_args:               Cardinal		:= 0
): Widget;

&lt;* EXTERNAL XtVaAppInitialize *&gt;
   PROCEDURE VaAppInitialize (
     VAR app_context_return: AppContext;
     application_class:      ConstString;
     options:                Xrm.OptionDescList;
     num_options:            Cardinal;
     VAR argc_in_out:        Cardinal;	
     argv_in_out:            Argv;
     fallback_resources:     ConstStringStar;
</PRE><BLOCKQUOTE><EM>    ...  </EM></BLOCKQUOTE><PRE>
): Widget;

&lt;* EXTERNAL XtInitialize *&gt;
   PROCEDURE Initialize (
     name:                   ConstString	:= NIL;
     class:                  ConstString	:= NIL;
     options:                Xrm.OptionDescList	:= NIL;
     num_options:            Cardinal		:= 0;
     VAR argc:               Cardinal;
     argv:                   Argv		:= NIL
): Widget;

&lt;* EXTERNAL XtOpenDisplay *&gt;
   PROCEDURE OpenDisplay (
     appContext:             AppContext;
     displayName:            ConstString	:= NIL;
     applName:               ConstString	:= NIL;
     className:              ConstString	:= NIL;
     urlist:                 Xrm.OptionDescList	:= NIL;
     num_urs:                Cardinal		:= 0;
     VAR argc:               Cardinal;
     argv:                   Argv		:= NIL
): DisplayStar;

&lt;* EXTERNAL XtCreateApplicationContext *&gt;
   PROCEDURE CreateApplicationContext (): AppContext;

&lt;* EXTERNAL XtAppSetFallbackResources *&gt;
   PROCEDURE AppSetFallbackResources (
     app_context:            AppContext;
     specification_list:     ConstStringStar 	
);

&lt;* EXTERNAL XtDestroyApplicationContext *&gt;
   PROCEDURE DestroyApplicationContext (
     appContext:             AppContext 	
);

&lt;* EXTERNAL XtInitializeWidgetClass *&gt;
   PROCEDURE InitializeWidgetClass (
     widget_class:           WidgetClass 	
);

&lt;* EXTERNAL XtWidgetToApplicationContext *&gt;
   PROCEDURE WidgetToApplicationContext (
     widget:                 Widget 		
): AppContext;

&lt;* EXTERNAL XtDisplayToApplicationContext *&gt;
   PROCEDURE DisplayToApplicationContext (
     dpy:                    DisplayStar		
): AppContext;

&lt;* EXTERNAL XtDatabase *&gt;
   PROCEDURE Database (
     dpy:                    DisplayStar		
): Xrm.Database;

&lt;* EXTERNAL XtCloseDisplay *&gt;
   PROCEDURE CloseDisplay (
     dpy:                    DisplayStar		
);

&lt;* EXTERNAL XtCopyFromParent *&gt;
   PROCEDURE CopyFromParent (
     widget:                 Widget;
     offset:                 Int;
     value:                  Xrm.ValueStar		
);

&lt;* EXTERNAL XtCopyDefaultDepth *&gt;
   PROCEDURE CopyDefaultDepth (
     widget:                 Widget;
     offset:                 Int;
     value:                  Xrm.ValueStar		
);

&lt;* EXTERNAL XtCopyDefaultColormap *&gt;
   PROCEDURE CopyDefaultColormap (
     widget:                 Widget;
     offset:                 Int;
     value:                  Xrm.ValueStar		
);

&lt;* EXTERNAL XtCopyAncestorSensitive *&gt;
   PROCEDURE CopyAncestorSensitive (
     widget:                 Widget;
     offset:                 Int;
     value:                  Xrm.ValueStar		
);

&lt;* EXTERNAL XtCopyScreen *&gt;
   PROCEDURE CopyScreen (
     widget:                 Widget;
     offset:                 Int;
     value:                  Xrm.ValueStar 		
);

&lt;* EXTERNAL XrmCompileResourceList *&gt;
   PROCEDURE mCompileResourceList (
     resources:              ResourceList;
     num_resources:          Cardinal 		
);

&lt;* EXTERNAL XtGetApplicationResources *&gt;
   PROCEDURE GetApplicationResources (
     widget:                 Widget;
     base:                   Pointer;
     resources:              ResourceList;
     num_resources:          Cardinal;
     args:                   ArgList		:= NIL;
     num_args:               Cardinal 		:= 0
);

&lt;* EXTERNAL XtVaGetApplicationResources *&gt;
   PROCEDURE VaGetApplicationResources (
     widget:                 Widget;
     base:                   Pointer;
     resources:              ResourceList;
     num_resources:          Cardinal;
</PRE><BLOCKQUOTE><EM>    ...  </EM></BLOCKQUOTE><PRE>
);

&lt;* EXTERNAL XtGetSubresources *&gt;
   PROCEDURE GetSubresources (
     widget:                 Widget;
     base:                   Pointer;
     name:                   ConstString;
     class:                  ConstString;
     resources:              ResourceList;
     num_resources:          Cardinal;
     args:                   ArgList		:= NIL;
     num_args:               Cardinal 		:= 0
);

&lt;* EXTERNAL XtVaGetSubresources *&gt;
   PROCEDURE VaGetSubresources (
     widget:                 Widget;
     base:                   Pointer;
     name:                   ConstString;
     class:                  ConstString;
     resources:              ResourceList;
     num_resources:          Cardinal;
</PRE><BLOCKQUOTE><EM>    ...  </EM></BLOCKQUOTE><PRE>
);

&lt;* EXTERNAL XtSetValues *&gt;
   PROCEDURE SetValues (
     widget:                 Widget;
     args:                   ArgList		:= NIL;
     num_args:               Cardinal 		:= 0
);

&lt;* EXTERNAL XtVaSetValues *&gt;
   PROCEDURE VaSetValues (
     widget:                 Widget;
</PRE><BLOCKQUOTE><EM>    ...  </EM></BLOCKQUOTE><PRE>
);

&lt;* EXTERNAL XtGetValues *&gt;
   PROCEDURE GetValues (
     widget:                 Widget;
     args:                   ArgList		:= NIL;
     num_args:               Cardinal 		:= 0
);

&lt;* EXTERNAL XtVaGetValues *&gt;
   PROCEDURE VaGetValues (
     widget:                 Widget;
</PRE><BLOCKQUOTE><EM>    ...  </EM></BLOCKQUOTE><PRE>
);

&lt;* EXTERNAL XtSetSubvalues *&gt;
   PROCEDURE SetSubvalues (
     base:                   Pointer;
     resources:              ResourceList;
     num_resources:          Cardinal;
     args:                   ArgList		:= NIL;
     num_args:               Cardinal 		:= 0
);

&lt;* EXTERNAL XtVaSetSubvalues *&gt;
   PROCEDURE VaSetSubvalues (
     base:                   Pointer;
     resources:              ResourceList;
     num_resources:          Cardinal;
</PRE><BLOCKQUOTE><EM>    ...  </EM></BLOCKQUOTE><PRE>
);

&lt;* EXTERNAL XtGetSubvalues *&gt;
   PROCEDURE GetSubvalues (
     base:                   Pointer;
     resources:              ResourceList;
     num_resources:          Cardinal;
     args:                   ArgList		:= NIL;
     num_args:               Cardinal 		:= 0
);

&lt;* EXTERNAL XtVaGetSubvalues *&gt;
   PROCEDURE VaGetSubvalues (
     base:                   Pointer;
     resources:              ResourceList;
     num_resources:          Cardinal;
</PRE><BLOCKQUOTE><EM>    ...  </EM></BLOCKQUOTE><PRE>
);

&lt;* EXTERNAL XtGetResourceList *&gt;
   PROCEDURE GetResourceList (
     widget_class:           WidgetClass;
     resources_return:       ResourceList;
     num_resources_return:   CardinalStar		
);

&lt;* EXTERNAL XtGetConstraintResourceList *&gt;
   PROCEDURE GetConstraintResourceList (
     widget_class:           WidgetClass;
     resources_return:       ResourceList;
     num_resources_return:   CardinalStar		
);
</PRE> ?!?!?!
#define XtUnspecifiedPixmap	((Pixmap)2)
#define XtUnspecifiedShellInt	(-1)
#define XtUnspecifiedWindow	((Window)2)
#define XtUnspecifiedWindowGroup ((Window)3)
#define XtDefaultForeground	<CODE>XtDefaultForeground</CODE>
#define XtDefaultBackground	<CODE>XtDefaultBackground</CODE>
#define XtDefaultFont		<CODE>XtDefaultFont</CODE>
#define XtOffset(p_type,field) \
	((Cardinal) (((char * ) (&amp;(((p_type)NULL)-&gt;field))) - ((char * ) NULL)))
#define XtOffsetOf(s_type,field) XtOffset(s_type*,field)
?!?!?! 

<P>************************************************************
 *
 * Error Handling
 *
 ***********************************************************

<P><PRE>&lt;* EXTERNAL XtAppSetErrorMsgHandler *&gt;
   PROCEDURE AppSetErrorMsgHandler (
     app:                    AppContext;
     handler:                ErrorMsgHandler 	
): ErrorMsgHandler;

&lt;* EXTERNAL XtSetErrorMsgHandler *&gt;
   PROCEDURE SetErrorMsgHandler (
     handler:                ErrorMsgHandler 	
);

&lt;* EXTERNAL XtAppSetWarningMsgHandler *&gt;
   PROCEDURE AppSetWarningMsgHandler (
     app:                    AppContext;
     handler:                ErrorMsgHandler 	
): ErrorMsgHandler;

&lt;* EXTERNAL XtSetWarningMsgHandler *&gt;
   PROCEDURE SetWarningMsgHandler (
     handler:                ErrorMsgHandler 	
);

&lt;* EXTERNAL XtAppErrorMsg *&gt;
   PROCEDURE AppErrorMsg (
     app:                    AppContext;
     name:                   ConstString;
     type:                   ConstString;
     class:                  ConstString;
     defaultp:               ConstString;
     params:                 StringStar;
     num_params:             CardinalStar		
);

&lt;* EXTERNAL XtErrorMsg *&gt;
   PROCEDURE ErrorMsg (
     name:                   ConstString;
     type:                   ConstString;
     class:                  ConstString;
     defaultp:               ConstString;
     params:                 StringStar;
     num_params:             CardinalStar		
);

&lt;* EXTERNAL XtAppWarningMsg *&gt;
   PROCEDURE AppWarningMsg (
     app:                    AppContext;
     name:                   ConstString;
     type:                   ConstString;
     class:                  ConstString;
     defaultp:               ConstString;
     params:                 StringStar;
     num_params:             CardinalStar		
);

&lt;* EXTERNAL XtWarningMsg *&gt;
   PROCEDURE WarningMsg (
     name:                   ConstString;
     type:                   ConstString;
     class:                  ConstString;
     defaultp:               ConstString;
     params:                 StringStar;
     num_params:             CardinalStar		
);

&lt;* EXTERNAL XtAppSetErrorHandler *&gt;
   PROCEDURE AppSetErrorHandler (
     app:                    AppContext;
     handler:                ErrorHandler 	
): ErrorHandler;

&lt;* EXTERNAL XtSetErrorHandler *&gt;
   PROCEDURE SetErrorHandler (
     handler:                ErrorHandler 	
);

&lt;* EXTERNAL XtAppSetWarningHandler *&gt;
   PROCEDURE AppSetWarningHandler (
     app:                    AppContext;
     handler:                ErrorHandler 	
): ErrorHandler;

&lt;* EXTERNAL XtSetWarningHandler *&gt;
   PROCEDURE SetWarningHandler (
     handler:                ErrorHandler 	
);

&lt;* EXTERNAL XtAppError *&gt;
   PROCEDURE AppError (
     app:                    AppContext;
     message:                ConstString	
);

&lt;* EXTERNAL XtError *&gt;
   PROCEDURE Error (
     message:                ConstString	
);

&lt;* EXTERNAL XtAppWarning *&gt;
   PROCEDURE AppWarning (
     app:                    AppContext;
     message:                ConstString	
);

&lt;* EXTERNAL XtWarning *&gt;
   PROCEDURE Warning (
     message:                ConstString	
);

&lt;* EXTERNAL XtAppGetErrorDatabase *&gt;
   PROCEDURE AppGetErrorDatabase (
     app:                    AppContext 	
): Xrm.DatabaseStar;

&lt;* EXTERNAL XtGetErrorDatabase *&gt;
   PROCEDURE GetErrorDatabase (): Xrm.DatabaseStar;

&lt;* EXTERNAL XtAppGetErrorDatabaseText *&gt;
   PROCEDURE AppGetErrorDatabaseText (
     app:                    AppContext;
     name:                   ConstString;
     type:                   ConstString;
     class:                  ConstString;
     defaultp:               ConstString;
     buffer:                 String;
     nbytes:                 Int;
     database:               Xrm.Database 	
);

&lt;* EXTERNAL XtGetErrorDatabaseText *&gt;
   PROCEDURE GetErrorDatabaseText (
     name:                   ConstString;
     type:                   ConstString;
     class:                  ConstString;
     defaultp:               ConstString;
     buffer:                 String;
     nbytes:                 Int 		
);
</PRE>***************************************************************
 *
 * Memory Management
 *
 ***************************************************************

<P> ?!?!?!
#define XtNew(type) ((type * ) XtMalloc((unsigned) sizeof(type)))
#define XtNewString(str) \
    ((str) == NULL ? NULL : (strcpy(XtMalloc((unsigned)strlen(str) + 1), str)))
?!?!?! 

<P><PRE>&lt;* EXTERNAL XtMalloc *&gt;
   PROCEDURE Malloc (
     size:                   Cardinal 		
): char_star;

&lt;* EXTERNAL XtCalloc *&gt;
   PROCEDURE Calloc (
     num:                    Cardinal;
     size:                   Cardinal 		
): char_star;

&lt;* EXTERNAL XtRealloc *&gt;
   PROCEDURE Realloc (
     ptr:                    char_star;
     num:                    Cardinal 		
): char_star;

&lt;* EXTERNAL XtFree *&gt;
   PROCEDURE Free (
     ptr:                    char_star		
);
</PRE>************************************************************
 *
 *  Work procs
 *
 *************************************************************

<P><PRE>&lt;* EXTERNAL XtAddWorkProc *&gt;
   PROCEDURE AddWorkProc (
     proc:                   WorkProc;
     closure:                Pointer 		
): WorkProcId;

&lt;* EXTERNAL XtAppAddWorkProc *&gt;
   PROCEDURE AppAddWorkProc (
     app:                    AppContext;
     proc:                   WorkProc;
     closure:                Pointer 		
): WorkProcId;

&lt;* EXTERNAL  XtRemoveWorkProc *&gt;
   PROCEDURE tRemoveWorkProc (
     id:                     WorkProcId 	
);
</PRE>***************************************************************
 *
 * Graphic Context Management
 *
 ****************************************************************

<P><PRE>&lt;* EXTERNAL XtGetGC *&gt;
   PROCEDURE GetGC (
     widget:                 Widget;
     valueMask:              GCMask;
     values:                 XGCValuesStar 		
): GC;

&lt;* EXTERNAL XtDestroyGC *&gt;
   PROCEDURE DestroyGC (
     gc:                     GC 			
);

&lt;* EXTERNAL XtReleaseGC *&gt;
   PROCEDURE ReleaseGC (
     object:                 Widget;
     gc:                     GC 			
);

&lt;* EXTERNAL XtReleaseCacheRef *&gt;
   PROCEDURE ReleaseCacheRef (
     cache_ref:              CacheRefStar		
);

&lt;* EXTERNAL XtCallbackReleaseCacheRef *&gt;
   PROCEDURE CallbackReleaseCacheRef (
     widget:                 Widget;
     closure:                Pointer;	(* CacheRef *)
     call_data:              Pointer 		
);

&lt;* EXTERNAL XtCallbackReleaseCacheRefList *&gt;
   PROCEDURE CallbackReleaseCacheRefList (
     widget:                 Widget;
     closure:                Pointer;	(* CacheRefStar *)
     call_data:              Pointer 		
);

&lt;* EXTERNAL XtSetWMColormapWindows *&gt;
   PROCEDURE SetWMColormapWindows (
     widget:                 Widget;
     list:                   WidgetStar;
     count:                  Cardinal		
);

&lt;* EXTERNAL XtFindFile *&gt;
   PROCEDURE FindFile (
     path:                   ConstString;
     substitutions:          SubstitutionStar;
     num_substitutions:      Cardinal;
     predicate:              FilePredicate	
): String;

&lt;* EXTERNAL XtResolvePathname *&gt;
   PROCEDURE ResolvePathname (
     dpy:                    DisplayStar;
     type:                   ConstString;
     filename:               ConstString;
     suffix:                 ConstString;
     path:                   ConstString;
     predicate:              FilePredicate 	
): String;
</PRE>***************************************************************
 *
 * Selections
 *
 ****************************************************************

<P> !!!! ?!?!?! based value too large: an unsigned integer cannot
be negative.
CONST
  XT_CONVERT_FAIL: Atom   = 16_80000001;


<P>
 * The given widget no longer wants the selection.  If it still owns it, then
 * the selection owner is cleared, and the window's losesSelection is called.
 

<P><PRE>&lt;* EXTERNAL XtDisownSelection *&gt;
   PROCEDURE DisownSelection (
     widget:                 Widget;
     selection:              Atom;
     time:                   Time 		
);
</PRE><P>
 * Get the value of the given selection.  
 

<P><PRE>&lt;* EXTERNAL XtGetSelectionValue *&gt;
   PROCEDURE GetSelectionValue (
     widget:                 Widget;
     selection:              Atom;
     target:                 Atom;
     callback:               SelectionCallbackProc;
     closure:                Pointer;
     time:                   Time 		
);

&lt;* EXTERNAL XtGetSelectionValues *&gt;
   PROCEDURE GetSelectionValues (
     widget:                 Widget;
     selection:              Atom;
     targets:                AtomStar;
     count:                  Int;
     callback:               SelectionCallbackProc;
     closures:               PointerStar;
     time:                   Time 		
);
</PRE> Set the selection timeout value, in units of milliseconds 

<P><PRE>&lt;* EXTERNAL XtAppSetSelectionTimeout *&gt;
   PROCEDURE AppSetSelectionTimeout (
     app:                    AppContext;
     timeout:                unsigned_long 	
);

&lt;* EXTERNAL XtSetSelectionTimeout *&gt;
   PROCEDURE SetSelectionTimeout (
     timeout:                unsigned_long 	
);

 (* Return the selection timeout value, in units of milliseconds *)

&lt;* EXTERNAL XtAppGetSelectionTimeout *&gt;
   PROCEDURE AppGetSelectionTimeout(
     app:                    AppContext 	
): unsigned_int;

&lt;* EXTERNAL XtGetSelectionTimeout *&gt;
   PROCEDURE GetSelectionTimeout(): unsigned_int;

&lt;* EXTERNAL XtGetSelectionRequest *&gt;
   PROCEDURE GetSelectionRequest (
     widget:                 Widget;
     selection:              Atom;
     request_id:             RequestId 	
): XSelectionRequestEventStar;

&lt;* EXTERNAL XtGetSelectionValueIncremental *&gt;
   PROCEDURE GetSelectionValueIncremental (
     widget:                 Widget;
     selection:              Atom;
     target:                 Atom;
     selection_callback:     SelectionCallbackProc;
     client_data:            Pointer;
     time:                   Time 		
);

&lt;* EXTERNAL XtGetSelectionValuesIncremental *&gt;
   PROCEDURE GetSelectionValuesIncremental (
     widget:                 Widget;
     selection:              Atom;
     targets:                AtomStar;
     count:                  Int;
     callback:               SelectionCallbackProc;
     client_data:            PointerStar;
     time:                   Time 		
);

&lt;* EXTERNAL XtGrabKey *&gt;
   PROCEDURE GrabKey (
     widget:                 Widget;
     keysym:                 KeySym;
     modifiers:              Modifiers;
     owner_events:           Boolean;
     pointer_mode:           Int;
     keyboard_mode:          Int 		
);

&lt;* EXTERNAL XtUngrabKey *&gt;
   PROCEDURE UngrabKey (
     widget:                 Widget;
     keysym:                 KeySym;
     modifiers:              Modifiers	 	
);

&lt;* EXTERNAL XtGrabKeyboard *&gt;
   PROCEDURE GrabKeyboard (
     widget:                 Widget;
     owner_events:           Boolean;
     pointer_mode:           Int;
     keyboard_mode:          Int;
     time:                   Time 		
): Int;

&lt;* EXTERNAL XtUngrabKeyboard *&gt;
   PROCEDURE UngrabKeyboard (
     widget:                 Widget;
     time:                   Time 		
);

&lt;* EXTERNAL XtGrabButton *&gt;
   PROCEDURE GrabButton (
     widget:                 Widget;
     button:                 Int;
     modifiers:              Modifiers;
     owner_events:           Boolean;
     event_mask:             unsigned_int;
     pointer_mode:           Int;
     keyboard_mode:          Int;
     confine_to:             Window;
     cursor:                 Cursor 		
);

&lt;* EXTERNAL XtUngrabButton *&gt;
   PROCEDURE UngrabButton (
     widget:                 Widget;
     button:                 unsigned_int;
     modifiers:              Modifiers	 	
);

&lt;* EXTERNAL XtGrabPointer *&gt;
   PROCEDURE GrabPointer (
     widget:                 Widget;
     owner_events:           Boolean;
     event_mask:             unsigned_int;
     pointer_mode:           Int;
     keyboard_mode:          Int;
     confine_to:             Window;
     cursor:                 Cursor;
     time:                   Time 		
): Int;

&lt;* EXTERNAL XtUngrabPointer *&gt;
   PROCEDURE UngrabPointer (
     widget:                 Widget;
     time:                   Time 		
);

&lt;* EXTERNAL XtGetApplicationNameAndClass *&gt;
   PROCEDURE GetApplicationNameAndClass (
     dpy:                    DisplayStar;
     name_return:            StringStar;
     class_return:           StringStar		
);
</PRE>===================================================================
 * $XConsortium: Composite.h,v 1.10 89/12/12 20:08:44 swick Exp $ *
 * $oHeader: Composite.h,v 1.2 asente Exp $ *
 ====================================================================

<P><PRE>&lt;* EXTERNAL XtManageChildren *&gt;
   PROCEDURE ManageChildren (children: WidgetList; num_children: Cardinal);

&lt;* EXTERNAL XtManageChild *&gt;
   PROCEDURE ManageChild (child: Widget);

&lt;* EXTERNAL XtUnmanageChildren *&gt;
   PROCEDURE UnmanageChildren (children: WidgetList; num_children: Cardinal);

&lt;* EXTERNAL XtUnmanageChild *&gt;
   PROCEDURE UnmanageChild (child: Widget);
</PRE> =====================================================
	The Geometry.h file IS NOT PROVIDED in X11R4 !!!
   ===================================================== 

<P><PRE>&lt;* EXTERNAL XtMakeresizeRequest *&gt;
   PROCEDURE MakeresizeRequest (
     widget:                Widget;
     width, height:         Dimension;
     replyWidth, replyHeight:  ADDRESS
): GeometryResult;

&lt;* EXTERNAL XtResizeWindow *&gt;
   PROCEDURE ResizeWindow (
     widget:                Widget
);

&lt;* EXTERNAL XtResizeWidget *&gt;
   PROCEDURE ResizeWidget (
     widget:                Widget;
     height, width, borderWidth: Dimension
);

&lt;* EXTERNAL XtConfigureWidget *&gt;
   PROCEDURE ConfigureWidget (
     widget:                Widget;
     x, y:                  Position;
     height, width, borderWidth: Dimension
);

&lt;* EXTERNAL XtMoveWidget *&gt;
   PROCEDURE MoveWidget (
     widget:                Widget;
     x, y:                  Position
);

&lt;* EXTERNAL XtTranslateCoords *&gt;
   PROCEDURE TranslateCoords (
     widget:                Widget;
     x, y:                  Position;
     rootx, rooty:          PositionStar
);

END Xt.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface XMachine is in:
</A><UL>
<LI><A HREF="../ALPHA_OSF/XMachine.i3#0TOP0">X11R4/src/ALPHA_OSF/XMachine.i3</A>
<LI><A HREF="../Vanilla/XMachine.i3#0TOP0">X11R4/src/Vanilla/XMachine.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
