<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/AmbientLightGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/AmbientLightGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Wed Feb  9 14:33:47 PST 1994 by najork                   

<P>
<P><PRE>UNSAFE MODULE <module>AmbientLightGO</module> EXPORTS <A HREF="AmbientLightGO.i3"><implements>AmbientLightGO</A></implements>, <A HREF="AmbientLightGOProxy.i3"><implements>AmbientLightGOProxy</A></implements>;

IMPORT <A HREF="AuxG.i3">AuxG</A>, <A HREF="BooleanPropPrivate.i3">BooleanPropPrivate</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="ColorPropPrivate.i3">ColorPropPrivate</A>, <A HREF="GO.i3">GO</A>, <A HREF="GOPrivate.i3">GOPrivate</A>,
       <A HREF="GraphicsState.i3">GraphicsState</A>, <A HREF="GraphicsStatePex.i3">GraphicsStatePex</A>, <A HREF="LightGO.i3">LightGO</A>, <A HREF="../../PEX/src/PEX.i3">PEX</A>, <A HREF="Prop.i3">Prop</A>;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (c : Color.T) : T =
  VAR
    light := NEW (T).init ();
  BEGIN
    LightGO.SetColour (light, c);
    LightGO.SetSwitch (light, TRUE);
    RETURN light;
  END New;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
  OVERRIDES
    init              := Init;
    draw              := Draw;
    damageIfDependent := DamageIfDependent;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T) : T =
  BEGIN
    EVAL GO.T.init (self);

    IF MkProxyT # NIL AND self.proxy = NIL THEN
      MkProxyT (self);
    END;

    RETURN self;
  END Init;

PROCEDURE <A NAME="DamageIfDependent"><procedure>DamageIfDependent</procedure></A> (self : T; pn : Prop.Name) =
  BEGIN
    IF pn = LightGO.Switch OR pn = LightGO.Colour THEN
      self.damaged := TRUE;
    END;
  END DamageIfDependent;

PROCEDURE <A NAME="Draw"><procedure>Draw</procedure></A> (self : T; state : GraphicsState.T) =
  VAR
    color : Color.T;
    light : PEX.pxlLightEntry;
  BEGIN
    state.push (self);

    (* Get the current light status from the state. If the switch is off,
       we don't need to do anything *)
    IF LightGO.Switch.getState (state) THEN

      (* Get the current light color from the state *)
      color := LightGO.Colour.getState (state);

      (* Build a PEX light structure *)
      light.lightType := PEX.PEXLightAmbient;
      light.lightColour := AuxG.MkRgbFloatColour (color);

      (* Add the light to the graphics state's light set *)
      state.addLight (light);
    END;

    self.damaged := FALSE;
    state.pop (self);
  END Draw;

BEGIN
END AmbientLightGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
