<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/Anim3D.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/Anim3D.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sat May 21 17:41:56 PDT 1994 by najork                   

<P>
<P> This interface provides access to the ``animation clock'', the clock that
   is used to drive animations. Clients can inquire the current time, and can 
   change the clock that is used. The default animation clock is a real-time
   clock; one particular alternative is <CODE>ZeusClock.T</CODE>, a clock that is 
   controlled by the Zeus algorithm animation system. 

<P><PRE>INTERFACE <interface><A HREF="Anim3D.m3">Anim3D</A></interface>;

IMPORT <A HREF="Clock.i3">Clock</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

PROCEDURE <A HREF="Anim3D.m3#Now">Now</A> () : LONGREAL;
</PRE><BLOCKQUOTE><EM> Return the current value of the animation clock. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Anim3D.m3#ChangeClock">ChangeClock</A> (clock : Clock.T);
</PRE><BLOCKQUOTE><EM> Let <CODE>clock</CODE> be the new animation clock. This procedure should not be 
   called while an animation is in progress; terrible things might happen. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Anim3D.m3#SetErrorWr">SetErrorWr</A> (wr : Wr.T);
</PRE><BLOCKQUOTE><EM> Set the writer to which animation server error messages will be written to
   be <CODE>wr</CODE>. By default, error messages are written to <CODE>Stdio.stderr</CODE>. </EM></BLOCKQUOTE><PRE>

VAR lock : MUTEX;
</PRE><BLOCKQUOTE><EM> A client that wants to prevent the animation server from rendering an 
   inconsistent scene should protect the critical section during which 
   the scene is inconsistent by acquiring <CODE>lock</CODE>. Not acquiring <CODE>lock</CODE> 
   will never crash a program. <CODE>lock</CODE> may not be held when <CODE>ah.animate()</CODE>
   is called for some animation handle <CODE>ah</CODE>. </EM></BLOCKQUOTE><PRE>

END Anim3D.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
