<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/AnimHandle.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/AnimHandle.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Mon Feb 21 15:29:33 PST 1994 by najork                   

<P>
<P> The 3D animation library supports two kinds of animations: synchronous
   and asynchronous ones. 
<P>
   An asynchronous animation is performed by attaching an {\em unsynchronized
   time-variant property value} <CODE>pv</CODE> to a geometric object <CODE>go</CODE>. Attaching 
   <CODE>pv</CODE> to <CODE>go</CODE> immediately starts to animate <CODE>go</CODE> in some fashion, the 
   animation ends once <CODE>pv</CODE> is again detached. 
   <P>
   A synchronous animation, on the other hand, is performed by attaching a
   {\em synchronized time-variant property value} <CODE>pv</CODE> to a geometric object
   <CODE>go</CODE>, and then issuing an animation request to <CODE>pv</CODE>. Associated with each 
   synchronous property value is an <CODE>AnimHandle.T</CODE>. However, <CODE>pv</CODE> will not 
   immediately start to change. 
<P>
   The message <CODE>ah.animate()</CODE> will start to animate all time-varying property 
   values tied to <CODE>ah</CODE>. The call to <CODE>ah.animate()</CODE> will return only after 
   these animations are completed. 
<P>
   Animation handles are monitored: only one thread can call <CODE>animate</CODE> at any
   given time, and no thread can insert requests into the request queue of a 
   synchronous property value while <CODE>animate</CODE> is in progress.


<P><PRE>INTERFACE <interface><A HREF="AnimHandle.m3">AnimHandle</A></interface>;

IMPORT <A HREF="ProxiedObj.i3">ProxiedObj</A>;

TYPE
  <A HREF="AnimHandle.m3#T">T</A> &lt;: Public;
  Public = ProxiedObj.T OBJECT
  METHODS
    init () : T;
    animate ();
  END;
</PRE><BLOCKQUOTE><EM> <CODE>ah.init()</CODE> initializes a new animation handle <CODE>ah</CODE> and returns it. 
   <CODE>ah.animate()</CODE> triggers the animation of all synchronous property values
   that are tied to <CODE>ah</CODE>. It returns when the animation is completed. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="AnimHandle.m3#New">New</A> () : T;
</PRE><BLOCKQUOTE><EM> <CODE>New</CODE> is a convenience procedure. The expression <CODE>New()</CODE> is equivalent 
   to <CODE>NEW(T).init()</CODE> </EM></BLOCKQUOTE><PRE>

END AnimHandle.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
