<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/AnimHandle.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/AnimHandle.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Mon Feb 21 15:34:26 PST 1994 by najork                   

<P>
<P><PRE>MODULE <module>AnimHandle</module> EXPORTS <A HREF="AnimHandle.i3"><implements>AnimHandle</A></implements>, <A HREF="AnimHandlePrivate.i3"><implements>AnimHandlePrivate</A></implements>, <A HREF="AnimHandleProxy.i3"><implements>AnimHandleProxy</A></implements>;

IMPORT <A HREF="Anim3D.i3">Anim3D</A>, <A HREF="AnimRequestQueue.i3">AnimRequestQueue</A>, <A HREF="AnimServer.i3">AnimServer</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

REVEAL
  <A NAME="T">T</A> = Private BRANDED OBJECT
    list : List;
  OVERRIDES
    init    := Init;
    attach  := Attach;
    animate := Animate;
  END;

TYPE
  List = REF RECORD
    head : AnimRequestQueue.T;
    tail : List;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T) : T =
  BEGIN
    self.mu := NEW (MUTEX);
    self.cv := NEW (Thread.Condition);
    self.list := NIL;
    self.activated := FALSE;

    IF MkProxyT # NIL THEN
      MkProxyT (self);
    END;

    RETURN self;
  END Init;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> () : T =
  BEGIN
    RETURN NEW (T).init ();
  END New;

PROCEDURE <A NAME="Attach"><procedure>Attach</procedure></A> (self : T; q : AnimRequestQueue.T) =

  PROCEDURE AddIfNew (VAR list : List) =
    BEGIN
      IF list = NIL THEN
        list := NEW (List, head := q, tail := list);
      ELSIF list.head # q THEN
        AddIfNew (list.tail);
      END;
    END AddIfNew;

  BEGIN
    AddIfNew (self.list);
  END Attach;

PROCEDURE <A NAME="Animate"><procedure>Animate</procedure></A> (self : T) =
  VAR
    max := 0.0;
    tmp : List;
  BEGIN
    LOCK self.mu DO
      tmp := self.list;
      self.activated := TRUE;
      self.starttime := Anim3D.Now ();
      WHILE tmp # NIL DO
        max := MAX (max, tmp.head.duration ());
        tmp := tmp.tail;
      END;
      self.endtime := self.starttime + FLOAT (max, LONGREAL);

      AnimServer.PauseAnimHandle (self);

      self.activated := FALSE;

      (* Flush all the animation request queues attached
         to the animation handle. *)
      tmp := self.list;
      WHILE tmp # NIL DO
        tmp.head.flush ();
        tmp := tmp.tail;
      END;
    END;
  END Animate;

BEGIN
END AnimHandle.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
