<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/AnimRequestQueue.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/AnimRequestQueue.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P><PRE>MODULE <module>AnimRequestQueue</module> EXPORTS <A HREF="AnimRequestQueue.i3"><implements>AnimRequestQueue</A></implements>, <A HREF="AnimRequestQueuePrivate.i3"><implements>AnimRequestQueuePrivate</A></implements>;

IMPORT <A HREF="AnimHandle.i3">AnimHandle</A>, <A HREF="AnimHandlePrivate.i3">AnimHandlePrivate</A>, <A HREF="Prop.i3">Prop</A>;

REVEAL
  <A NAME="T">T</A> = Private BRANDED OBJECT
  OVERRIDES
    init     := Init;
    insert   := Insert;
    duration := Duration;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T; ah : AnimHandle.T) : T =
  BEGIN
    self.list := NIL;
    self.ah := ah;
    ah.attach (self);
    RETURN self;
  END Init;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A> (self : T; req : Prop.Request) RAISES {Prop.BadInterval} =

  PROCEDURE InsertIntoList (VAR l : List) RAISES {Prop.BadInterval} =
    BEGIN
      IF l = NIL THEN
        l := NEW (List, req := req, next := NIL);
      ELSIF Before (req.start, req.dur, l.req.start, l.req.dur) THEN
        l := NEW (List, req := req, next := l);
      ELSE
        InsertIntoList (l.next);
      END;
    END InsertIntoList;

  BEGIN
    LOCK self.ah.mu DO
      InsertIntoList (self.list);
    END;
  END Insert;
</PRE> Returns TRUE if interval1 is before interval2, 
           FALSE if interval1 is after interval2,
   raises Prop.BadInterval if they overlap. 
<PRE>PROCEDURE <A NAME="Before"><procedure>Before</procedure></A> (start1, dur1, start2, dur2 : REAL) : BOOLEAN
    RAISES {Prop.BadInterval} =
  BEGIN
    IF dur1 = 0.0 AND dur2 = 0.0 THEN
      IF    start1 &lt; start2 THEN
        RETURN TRUE;
      ELSIF start1 &gt; start2 THEN
        RETURN FALSE;
      ELSE
        RAISE Prop.BadInterval;
      END;
    ELSE
      IF start1 + dur1 &lt;= start2 THEN
        RETURN TRUE;
      ELSIF start2 + dur2 &lt;= start1 THEN
        RETURN FALSE;
      ELSE
        RAISE Prop.BadInterval;
      END;
    END;
  END Before;

PROCEDURE <A NAME="Duration"><procedure>Duration</procedure></A> (self : T) : REAL =
  VAR
    l   : List;
    max := 0.0;
  BEGIN
    l := self.list;
    WHILE l # NIL DO
      max := MAX (max, l.req.start + l.req.dur);
      l := l.next;
    END;
    RETURN max;
  END Duration;

BEGIN
END AnimRequestQueue.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
