<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/AnimServer.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/AnimServer.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Tue May 24 11:27:39 PDT 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="AnimServer.i3">AnimServer</A></implements></module>;

IMPORT <A HREF="Anim3D.i3">Anim3D</A>, <A HREF="AnimHandle.i3">AnimHandle</A>, <A HREF="AnimHandlePrivate.i3">AnimHandlePrivate</A>, <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="GOPrivate.i3">GOPrivate</A>,
       <A HREF="GraphicsBasePrivate.i3">GraphicsBasePrivate</A>, <A HREF="../../ui/src/split/HVSplit.i3">HVSplit</A>, <A HREF="../../parseparams/src/ParseParams.i3">ParseParams</A>, <A HREF="RootGO.i3">RootGO</A>, <A HREF="RootGOPrivate.i3">RootGOPrivate</A>,
       <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A>, <A HREF="../../ui/src/split/TextVBT.i3">TextVBT</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../time/src/Common/Time.i3">Time</A>, <A HREF="../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../ui/src/vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

TYPE
  Closure = Thread.Closure BRANDED OBJECT
  OVERRIDES
    apply := Apply;
  END;

  RootList = REF RECORD
    head : RootGO.T;
    tail : RootList;
  END;

  HandleList = REF RECORD
    head : AnimHandle.T;
    tail : HandleList;
  END;

VAR
  roots   : RootList   := NIL;
  handles : HandleList := NIL;
  handles_lock         := NEW (MUTEX);
</PRE> <CODE>Apply</CODE> is the main procedure of the animation server thread. 
   This thread terminates only when the program terminates. 
<PRE>PROCEDURE <A NAME="Apply"><procedure>Apply</procedure></A> (&lt;* UNUSED *&gt; self : Closure) : REFANY =

  PROCEDURE SignalExpiredHandles (VAR handles : HandleList; now : LONGREAL) =
    BEGIN
      IF handles # NIL THEN
        WITH ah = handles.head DO
          IF ah.endtime &lt;= now THEN
            Thread.Signal (ah.cv);
            handles := handles.tail;
            SignalExpiredHandles (handles, now);
          ELSE
            SignalExpiredHandles (handles.tail, now);
          END;
        END;
      END;
    END SignalExpiredHandles;

  VAR
    now      : LONGREAL;
    damaged  : BOOLEAN;
    tmpRoots : RootList;
    timer    : Timer := NEW (Timer).init();
  BEGIN
    LOOP
      now := Anim3D.Now ();

      tmpRoots := roots;
      WHILE tmpRoots # NIL DO
        tmpRoots.head.base.processEvents ();
        tmpRoots := tmpRoots.tail;
      END;

      LOCK externalLock DO
        LOCK internalLock DO

          tmpRoots := roots;
          WHILE tmpRoots # NIL DO
            WITH root = tmpRoots.head DO
              IF root.base.status = GraphicsBasePrivate.Status.Destroyed THEN
                root.base.unmap ();
                RemoveRootGO (root);
              END;
            END;
            tmpRoots := tmpRoots.tail;
          END;

          tmpRoots := roots;
          WHILE tmpRoots # NIL DO
            tmpRoots.head.adjust (now);
            tmpRoots := tmpRoots.tail;
          END;

          tmpRoots := roots;
          damaged := FALSE;
          WHILE tmpRoots # NIL DO
            tmpRoots.head.base.repair (damaged);
            tmpRoots := tmpRoots.tail;
          END;

        END;
      END;

      LOCK handles_lock DO
        SignalExpiredHandles (handles, now);
      END;

      IF NOT damaged THEN
        Thread.Pause (0.1d0);
      END;

      IF timer.active THEN
        timer.click();
      END;
    END; (* This is an endless-loop! *)
  END Apply;

PROCEDURE <A NAME="RegisterRootGO"><procedure>RegisterRootGO</procedure></A> (root : RootGO.T) =
  BEGIN
    (*** Must be protected from interference with the animation server ***)
    LOCK internalLock DO
      roots := NEW (RootList, head := root, tail := roots);
    END;
  END RegisterRootGO;

PROCEDURE <A NAME="RemoveRootGO"><procedure>RemoveRootGO</procedure></A> (root : RootGO.T) =

  PROCEDURE RecursiveRemove (root : RootGO.T; VAR list : RootList) =
    BEGIN
      &lt;* ASSERT list # NIL *&gt;
      IF list.head = root THEN
        list := list.tail;
      ELSE
        RecursiveRemove (root, list.tail);
      END;
    END RecursiveRemove;

  BEGIN
    (*** Must be protected from interference with the animation server ***)
    RecursiveRemove (root, roots);
  END RemoveRootGO;

PROCEDURE <A NAME="PauseAnimHandle"><procedure>PauseAnimHandle</procedure></A> (ah : AnimHandle.T) =
  BEGIN
    LOCK handles_lock DO
      handles := NEW (HandleList, head := ah, tail := handles);
      Thread.Wait (handles_lock, ah.cv);
    END;
  END PauseAnimHandle;

PROCEDURE <A NAME="SetErrorWr"><procedure>SetErrorWr</procedure></A> (wr : Wr.T) =
  BEGIN
    animerr := wr;
  END SetErrorWr;

PROCEDURE <A NAME="ReportError"><procedure>ReportError</procedure></A> (msg : TEXT) =
  &lt;* FATAL Wr.Failure, Thread.Alerted *&gt;
  BEGIN
    Wr.PutText (animerr, msg &amp; &quot;\n&quot;);
  END ReportError;

VAR
  animerr : Wr.T;

TYPE
  Timer = OBJECT
    active : BOOLEAN := FALSE;
    text1  : TextVBT.T;
    text2  : TextVBT.T;
    framecounter : LONGREAL := 0.0d0;
    geomAvg      : LONGREAL := 0.0d0;
    serverstart  : LONGREAL;
    now          : LONGREAL;
  METHODS
    init (): Timer  := InitTimer;
    click ()        := ClickTimer;
  END;

PROCEDURE <A NAME="InitTimer"><procedure>InitTimer</procedure></A> (self : Timer) : Timer =
  BEGIN
    IF NEW(ParseParams.T).init(Stdio.stderr).keywordPresent(&quot;@O3Dshowtime&quot;) THEN
      self.active := TRUE;
      self.serverstart := Time.Now();
      self.now := self.serverstart;
      self.text1 := TextVBT.New (&quot; &quot;, hmargin := 5.0, vmargin := 5.0);
      self.text2 := TextVBT.New (&quot; &quot;, hmargin := 5.0, vmargin := 5.0);
      WITH vsplit = HVSplit.Cons (Axis.T.Ver, self.text1, self.text2) DO
        TRY
          Trestle.Install (vsplit);
        EXCEPT
          TrestleComm.Failure =&gt; self.active := FALSE;
        END;
      END;
    END;
    RETURN self;
  END InitTimer;

PROCEDURE <A NAME="ClickTimer"><procedure>ClickTimer</procedure></A> (self : Timer) =
  BEGIN
    WITH fc    = self.framecounter,
         geom  = self.geomAvg,
         now   = Time.Now(),
         total = (now - self.serverstart) / fc DO
      fc := fc + 1.0d0;
      geom := (geom + (now - self.now)) * 0.5d0;
      self.now := now;
      TextVBT.Put (self.text1,
                   &quot;Total Avg: &quot; &amp; Fmt.LongReal(total) &amp; &quot; sec/frame&quot;);
      TextVBT.Put (self.text2,
                   &quot;Geom. Avg: &quot; &amp; Fmt.LongReal(geom) &amp; &quot; sec/frame&quot;);
    END;
 END ClickTimer;

BEGIN
  roots        := NIL;
  handles      := NIL;
  handles_lock := NEW (MUTEX);

  animerr := Stdio.stderr;

  internalLock := NEW (MUTEX);
  externalLock := NEW (MUTEX);

  EVAL Thread.Fork (NEW (Closure));  (* start animation server thread *)
END AnimServer.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
