<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/AuxG.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/AuxG.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P><PRE>UNSAFE MODULE <module><implements><A HREF="AuxG.i3">AuxG</A></implements></module>;

IMPORT <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="GO.i3">GO</A>, <A HREF="../../arith/src/Math.i3">Math</A>, <A HREF="Mth.i3">Mth</A>, <A HREF="../../PEX/src/PEX.i3">PEX</A>, <A HREF="Point3.i3">Point3</A>;

PROCEDURE <A NAME="MkRgbFloatColour"><procedure>MkRgbFloatColour</procedure></A> (c : Color.T) : PEX.pxlColourSpecifier =
  VAR
    cs : PEX.pxlColourSpecifier;
  BEGIN
    cs.colourType := PEX.PEXRgbFloatColour;
    cs.colour     := FromRgbFloatColour(PEX.pexRgbFloatColour{c.r, c.g, c.b});
    RETURN cs;
  END MkRgbFloatColour;

&lt;* INLINE *&gt;
PROCEDURE <A NAME="FromRgbFloatColour"><procedure>FromRgbFloatColour</procedure></A> (c : PEX.pexRgbFloatColour) : PEX.pexColour =
  VAR
    col : PEX.pexColourStar := LOOPHOLE(ADR(c),PEX.pexColourStar);
  BEGIN
    RETURN col^
  END FromRgbFloatColour;

PROCEDURE <A NAME="ConvertShape"><procedure>ConvertShape</procedure></A>(s : GO.Shape) : INTEGER =
  BEGIN
    CASE s OF
    | GO.Shape.Complex   =&gt; RETURN PEX.PEXComplex;
    | GO.Shape.NonConvex =&gt; RETURN PEX.PEXNonconvex;
    | GO.Shape.Convex    =&gt; RETURN PEX.PEXConvex;
    | GO.Shape.Unknown   =&gt; RETURN PEX.PEXUnknownShape;
    END
  END ConvertShape;
</PRE>***************************************************************************
 The Unit Circle caching mechanism                                         
***************************************************************************

<P>
<P><PRE>TYPE
  CircleCache = REF RECORD
    prec  : INTEGER;
    verts : REF ARRAY OF Point3.T;
    next  : CircleCache;
  END;

VAR
  circleCache : CircleCache := NIL;

PROCEDURE <A NAME="GetUnitCirclePoints"><procedure>GetUnitCirclePoints</procedure></A> (prec : INTEGER) : REF ARRAY OF Point3.T =
  VAR
    tmp := circleCache;
    ang := 0.0;
  BEGIN
    WHILE tmp # NIL DO
      IF tmp.prec = prec THEN
        (* We have cached a circle at this resolution, so return it *)
        RETURN tmp.verts;
      END;
      tmp := tmp.next;
    END;

    (* So far, we have not computed a circle at this resolution ... *)
    WITH v = NEW (REF ARRAY OF Point3.T, prec + 1),
         Dang = 2.0 * Math.Pi / FLOAT (prec) DO

      FOR i := 0 TO prec - 1 DO
        v[i] := Point3.T {Mth.sin(ang), Mth.cos(ang), 0.0};
        ang := ang + Dang;
      END;
      v[prec] := v[0];
      circleCache := NEW (CircleCache,
                          prec  := prec,
                          verts := v,
                          next  := circleCache);
      RETURN v;
    END;
  END GetUnitCirclePoints;

BEGIN
END AuxG.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
