<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/BooleanProp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/BooleanProp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sat May 21 21:53:22 PDT 1994 by najork                   

<P>
<P><PRE>MODULE <module>BooleanProp</module> EXPORTS <A HREF="BooleanProp.i3"><implements>BooleanProp</A></implements>, <A HREF="BooleanPropPrivate.i3"><implements>BooleanPropPrivate</A></implements>, <A HREF="BooleanPropProxy.i3"><implements>BooleanPropProxy</A></implements>;

IMPORT <A HREF="Anim3D.i3">Anim3D</A>, <A HREF="AnimHandle.i3">AnimHandle</A>, <A HREF="AnimHandlePrivate.i3">AnimHandlePrivate</A>, <A HREF="AnimRequestQueue.i3">AnimRequestQueue</A>,
       <A HREF="AnimRequestQueuePrivate.i3">AnimRequestQueuePrivate</A>, <A HREF="AnimServer.i3">AnimServer</A>, <A HREF="GraphicsState.i3">GraphicsState</A>,
       <A HREF="GraphicsStatePrivate.i3">GraphicsStatePrivate</A>, <A HREF="Prop.i3">Prop</A>, <A HREF="PropPrivate.i3">PropPrivate</A>;
</PRE>***************************************************************************
 Type <CODE>Name</CODE>                                                               
***************************************************************************

<P><PRE>REVEAL
  <A NAME="Name">Name</A> = PrivateName BRANDED OBJECT
    default : Base;
  OVERRIDES
    init      := InitName;
    bind      := BindName;
    makeProxy := MakeProxyName;
    push      := PushName;
    pop       := PopName;
    newStack  := NewStack;
    getState  := GetState;
  END;

PROCEDURE <A NAME="InitName"><procedure>InitName</procedure></A> (self : Name; default : Base) : Name =
  BEGIN
    EVAL Prop.Name.init (self);
    self.default := default;
    IF NamePM # NIL THEN
      NamePM (self);
    END;
    RETURN self;
  END InitName;

PROCEDURE <A NAME="BindName"><procedure>BindName</procedure></A> (self : Name; val : Val) : Prop.T =
  BEGIN
    RETURN NEW (Prop.T).init (self, val);
  END BindName;

PROCEDURE <A NAME="MakeProxyName"><procedure>MakeProxyName</procedure></A> (self : Name) =
  BEGIN
    IF self.proxy = NIL AND NamePM # NIL THEN
      NamePM (self);
    END;
  END MakeProxyName;

PROCEDURE <A NAME="PushName"><procedure>PushName</procedure></A> (self : Name; state : GraphicsState.T; pv : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], Stack),
         val   = NARROW (pv, Val).val DO
      stack.push (val);
    END;
  END PushName;

PROCEDURE <A NAME="PopName"><procedure>PopName</procedure></A> (self : Name; state : GraphicsState.T) =
  BEGIN
    EVAL NARROW (state.stacks[self.id], Stack).pop ();
  END PopName;

PROCEDURE <A NAME="NewStack"><procedure>NewStack</procedure></A> (self : Name) : PropPrivate.Stack =
  BEGIN
    RETURN NEW (Stack).init (self.default);
  END NewStack;

PROCEDURE <A NAME="GetState"><procedure>GetState</procedure></A> (self: Name; state : GraphicsState.T) : Base =
  BEGIN
    RETURN NARROW (state.stacks[self.id], Stack).top;
  END GetState;
</PRE>***************************************************************************
 Type <CODE>Val</CODE>                                                                
***************************************************************************

<P><PRE>REVEAL
  <A NAME="Val">Val</A> = PrivateVal BRANDED OBJECT
  OVERRIDES
    init   := InitVal;
    get    := GetVal;
    value  := ValueVal;
    adjust := AdjustVal;
  END;

PROCEDURE <A NAME="InitVal"><procedure>InitVal</procedure></A> (self : Val; beh : Beh) : Val =
  BEGIN
    self.beh  := beh;
    self.time := Anim3D.Now () - 10.0d0;

    IF ValPM # NIL THEN
      ValPM (self);
    END;
    RETURN self;
  END InitVal;

PROCEDURE <A NAME="GetVal"><procedure>GetVal</procedure></A> (self : Val) : Base RAISES {Prop.BadMethod} =
  BEGIN
    RETURN self.beh.value (Anim3D.Now ());
  END GetVal;

PROCEDURE <A NAME="ValueVal"><procedure>ValueVal</procedure></A> (self : Val; time : LONGREAL) : Base
    RAISES {Prop.BadMethod} =
  BEGIN
    IF time = self.time THEN
      RETURN self.val;
    ELSE
      RETURN self.beh.value (time);
    END;
  END ValueVal;

PROCEDURE <A NAME="AdjustVal"><procedure>AdjustVal</procedure></A> (self : Val; time : LONGREAL) : BOOLEAN
    RAISES {Prop.BadMethod} =
  BEGIN
    IF time # self.time THEN
      WITH val = self.beh.value (time) DO
        self.damaged := val # self.val;
        self.time    := time;
        self.val     := val;
      END;
    END;
    RETURN self.damaged;
  END AdjustVal;
</PRE>***************************************************************************
 Type <CODE>Beh</CODE>                                                                
***************************************************************************

<P><PRE>REVEAL
  <A NAME="Beh">Beh</A> = PrivateBeh BRANDED OBJECT
  OVERRIDES
    init := InitBeh;
  END;

PROCEDURE <A NAME="InitBeh"><procedure>InitBeh</procedure></A> (self : Beh) : Beh =
  BEGIN
    RETURN self;
  END InitBeh;
</PRE>***************************************************************************
 Type <CODE>ConstBeh</CODE>                                                           
***************************************************************************

<P><PRE>REVEAL
  <A NAME="ConstBeh">ConstBeh</A> = PublicConstBeh BRANDED OBJECT
    b : Base;
  OVERRIDES
    init   := InitConstBeh;
    set    := SetConstBeh;
    value  := ValueConstBeh;
  END;

PROCEDURE <A NAME="InitConstBeh"><procedure>InitConstBeh</procedure></A> (self : ConstBeh; b : Base) : ConstBeh =
  BEGIN
    EVAL Beh.init (self);
    self.b := b;
    IF ConstBehPM # NIL THEN
      ConstBehPM (self);
    END;
    RETURN self;
  END InitConstBeh;

PROCEDURE <A NAME="SetConstBeh"><procedure>SetConstBeh</procedure></A> (self : ConstBeh; b : Base) =
  BEGIN
    self.b := b;
  END SetConstBeh;

PROCEDURE <A NAME="ValueConstBeh"><procedure>ValueConstBeh</procedure></A> (             self : ConstBeh;
                         &lt;* UNUSED *&gt; time : LONGREAL) : Base =
  BEGIN
    RETURN self.b;
  END ValueConstBeh;

PROCEDURE <A NAME="NewConst"><procedure>NewConst</procedure></A> (b : Base) : Val =
  BEGIN
    RETURN NEW (Val).init (NEW (ConstBeh).init (b));
  END NewConst;
</PRE>***************************************************************************
 Type <CODE>AsyncBeh</CODE>                                                           
***************************************************************************

<P><PRE>REVEAL
  <A NAME="AsyncBeh">AsyncBeh</A> = PublicAsyncBeh BRANDED OBJECT
  OVERRIDES
    init    := InitAsyncBeh;
    value   := ValueAsyncBeh;
    compute := ComputeAsyncBeh;
  END;

PROCEDURE <A NAME="InitAsyncBeh"><procedure>InitAsyncBeh</procedure></A> (self : AsyncBeh) : AsyncBeh =
  BEGIN
    EVAL Beh.init (self);
    IF AsyncBehPM # NIL THEN
      AsyncBehPM (self);
    END;
    RETURN self;
  END InitAsyncBeh;

PROCEDURE <A NAME="ValueAsyncBeh"><procedure>ValueAsyncBeh</procedure></A> (self : AsyncBeh; time : LONGREAL) : Base
    RAISES {Prop.BadMethod} =
  BEGIN
    RETURN self.compute (time);
  END ValueAsyncBeh;

PROCEDURE <A NAME="ComputeAsyncBeh"><procedure>ComputeAsyncBeh</procedure></A> (self : AsyncBeh; time : LONGREAL) : Base
    RAISES {Prop.BadMethod} =
  BEGIN
    IF self.proxy # NIL THEN
      RETURN NARROW (self.proxy, AsyncBehProxy).compute (time);
    ELSE
      RAISE Prop.BadMethod(&quot;BooleanProp.AsyncBeh.compute method is undefined&quot;);
    END;
  END ComputeAsyncBeh;

PROCEDURE <A NAME="NewAsync"><procedure>NewAsync</procedure></A> (b : AsyncBeh) : Val =
  BEGIN
    RETURN NEW (Val).init (b);
  END NewAsync;
</PRE>***************************************************************************
 Type <CODE>DepBeh</CODE>                                                             
***************************************************************************

<P><PRE>REVEAL
  <A NAME="DepBeh">DepBeh</A> = PublicDepBeh BRANDED OBJECT
    hot : BOOLEAN;
  OVERRIDES
    init    := InitDepBeh;
    value   := ValueDepBeh;
    compute := ComputeDepBeh;
  END;

PROCEDURE <A NAME="InitDepBeh"><procedure>InitDepBeh</procedure></A> (self : DepBeh) : DepBeh =
  BEGIN
    EVAL Beh.init (self);
    self.hot := FALSE;
    IF DepBehPM # NIL THEN
      DepBehPM (self);
    END;
    RETURN self;
  END InitDepBeh;

PROCEDURE <A NAME="ValueDepBeh"><procedure>ValueDepBeh</procedure></A> (self : DepBeh; time : LONGREAL) : Base
    RAISES {Prop.BadMethod} =
  BEGIN
    (* &quot;hot&quot; is set to true while the value of the behavior is computed.
       So, if &quot;hot&quot; is currently true, we have cyclic dependencies.
       If unchecked, this would lead to an infinite recursion.
       We raise an exception instead. *)
    IF self.hot THEN
      RAISE Prop.BadMethod(&quot;BooleanProp.DepBeh occurs in a dependency cycle&quot;);
    END;

    TRY
      self.hot := TRUE;
      RETURN self.compute (time);
    FINALLY
      self.hot := FALSE;
    END;
  END ValueDepBeh;

PROCEDURE <A NAME="ComputeDepBeh"><procedure>ComputeDepBeh</procedure></A> (self : DepBeh; time : LONGREAL) : Base
    RAISES {Prop.BadMethod} =
  BEGIN
    IF self.proxy # NIL THEN
      RETURN NARROW (self.proxy, DepBehProxy).compute (time);
    ELSE
      RAISE Prop.BadMethod(&quot;BooleanProp.DepBeh.compute method is undefined&quot;);
    END;
  END ComputeDepBeh;

PROCEDURE <A NAME="NewDep"><procedure>NewDep</procedure></A> (b : DepBeh) : Val =
  BEGIN
    RETURN NEW (Val).init (b);
  END NewDep;
</PRE>***************************************************************************
 Type <CODE>SyncBeh</CODE>                                                            
***************************************************************************

<P><PRE>REVEAL
  <A NAME="SyncBeh">SyncBeh</A> = PublicSyncBeh BRANDED OBJECT
    queue : MyAnimRequestQueue;
  OVERRIDES
    init       := InitSyncBeh;
    value      := ValueSyncBeh;
    addRequest := AddRequest;
    change     := Change;
  END;

PROCEDURE <A NAME="InitSyncBeh"><procedure>InitSyncBeh</procedure></A> (self : SyncBeh;
                       ah   : AnimHandle.T;
                       b    : Base) : SyncBeh =
  BEGIN
    EVAL Beh.init (self);
    self.queue := NEW (MyAnimRequestQueue).init (ah, b);

    IF SyncBehPM # NIL THEN
      SyncBehPM (self);
    END;
    RETURN self;
  END InitSyncBeh;

PROCEDURE <A NAME="ValueSyncBeh"><procedure>ValueSyncBeh</procedure></A> (self : SyncBeh; time : LONGREAL) : Base
    RAISES {Prop.BadMethod} =
  BEGIN
    RETURN self.queue.value (time);
  END ValueSyncBeh;

PROCEDURE <A NAME="AddRequest"><procedure>AddRequest</procedure></A> (self : SyncBeh; r : Request) RAISES {Prop.BadInterval} =
  BEGIN
    self.queue.insert (r);
  END AddRequest;

PROCEDURE <A NAME="Change"><procedure>Change</procedure></A> (self : SyncBeh; b : Base; start : REAL)
    RAISES {Prop.BadInterval} =
  BEGIN
    self.queue.insert (NEW (ChangeReq).init (start, 0.0, b));
  END Change;

PROCEDURE <A NAME="NewSync"><procedure>NewSync</procedure></A> (ah : AnimHandle.T; b : Base) : Val =
  BEGIN
    RETURN NEW (Val).init (NEW (SyncBeh).init (ah, b));
  END NewSync;
</PRE>***************************************************************************
 Request Subtypes                                                          
***************************************************************************

<P>
<P><PRE>REVEAL
  <A NAME="Request">Request</A> = PublicRequest BRANDED OBJECT
  OVERRIDES
    init  := InitRequest;
    value := ValueRequest;
  END;

PROCEDURE <A NAME="InitRequest"><procedure>InitRequest</procedure></A> (self : Request; start, dur : REAL) : Request =
  BEGIN
    EVAL Prop.Request.init (self, start, dur);
    IF RequestPM # NIL THEN
      RequestPM (self);
    END;
    RETURN self;
  END InitRequest;

PROCEDURE <A NAME="ValueRequest"><procedure>ValueRequest</procedure></A> (self     : Request;
                        startval : Base;
                        reltime  : REAL) : Base RAISES {Prop.BadMethod} =
  BEGIN
    IF self.proxy # NIL THEN
      RETURN NARROW (self.proxy, RequestProxy).value (startval, reltime);
    ELSE
      RAISE Prop.BadMethod(&quot;BooleanProp.Request.value method is undefined&quot;);
    END;
  END ValueRequest;

TYPE
  ChangeReq = Request BRANDED OBJECT
    b : Base;
  METHODS
    init (start, dur : REAL; b : Base) : ChangeReq := InitChangeReq;
  OVERRIDES
    value := ChangeReqValue;
  END;

PROCEDURE <A NAME="InitChangeReq"><procedure>InitChangeReq</procedure></A> (self  : ChangeReq;
                         start : REAL;
                         dur   : REAL;
                         b     : Base) : ChangeReq =
  BEGIN
    EVAL Request.init (self, start, dur);
    self.b := b;
    RETURN self;
  END InitChangeReq;

PROCEDURE <A NAME="ChangeReqValue"><procedure>ChangeReqValue</procedure></A> (self      : ChangeReq;
             &lt;* UNUSED *&gt; startbool : Base;
                          reltime   : REAL) : Base =
  BEGIN
    &lt;* ASSERT reltime &gt;= self.start AND reltime &lt;= self.start + self.dur *&gt;
    RETURN self.b;
  END ChangeReqValue;
</PRE>***************************************************************************
 Animation queue for synchronous point property value behavior             
***************************************************************************

<P>
<P><PRE>TYPE
  MyAnimRequestQueue = AnimRequestQueue.T BRANDED OBJECT
    b : Base;  (* The initial value of the pv *)
  METHODS
    init (ah : AnimHandle.T; b : Base) : MyAnimRequestQueue
      := MyAnimRequestQueue_Init;
    value (time : LONGREAL) : Base RAISES {Prop.BadMethod}
      := MyAnimRequestQueue_Value;
  OVERRIDES
    flush := MyAnimRequestQueue_Flush;
  END;

PROCEDURE <A NAME="MyAnimRequestQueue_Init"><procedure>MyAnimRequestQueue_Init</procedure></A> (self : MyAnimRequestQueue;
                                   ah   : AnimHandle.T;
                                   b    : Base) : MyAnimRequestQueue =
  BEGIN
    EVAL AnimRequestQueue.T.init (self, ah);
    self.b := b;
    RETURN self;
  END MyAnimRequestQueue_Init;

PROCEDURE <A NAME="MyAnimRequestQueue_Value"><procedure>MyAnimRequestQueue_Value</procedure></A> (self : MyAnimRequestQueue;
                                    time : LONGREAL) : Base
    RAISES {Prop.BadMethod} =
  VAR
    l       := self.list;
    req     : Request;
    b       : Base;
    reltime : REAL;
  BEGIN
    IF self.ah.activated THEN
      reltime := FLOAT (time - self.ah.starttime);
      b := self.b;
      WHILE l # NIL DO
        req := l.req;
        IF reltime &lt; req.start  THEN
          RETURN b;
        ELSIF reltime &lt; req.start + req.dur THEN
          RETURN req.value (b, reltime);
        ELSE
          b := req.value (b, req.start + req.dur);
          l := l.next;
        END;
      END;
      RETURN b;
    ELSE
      RETURN self.b;
    END;
  END MyAnimRequestQueue_Value;

PROCEDURE <A NAME="MyAnimRequestQueue_Flush"><procedure>MyAnimRequestQueue_Flush</procedure></A> (self : MyAnimRequestQueue) =
  VAR
    req : Request;
  BEGIN
    WHILE self.list # NIL DO
      req := self.list.req;
      TRY
        self.b := req.value (self.b, req.start + req.dur);
      EXCEPT
        Prop.BadMethod (msg) =&gt; AnimServer.ReportError (msg);
      END;
      self.list := self.list.next;
    END;
  END MyAnimRequestQueue_Flush;
</PRE>***************************************************************************
 Stack                                                                     
***************************************************************************

<P><PRE>REVEAL
  <A NAME="Stack">Stack</A> = PublicStack BRANDED OBJECT
    cnt  : INTEGER;
    vals : REF ARRAY OF Base;
  METHODS
    init (top : Base) : Stack := InitStack;
  OVERRIDES
    push := PushStack;
    pop  := PopStack;
  END;

PROCEDURE <A NAME="InitStack"><procedure>InitStack</procedure></A> (self : Stack; top : Base) : Stack =
  BEGIN
    self.cnt  := 0;
    self.vals := NEW (REF ARRAY OF Base, 10);
    self.top  := top;
    RETURN self;
  END InitStack;

PROCEDURE <A NAME="PushStack"><procedure>PushStack</procedure></A> (self : Stack; val : Base) =
  BEGIN
    IF self.cnt &gt;= LAST (self.vals^) THEN
      WITH tmp = NEW (REF ARRAY OF Base, 2 * NUMBER (self.vals^)) DO
        SUBARRAY (tmp^, 0, NUMBER (self.vals^)) := self.vals^;
        self.vals := tmp;
      END;
    END;
    self.vals[self.cnt] := self.top;
    self.top := val;
    INC (self.cnt);
  END PushStack;

PROCEDURE <A NAME="PopStack"><procedure>PopStack</procedure></A> (self : Stack) : Base =
  BEGIN
    DEC (self.cnt);
    self.top := self.vals[self.cnt];
    RETURN self.top;
  END PopStack;

BEGIN
END BooleanProp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
