<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/BoxGO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/BoxGO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P> A <CODE>BoxGO.T</CODE> is a geometric object describing a parallelopiped. 

<P>
<P><PRE>INTERFACE <interface><A HREF="BoxGO.m3">BoxGO</A></interface>;

IMPORT <A HREF="GO.i3">GO</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="PointProp.i3">PointProp</A>, <A HREF="SurfaceGO.i3">SurfaceGO</A>;

TYPE
  <A HREF="BoxGO.m3#T">T</A> &lt;: Public;
  Public = SurfaceGO.T OBJECT
  METHODS
    init () : T;
  END;
</PRE> <CODE>box.init()</CODE>  initializes a new parallelopiped <CODE>box</CODE> and returns it.
   The sides of the parallelopiped are axis-aligned, its corners are 
   determined by the <CODE>Corner1</CODE> and <CODE>Corner2</CODE> properties. 

<P><PRE>VAR
  Corner1 : PointProp.Name;
  Corner2 : PointProp.Name;
</PRE> In addition to the properties observed by all \type{GO}{T}'s and
   \type{SurfaceGO}{T}'s, there are two additional properties that 
   are observed by <CODE>BoxGO.T</CODE>'s:
<P>
   <CODE>Corner1</CODE> and <CODE>Corner2</CODE> are the names of two point properties that 
   describe the two cornerpoints of the box. They associate with 
   \type{PointProp}{Val}s. If they are not specified, (0,0,0) and (1,1,1) 
   are used as cornerpoints. 

<P><PRE>PROCEDURE <A HREF="BoxGO.m3#New">New</A> (a, b : Point3.T) : T;
</PRE><BLOCKQUOTE><EM> <CODE>New(a,b)</CODE> creates a new box and returns it. It also attaches the following
   properties to the new box:
   \begin{verbatim}
     (Corner1,PointProp.NewConst(a))
     (Corner2,PointProp.NewConst(b))
   \end{verbatim}
</EM></BLOCKQUOTE><PRE>
</PRE> The following two procedures provide sugaring to attach <CODE>Corner1</CODE> and 
   <CODE>Corner2</CODE> properties with non-animated property values to geometric 
   objects: 

<P><PRE>PROCEDURE <A HREF="BoxGO.m3#SetCorner1">SetCorner1</A> (o : GO.T; p : Point3.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetCorner1(o,p)</CODE> is equivalent to
   <CODE>o.setProp(Corner1.bind(PointProp.NewConst(p)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="BoxGO.m3#SetCorner2">SetCorner2</A> (o : GO.T; p : Point3.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetCorner2(o,p)</CODE> is equivalent to
   <CODE>o.setProp(Corner2.bind(PointProp.NewConst(p)))</CODE>. </EM></BLOCKQUOTE><PRE>

END BoxGO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
