<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/CBStack.mg</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/CBStack.mg</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Fri Feb 18 10:58:07 PST 1994 by najork                   

<P>
<P><PRE>GENERIC MODULE <genericModule><A HREF="CBStack.ig">CBStack</A></genericModule> (AnyCB);

IMPORT <A HREF="CB.i3">CB</A>, <A HREF="GO.i3">GO</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
    mu   : MUTEX;
    list : List;
  OVERRIDES
    init      := Init;
    invokeTop := InvokeTop;
    push      := Push;
    pop       := Pop;
    remove    := Remove;
  END;

TYPE
  List = REF RECORD
    head : AnyCB.T;
    tail : List;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T) : T =
  BEGIN
    self.list := NIL;
    self.mu   := NEW (MUTEX);
    RETURN self;
  END Init;

PROCEDURE <A NAME="InvokeTop"><procedure>InvokeTop</procedure></A> (self : T; rec : AnyCB.Rec) RAISES {CB.BadMethod} =
  VAR
    top : AnyCB.T;
  BEGIN
    LOCK self.mu DO
      IF self.list # NIL THEN
        top := self.list.head;
      END;
    END;
    IF top # NIL THEN
      top.invoke (rec);
    END;
  END InvokeTop;

PROCEDURE <A NAME="Push"><procedure>Push</procedure></A> (self : T; cb : AnyCB.T) =
  BEGIN
    LOCK self.mu DO
      self.list := NEW (List, head := cb, tail := self.list);
    END;
  END Push;

PROCEDURE <A NAME="Pop"><procedure>Pop</procedure></A> (self : T) RAISES {GO.StackError} =
  BEGIN
    LOCK self.mu DO
      IF self.list = NIL THEN
        RAISE GO.StackError;
      ELSE
        self.list := self.list.tail;
      END;
    END;
  END Pop;

PROCEDURE <A NAME="Remove"><procedure>Remove</procedure></A> (self : T; cb : AnyCB.T) RAISES {GO.StackError} =

  PROCEDURE Remove (VAR list : List) RAISES {GO.StackError} =
    BEGIN
      IF list = NIL THEN
        RAISE GO.StackError;
      ELSIF list.head = cb THEN
        list := list.tail;
      ELSE
        Remove (list.tail);
      END;
    END Remove;

  BEGIN
    LOCK self.mu DO
      Remove (self.list);
    END;
  END Remove;

BEGIN
END CBStack.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
