<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/CameraGO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/CameraGO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Thu Feb 10 11:47:55 PST 1994 by najork                   

<P> A camera is a special kind of geometric object. Like any other geometric 
   object, it can be a part of a group (and thus, by transitivity, of an 
   entire scene), properties can be attached to it, and it observes both 
   the properties attached to itself and to its ancestors in the scene. 
   In particular, cameras are affected by transformation properties: When 
   the transformation property of a camera or of one of its ancestors in 
   the scene changes, the camera changes its position. 
<P>
   Cameras are themselves invisible.
<P>
   <CODE>CameraGO.T</CODE> is the abstract class of all cameras. 

<P><PRE>INTERFACE <interface><A HREF="CameraGO.m3">CameraGO</A></interface>;

IMPORT <A HREF="GO.i3">GO</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="PointProp.i3">PointProp</A>, <A HREF="RealProp.i3">RealProp</A>;

TYPE
  <A HREF="CameraGO.m3#T">T</A> &lt;: GO.T;
</PRE><BLOCKQUOTE><EM> <CODE>CameraGO.T</CODE> is a subtype of \type{GO}{T}. No additional fiels or methods 
   are defined. </EM></BLOCKQUOTE><PRE>

VAR
  From   : PointProp.Name;
  To     : PointProp.Name;
  Up     : PointProp.Name;
  Aspect : RealProp.Name;
</PRE><BLOCKQUOTE><EM> In addition to the properties observed by all \type{GO}{T}'s, there are four
   additional properties that are observed by all <CODE>CameraGO.T</CODE>'s. 
<P>
   <CODE>From</CODE> is the name of a property that describes the position of the 
   camera. <CODE>To</CODE> is the name of a property that defines a point the camera 
   is looking at. <CODE>Up</CODE> is the name of a property that defines the up-vector 
   of the camera. <CODE>From</CODE>, <CODE>To</CODE>, and <CODE>Up</CODE> associate with property values of 
   type \type{PointProp}{Val}.
<P>
   <CODE>Aspect</CODE> is the name of a property that defines the aspect ration 
   (width / height) of the image generated by the camera. It associates with 
   a \type{RealProp}{Val}. Its default value is 1, which means that the 
   picture is not distorted
   (In the current implementation, the drawing area is always square). </EM></BLOCKQUOTE><PRE>
</PRE> The following four procedures make it more convenient to modify the
   <CODE>From</CODE>, <CODE>To</CODE>, <CODE>Up</CODE>, and <CODE>Aspect</CODE> properties of a camera: 

<P><PRE>PROCEDURE <A HREF="CameraGO.m3#SetFrom">SetFrom</A> (o : GO.T; p: Point3.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetFrom(o,p)</CODE> is equivalent to 
   <CODE>o.setProp(From.bind(PointProp.NewConst(p)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CameraGO.m3#SetTo">SetTo</A> (o : GO.T; p: Point3.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetTo(o,p)</CODE> is equivalent to 
   <CODE>o.setProp(To.bind(PointProp.NewConst(p)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CameraGO.m3#SetUp">SetUp</A> (o : GO.T; p: Point3.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetUp(o,p)</CODE> is equivalent to 
   <CODE>o.setProp(Up.bind(PointProp.NewConst(p)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CameraGO.m3#SetAspect">SetAspect</A> (o : GO.T; r: REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetAspect(o,r)</CODE> is equivalent to 
   <CODE>o.setProp(Aspect.bind(RealProp.NewConst(r)))</CODE>. </EM></BLOCKQUOTE><PRE>

END CameraGO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
