<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/CameraGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/CameraGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Mon Feb 14 16:01:13 PST 1994 by najork                   

<P>
<P><PRE>MODULE <module>CameraGO</module> EXPORTS <A HREF="CameraGO.i3"><implements>CameraGO</A></implements>, <A HREF="CameraGOPrivate.i3"><implements>CameraGOPrivate</A></implements>;

IMPORT <A HREF="GO.i3">GO</A>, <A HREF="GOPrivate.i3">GOPrivate</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="PointProp.i3">PointProp</A>, <A HREF="PointPropPrivate.i3">PointPropPrivate</A>, <A HREF="RealProp.i3">RealProp</A>,
       <A HREF="RealPropPrivate.i3">RealPropPrivate</A>;

REVEAL
  <A NAME="T">T</A> = Private BRANDED OBJECT
  OVERRIDES
    init := Init;
    needsTransparency := NeedsTransparency;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T) : T =
  BEGIN
    EVAL GO.T.init (self);
    self.flag := FALSE;
    RETURN self;
  END Init;

PROCEDURE <A NAME="NeedsTransparency"><procedure>NeedsTransparency</procedure></A> (&lt;* UNUSED *&gt; self : T;
                             &lt;* UNUSED *&gt; t    : REAL) : BOOLEAN =
  BEGIN
    RETURN FALSE;
  END NeedsTransparency;
</PRE>***************************************************************************
 Convenience Procedures                                                    
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetFrom"><procedure>SetFrom</procedure></A> (o : GO.T; p: Point3.T) =
  BEGIN
    o.setProp(From.bind(PointProp.NewConst(p)));
  END SetFrom;

PROCEDURE <A NAME="SetTo"><procedure>SetTo</procedure></A> (o : GO.T; p: Point3.T) =
  BEGIN
    o.setProp(To.bind(PointProp.NewConst(p)));
  END SetTo;

PROCEDURE <A NAME="SetUp"><procedure>SetUp</procedure></A> (o : GO.T; p: Point3.T) =
  BEGIN
    o.setProp(Up.bind(PointProp.NewConst(p)));
  END SetUp;

PROCEDURE <A NAME="SetAspect"><procedure>SetAspect</procedure></A> (o : GO.T; r: REAL) =
  BEGIN
    o.setProp(Aspect.bind(RealProp.NewConst(r)));
  END SetAspect;
</PRE>***************************************************************************
 Module body                                                               
***************************************************************************

<P>
<P><PRE>BEGIN
  From   := NEW (PointProp.Name).init (Point3.T {0.0, 0.0, 100.0});
  To     := NEW (PointProp.Name).init (Point3.Origin);
  Up     := NEW (PointProp.Name).init (Point3.T {0.0, 1.0, 0.0});
  Aspect := NEW (RealProp.Name).init (1.0);
END CameraGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
