<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/ConeGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/ConeGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P><PRE>MODULE <module>ConeGO</module> EXPORTS <A HREF="ConeGO.i3"><implements>ConeGO</A></implements>, <A HREF="ConeGOProxy.i3"><implements>ConeGOProxy</A></implements>;

IMPORT <A HREF="GO.i3">GO</A>, <A HREF="GOPrivate.i3">GOPrivate</A>, <A HREF="GraphicsState.i3">GraphicsState</A>, <A HREF="Matrix4.i3">Matrix4</A>, <A HREF="Mth.i3">Mth</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="PointProp.i3">PointProp</A>,
       <A HREF="PointPropPrivate.i3">PointPropPrivate</A>, <A HREF="Prop.i3">Prop</A>, <A HREF="RealProp.i3">RealProp</A>, <A HREF="RealPropPrivate.i3">RealPropPrivate</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
    prec   : INTEGER;
    base   : Point3.T;
    tip    : Point3.T;
    radius : REAL;
    matrix : Matrix4.T;      (* transforms unit cone into desired cone *)
  OVERRIDES
    init              := Init;
    draw              := Draw;
    damageIfDependent := DamageIfDependent;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T; prec : INTEGER) : T =
  BEGIN
    EVAL GO.T.init (self);
    self.prec   := prec;
    self.matrix := Matrix4.Identity ();
    self.base   := Point3.T {0.0, 0.0, 0.0};
    self.tip    := Point3.T {0.0, 0.0, 1.0};
    self.radius := 1.0;

    IF MkProxyT # NIL AND self.proxy = NIL THEN
      MkProxyT (self);
    END;

    RETURN self;
  END Init;

PROCEDURE <A NAME="DamageIfDependent"><procedure>DamageIfDependent</procedure></A> (self : T; pn : Prop.Name) =
  BEGIN
    IF pn = Base OR pn = Tip OR pn = Radius THEN
      self.damaged := TRUE;
    END;
  END DamageIfDependent;

PROCEDURE <A NAME="Draw"><procedure>Draw</procedure></A> (self : T; state : GraphicsState.T) =
  BEGIN
    state.push (self);
    WITH base   = Base.getState (state),
         tip    = Tip.getState (state),
         radius = Radius.getState (state) DO

      IF base # self.base OR tip # self.tip OR radius # self.radius THEN
        self.base   := base;
        self.tip    := tip;
        self.radius := radius;

        (* Compute a transformation matrix that transforms the prototypical
           cone into the desired one. *)
        WITH n = Point3.Minus (tip, base),
             s = Point3.OrthoVector (n),
             t = Point3.CrossProduct (n, s),
             a = Point3.Plus (base, Point3.ScaleToLen (s, radius)),
             b = Point3.Plus (base, Point3.ScaleToLen (t, radius)) DO
          self.matrix := Matrix4.TransformUnitCube (base, a, b, tip);
        END;

      END;

      state.pushMatrix (self.matrix);
      state.drawProtoCone (self.prec);
      state.popMatrix ();
      WITH center = Point3.MidPoint (base, tip),
           dist   = Point3.Distance (base, tip) / 2.0,
           rad    = Mth.sqrt (dist * dist + radius * radius) DO
        state.growBoundingVolume (center, rad);
      END;
    END;

    self.damaged := FALSE;
    state.pop (self);
  END Draw;
</PRE>***************************************************************************
 Convenience Procedures                                                    
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="New"><procedure>New</procedure></A> (base, tip : Point3.T; r : REAL; prec := 30) : T =
  VAR
    cone := NEW (T).init (prec);
  BEGIN
    SetBase (cone, base);
    SetTip (cone, tip);
    SetRadius (cone, r);
    RETURN cone;
  END New;

PROCEDURE <A NAME="SetBase"><procedure>SetBase</procedure></A> (o : GO.T; v : Point3.T) =
  BEGIN
    o.setProp (Base.bind (PointProp.NewConst (v)));
  END SetBase;

PROCEDURE <A NAME="SetTip"><procedure>SetTip</procedure></A> (o : GO.T; v : Point3.T) =
  BEGIN
    o.setProp (Tip.bind (PointProp.NewConst (v)));
  END SetTip;

PROCEDURE <A NAME="SetRadius"><procedure>SetRadius</procedure></A> (o : GO.T; v : REAL) =
  BEGIN
    o.setProp (Radius.bind (RealProp.NewConst (v)));
  END SetRadius;

BEGIN
  Base   := NEW (PointProp.Name).init (Point3.T {0.0, 0.0, 0.0});
  Tip    := NEW (PointProp.Name).init (Point3.T {1.0, 0.0, 0.0});
  Radius := NEW (RealProp.Name).init (1.0);
END ConeGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
