<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/CylinderGO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/CylinderGO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P> A <CODE>CylinderGO.T</CODE> is a geometric object describing a cylinder. 

<P><PRE>INTERFACE <interface><A HREF="CylinderGO.m3">CylinderGO</A></interface>;

IMPORT <A HREF="GO.i3">GO</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="PointProp.i3">PointProp</A>, <A HREF="RealProp.i3">RealProp</A>, <A HREF="SurfaceGO.i3">SurfaceGO</A>;

TYPE
  <A HREF="CylinderGO.m3#T">T</A> &lt;: Public;
  Public = SurfaceGO.T OBJECT
  METHODS
    init (prec := 30) : T;
  END;
</PRE><BLOCKQUOTE><EM> <CODE>cyl.init(prec)</CODE>  initializes a new cylinder <CODE>cyl</CODE>, whose
   surface is composed of <CODE>prec</CODE> rectangles, and returns it.
   The location and radius of the cylinder is determined by the 
   three properties <CODE>Point1</CODE>, <CODE>Point2</CODE>, and <CODE>Radius</CODE>. </EM></BLOCKQUOTE><PRE>

VAR
  Point1 : PointProp.Name;
  Point2 : PointProp.Name;
  Radius : RealProp.Name;
</PRE><BLOCKQUOTE><EM> In addition to the properties observed by all \type{GO}{T}'s and
   \type{SurfaceGO}{T}'s, there are three additional properties that 
   are observed by <CODE>CylinderGO.T</CODE>'s:
<P>
   <CODE>Point1</CODE> is the name of a property that describes the first endpoint 
   of the cylinder. It associates with a \type{PointProp}{Val}. If no <CODE>Point1</CODE> 
   property is specified, the cylinder starts at the origin.
<P>
   <CODE>Point2</CODE> is the name of a property that describes the second endpoint 
   of the cylinder. It associates with a \type{PointProp}{Val}. If no <CODE>Point2</CODE> 
   property is specified, the cylinder ends at point (1,0,0).
<P>
   <CODE>Radius</CODE> is the name of a property that describes the radius of the 
   cylinder. It associates with a \type{RealProp}{Val}. If no <CODE>Radius</CODE> property
   is specified, the cylinder has a radius of 1. 
<P>
   Assume that in a given context and at a given point in time, the property 
   mapping is such that <CODE>Point1</CODE> maps to a point property value which 
   evaluates to <CODE>p1</CODE>, <CODE>Point2</CODE> maps to a point property value which evaluates 
   to <CODE>p2</CODE>, and <CODE>Radius</CODE> maps to a real property value which evaluates to <CODE>r</CODE>. 
   <CODE>p1</CODE>, <CODE>p2</CODE>, and <CODE>r</CODE> define the position and shape of the cylinder 
   in this context and at this time as shown below:
   \begin{center}
   \begin{tabular}{c}
   \psfig{figure=images/CylinderGO.ps,width=3in,silent=}
   \end{tabular}
   \end{center}
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CylinderGO.m3#New">New</A> (p1, p2 : Point3.T; r : REAL; prec := 30) : T;
</PRE><BLOCKQUOTE><EM> <CODE>New(p1,p2,r,prec)</CODE>  creates a new cylinder, whose surface is composed 
   of <CODE>prec</CODE> rectangles, and returns it. It also attaches the following 
   properties to the new cylinder:
   \begin{verbatim}
     (Point1,PointProp.NewConst(p1))
     (Point2,PointProp.NewConst(p2))
     (Radius,RealProp.NewConst(r))
   \end{verbatim}
</EM></BLOCKQUOTE><PRE>
</PRE> The following three procedures provide sugaring to attach 
   <CODE>Point1</CODE>, <CODE>Point2</CODE>, and <CODE>Radius</CODE> properties with non-animated 
   property values to geometric objects: 

<P><PRE>PROCEDURE <A HREF="CylinderGO.m3#SetPoint1">SetPoint1</A> (o : GO.T; p : Point3.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetPoint1(o,p)</CODE> is equivalent to
   <CODE>o.setProp(Point1.bind(PointProp.NewConst(p)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CylinderGO.m3#SetPoint2">SetPoint2</A> (o : GO.T; p : Point3.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetPoint2(o,p)</CODE> is equivalent to
   <CODE>o.setProp(Point2.bind(PointProp.NewConst(p))))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="CylinderGO.m3#SetRadius">SetRadius</A> (o : GO.T; r : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetRadius(o,r)</CODE>is equivalent to
   <CODE>o.setProp(Radius.bind(RealProp.NewConst(r))</CODE>. </EM></BLOCKQUOTE><PRE>

END CylinderGO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
