<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/DiskGO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/DiskGO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P> A <CODE>DiskGO.T</CODE> is a geometric object describing a disk. 

<P><PRE>INTERFACE <interface><A HREF="DiskGO.m3">DiskGO</A></interface>;

IMPORT <A HREF="GO.i3">GO</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="PointProp.i3">PointProp</A>, <A HREF="RealProp.i3">RealProp</A>, <A HREF="SurfaceGO.i3">SurfaceGO</A>;

TYPE
  <A HREF="DiskGO.m3#T">T</A> &lt;: Public;
  Public = SurfaceGO.T OBJECT
  METHODS
    init (prec := 10) : T;
  END;
</PRE><BLOCKQUOTE><EM> <CODE>disk.init(prec)</CODE>  initializes a new disk <CODE>disk</CODE>, whose surface is 
   approximated by a polygon with <CODE>prec</CODE> edges, and returns it. The location,
   orientation, and radius of the disk is determined by the three properties 
   <CODE>Center</CODE>, <CODE>Normal</CODE>, and <CODE>Radius</CODE>. </EM></BLOCKQUOTE><PRE>

VAR
  Center : PointProp.Name;
  Normal : PointProp.Name;
  Radius : RealProp.Name;
</PRE><BLOCKQUOTE><EM> In addition to the properties observed by all \type{GO}{T}'s and
   \type{SurfaceGO}{T}'s, there are three additional properties that 
   are observed by <CODE>DiskGO.T</CODE>'s:
<P>
   <CODE>Center</CODE> is the name of a property that describes the center  
   of the disk. It associates with a \type{PointProp}{Val}. If no <CODE>Center</CODE> 
   property is specified, the disk is centered around the origin.
<P>
   <CODE>Normal</CODE> is the name of a property that describes the normal vector 
   of the disk. It associates with a \type{PointProp}{Val}. If no <CODE>Normal</CODE> 
   property is specified, the normal vector is taken to be (0,0,1).
<P>
   <CODE>Radius</CODE> is the name of a property that describes the radius of the 
   disk. It associates with a \type{RealProp}{Val}. If no <CODE>Radius</CODE> property
   is specified, the disk has a radius of 1. 
<P>
   Assume that in a given context and at a given point in time, the property 
   mapping is such that <CODE>Center</CODE> maps to a point property value which 
   evaluates to <CODE>p</CODE>, <CODE>Normal</CODE> maps to a point property value which evaluates 
   to <CODE>n</CODE>, and <CODE>Radius</CODE> maps to a real property value which evaluates to <CODE>r</CODE>.
   <CODE>p</CODE>, <CODE>n</CODE>, and <CODE>r</CODE> define the position and shape of the disk 
   in this context and at this time as shown below:
   \begin{center}
   \begin{tabular}{c}
   \psfig{figure=images/DiskGO.ps,silent=}
   \end{tabular}
   \end{center}
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DiskGO.m3#New">New</A> (p : Point3.T; n : Point3.T; r : REAL; prec := 10) : T;
</PRE><BLOCKQUOTE><EM> <CODE>New(p,n,r,prec)</CODE> creates a new disk, whose surface is approximated by a 
   polygon with <CODE>prec</CODE> edges, and returns it. It also attaches the following 
   properties to the new cone:
    \begin{verbatim}
     (Center,PointProp.NewConst(p))
     (Normal,PointProp.NewConst(n))
     (Radius,RealProp.NewConst(r))
   \end{verbatim}
</EM></BLOCKQUOTE><PRE>
</PRE> The following three procedures provide sugaring to attach 
   <CODE>Center</CODE>, <CODE>Normal</CODE>, and <CODE>Radius</CODE> properties with non-animated 
   property values to geometric objects: 

<P><PRE>PROCEDURE <A HREF="DiskGO.m3#SetCenter">SetCenter</A> (o : GO.T; p : Point3.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetCenter(o,p)</CODE> is equivalent to
   <CODE>o.setProp(Center.bind(PointProp.NewConst(p)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DiskGO.m3#SetNormal">SetNormal</A> (o : GO.T; p : Point3.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetNormal(o,p)</CODE> is equivalent to
   <CODE>o.setProp(Normal.bind(PointProp.NewConst(p))))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DiskGO.m3#SetRadius">SetRadius</A> (o : GO.T; r : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetRadius(o,r)</CODE>is equivalent to
   <CODE>o.setProp(Radius.bind(RealProp.NewConst(r))</CODE>. </EM></BLOCKQUOTE><PRE>

END DiskGO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
