<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/DiskGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/DiskGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P><PRE>MODULE <module>DiskGO</module> EXPORTS <A HREF="DiskGO.i3"><implements>DiskGO</A></implements>, <A HREF="DiskGOProxy.i3"><implements>DiskGOProxy</A></implements>;

IMPORT <A HREF="GO.i3">GO</A>, <A HREF="GOPrivate.i3">GOPrivate</A>, <A HREF="GraphicsState.i3">GraphicsState</A>, <A HREF="Matrix4.i3">Matrix4</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="PointProp.i3">PointProp</A>,
       <A HREF="PointPropPrivate.i3">PointPropPrivate</A>, <A HREF="Prop.i3">Prop</A>, <A HREF="RealProp.i3">RealProp</A>, <A HREF="RealPropPrivate.i3">RealPropPrivate</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
    prec   : INTEGER;
    matrix : Matrix4.T;      (* transforms unit sphere into desired sphere *)
    center : Point3.T;       (* center achieved through matrix *)
    normal : Point3.T;       (* normal achieved through matrix *)
    radius : REAL;           (* radius achieved through matrix *)
  OVERRIDES
    init              := Init;
    draw              := Draw;
    damageIfDependent := DamageIfDependent;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T; prec : INTEGER) : T =
  BEGIN
    EVAL GO.T.init (self);
    self.prec   := prec;
    self.matrix := Matrix4.Identity ();
    self.center := Point3.T {0.0, 0.0, 0.0};
    self.normal := Point3.T {0.0, 0.0, 1.0};
    self.radius := 1.0;

    IF MkProxyT # NIL AND self.proxy = NIL THEN
      MkProxyT (self);
    END;

    RETURN self;
  END Init;

PROCEDURE <A NAME="DamageIfDependent"><procedure>DamageIfDependent</procedure></A> (self : T; pn : Prop.Name) =
  BEGIN
    IF pn = Center OR pn = Normal OR pn = Radius THEN
      self.damaged := TRUE;
    END;
  END DamageIfDependent;

PROCEDURE <A NAME="Draw"><procedure>Draw</procedure></A> (self : T; state : GraphicsState.T) =
  BEGIN
    state.push (self);
    WITH center = Center.getState (state),
         normal = Normal.getState (state),
         radius = Radius.getState (state) DO

      IF center # self.center OR normal # self.normal OR radius # self.radius THEN
        self.center := center;
        self.normal := normal;
        self.radius := radius;
        WITH s = Point3.OrthoVector (normal),
             t = Point3.CrossProduct (normal, s),
             a = Point3.Plus (center, Point3.ScaleToLen (s, radius)),
             b = Point3.Plus (center, Point3.ScaleToLen (t, radius)),
             c = Point3.Plus (center, normal) DO
          self.matrix := Matrix4.TransformUnitCube (center, a, b, c);
        END;
      END;

      state.pushMatrix (self.matrix);
      state.drawProtoDisk (self.prec);
      state.popMatrix ();
      state.growBoundingVolume (center, radius);
    END;

    self.damaged := FALSE;
    state.pop (self);
  END Draw;
</PRE>***************************************************************************
 Convenience Procedures                                                    
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="New"><procedure>New</procedure></A> (p : Point3.T; n : Point3.T; r : REAL; prec := 10) : T =
  VAR
    disk := NEW (T).init (prec);
  BEGIN
    SetCenter (disk, p);
    SetNormal (disk, n);
    SetRadius (disk, r);
    RETURN disk;
  END New;

PROCEDURE <A NAME="SetCenter"><procedure>SetCenter</procedure></A> (o : GO.T; v : Point3.T) =
  BEGIN
    o.setProp (Center.bind (PointProp.NewConst (v)));
  END SetCenter;

PROCEDURE <A NAME="SetNormal"><procedure>SetNormal</procedure></A> (o : GO.T; v : Point3.T) =
  BEGIN
    o.setProp (Normal.bind (PointProp.NewConst (v)));
  END SetNormal;

PROCEDURE <A NAME="SetRadius"><procedure>SetRadius</procedure></A> (o : GO.T; v : REAL) =
  BEGIN
    o.setProp (Radius.bind (RealProp.NewConst (v)));
  END SetRadius;

BEGIN
  Center := NEW (PointProp.Name).init (Point3.T {0.0, 0.0, 0.0});
  Normal := NEW (PointProp.Name).init (Point3.T {0.0, 0.0, 1.0});
  Radius := NEW (RealProp.Name).init (1.0);
END DiskGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
