<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/GO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/GO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    
<PRE>&lt;* PRAGMA LL *&gt;
</PRE> Geometric objects are one of two main concepts in the 3D animation 
   libraries (properties being the other one). A geometric object is an
   object in the scene we are viewing: a visible object such a line, 
   a sphere, or a torus, an invisible object such as a light source 
   (lights affect other objects, but are themselves invisible) or a 
   camera, or a group of other geometric objects. 
<P>
   <CODE>GO.T</CODE> is the abstract class of geometric objects. 

<P><PRE>INTERFACE <interface><A HREF="GO.m3">GO</A></interface>;

IMPORT <A HREF="KeyCB.i3">KeyCB</A>, <A HREF="MouseCB.i3">MouseCB</A>, <A HREF="Prop.i3">Prop</A>, <A HREF="ProxiedObj.i3">ProxiedObj</A>, <A HREF="PositionCB.i3">PositionCB</A>, <A HREF="TransformProp.i3">TransformProp</A>;

EXCEPTION PropUndefined;
EXCEPTION StackError;

TYPE
  Shape = {Complex, NonConvex, Convex, Unknown};
</PRE><BLOCKQUOTE><EM> <CODE>Shape</CODE> is used to provide shape hints to some type geometric objects 
   that are composed of polygons (right now, \type{PolygonGO}{T} and 
   \type{QuadMeshGO}{T}).
   <CODE>Convex</CODE> indicates that the object is composed of convex polygons,
   <CODE>NonConvex</CODE> indicates that the object is composed on non-convex polygons 
   that have non-intersecting border lines, <CODE>Convex</CODE> indicates that the 
   object is composed on non-convex polygons that may have intersecting 
   border lines, <CODE>Unknown</CODE> indicates that the shape of the object is unknown.
</EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="GO.m3#T">T</A> &lt;: Public;
  Public = ProxiedObj.T OBJECT
  METHODS
    init () : T;

    setProp (p : Prop.T);
    unsetProp (pn : Prop.Name) RAISES {PropUndefined};
    getProp (pn : Prop.Name) : Prop.Val RAISES {PropUndefined};

    setName (name : TEXT);
    getName () : TEXT;
    findName (name : TEXT) : T;        &lt;* LL = &quot;all roots of self&quot; *&gt;

    pushMouseCB (cb : MouseCB.T);
    popMouseCB () RAISES {StackError};
    removeMouseCB (cb : MouseCB.T) RAISES {StackError};
    invokeMouseCB (mr : MouseCB.Rec);

    pushPositionCB (cb : PositionCB.T);
    popPositionCB () RAISES {StackError};
    removePositionCB (cb : PositionCB.T) RAISES {StackError};
    invokePositionCB (pr : PositionCB.Rec);

    pushKeyCB (cb : KeyCB.T);
    popKeyCB () RAISES {StackError};
    removeKeyCB (cb : KeyCB.T) RAISES {StackError};
    invokeKeyCB (kr : KeyCB.Rec);
  END;
</PRE> Associated with each geometric object <CODE>o</CODE> is a property mapping $M_o$.
   A property mapping is a partial function that maps property names to 
   property values.
   We say ``<CODE>pn</CODE> is associated with <CODE>pv</CODE>'' if $M_o$(<CODE>pn</CODE>) = <CODE>pv</CODE>.
   We also say that (<CODE>pn</CODE>,<CODE>pv</CODE>) is attached to the geometric object.
<P>
   Name/Value associations in the property mapping are guaranteed to be
   compatible, i.e. a properity name of type \type{PointProp}{Name} will be 
   associated with a value of type \type{PointProp}{Val}. 
<P>
   <CODE>o.setProp(p)</CODE> attaches the property <CODE>p</CODE> to <CODE>o</CODE>. 
<P>
   If $M_o$(<CODE>pn</CODE>) = <CODE>pv</CODE>, then <CODE>o.unsetProp(pn)</CODE> detaches 
   (<CODE>pn</CODE>,<CODE>pv</CODE>) from <CODE>o</CODE>, that is, $M_o$(<CODE>pn</CODE>) will be undefined afterwards.
   If $M_o$(<CODE>pn</CODE>) is undefined, then <CODE>o.unsetProp(pn)</CODE> raises the
   exception <CODE>PropUndefined</CODE>.
<P>
   If $M_o$(<CODE>pn</CODE>) = <CODE>pv</CODE>, then <CODE>o.getProp(pn)</CODE> returns <CODE>pv</CODE>.
   If $M_o$(<CODE>pn</CODE>) is undefined, then <CODE>o.getProp(pn)</CODE> raises <CODE>PropUndefined</CODE>. 
<P>
   Geometric objects can have names, i.e.\ strings that identify them. Names 
   provide a convenient way to find a geometric object within a scene DAG. 
   No two GOs with a common ancestor should have the same name; however,
   this is not enforced. 
<P>
   When a geometric object is created, no name is associated with it. 
   <CODE>o.setName(name)</CODE> associates the name <CODE>name</CODE> with the object <CODE>o</CODE>.
   <CODE>o.getName()</CODE> returns <CODE>o</CODE>'s name (<CODE>NIL</CODE> if no name is associated with <CODE>o</CODE>).
   <CODE>o.findName(name)</CODE> returns a descendent of <CODE>o</CODE> with name <CODE>name</CODE> if there
   is one, <CODE>NIL</CODE> otherwise.
<P>
   Geometric objects are reactive. A {\em callback object} is an object 
   that responds to a particular kind of events. Currently, there are four 
   types of callback objects: \type{MouseCB}{T} (objects that handle mouse 
   button presses and releases), \type{PositionCB}{T} (objects that handle 
   mouse movements), and \type{KeyCB}{T} (objects that handle key presses and 
   releases). 
<P>
   Associated with each geometric object are four {\em callback object stacks},
   one for each type of callback object. When a mouse/position/key/click
   event is delivered to <CODE>o</CODE>, the top callback object on the corresponding 
   stack is invoked to handle it. If there is no such object, the event is 
   dropped.
<P>
   Having stacks of callback objects rather than single callback objects
   makes it easier to temporally change the behavior of a geometric object 
   and later on to reestablish its old behavior (simply by popping the stack).
<P>
   <CODE>o.pushMouseCB(cb)</CODE> pushes a mouse callback object <CODE>cb</CODE> onto <CODE>o's</CODE>
   mouse callback stack. 
<P>
   <CODE>o.popMouseCB()</CODE> removes the top callback object from <CODE>o</CODE>'s mouse
   callback stack. If the stack is empty, <CODE>StackError</CODE> is raised.
<P>
   <CODE>o.removeMouseCB(cb)</CODE> removes the callback object <CODE>cb</CODE> from <CODE>o</CODE>'s mouse
   callback stack. If <CODE>cb</CODE> is not in the stack, <CODE>StackError</CODE> is raised.
<P>
   <CODE>o.invokeMouseCB(mr)</CODE> invokes the top callback object on <CODE>o</CODE>'s mouse
   callback stack with argument <CODE>mr</CODE>.
<P>
   The remaining methods perform analogous tasks for position, and key 
   callbacks.
<P>
   {\em The event handling model is largely untested. It is probably
   the least stable part of the interface. Expect changes to <CODE>...CB.T</CODE>,
   <CODE>...CB.Rec</CODE>, and the <CODE>invoke...CB</CODE> methods.} 

<P><PRE>VAR
  Transform : TransformProp.Name;
</PRE><BLOCKQUOTE><EM> <CODE>Transform</CODE> is the name of the transformation property, a property that
   applies to all geometric objects. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="GO.m3#GetTransform">GetTransform</A> (o : T) : TransformProp.Val RAISES {PropUndefined};
</PRE><BLOCKQUOTE><EM> <CODE>GetTransform</CODE> is a convenience procedure for looking up the transformation 
   property value of a geometric object. The expression <CODE>GetTransform (o)</CODE> is 
   equivalent to <CODE>NARROW (o.getProp (Transform), TransformProp.Val)</CODE>. </EM></BLOCKQUOTE><PRE>

END GO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
