<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/GO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/GO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P><PRE>MODULE <module>GO</module> EXPORTS <A HREF="GO.i3"><implements>GO</A></implements>, <A HREF="GOPrivate.i3"><implements>GOPrivate</A></implements>;

IMPORT <A HREF="AnimServer.i3">AnimServer</A>, <A HREF="CB.i3">CB</A>, <A HREF="GraphicsState.i3">GraphicsState</A>, <A HREF="GraphicsStatePrivate.i3">GraphicsStatePrivate</A>,
       <A HREF="KeyCB.i3">KeyCB</A>, <A HREF="../derived/KeyCBStack.i3">KeyCBStack</A>, <A HREF="Matrix4.i3">Matrix4</A>, <A HREF="MouseCB.i3">MouseCB</A>, <A HREF="../derived/MouseCBStack.i3">MouseCBStack</A>, <A HREF="PositionCB.i3">PositionCB</A>,
       <A HREF="../derived/PositionCBStack.i3">PositionCBStack</A>, <A HREF="Prop.i3">Prop</A>, <A HREF="PropList.i3">PropList</A>, <A HREF="PropPrivate.i3">PropPrivate</A>, <A HREF="RealProp.i3">RealProp</A>,
       <A HREF="RealPropPrivate.i3">RealPropPrivate</A>, <A HREF="SurfaceGO.i3">SurfaceGO</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="TransformProp.i3">TransformProp</A>, <A HREF="TransformPropPrivate.i3">TransformPropPrivate</A>;

REVEAL
  <A NAME="T">T</A> = Private BRANDED OBJECT
  OVERRIDES
    init := Init;

    setProp   := SetProp;
    unsetProp := UnsetProp;
    getProp   := GetProp;

    setName  := SetName;
    getName  := GetName;
    findName := FindName;

    pushMouseCB   := PushMouseCB;
    popMouseCB    := PopMouseCB;
    removeMouseCB := RemoveMouseCB;
    invokeMouseCB := InvokeMouseCB;

    pushPositionCB   := PushPositionCB;
    popPositionCB    := PopPositionCB;
    removePositionCB := RemovePositionCB;
    invokePositionCB := InvokePositionCB;

    pushKeyCB   := PushKeyCB;
    popKeyCB    := PopKeyCB;
    removeKeyCB := RemoveKeyCB;
    invokeKeyCB := InvokeKeyCB;

    damageIfDependent    := DamageIfDependent;
    adjust               := Adjust;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T) : T =
  BEGIN
    self.props   := NIL;
    self.damaged := TRUE;
    self.name    := NIL;
    self.dl      := NIL;

    self.mouseCBstack    := NEW (MouseCBStack.T).init ();
    self.positionCBstack := NEW (PositionCBStack.T).init ();
    self.keyCBstack      := NEW (KeyCBStack.T).init ();

    RETURN self;
  END Init;
</PRE>***************************************************************************
 Property-related methods                                                  
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetProp"><procedure>SetProp</procedure></A> (self : T; p : Prop.T) =
  VAR
    tmp : PropList.T;
  BEGIN
    (*** Must be protected from interference with the animation server ***)
    LOCK AnimServer.internalLock DO

      (* Damage the object and/or its descendents. The damage is propagated
         to the roots by the next call to &quot;root.adjust (now)&quot; *)
      p.n.damage (self);

      tmp := self.props;
      WHILE tmp # NIL DO
        IF tmp.head.n = p.n THEN
          tmp.head.v := p.v;
          RETURN;
        END;
        tmp := tmp.tail;
      END;
      self.props := PropList.Cons (p, self.props);
    END;
  END SetProp;

PROCEDURE <A NAME="UnsetProp"><procedure>UnsetProp</procedure></A> (self : T; pn : Prop.Name) RAISES {PropUndefined} =
  VAR
    pv : Prop.Val;

  PROCEDURE Unset (VAR plist : PropList.T) RAISES {PropUndefined} =
    BEGIN
      IF plist = NIL THEN
        RAISE PropUndefined;
      ELSIF plist.head.n = pn THEN
        pv := plist.head.v;
        plist := plist.tail;
      ELSE
        Unset (plist.tail);
      END;
    END Unset;

  BEGIN
    (*** Must be protected from interference with the animation server ***)
    LOCK AnimServer.internalLock DO

      (*** if (pn,pv) is a transmission coeff, void the cache ***)
      IF pn = SurfaceGO.TransmissionCoeff THEN
        self.trans := FIRST (REAL);
      END;
      Unset (self.props);

      (* Damage the object and/or its descendents. The damage is propagated
         to the roots by the next call to &quot;root.adjust (now)&quot; *)
      pn.damage (self);
    END;
  END UnsetProp;

PROCEDURE <A NAME="GetProp"><procedure>GetProp</procedure></A> (self : T; pn : Prop.Name) : Prop.Val
    RAISES {PropUndefined} =
  VAR
    tmp : PropList.T;
  BEGIN
    (* No interference with the animation server. Possible interference with
       other client threads; client code has to provide adequate protection. *)

    tmp := self.props;
    WHILE tmp # NIL DO
      IF tmp.head.n = pn THEN
        RETURN tmp.head.v;
      END;
      tmp := tmp.tail;
    END;
    RAISE PropUndefined;
  END GetProp;
</PRE>***************************************************************************
 Name-related methods                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetName"><procedure>SetName</procedure></A> (self : T; name : TEXT) =
  BEGIN
    self.name := name;
  END SetName;

PROCEDURE <A NAME="GetName"><procedure>GetName</procedure></A> (self : T) : TEXT =
  BEGIN
    RETURN self.name;
  END GetName;

PROCEDURE <A NAME="FindName"><procedure>FindName</procedure></A> (self : T; name : TEXT) : T =
  BEGIN
    IF self.name # NIL AND Text.Equal (self.name, name) THEN
      RETURN self;
    ELSE
      RETURN NIL;
    END;
  END FindName;
</PRE>***************************************************************************
 Callback-related methods                                                  
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="PushMouseCB"><procedure>PushMouseCB</procedure></A> (self : T; cb : MouseCB.T) =
  BEGIN
    self.mouseCBstack.push (cb);
  END PushMouseCB;

PROCEDURE <A NAME="PopMouseCB"><procedure>PopMouseCB</procedure></A> (self : T) RAISES {StackError} =
  BEGIN
    self.mouseCBstack.pop ();
  END PopMouseCB;

PROCEDURE <A NAME="RemoveMouseCB"><procedure>RemoveMouseCB</procedure></A> (self : T; cb : MouseCB.T) RAISES {StackError} =
  BEGIN
    self.mouseCBstack.remove (cb);
  END RemoveMouseCB;

PROCEDURE <A NAME="InvokeMouseCB"><procedure>InvokeMouseCB</procedure></A> (self : T; mr : MouseCB.Rec) =
  BEGIN
    TRY
      self.mouseCBstack.invokeTop (mr);
    EXCEPT
      CB.BadMethod (msg) =&gt; AnimServer.ReportError (msg);
    END;
  END InvokeMouseCB;

PROCEDURE <A NAME="PushPositionCB"><procedure>PushPositionCB</procedure></A> (self : T; cb : PositionCB.T) =
  BEGIN
    self.positionCBstack.push (cb);
  END PushPositionCB;

PROCEDURE <A NAME="PopPositionCB"><procedure>PopPositionCB</procedure></A> (self : T) RAISES {StackError} =
  BEGIN
    self.positionCBstack.pop ();
  END PopPositionCB;

PROCEDURE <A NAME="RemovePositionCB"><procedure>RemovePositionCB</procedure></A> (self : T; cb : PositionCB.T) RAISES {StackError} =
  BEGIN
    self.positionCBstack.remove (cb);
  END RemovePositionCB;

PROCEDURE <A NAME="InvokePositionCB"><procedure>InvokePositionCB</procedure></A> (self : T; pr : PositionCB.Rec) =
  BEGIN
    TRY
      self.positionCBstack.invokeTop (pr);
    EXCEPT
      CB.BadMethod (msg) =&gt; AnimServer.ReportError (msg);
    END;
  END InvokePositionCB;

PROCEDURE <A NAME="PushKeyCB"><procedure>PushKeyCB</procedure></A> (self : T; cb : KeyCB.T) =
  BEGIN
    self.keyCBstack.push (cb);
  END PushKeyCB;

PROCEDURE <A NAME="PopKeyCB"><procedure>PopKeyCB</procedure></A> (self : T) RAISES {StackError} =
  BEGIN
    self.keyCBstack.pop ();
  END PopKeyCB;

PROCEDURE <A NAME="RemoveKeyCB"><procedure>RemoveKeyCB</procedure></A> (self : T; cb : KeyCB.T) RAISES {StackError} =
  BEGIN
    self.keyCBstack.remove (cb);
  END RemoveKeyCB;

PROCEDURE <A NAME="InvokeKeyCB"><procedure>InvokeKeyCB</procedure></A> (self : T; kr : KeyCB.Rec) =
  BEGIN
    TRY
      self.keyCBstack.invokeTop (kr);
    EXCEPT
      CB.BadMethod (msg) =&gt; AnimServer.ReportError (msg);
    END;
  END InvokeKeyCB;
</PRE>***************************************************************************
 Rendering-related methods                                                 
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="DamageIfDependent"><procedure>DamageIfDependent</procedure></A> (&lt;* UNUSED *&gt; self : T;
                             &lt;* UNUSED *&gt; pn   : Prop.Name) =
  BEGIN
    (* by default, a GO is not interested in anything *)
  END DamageIfDependent;

PROCEDURE <A NAME="Adjust"><procedure>Adjust</procedure></A> (self : T; time : LONGREAL) =
  VAR
    props := self.props;
  BEGIN
    self.trans := FIRST (REAL);
    WHILE props # NIL DO
      props.head.adjust (time, self);

      (* if there is a transmission coefficient attached, cache it *)
      IF props.head.n = SurfaceGO.TransmissionCoeff THEN
        self.trans := NARROW (props.head.v, RealProp.Val).val;
      END;

      props := props.tail;
    END;
  END Adjust;
</PRE>***************************************************************************
 TransformPN                                                               
***************************************************************************

<P><PRE>TYPE
  Transform_PN = TransformProp.Name OBJECT
  OVERRIDES
    damage  := DamageTransform;
    push    := PushTransform;
    pop     := PopTransform;
  END;

PROCEDURE <A NAME="DamageTransform"><procedure>DamageTransform</procedure></A> (self : Transform_PN; caller : T) =
  BEGIN
    caller.damaged := TRUE;           (* damage the caller *)
    caller.damageIfDependent (self);  (* ... and maybe some of its children *)
  END DamageTransform;

PROCEDURE <A NAME="PushTransform"><procedure>PushTransform</procedure></A> (self  : Transform_PN;
                         state : GraphicsState.T;
                         pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], TransformPropPrivate.Stack),
         m = NARROW (pv, TransformProp.Val).val DO

      (*** push the matrix ***)
      state.pushMatrix (m);

      (* Push the composite transformation matrix onto the state stack.
         This matrix differs from the local transformation matrix on top
         of the PEX matrix stack. *)
      stack.push (Matrix4.Multiply (stack.top, m));
    END;

  END PushTransform;

PROCEDURE <A NAME="PopTransform"><procedure>PopTransform</procedure></A> (self  : Transform_PN; state : GraphicsState.T) =
  BEGIN
    (*** pop the matrix ***)
    state.popMatrix ();
    EVAL NARROW (state.stacks[self.id], TransformPropPrivate.Stack).pop();
  END PopTransform;
</PRE>***************************************************************************
 Convenience procedures                                                    
***************************************************************************

<P><PRE>PROCEDURE <A NAME="GetTransform"><procedure>GetTransform</procedure></A> (o : T) : TransformProp.Val RAISES {PropUndefined} =
  BEGIN
    RETURN NARROW (o.getProp (Transform), TransformProp.Val);
  END GetTransform;
</PRE>***************************************************************************
 Module body                                                               
***************************************************************************

<P><PRE>BEGIN
  Transform := NEW (Transform_PN).init (Matrix4.Id);
END GO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
