<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/GOPrivate.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/GOPrivate.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P><PRE>INTERFACE <interface><A HREF="GO.m3">GOPrivate</A></interface>;

IMPORT <A HREF="GraphicsState.i3">GraphicsState</A>, <A HREF="../derived/KeyCBStack.i3">KeyCBStack</A>, <A HREF="../derived/MouseCBStack.i3">MouseCBStack</A>, <A HREF="../derived/PositionCBStack.i3">PositionCBStack</A>, <A HREF="Prop.i3">Prop</A>,
       <A HREF="PropList.i3">PropList</A>;

FROM <A HREF="GO.i3">GO</A> IMPORT T, Public;

REVEAL
  T &lt;: Private;

TYPE
  Private = Public BRANDED OBJECT
    props : PropList.T;
    trans : REAL;   (* FIRST(REAL) means: no transmission coeff in props *)
    name  : TEXT;

    mouseCBstack    : MouseCBStack.T;
    positionCBstack : PositionCBStack.T;
    keyCBstack      : KeyCBStack.T;

    damaged         : BOOLEAN;
    dl              : REFANY;   (* A wrapper around a PEX &quot;Structure&quot;
                                   or an OpenGL &quot;Display List&quot; *)
  METHODS
    draw (state : GraphicsState.T);
    needsTransparency (t : REAL) : BOOLEAN;

    damageIfDependent (pn : Prop.Name);
    adjust (time : LONGREAL);
  END;
</PRE> <CODE>go.damageIfDependent(pn)</CODE> leaves a damage trail from <CODE>go</CODE> to all 
   descendants of <CODE>go</CODE> (including <CODE>go</CODE>) that depend on <CODE>pn</CODE>. 
<P>
   <CODE>go.adjust(time)</CODE> reevaluates all property values attached to <CODE>go</CODE> and
   its descendants, based on the given time. It also might add damages to 
   the scene, either to <CODE>go</CODE> or to some of its children. Damaging a node
   causes damage to all its ancestors as well. 

<P><PRE>END GOPrivate.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
