<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/GraphicsBasePrivate.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/GraphicsBasePrivate.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Wed Feb 16 17:57:52 PST 1994 by najork                   

<P><PRE>INTERFACE <interface>GraphicsBasePrivate</interface>;

IMPORT <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="ProxiedObj.i3">ProxiedObj</A>, <A HREF="RootGO.i3">RootGO</A>;

FROM <A HREF="GraphicsBase.i3">GraphicsBase</A> IMPORT T;

REVEAL <A NAME="T">T</A> = Private;

TYPE
  Private = ProxiedObj.T BRANDED OBJECT
    root   : RootGO.T := NIL;
    status : Status   := Status.Unmapped;
  METHODS
    setBackgroundColor (color : Color.T);
    unmap ();
    processEvents ();
    repair (VAR damaged : BOOLEAN);
  END;
</PRE> <CODE>base.repair(damaged)</CODE> redraws the scene rooted at <CODE>base.root</CODE>. Only those
   nodes that were marked as damaged are re-rendered, for the other nodes,
   cached values are used. 
<P>
   Nodes can be damaged in two ways: 
   \begin{enumerate}
   \item By operations that change the scene DAG (i.e.\ the group operations
         <CODE>add</CODE>, <CODE>remove</CODE>, and <CODE>flush</CODE>).
   \item By changes in the value of an attached property. 
   \end{enumerate}
<P>
   Calling <CODE>root.adjust(time)</CODE> serves two purposes: It reevaluates all the 
   properties attached to all descendants of <CODE>root</CODE>, and damages those nodes 
   whose properties have changed since the last round of rendering. It also
   propagates damages up the scene DAGs.
       <CODE>
   </CODE>base.repair(damaged)<CODE> is called after all roots have been adjusted. The 
   VAR parameter </CODE>damaged<CODE> is set to TRUE if there were any damages in the 
   scene, otherwise, it remains unchanged. 

<P><PRE>TYPE Status = {Unmapped, Mapped, Destroyed};

END GraphicsBasePrivate.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
