<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/GraphicsState.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/GraphicsState.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Wed Jan 26 15:14:17 PST 1994 by najork                   

<P>
<P><PRE>INTERFACE <interface><A HREF="GraphicsState.m3">GraphicsState</A></interface>;

IMPORT <A HREF="BSphere.i3">BSphere</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="GO.i3">GO</A>, <A HREF="LineTypeProp.i3">LineTypeProp</A>, <A HREF="MarkerTypeProp.i3">MarkerTypeProp</A>, <A HREF="Matrix4.i3">Matrix4</A>, <A HREF="Point3.i3">Point3</A>,
       <A HREF="RasterModeProp.i3">RasterModeProp</A>, <A HREF="ShadingProp.i3">ShadingProp</A>;

TYPE
  <A HREF="GraphicsState.m3#T">T</A> &lt;: Public;
  Public = MUTEX OBJECT
  METHODS
    (*** Pushing and popping property lists onto the state **)
    push (caller : GO.T);
    pop (caller : GO.T);

    (*** Display Lists ***)
    openDisplayList (go : GO.T);
    closeDisplayList ();
    callDisplayList (go : GO.T);

    (*** The matrix stack ***)
    pushMatrix (READONLY matrix : Matrix4.T);
    popMatrix ();

    (* Bounding volumes *)
    resetBoundingVolume ();
    growBoundingVolume (center : Point3.T; radius : REAL);
    getBoundingVolume () : BSphere.T;

    (*** Graphics Commands (PEX specific?) ***)
    setMarkerColor (val : Color.T);
    setMarkerScale (val : REAL);
    setMarkerType  (val : MarkerTypeProp.Kind);

    setLineColor (val : Color.T);
    setLineWidth (val : REAL);
    setLineType  (val : LineTypeProp.Kind);

    setSurfaceColor (val : Color.T);
    setRasterMode (val : RasterModeProp.Kind);
    setDistinguishFacetsFlag (val : BOOLEAN);
    setLighting (val : BOOLEAN);
    setShading (val : ShadingProp.Kind);
    setSurfaceEdgeFlag (val : BOOLEAN);
    setSurfaceEdgeColor (val : Color.T);
    setSurfaceEdgeType (val : LineTypeProp.Kind);
    setSurfaceEdgeWidth (val : REAL);

    setAmbientReflCoeff (val : REAL);
    setDiffuseReflCoeff (val : REAL);
    setSpecularReflCoeff (val : REAL);
    setSpecularReflConc (val : REAL);
    setSpecularReflColor (val : Color.T);
    setTransmissionCoeff (val : REAL);

    drawMarker (p : Point3.T);
    drawLine (p1, p2 : Point3.T);
    drawPolygon (READONLY pts : ARRAY OF Point3.T; shape : GO.Shape);
    drawQuadMesh (READONLY pts : ARRAY OF ARRAY OF Point3.T; shape : GO.Shape);

    drawProtoSphere (prec : INTEGER);
    drawProtoCone (prec : INTEGER);
    drawProtoCylinder (prec : INTEGER);
    drawProtoDisk (prec : INTEGER);
    drawProtoTorus (prec: INTEGER; radiusRatio : REAL);
  END;

END GraphicsState.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
