<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/GraphicsState.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/GraphicsState.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Wed Jan 26 15:20:34 PST 1994 by najork                   

<P>
<P><PRE>UNSAFE MODULE <module>GraphicsState</module> EXPORTS <A HREF="GraphicsState.i3"><implements>GraphicsState</A></implements>,
                                    <A HREF="GraphicsStatePrivate.i3"><implements>GraphicsStatePrivate</A></implements>,
                                    <A HREF="GraphicsStatePex.i3"><implements>GraphicsStatePex</A></implements>;

IMPORT <A HREF="AuxG.i3">AuxG</A>, <A HREF="BSphere.i3">BSphere</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="ColorPropPrivate.i3">ColorPropPrivate</A>, <A HREF="../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="GO.i3">GO</A>, <A HREF="GOPrivate.i3">GOPrivate</A>, <A HREF="LineGO.i3">LineGO</A>,
       <A HREF="LineTypeProp.i3">LineTypeProp</A>, <A HREF="MarkerGO.i3">MarkerGO</A>, <A HREF="MarkerTypeProp.i3">MarkerTypeProp</A>, <A HREF="../../arith/src/Math.i3">Math</A>, <A HREF="Matrix4.i3">Matrix4</A>, <A HREF="../../PEX/src/PEX.i3">PEX</A>, <A HREF="Point3.i3">Point3</A>,
       <A HREF="PropPrivate.i3">PropPrivate</A>, <A HREF="RasterModeProp.i3">RasterModeProp</A>, <A HREF="RealPropPrivate.i3">RealPropPrivate</A>, <A HREF="ShadingProp.i3">ShadingProp</A>, <A HREF="SurfaceGO.i3">SurfaceGO</A>,
       <A HREF="TransformPropPrivate.i3">TransformPropPrivate</A>, <A HREF="../../weakref/src/WeakRef.i3">WeakRef</A>, <A HREF="../../X11R4/src/Common/X.i3">X</A>;

REVEAL
  <A NAME="T">T</A> = PexSpecific BRANDED OBJECT
    stateSize : INTEGER;
  (*** Things associated with light sources ***)
    lia           : REF ARRAY OF PEX.pxlTableIndex;
                             (* The &quot;light index array&quot; *)
    lastLightSlot : INTEGER; (* The last slot used during a particular draw *)
    maxLights     : INTEGER; (* The highest used index into lightLut *)

  (*** Things associated with display lists ***)
    ocbufStack       : OcbufStack;
    ocbufStackPtr    : INTEGER;
  (*** Things associated with the matrix stack (PEX-specific) ***)
    matrixStack      : MatrixStack;
    matrixStackTop   : INTEGER;
  (* bounding volume stuff *)
    b_vol_min        : Point3.T;
    b_vol_max        : Point3.T;
  (*** need to accumulate some PEX state ***)
    surfRefl         : PEX.pxlReflectionAttr;    (* USED FOR A DIRTY HACK *)
  (*** caching of PEX structures for prototypical objects ***)
    sphereStructures   : StructureList := NIL;
    coneStructures     : StructureList := NIL;
    cylinderStructures : StructureList := NIL;
    diskStructures     : StructureList := NIL;
    torusStructures    : TorusStructureList := NIL;
  OVERRIDES
    init             := Init;
    setup            := Setup;
    push             := Push;
    pop              := Pop;
    addLight         := AddLight;
    establishLights  := EstablishLights;

    openDisplayList  := OpenDisplayList;
    closeDisplayList := CloseDisplayList;
    callDisplayList  := CallDisplayList;

    pushMatrix       := PushMatrix;
    popMatrix        := PopMatrix;

    resetBoundingVolume := ResetBoundingVolume;
    growBoundingVolume  := GrowBoundingVolume;
    getBoundingVolume   := GetBoundingVolume;

    setMarkerColor           := SetMarkerColor;
    setMarkerScale           := SetMarkerScale;
    setMarkerType            := SetMarkerType;
    setLineColor             := SetLineColor;
    setLineWidth             := SetLineWidth;
    setLineType              := SetLineType;
    setSurfaceColor          := SetSurfaceColor;
    setRasterMode            := SetRasterMode;
    setDistinguishFacetsFlag := SetDistinguishFacetsFlag;
    setLighting              := SetLighting;
    setShading               := SetShading;
    setSurfaceEdgeFlag       := SetSurfaceEdgeFlag;
    setSurfaceEdgeColor      := SetSurfaceEdgeColor;
    setSurfaceEdgeType       := SetSurfaceEdgeType;
    setSurfaceEdgeWidth      := SetSurfaceEdgeWidth;
    setAmbientReflCoeff      := SetAmbientReflCoeff;
    setDiffuseReflCoeff      := SetDiffuseReflCoeff;
    setSpecularReflCoeff     := SetSpecularReflCoeff;
    setSpecularReflConc      := SetSpecularReflConc;
    setSpecularReflColor     := SetSpecularReflColor;
    setTransmissionCoeff     := SetTransmissionCoeff;
    drawMarker               := DrawMarker;
    drawLine                 := DrawLine;
    drawPolygon              := DrawPolygon;
    drawQuadMesh             := DrawQuadMesh;
    drawProtoSphere          := DrawProtoSphere;
    drawProtoCone            := DrawProtoCone;
    drawProtoCylinder        := DrawProtoCylinder;
    drawProtoDisk            := DrawProtoDisk;
    drawProtoTorus           := DrawProtoTorus;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T; oc : PEX.pxlOCBufStar) : T =
  BEGIN
    WITH stacks = self.stacks DO
      self.oc := oc;
      stacks := PropPrivate.NewStacks ();
      self.stateSize := NUMBER (stacks^);

      self.surfRefl.ambient :=
          SurfaceGO.AmbientReflectionCoeff.getState (self);
      self.surfRefl.diffuse :=
          SurfaceGO.DiffuseReflectionCoeff.getState (self);
      self.surfRefl.specular :=
          SurfaceGO.SpecularReflectionCoeff.getState (self);
      self.surfRefl.specularConc :=
          SurfaceGO.SpecularReflectionConc.getState (self);
      self.surfRefl.transmission :=
          SurfaceGO.TransmissionCoeff.getState (self);
      WITH val = SurfaceGO.SpecularReflectionColour.getState (self) DO
        self.surfRefl.specularColour := PexColourSpecifier (val);
      END;
    END;

    (*** Initialize light-related stuff ***)
    self.maxLights := 0;
    self.lia := NEW (REF ARRAY OF PEX.pxlTableIndex, 10);
    FOR i := FIRST (self.lia^) TO LAST (self.lia^) DO
      self.lia[i] := i + 1;
    END;

    InitDisplayListManagement (self);
    InitMatrixStack (self);

    RETURN self;
  END Init;

PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A> (self : T) =
  VAR
    pexrep : PEX.pexRgbFloatColour;
  BEGIN
    WITH state = self.stacks, oc = self.oc DO
      WITH val = MarkerGO.Colour.getState (self) DO
        pexrep := PEX.pexRgbFloatColour {val.r, val.g, val.b};
        PEX.PEXSetMarkerColour (oc, ADR (pexrep));
      END;
      WITH val = LineGO.Colour.getState (self) DO
        pexrep := PEX.pexRgbFloatColour {val.r, val.g, val.b};
        PEX.PEXSetLineColour (oc, ADR (pexrep));
      END;
      WITH val = SurfaceGO.Colour.getState (self) DO
        pexrep := PEX.pexRgbFloatColour {val.r, val.g, val.b};
        PEX.PEXSetSurfaceColour (oc, ADR (pexrep));
      END;
      WITH val = SurfaceGO.EdgeColour.getState (self) DO
        pexrep := PEX.pexRgbFloatColour {val.r, val.g, val.b};
        PEX.PEXSetSurfaceEdgeColour (oc, ADR (pexrep));
      END;
      PEX.PEXSetReflectionModel        (oc, PEX.PEXReflectionSpecular);
      PEX.PEXSetInteriorStyle          (oc, PEX.PEXInteriorStyleSolid);
      PEX.PEXSetReflectionAttributes   (oc, ADR(self.surfRefl));
      PEX.PEXSetBFReflectionAttributes (oc, ADR(self.surfRefl));
    END;

    (* Reset the light counter *)
    self.lastLightSlot := 0;
  END Setup;

PROCEDURE <A NAME="Push"><procedure>Push</procedure></A> (self : T; caller : GO.T) =
  VAR
    oldSurfRefl : PEX.pxlReflectionAttr;
    props := caller.props;
  BEGIN
    oldSurfRefl := self.surfRefl;

    WHILE props # NIL DO
      WITH prop = props.head DO
        prop.refreshDamage (caller);
        prop.n.push (self, prop.v);
      END;
      props := props.tail;
    END;

    IF oldSurfRefl # self.surfRefl THEN
      PEX.PEXSetReflectionAttributes (self.oc, ADR(self.surfRefl));
      PEX.PEXSetBFReflectionAttributes (self.oc, ADR(self.surfRefl));
    END;
  END Push;

PROCEDURE <A NAME="Pop"><procedure>Pop</procedure></A> (self : T; caller : GO.T) =
  VAR
    oldSurfRefl : PEX.pxlReflectionAttr;
    props := caller.props;
  BEGIN
    oldSurfRefl := self.surfRefl;

    WHILE props # NIL DO
      props.head.n.pop (self);
      props := props.tail;
    END;

    IF oldSurfRefl # self.surfRefl THEN
      PEX.PEXSetReflectionAttributes (self.oc, ADR(self.surfRefl));
      PEX.PEXSetBFReflectionAttributes (self.oc, ADR(self.surfRefl));
    END;
  END Pop;
</PRE>***************************************************************************
 Light source management                                                   
***************************************************************************

<P><PRE>PROCEDURE <A NAME="AddLight"><procedure>AddLight</procedure></A> (self : T; READONLY light : PEX.pxlLightEntry) =
  BEGIN
    INC (self.lastLightSlot);
    self.maxLights := MAX (self.maxLights, self.lastLightSlot);
    PEX.PEXSetTableEntries (self.disp,
                            self.lightLut,
                            PEX.PEXLightLUT,
                            self.lastLightSlot,
                            1,
                            ADR (light));

    (*** Check if we need to grow the light index array ***)
    IF self.maxLights &gt; NUMBER (self.lia^) THEN
      self.lia := NEW (REF ARRAY OF PEX.pxlTableIndex, 2 * NUMBER (self.lia^));
      FOR i := FIRST (self.lia^) TO LAST (self.lia^) DO
        self.lia[i] := i + 1;
      END;
    END;
  END AddLight;

PROCEDURE <A NAME="EstablishLights"><procedure>EstablishLights</procedure></A> (self : T) =
  BEGIN
    PEX.PEXSetLightSourceState (self.lightOcBuf,
                                ADR (self.lia [0]),
                                self.lastLightSlot,
                                ADR (self.lia [self.lastLightSlot]),
                                self.maxLights - self.lastLightSlot);
  END EstablishLights;
</PRE>***************************************************************************
 Display-List management (PEX-specific)                                    
***************************************************************************

<P><PRE>TYPE
  StructureList = REF RECORD
    prec : INTEGER;
    dl   : DisplayList;
    next : StructureList;
  END;

  DisplayList = REF RECORD
    structure : PEX.pxlStructure;
    ocbuf     : PEX.pxlOCBufStar;
  END;

  DisplayListPool = REF RECORD
    dl   : DisplayList;
    next : DisplayListPool;
  END;

  OcbufStack = REF ARRAY OF PEX.pxlOCBufStar;

VAR
  dl_pool : DisplayListPool;
  (* This is a simplification. There should really be one pool per X server. *)

PROCEDURE <A NAME="InitDisplayListManagement"><procedure>InitDisplayListManagement</procedure></A> (self : T) =
  BEGIN
    (*** Create an initial output command buffer stack ***)
    self.ocbufStackPtr := 0;
    self.ocbufStack := NEW (OcbufStack, 10);
  END InitDisplayListManagement;

PROCEDURE <A NAME="OpenDisplayList"><procedure>OpenDisplayList</procedure></A> (self : T; go : GO.T) =
  VAR
    dl       : DisplayList;
    tmpStack : OcbufStack;
  BEGIN
    (*** Extract the display list associated with the GO. ***)
    IF go.dl = NIL THEN
      dl := NewDisplayList (self);
      go.dl := dl;
    ELSE
      dl := NARROW (go.dl, DisplayList);
    END;

    (*** Push the oc-buffer stack ***)
    WITH s = self.ocbufStack, p = self.ocbufStackPtr, n = NUMBER (s^) DO
      IF p &gt;= n THEN
        tmpStack := NEW (OcbufStack, 2 * n);
        SUBARRAY (tmpStack^, 0, n) := s^;
        s := tmpStack;
      END;
      s[p] := self.oc;
      INC (p);
    END;

    (*** I assume that deleting elements is cheaper than creating a new
      structure. ***)
    PEX.PEXDeleteElements (self.disp, dl.structure,
                           PEX.PEXBeginning, 0, PEX.PEXEnd, 0);

    (*** Activate the oc-buffer that leads into the structure ***)
    self.oc := dl.ocbuf;

    (*** Push an identity matrix onto the matrix stack, reflecting the
         semantics of PEXExecuteStructure, which maintains ints own
         matrix stack. ***)
    WITH s = self.matrixStack, n = NUMBER (s^), top = self.matrixStackTop DO
      INC (top);
      IF top &gt;= n THEN
        WITH tmp = NEW (MatrixStack, 2 * n) DO
          SUBARRAY (tmp^, 0, n) := s^;
          s := tmp;
        END;
      END;
      s[top] := Matrix4.Id;
    END;
  END OpenDisplayList;

PROCEDURE <A NAME="CloseDisplayList"><procedure>CloseDisplayList</procedure></A> (self : T) =
  BEGIN
    (*** pop the oc-buffer stack ***)
    WITH s = self.ocbufStack, p = self.ocbufStackPtr DO
      DEC (p);
      self.oc := s[p];
    END;

    (*** pop the identity matrix from the matrix stack ***)
    DEC (self.matrixStackTop);
  END CloseDisplayList;

PROCEDURE <A NAME="CallDisplayList"><procedure>CallDisplayList</procedure></A> (self : T; go : GO.T) =
  BEGIN
    PEX.PEXExecuteStructure (self.oc, NARROW (go.dl, DisplayList).structure);
  END CallDisplayList;

PROCEDURE <A NAME="NewDisplayList"><procedure>NewDisplayList</procedure></A> (self : T) : DisplayList =
  VAR
    dl : DisplayList;
  BEGIN
    IF dl_pool # NIL THEN
      (*** Take an unused display list from the pool ***)
      dl := dl_pool.dl;
      dl_pool := dl_pool.next;
    ELSE
      (*** The pool is empty, so create a new display list ***)
      dl := NEW (DisplayList);
      dl.structure := PEX.PEXCreateStructure (self.disp);
      dl.ocbuf := PEX.PEXAllocateTransientOCBuffer (
                              self.disp,
                              PEX.pxlAddToStructure,
                              dl.structure,
                              PEX.PEXDefaultOCError, 0);
      (*** I tried 0 and 8192, seems to not make much difference ***)
    END;

    (* Register a clean-up precedure that will be called when &quot;dl&quot; becomes
       unreachable, and will put it back into the pool *)
    EVAL WeakRef.FromRef (dl, CleanUpDisplayList);

    RETURN dl;
  END NewDisplayList;

PROCEDURE <A NAME="CleanUpDisplayList"><procedure>CleanUpDisplayList</procedure></A> (&lt;* UNUSED *&gt; READONLY w : WeakRef.T;
                                                    r : REFANY) =
  BEGIN
    dl_pool := NEW (DisplayListPool,
                    dl := NARROW (r, DisplayList),
                    next := dl_pool);
  END CleanUpDisplayList;
</PRE>***************************************************************************
 The Matrix Stack (PEX-specific)                                           
***************************************************************************

<P><PRE>TYPE
  MatrixStack = REF ARRAY OF Matrix4.T;

PROCEDURE <A NAME="InitMatrixStack"><procedure>InitMatrixStack</procedure></A> (self : T) =
  BEGIN
    self.matrixStack := NEW (MatrixStack, 32);
    PEX.PEXIdentityMatrix (ADR (self.matrixStack[0]));
    self.matrixStackTop := 0;
  END InitMatrixStack;

PROCEDURE <A NAME="PushMatrix"><procedure>PushMatrix</procedure></A> (self : T; READONLY matrix : Matrix4.T) =
  VAR
    tmp : MatrixStack;
    transformdata : PEX.pxlLocalTransform3DData;
  BEGIN
    WITH s = self.matrixStack, n = NUMBER (s^), top = self.matrixStackTop DO
      INC (top);
      IF top &gt;= n THEN
        tmp := NEW (MatrixStack, 2 * n);
        SUBARRAY (tmp^, 0, n) := s^;
        s := tmp;
      END;
      PEX.PEXMultiplyMatrices (ADR (s[top - 1]), ADR (matrix), ADR (s[top]));
      transformdata.composition := PEX.PEXReplace;
      transformdata.matrix := s[top];
      PEX.PEXSetLocalTransform (self.oc, ADR (transformdata));
    END;
  END PushMatrix;

PROCEDURE <A NAME="PopMatrix"><procedure>PopMatrix</procedure></A> (self : T) =
  VAR
    transformdata : PEX.pxlLocalTransform3DData;
  BEGIN
    DEC (self.matrixStackTop);
    transformdata.composition := PEX.PEXReplace;
    transformdata.matrix := self.matrixStack[self.matrixStackTop];
    PEX.PEXSetLocalTransform (self.oc, ADR (transformdata));
  END PopMatrix;
</PRE>***************************************************************************
 Bounding Volume Management                                                
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="ResetBoundingVolume"><procedure>ResetBoundingVolume</procedure></A> (self : T) =
  BEGIN
    self.b_vol_min := Point3.Max;
    self.b_vol_max := Point3.Min;
  END ResetBoundingVolume;

PROCEDURE <A NAME="GrowBoundingVolume"><procedure>GrowBoundingVolume</procedure></A> (self : T; center : Point3.T; radius : REAL) =
  BEGIN
    WITH A       = GO.Transform.getState(self),
         center1 = Matrix4.TransformPoint3 (A, center),
         radius1 = radius * Matrix4.UnitSphereMaxSquishFactor (A),
         min     = self.b_vol_min,
         max     = self.b_vol_max DO

      min := Point3.T {MIN (min.x, center1.x - radius1),
                       MIN (min.y, center1.y - radius1),
                       MIN (min.z, center1.z - radius1)};
      max := Point3.T {MAX (max.x, center1.x + radius1),
                       MAX (max.y, center1.y + radius1),
                       MAX (max.z, center1.z + radius1)};
    END;
  END GrowBoundingVolume;

PROCEDURE <A NAME="GetBoundingVolume"><procedure>GetBoundingVolume</procedure></A> (self : T) : BSphere.T =
  BEGIN
    WITH min = self.b_vol_min, max = self.b_vol_max DO
      IF min = Point3.Max AND max = Point3.Min THEN
        (* There are no objects with nonempty bounding boxes in the root,
           so we set the bounding sphere to a default value. *)
        RETURN BSphere.T {Point3.Origin, 0.0};
      ELSE
        (* We put a (conservative) bounding sphere around the bounding box. *)

        RETURN BSphere.T {Point3.MidPoint (min, max),
                          Point3.Distance (min, max) / 2.0};
      END;
    END;
  END GetBoundingVolume;
</PRE>***************************************************************************
 Hooks into PEX functions                                                  
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetMarkerColor"><procedure>SetMarkerColor</procedure></A> (self : T; col : Color.T) =
  VAR
    pexrep := PEX.pexRgbFloatColour {col.r, col.g, col.b};
  BEGIN
    PEX.PEXSetMarkerColour (self.oc, ADR (pexrep));
  END SetMarkerColor;

PROCEDURE <A NAME="SetMarkerScale"><procedure>SetMarkerScale</procedure></A> (self : T; scale : REAL) =
  BEGIN
    PEX.PEXSetMarkerScale (self.oc, FLOAT (scale, LONGREAL));
  END SetMarkerScale;

PROCEDURE <A NAME="SetMarkerType"><procedure>SetMarkerType</procedure></A> (self : T; type : MarkerTypeProp.Kind) =
  VAR
    pexrep : Ctypes.int;
  BEGIN
    CASE type OF
    | MarkerTypeProp.Kind.Dot      =&gt; pexrep := PEX.PEXMarkerDot;
    | MarkerTypeProp.Kind.Cross    =&gt; pexrep := PEX.PEXMarkerCross;
    | MarkerTypeProp.Kind.Asterisk =&gt; pexrep := PEX.PEXMarkerAsterisk;
    | MarkerTypeProp.Kind.Circle   =&gt; pexrep := PEX.PEXMarkerCircle;
    | MarkerTypeProp.Kind.X        =&gt; pexrep := PEX.PEXMarkerX;
    END;
    PEX.PEXSetMarkerType (self.oc, pexrep);
  END SetMarkerType;

PROCEDURE <A NAME="SetLineColor"><procedure>SetLineColor</procedure></A> (self : T; col : Color.T) =
  VAR
    pexrep := PEX.pexRgbFloatColour {col.r, col.g, col.b};
  BEGIN
    PEX.PEXSetLineColour (self.oc, ADR (pexrep));
  END SetLineColor;

PROCEDURE <A NAME="SetLineWidth"><procedure>SetLineWidth</procedure></A> (self : T; scale : REAL) =
  BEGIN
    PEX.PEXSetLineWidth (self.oc, FLOAT (scale, LONGREAL));
  END SetLineWidth;

PROCEDURE <A NAME="SetLineType"><procedure>SetLineType</procedure></A> (self : T; type : LineTypeProp.Kind) =
  VAR
    pexrep : Ctypes.int;
  BEGIN
    CASE type OF
    | LineTypeProp.Kind.Solid   =&gt; pexrep := PEX.PEXLineTypeSolid;
    | LineTypeProp.Kind.Dashed  =&gt; pexrep := PEX.PEXLineTypeDashed;
    | LineTypeProp.Kind.Dotted  =&gt; pexrep := PEX.PEXLineTypeDotted;
    | LineTypeProp.Kind.DashDot =&gt; pexrep := PEX.PEXLineTypeDashDot;
    END;
    PEX.PEXSetLineType (self.oc, pexrep);
  END SetLineType;

PROCEDURE <A NAME="SetSurfaceColor"><procedure>SetSurfaceColor</procedure></A> (self : T; col : Color.T) =
  VAR
    pexrep := PEX.pexRgbFloatColour {col.r, col.g, col.b};
  BEGIN
    PEX.PEXSetSurfaceColour (self.oc, ADR (pexrep));
  END SetSurfaceColor;

PROCEDURE <A NAME="SetRasterMode"><procedure>SetRasterMode</procedure></A> (self : T; val : RasterModeProp.Kind) =
  VAR
    pexrep : Ctypes.int;
  BEGIN
    CASE val OF
    | RasterModeProp.Kind.Hollow =&gt; pexrep := PEX.PEXInteriorStyleHollow;
    | RasterModeProp.Kind.Solid  =&gt; pexrep := PEX.PEXInteriorStyleSolid;
    | RasterModeProp.Kind.Empty  =&gt; pexrep := PEX.PEXInteriorStyleEmpty;
    END;
    PEX.PEXSetInteriorStyle (self.oc, pexrep);
  END SetRasterMode;

PROCEDURE <A NAME="SetDistinguishFacetsFlag"><procedure>SetDistinguishFacetsFlag</procedure></A> (self : T; val : BOOLEAN) =
  BEGIN
    IF val THEN
      PEX.PEXSetFacetDistinguishFlag (self.oc, X.True);
    ELSE
      PEX.PEXSetFacetDistinguishFlag (self.oc, X.False);
    END;
  END SetDistinguishFacetsFlag;

PROCEDURE <A NAME="SetLighting"><procedure>SetLighting</procedure></A> (self : T; val : BOOLEAN) =
  BEGIN
    IF val THEN
      PEX.PEXSetReflectionModel (self.oc, PEX.PEXReflectionSpecular);
    ELSE
      PEX.PEXSetReflectionModel (self.oc, PEX.PEXReflectionNoShading);
    END;
  END SetLighting;

PROCEDURE <A NAME="SetShading"><procedure>SetShading</procedure></A> (self : T; val : ShadingProp.Kind) =
  BEGIN
    CASE val OF
    | ShadingProp.Kind.Flat =&gt;
      PEX.PEXSetSurfaceInterpMethod (self.oc, PEX.PEXSurfaceInterpNone);
    | ShadingProp.Kind.Gouraud =&gt;
      PEX.PEXSetSurfaceInterpMethod (self.oc, PEX.PEXSurfaceInterpColour);
    END;
  END SetShading;

PROCEDURE <A NAME="SetSurfaceEdgeFlag"><procedure>SetSurfaceEdgeFlag</procedure></A> (self : T; val : BOOLEAN) =
  BEGIN
    IF val THEN
      PEX.PEXSetSurfaceEdgeFlag (self.oc, PEX.PEXOn);
    ELSE
      PEX.PEXSetSurfaceEdgeFlag (self.oc, PEX.PEXOff);
    END;
  END SetSurfaceEdgeFlag;

PROCEDURE <A NAME="SetSurfaceEdgeColor"><procedure>SetSurfaceEdgeColor</procedure></A> (self : T; val : Color.T) =
  VAR
    pexrep := PEX.pexRgbFloatColour {val.r, val.g, val.b};
  BEGIN
    PEX.PEXSetSurfaceEdgeColour (self.oc, ADR (pexrep));
  END SetSurfaceEdgeColor;

PROCEDURE <A NAME="SetSurfaceEdgeType"><procedure>SetSurfaceEdgeType</procedure></A> (self : T; val : LineTypeProp.Kind) =
  VAR
    pexrep : Ctypes.int;
  BEGIN
    CASE val OF
    | LineTypeProp.Kind.Solid   =&gt; pexrep := PEX.PEXSurfaceEdgeSolid;
    | LineTypeProp.Kind.Dashed  =&gt; pexrep := PEX.PEXSurfaceEdgeDashed;
    | LineTypeProp.Kind.Dotted  =&gt; pexrep := PEX.PEXSurfaceEdgeDotted;
    | LineTypeProp.Kind.DashDot =&gt; pexrep := PEX.PEXSurfaceEdgeDashDot;
    END;
    PEX.PEXSetSurfaceEdgeType (self.oc, pexrep);
  END SetSurfaceEdgeType;

PROCEDURE <A NAME="SetSurfaceEdgeWidth"><procedure>SetSurfaceEdgeWidth</procedure></A> (self : T; val : REAL) =
  BEGIN
    PEX.PEXSetSurfaceEdgeWidth (self.oc, FLOAT (val, LONGREAL));
  END SetSurfaceEdgeWidth;

PROCEDURE <A NAME="SetAmbientReflCoeff"><procedure>SetAmbientReflCoeff</procedure></A> (self : T; val : REAL) =
  BEGIN
    self.surfRefl.ambient := val;
  END SetAmbientReflCoeff;

PROCEDURE <A NAME="SetDiffuseReflCoeff"><procedure>SetDiffuseReflCoeff</procedure></A> (self : T; val : REAL) =
  BEGIN
    self.surfRefl.diffuse := val;
  END SetDiffuseReflCoeff;

PROCEDURE <A NAME="SetSpecularReflCoeff"><procedure>SetSpecularReflCoeff</procedure></A> (self : T; val : REAL) =
  BEGIN
    self.surfRefl.specular := val;
  END SetSpecularReflCoeff;

PROCEDURE <A NAME="SetSpecularReflConc"><procedure>SetSpecularReflConc</procedure></A> (self : T; val : REAL) =
  BEGIN
    self.surfRefl.specularConc := val;
  END SetSpecularReflConc;

PROCEDURE <A NAME="SetSpecularReflColor"><procedure>SetSpecularReflColor</procedure></A> (self : T; val : Color.T) =
  BEGIN
    self.surfRefl.specularColour := PexColourSpecifier (val);
  END SetSpecularReflColor;

PROCEDURE <A NAME="SetTransmissionCoeff"><procedure>SetTransmissionCoeff</procedure></A> (self : T; val : REAL) =
  BEGIN
    self.surfRefl.transmission := val;
  END SetTransmissionCoeff;

PROCEDURE <A NAME="DrawMarker"><procedure>DrawMarker</procedure></A> (self : T; p : Point3.T) =
  BEGIN
    PEX.PEXMarkers (self.oc, ADR (p), 1);
  END DrawMarker;

PROCEDURE <A NAME="DrawLine"><procedure>DrawLine</procedure></A> (self : T; p1, p2 : Point3.T) =
  VAR
    line := ARRAY [1 .. 2] OF PEX.pxlCoord3D {p1, p2};
  BEGIN
    PEX.PEXPolyline (self.oc, ADR (line), 2);
  END DrawLine;

PROCEDURE <A NAME="DrawPolygon"><procedure>DrawPolygon</procedure></A> (self         : T;
                       READONLY pts : ARRAY OF Point3.T;
                       shape        : GO.Shape) =
  VAR
    pexrep : Ctypes.int;
  BEGIN
    CASE shape OF
    | GO.Shape.Complex   =&gt; pexrep := PEX.PEXComplex;
    | GO.Shape.NonConvex =&gt; pexrep := PEX.PEXNonconvex;
    | GO.Shape.Convex    =&gt; pexrep := PEX.PEXConvex;
    | GO.Shape.Unknown   =&gt; pexrep := PEX.PEXUnknownShape;
    END;
    PEX.PEXFillArea (self.oc, pexrep, X.False, ADR (pts[0]), NUMBER (pts));
  END DrawPolygon;

PROCEDURE <A NAME="DrawQuadMesh"><procedure>DrawQuadMesh</procedure></A> (self         : T;
                        READONLY pts : ARRAY OF ARRAY OF Point3.T;
                        shape        : GO.Shape) =
  VAR
    pexrep : Ctypes.int;
  BEGIN
    CASE shape OF
    | GO.Shape.Complex   =&gt; pexrep := PEX.PEXComplex;
    | GO.Shape.NonConvex =&gt; pexrep := PEX.PEXNonconvex;
    | GO.Shape.Convex    =&gt; pexrep := PEX.PEXConvex;
    | GO.Shape.Unknown   =&gt; pexrep := PEX.PEXUnknownShape;
    END;
    PEX.PEXQuadMesh (self.oc, pexrep, 0, 0, NIL, ADR(pts[0][0]),
                     NUMBER (pts), NUMBER (pts[0]));
  END DrawQuadMesh;
</PRE>***************************************************************************
 The sphere caching mechanism                                              
***************************************************************************

<P><PRE>TYPE
  VertexData  = RECORD
    pt   : PEX.pexCoord3D;
    norm : PEX.pexCoord3D;
  END;

PROCEDURE <A NAME="DrawProtoSphere"><procedure>DrawProtoSphere</procedure></A> (self : T; prec : INTEGER) =
  VAR
    dl   : DisplayList;
    list : StructureList;
  BEGIN
    list := self.sphereStructures;
    WHILE list # NIL DO
      IF list.prec = prec THEN
        PEX.PEXExecuteStructure (self.oc, list.dl.structure);
        RETURN;
      END;
      list := list.next;
    END;
    dl := NewDisplayList (self);
    WITH verts = ComputeUnitSphere (prec) DO
      FOR i := FIRST (verts^) TO LAST (verts^) DO
        PEX.PEXTriangleStrip (dl.ocbuf, 0, PEX.PEXGANormal, NIL,
                              ADR (verts[i][0]), NUMBER(verts[i]));
      END;
    END;
    self.sphereStructures := NEW (StructureList,
                                  prec := prec,
                                  dl   := dl,
                                  next := self.sphereStructures);
    PEX.PEXExecuteStructure (self.oc, dl.structure);
  END DrawProtoSphere;

PROCEDURE <A NAME="ComputeUnitSphere"><procedure>ComputeUnitSphere</procedure></A> (prec : INTEGER) : REF ARRAY OF ARRAY OF VertexData =
  CONST
    YMAX           =  1.0;
    YMIN           = -1.0;
  VAR
    Y, DY                : REAL;
    vertexTop, vertexBot : REF ARRAY OF Point3.T;
    verts                : REF ARRAY OF ARRAY OF VertexData;
  BEGIN
    vertexTop := NEW(REF ARRAY OF Point3.T, prec);
    vertexBot := NEW(REF ARRAY OF Point3.T, prec);
    verts     := NEW(REF ARRAY OF ARRAY OF VertexData, prec, 2 * prec + 2);

    (* compute the number of triangle strip *)
    DY := (YMAX - YMIN) / FLOAT(prec);

    CalSphereVertex (vertexTop^, YMAX);
    Y := YMAX - DY;

    FOR i := 0 TO prec - 1 DO
      CalSphereVertex (vertexBot^, Y);

      (* build triangle strip data *)
      FOR j := 0 TO prec - 1 DO
        verts[i][2*j  ] := VertexData {vertexBot[j], vertexBot[j]};
        verts[i][2*j+1] := VertexData {vertexTop[j], vertexTop[j]};
      END;
      verts[i][2*prec  ] := VertexData {vertexBot[0], vertexBot[0]};
      verts[i][2*prec+1] := VertexData {vertexTop[0], vertexBot[0]};

      (* set up for next triangle strip *)
      vertexTop^ := vertexBot^;
      Y := Y - DY;
    END;
    RETURN verts;
  END ComputeUnitSphere;

PROCEDURE <A NAME="CalSphereVertex"><procedure>CalSphereVertex</procedure></A>(VAR vertex : ARRAY OF Point3.T; y : REAL) =
  VAR
    dPhi := 2.0 * Math.Pi / FLOAT (NUMBER (vertex));
    phi  := 0.0;
    r    := 1.0 - y * y;
  BEGIN
    (*
     * This function samples the surface y = -1/r where
     * r is the radius of the circle, i.e. r**2 = x**2 + y**2.
     *)
    IF r &lt; 0.00001 THEN
      r := 0.0;
    END;
    r := FLOAT (Math.sqrt (FLOAT (r, LONGREAL)));
    FOR i := FIRST (vertex) TO LAST (vertex) DO
      vertex[i].x := r * FLOAT (Math.cos (FLOAT (phi, LONGREAL)));
      vertex[i].z := r * FLOAT (Math.sin (FLOAT (phi, LONGREAL)));
      vertex[i].y := y;
      phi := phi + dPhi;
    END;
  END CalSphereVertex;
</PRE>***************************************************************************
 The cone caching mechanism                                                
***************************************************************************

<P>
<P><PRE>TYPE
  ConeVertices = REF ARRAY OF ARRAY [1 .. 2] OF VertexData;

PROCEDURE <A NAME="DrawProtoCone"><procedure>DrawProtoCone</procedure></A> (self : T; prec : INTEGER) =
  VAR
    dl   : DisplayList;
    list : StructureList;
  BEGIN
    list := self.coneStructures;
    WHILE list # NIL DO
      IF list.prec = prec THEN
        PEX.PEXExecuteStructure (self.oc, list.dl.structure);
        RETURN;
      END;
      list := list.next;
    END;
    dl := NewDisplayList (self);
    WITH verts = ComputeUnitCone (prec) DO
      PEX.PEXQuadMesh (dl.ocbuf, PEX.PEXConvex, 0, PEX.PEXGANormal, NIL,
                       ADR (verts[0][1]), NUMBER (verts^), 2);
    END;
    self.coneStructures := NEW (StructureList,
                                prec := prec,
                                dl   := dl,
                                next := self.coneStructures);
    PEX.PEXExecuteStructure (self.oc, dl.structure);
  END DrawProtoCone;
</PRE> ComputeUnitCone is called once for each (state,precision) pair. 

<P><PRE>PROCEDURE <A NAME="ComputeUnitCone"><procedure>ComputeUnitCone</procedure></A> (prec : INTEGER) : ConeVertices =
  VAR
    v  := NEW (ConeVertices, prec + 1);
  BEGIN
    WITH v1 = AuxG.GetUnitCirclePoints (prec) DO
      FOR i := FIRST(v1^) TO LAST(v1^) DO
        WITH p = v1[i], n = Point3.T {-p.x, -p.y, -1.0} DO
          v[i][1] := VertexData {p, n};
          v[i][2] := VertexData {Point3.T {0.0, 0.0, 1.0}, n};
        END;
      END;
    END;
    RETURN v;
  END ComputeUnitCone;
</PRE>***************************************************************************
 The Cylinder caching mechanism                                            
***************************************************************************

<P><PRE>TYPE
  CylVertices = REF ARRAY OF ARRAY [1 .. 2] OF VertexData;

PROCEDURE <A NAME="DrawProtoCylinder"><procedure>DrawProtoCylinder</procedure></A> (self : T; prec : INTEGER) =
  VAR
    dl   : DisplayList;
    list : StructureList;
  BEGIN
    list := self.cylinderStructures;
    WHILE list # NIL DO
      IF list.prec = prec THEN
        PEX.PEXExecuteStructure (self.oc, list.dl.structure);
        RETURN;
      END;
      list := list.next;
    END;
    dl := NewDisplayList (self);
    WITH verts = ComputeUnitCylinder (prec) DO
      PEX.PEXQuadMesh (dl.ocbuf, PEX.PEXConvex, 0, PEX.PEXGANormal, NIL,
                       ADR (verts[0][1]), NUMBER (verts^), 2);
    END;
    self.cylinderStructures := NEW (StructureList,
                                    prec := prec,
                                    dl   := dl,
                                    next := self.cylinderStructures);
    PEX.PEXExecuteStructure (self.oc, dl.structure);
  END DrawProtoCylinder;

PROCEDURE <A NAME="ComputeUnitCylinder"><procedure>ComputeUnitCylinder</procedure></A> (prec : INTEGER) : CylVertices =
  VAR
    v  := NEW (CylVertices, prec + 1);
  BEGIN
    WITH v1 = AuxG.GetUnitCirclePoints (prec) DO
      FOR i := FIRST(v1^) TO LAST(v1^) DO
        WITH p = v1[i], n = Point3.T{-p.x, -p.y, -p.z} DO
          v[i][1] := VertexData {p, n};
          v[i][2] := VertexData {Point3.T{p.x, p.y, p.z + 1.0}, n};
        END;
      END;
    END;
    RETURN v;
  END ComputeUnitCylinder;
</PRE>***************************************************************************
 The disk caching mechanism                                                
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="DrawProtoDisk"><procedure>DrawProtoDisk</procedure></A> (self : T; prec : INTEGER) =
  VAR
    dl   : DisplayList;
    list : StructureList;
  BEGIN
    list := self.diskStructures;
    WHILE list # NIL DO
      IF list.prec = prec THEN
        PEX.PEXExecuteStructure (self.oc, list.dl.structure);
        RETURN;
      END;
      list := list.next;
    END;
    dl := NewDisplayList (self);
    WITH pts = AuxG.GetUnitCirclePoints (prec) DO
      PEX.PEXFillArea (dl.ocbuf, PEX.PEXConvex, X.False, ADR (pts[0]), prec);
    END;
    self.diskStructures := NEW (StructureList,
                                prec := prec,
                                dl   := dl,
                                next := self.diskStructures);
    PEX.PEXExecuteStructure (self.oc, dl.structure);
  END DrawProtoDisk;
</PRE>***************************************************************************
 The torus caching mechanism                                               
***************************************************************************

<P>
<P><PRE>TYPE
  TorusStructureList = REF RECORD
    prec        : INTEGER;
    radiusRatio : REAL;
    dl          : DisplayList;
    next        : TorusStructureList;
  END;

  TorusVertices = REF ARRAY OF ARRAY OF VertexData;

PROCEDURE <A NAME="DrawProtoTorus"><procedure>DrawProtoTorus</procedure></A> (self : T; prec : INTEGER; radiusRatio : REAL ) =
  VAR
    dl   : DisplayList;
    list : TorusStructureList;
  BEGIN
    list := self.torusStructures;
    WHILE list # NIL DO
      IF list.prec = prec AND list.radiusRatio = radiusRatio THEN
        PEX.PEXExecuteStructure (self.oc, list.dl.structure);
        RETURN;
      END;
      list := list.next;
    END;
    dl := NewDisplayList (self);
    WITH verts = ComputeUnitTorus (prec,radiusRatio) DO
      PEX.PEXQuadMesh (dl.ocbuf, PEX.PEXConvex, 0, PEX.PEXGANormal,
                       NIL, ADR (verts[0][0]),
                       NUMBER (verts^), NUMBER(verts[0]));
    END;
    self.torusStructures := NEW (TorusStructureList,
                                 prec := prec,
                                 radiusRatio := radiusRatio,
                                 dl   := dl,
                                 next := self.torusStructures);
    PEX.PEXExecuteStructure (self.oc, dl.structure);
  END DrawProtoTorus;
</PRE> ComputeUnitTorus is called once for each (state,precision,radiusRatio) 
   triple. The constant parameters are:
     center  = (0,0,0)
     normal  = (1,0,0)
     radius1 = 1.0


<P><PRE>PROCEDURE <A NAME="ComputeUnitTorus"><procedure>ComputeUnitTorus</procedure></A> (prec : INTEGER; radius2 : REAL) : TorusVertices =
  VAR
    verts : TorusVertices := NEW (TorusVertices, prec+1, prec+1);
  BEGIN
    WITH u = AuxG.GetUnitCirclePoints (prec),
             (* normal of unit circle is z-axis *)
         normal = Point3.T {0.0, 0.0, 1.0} DO
      FOR i := 0 TO prec DO
        WITH aux  = u[i],
             a2   = Point3.Plus (aux, Point3.ScaleToLen (normal, radius2)),
             b2   = Point3.Plus (aux, Point3.ScaleToLen (aux, radius2)),
             c2   = Point3.Plus (aux, Point3.CrossProduct(aux, normal)),
             N    = Matrix4.TransformUnitCube (aux, a2, b2, c2) DO
          FOR j := 0 TO prec DO
            WITH p = Matrix4.TransformPoint3 (N, u[j]),
                 n = Point3.Minus (aux, p) DO
              verts[i][j] := VertexData {p, n};
            END;
          END;
        END;
      END;
    END;
    RETURN verts;
  END ComputeUnitTorus;
</PRE>***************************************************************************
 Low-level conversion functions to PEX types                               
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="PexColourSpecifier"><procedure>PexColourSpecifier</procedure></A> (c : Color.T) : PEX.pxlColourSpecifier =
  VAR
    cs : PEX.pxlColourSpecifier;
    c0 := PEX.pexRgbFloatColour {c.r, c.g, c.b};
  BEGIN
    cs.colourType := PEX.PEXRgbFloatColour;
    cs.colour     := LOOPHOLE (ADR (c0), PEX.pexColourStar)^;
    RETURN cs;
  END PexColourSpecifier;

BEGIN
END GraphicsState.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
