<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/GroupGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/GroupGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P><PRE>MODULE <module>GroupGO</module> EXPORTS <A HREF="GroupGO.i3"><implements>GroupGO</A></implements>, <A HREF="GroupGOPrivate.i3"><implements>GroupGOPrivate</A></implements>, <A HREF="GroupGOProxy.i3"><implements>GroupGOProxy</A></implements>;

IMPORT <A HREF="AnimServer.i3">AnimServer</A>, <A HREF="GO.i3">GO</A>, <A HREF="GOPrivate.i3">GOPrivate</A>, <A HREF="GraphicsState.i3">GraphicsState</A>, <A HREF="Prop.i3">Prop</A>;

REVEAL
  <A NAME="T">T</A> = Private BRANDED OBJECT
  OVERRIDES
    init               := Init;                (* GroupGO.Public *)
    add                := Add;                 (* GroupGO.Public *)
    remove             := Remove;              (* GroupGO.Public *)
    flush              := Flush;               (* GroupGO.Public *)
    content            := Content;             (* GroupGO.Public *)
    findName           := FindName;            (* GO.Public *)
    draw               := Draw;                (* GO.Private *)
    needsTransparency  := NeedsTransparency;   (* GO.Private *)
    adjust             := Adjust;              (* GO.Private *)
    damageIfDependent  := DamageIfDependent;   (* GO.Private *)
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T; initSize : INTEGER) : T =
  BEGIN
    (*** No protection needed ***)
    EVAL GO.T.init (self);
    self.children := NEW (REF ARRAY OF GO.T, initSize); (* grow as needed *)
    self.last := -1;
    self.damaged := FALSE;  (* groups are not damaged at creation *)

    IF MkProxyT # NIL THEN
      MkProxyT (self);
    END;

    RETURN self;
  END Init;

PROCEDURE <A NAME="Add"><procedure>Add</procedure></A> (self : T; o : GO.T) =
  BEGIN
    (*** Must be protected from interference with the animation server ***)
    LOCK AnimServer.internalLock DO
      self.damaged := TRUE;
      INC (self.last);
      IF self.last &gt; LAST (self.children^) THEN
        WITH n   = NUMBER (self.children^),
             tmp = NEW (REF ARRAY OF GO.T, 2 * n) DO
          SUBARRAY (tmp^, 0, n) := self.children^;
          self.children := tmp;
        END;
      END;
      self.children[self.last] := o;
    END;
  END Add;

PROCEDURE <A NAME="Remove"><procedure>Remove</procedure></A>(self : T; o : GO.T) RAISES {BadElement} =
  BEGIN
    (*** Must be protected from interference with the animation server ***)
    LOCK AnimServer.internalLock DO
      self.damaged := TRUE;

      WITH B = self.children^ DO
        FOR i := 0 TO self.last DO
          IF B[i] = o THEN
            B[i] := B[self.last];
            B[self.last] := NIL;
            DEC (self.last);
            RETURN;
          END;
        END;
      END;
      RAISE BadElement;
    END;
  END Remove;

PROCEDURE <A NAME="Flush"><procedure>Flush</procedure></A> (self : T) =
  BEGIN
    (*** Must be protected from interference with the animation server ***)
    LOCK AnimServer.internalLock DO
      self.damaged := TRUE;
      FOR i := 0 TO self.last DO
        self.children[i] := NIL;
      END;
      self.last := -1;
    END;
  END Flush;

PROCEDURE <A NAME="Content"><procedure>Content</procedure></A> (self : T) : REF ARRAY OF GO.T =
  BEGIN
    WITH res = NEW (REF ARRAY OF GO.T, self.last + 1) DO
      res^ := SUBARRAY (self.children^, 0, self.last + 1);
      RETURN res;
    END;
  END Content;

PROCEDURE <A NAME="FindName"><procedure>FindName</procedure></A> (self : T; name : TEXT) : GO.T =
  BEGIN
    (* No interference with the animation server. Possible interference with
       other client threads; client code has to provide adequate protection. *)
    IF GO.T.findName (self, name) # NIL THEN
      RETURN self;
    ELSE
      FOR i := 0 TO self.last DO
        WITH go = self.children[i].findName (name) DO
          IF go # NIL THEN
            RETURN go;
          END;
        END;
      END;
    END;
    RETURN NIL;
  END FindName;
</PRE>***************************************************************************
 Private Methods:                                                          
                                                                           
 These procedures are called only from the animation server thread.        
 Their locking level is {AnimServer.externalLock,AnimServer.internalLock}  
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Draw"><procedure>Draw</procedure></A> (self : T; state : GraphicsState.T) =
  BEGIN
    state.push (self);

    FOR i := 0 TO self.last DO
      self.children[i].draw (state);
    END;

    (* Indicate that damages have been repaired *)
    self.damaged := FALSE;

    state.pop (self);
  END Draw;

PROCEDURE <A NAME="NeedsTransparency"><procedure>NeedsTransparency</procedure></A> (self : T; t : REAL) : BOOLEAN =
  BEGIN
    IF self.trans # FIRST(REAL) THEN
      t := self.trans;
    END;

    FOR i := 0 TO self.last DO
      IF self.children[i].needsTransparency (t) THEN
        RETURN TRUE;
      END;
    END;
    RETURN FALSE;
  END NeedsTransparency;

PROCEDURE <A NAME="Adjust"><procedure>Adjust</procedure></A> (self : T; time : LONGREAL) =
  BEGIN
    (*** adjust properties of self ***)
    GO.T.adjust (self, time);

    FOR i := 0 TO self.last DO
      self.children[i].adjust (time);
      IF self.children[i].damaged THEN
        self.damaged := TRUE;
      END;
    END;
  END Adjust;

PROCEDURE <A NAME="DamageIfDependent"><procedure>DamageIfDependent</procedure></A> (self : T; pn : Prop.Name) =
  BEGIN
    FOR i := 0 TO self.last DO
      self.children[i].damageIfDependent (pn);
      IF self.children[i].damaged THEN
        self.damaged := TRUE;
      END;
    END;
  END DamageIfDependent;

BEGIN
END GroupGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
