<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/KeyCB.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/KeyCB.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Fri Feb 18 09:53:07 PST 1994 by najork                   

<P>
<P> In accordance with the terminology used by Trestle, we refer to key 
   transitions as to {\em key events}. A key event is represented
   by a record <CODE>KeyCB.Rec</CODE>.
<P>
   A {\em key event callback object} is an object which has one
   method, <CODE>invoke</CODE>. Each geometric object has a stack of key callback
   objects. When a key event <CODE>kr</CODE> is relayed to a particular geometric
   <CODE>o</CODE>, the the message <CODE>cb.invoke(kr)</CODE> is sent to the top callback
   object on <CODE>o</CODE>'s key callback stack (if <CODE>o</CODE>'s key callback stack is
   empty, the event is simply dropped). It is <CODE>cb</CODE>'s reponsibility to
   perform whatever action is appropriate in the current context. 

<P><PRE>INTERFACE <interface><A HREF="KeyCB.m3">KeyCB</A></interface>;

IMPORT <A HREF="CB.i3">CB</A>, <A HREF="ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="KeyCB.m3#T">T</A> &lt;: Public;
  Public = ProxiedObj.T OBJECT
  METHODS
    init () : T;
    invoke (kr : Rec) RAISES {CB.BadMethod};
  END;
</PRE><BLOCKQUOTE><EM> <CODE>KeyCB.T</CODE> is the abstract class of key callback objects. If <CODE>o</CODE> is a 
   geometric object, <CODE>c</CODE> is the top object in its key callback stack, and 
   a key event <CODE>kr</CODE> gets relayed to <CODE>o</CODE>, then <CODE>cb.invoke(kr)</CODE> will be called.
   It is up to the user to create subclasses of <CODE>KeyCB.T</CODE> that handle
   key events in a given context appropriately. </EM></BLOCKQUOTE><PRE>

  Rec = RECORD
    whatChanged : VBT.KeySym;
    wentDown    : BOOLEAN;
    modifiers   : VBT.Modifiers;
  END;
</PRE><BLOCKQUOTE><EM> <CODE>KeyCB.Rec</CODE> is a record type containing information about a key event.
   <CODE>whatChanged</CODE> is the key that went up or down, <CODE>wentDown</CODE> indicates 
   whether it went down or up.
   <CODE>modifiers</CODE> is the set of modifiers (Shift, Control, Mouse Buttons, etc.) 
   that was active when the transition took place.
<P>
   {\em NOTE: There is a fair chance that I will add other fields to <CODE>Rec</CODE>,
   once we have gained more experience with event handling. So far, I pretty
   much mimick (part of) what is there in <CODE>VBT.KeyRec</CODE>.} </EM></BLOCKQUOTE><PRE>

END KeyCB.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
