<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/LightGO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/LightGO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Fri Feb  4 15:19:54 PST 1994 by najork                   

<P> Lights are treated as a special kind of geometric objects. A light,
   like any other geometric object, can be a part of a group (and thus,
   by transitivity, of an entire scene), properties can be attached to
   it, and it observes both the properties attached to itself and to its
   ancestors in the scene. In particular, lights are affected by
   transformation properties: When the transformation property of a light
   or of one of its ancestors in the scene changes, the light source
   moves.
<P>
   Light sources affect all geometric objects of type \type{SurfaceGO}{T} 
   in the scene, by illuminating their surfaces. However, they are invisible 
   themselves. 
<P>
   <CODE>LightGO.T</CODE> is the abstract class of all light sources. 

<P>
<P><PRE>INTERFACE <interface><A HREF="LightGO.m3">LightGO</A></interface>;

IMPORT <A HREF="BooleanProp.i3">BooleanProp</A>, <A HREF="ColorProp.i3">ColorProp</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="GO.i3">GO</A>;

TYPE
  <A HREF="LightGO.m3#T">T</A> &lt;: GO.T;
</PRE><BLOCKQUOTE><EM> <CODE>LightGO.T</CODE> is a subtype of \type{GO}{T}. No additional fiels or methods 
   are defined. </EM></BLOCKQUOTE><PRE>

VAR
  Colour : ColorProp.Name;
  Switch : BooleanProp.Name;
</PRE><BLOCKQUOTE><EM> In addition to the properties observed by all \type{GO}{T}'s, there are two
   additional properties that are observed by all <CODE>LightGO.T</CODE>'s. 
   <CODE>Colour</CODE> is the name of a property that determines the colour of the light 
   emitted by the <CODE>LightGO.T</CODE>; it associates with a property value of type 
   \type{ColourProp}{Val}.
   <CODE>Switch</CODE> is the name of a property that determines if the light source 
   is on or off; it associates with a property value of type 
   \type{BooleanProp}{Val}. </EM></BLOCKQUOTE><PRE>
</PRE> The following two procedures make it more convenient to modify the
   <CODE>Colour</CODE> and <CODE>Switch</CODE> properties of a light: 

<P><PRE>PROCEDURE <A HREF="LightGO.m3#SetColour">SetColour</A> (o : GO.T; c : Color.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetColour(o,c)</CODE> is equivalent to 
   <CODE>o.setProp(Colour.bind(ColorProp.NewConst(c)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="LightGO.m3#SetSwitch">SetSwitch</A> (o : GO.T; switch : BOOLEAN);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetSwitch(o,b)</CODE> is equivalent to 
   <CODE>o.setProp(Switch.bind(BooleanProp.NewConst(b)))</CODE>. </EM></BLOCKQUOTE><PRE>

END LightGO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
