<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/LineGO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/LineGO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P> A <CODE>LineGO.T</CODE> is a geometric object describing a line. 

<P><PRE>INTERFACE <interface><A HREF="LineGO.m3">LineGO</A></interface>;

IMPORT <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="ColorProp.i3">ColorProp</A>, <A HREF="GO.i3">GO</A>, <A HREF="LineTypeProp.i3">LineTypeProp</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="PointProp.i3">PointProp</A>, <A HREF="RealProp.i3">RealProp</A>;

TYPE
  <A HREF="LineGO.m3#T">T</A> &lt;: Public;
  Public = GO.T OBJECT
  METHODS
    init () : T;
  END;
</PRE><BLOCKQUOTE><EM> <CODE>l.init()</CODE> initializes <CODE>l</CODE> and returns it. The start- and endpoints of
   the line are determined by the properties <CODE>Point1</CODE> and <CODE>Point2</CODE>. </EM></BLOCKQUOTE><PRE>

VAR
  Point1 : PointProp.Name;
  Point2 : PointProp.Name;
  Colour : ColorProp.Name;
  Width  : RealProp.Name;
  Type   : LineTypeProp.Name;
</PRE> In addition to the properties observed by all \type{GO}{T}'s, there are 
   some additional properties that are observed by <CODE>LineGO.T</CODE>'s:
<P>
   <CODE>Point1</CODE> and <CODE>Point2</CODE> are the names of two point properties that describe
   the endpoints of the line. If <CODE>Point1</CODE> is not specified, the line starts
   at (0,0,0). If <CODE>Point2</CODE> is not specified, the line ends at (1,0,0).
<P>
   <CODE>Colour</CODE> is the name of a color property that describes the color of 
   the line. If no <CODE>Colour</CODE> property is specified, the line is drawn in white.
<P>
   <CODE>Width</CODE> is the name of a real property that describes the width of the 
   line. If no <CODE>Width</CODE> property is specified, the line is drawn with width 1.
<P>
   <CODE>Type</CODE> is the name of a line type property that describes the type of 
   the line (solid, dashed, dotted, or alternatingly dashed and dotted).
   If no <CODE>Type</CODE> property is specified, the line is drawn solid. 

<P><PRE>PROCEDURE <A HREF="LineGO.m3#New">New</A> (p1, p2 : Point3.T) : T;
</PRE><BLOCKQUOTE><EM> <CODE>New(p1,p2)</CODE> creates a new line and returns it. It also attaches the 
   following properties to the new line:
   \begin{verbatim}
     (Point1,PointProp.NewConst(p1))
     (Point2,PointProp.NewConst(p2))
   \end{verbatim}
</EM></BLOCKQUOTE><PRE>
</PRE> The following five procedures provide sugaring to attach <CODE>Colour</CODE>, <CODE>Width</CODE>,
   <CODE>Type</CODE>, <CODE>Point1</CODE>, and <CODE>Point2</CODE> properties to geometric objects: 

<P><PRE>PROCEDURE <A HREF="LineGO.m3#SetColour">SetColour</A> (o : GO.T; c : Color.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetColour(o,c)</CODE> is equivalent to
   <CODE>o.setProp(Colour.bind(ColorProp.NewConst(c)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="LineGO.m3#SetWidth">SetWidth</A> (o : GO.T; r : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetWidth(o,r)</CODE> is equivalent to
   <CODE>o.setProp(Width.bind(RealProp.NewConst(r)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="LineGO.m3#SetType">SetType</A> (o : GO.T; v : LineTypeProp.Kind);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetType(o,t)</CODE> is equivalent to
   <CODE>o.setProp(Type.bind(LineTypeProp.NewConst(t)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="LineGO.m3#SetPoint1">SetPoint1</A> (o : GO.T; v : Point3.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetPoint1(o,p)</CODE>is equivalent to
   <CODE>o.setProp(Point1.bind(PointProp.NewConst(p)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="LineGO.m3#SetPoint2">SetPoint2</A> (o : GO.T; v : Point3.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetPoint2(o,p)</CODE>is equivalent to
   <CODE>o.setProp(Point2.bind(PointProp.NewConst(p)))</CODE>. </EM></BLOCKQUOTE><PRE>

END LineGO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
