<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/LineGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/LineGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P><PRE>MODULE <module>LineGO</module> EXPORTS <A HREF="LineGO.i3"><implements>LineGO</A></implements>, <A HREF="LineGOProxy.i3"><implements>LineGOProxy</A></implements>;

IMPORT <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="ColorProp.i3">ColorProp</A>, <A HREF="ColorPropPrivate.i3">ColorPropPrivate</A>, <A HREF="GO.i3">GO</A>, <A HREF="GOPrivate.i3">GOPrivate</A>, <A HREF="GraphicsState.i3">GraphicsState</A>,
       <A HREF="GraphicsStatePrivate.i3">GraphicsStatePrivate</A>, <A HREF="LineTypeProp.i3">LineTypeProp</A>, <A HREF="LineTypePropPrivate.i3">LineTypePropPrivate</A>,
       <A HREF="Point3.i3">Point3</A>, <A HREF="PointProp.i3">PointProp</A>, <A HREF="PointPropPrivate.i3">PointPropPrivate</A>, <A HREF="Prop.i3">Prop</A>, <A HREF="PropPrivate.i3">PropPrivate</A>, <A HREF="RealProp.i3">RealProp</A>,
       <A HREF="RealPropPrivate.i3">RealPropPrivate</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
  OVERRIDES
    init              := Init;
    draw              := Draw;
    damageIfDependent := DamageIfDependent;
    needsTransparency := NeedsTransparency;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T) : T =
  BEGIN
    EVAL GO.T.init (self);

    IF MkProxyT # NIL AND self.proxy = NIL THEN
      MkProxyT (self);
    END;

    RETURN self;
  END Init;

PROCEDURE <A NAME="Draw"><procedure>Draw</procedure></A> (self : T; state : GraphicsState.T) =
  BEGIN
    state.push (self);
    WITH p1 = Point1.getState (state),
         p2 = Point2.getState (state) DO
      state.drawLine (p1, p2);
      state.growBoundingVolume (Point3.MidPoint (p1, p2),
                                Point3.Distance (p1, p2) / 2.0);
    END;

    self.damaged := FALSE;
    state.pop (self);
  END Draw;

PROCEDURE <A NAME="DamageIfDependent"><procedure>DamageIfDependent</procedure></A> (self : T; pn : Prop.Name) =
  BEGIN
    IF pn = Point1 OR pn = Point2 THEN
      self.damaged := TRUE;
    END;
  END DamageIfDependent;

PROCEDURE <A NAME="NeedsTransparency"><procedure>NeedsTransparency</procedure></A> (&lt;* UNUSED *&gt; self : T;
                             &lt;* UNUSED *&gt; t    : REAL) : BOOLEAN =
  BEGIN
    RETURN FALSE;
  END NeedsTransparency;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (p1, p2 : Point3.T) : T =
  VAR
    line := NEW (T).init ();
  BEGIN
    SetPoint1 (line, p1);
    SetPoint2 (line, p2);
    RETURN line;
  END New;
</PRE>***************************************************************************
 Colour_PN                                                                 
***************************************************************************

<P><PRE>TYPE
  Colour_PN = ColorProp.Name OBJECT
  OVERRIDES
    damage := DamageColour;
    push   := PushColour;
    pop    := PopColour;
  END;

PROCEDURE <A NAME="DamageColour"><procedure>DamageColour</procedure></A> (&lt;* UNUSED *&gt; self : Colour_PN; caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageColour;

PROCEDURE <A NAME="PushColour"><procedure>PushColour</procedure></A> (self  : Colour_PN;
                      state : GraphicsState.T;
                      pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], ColorPropPrivate.Stack),
         val   = NARROW (pv, ColorProp.Val).val DO
      IF stack.top # val THEN
        state.setLineColor (val);
      END;
      stack.push (val);
    END;
  END PushColour;

PROCEDURE <A NAME="PopColour"><procedure>PopColour</procedure></A> (self : Colour_PN; state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], ColorPropPrivate.Stack) DO
      state.setLineColor (stack.pop ());
    END;
  END PopColour;
</PRE>***************************************************************************
 Width_PN                                                                  
***************************************************************************

<P><PRE>TYPE
  Width_PN = RealProp.Name OBJECT
  OVERRIDES
    damage := DamageWidth;
    push   := PushWidth;
    pop    := PopWidth;
  END;

PROCEDURE <A NAME="DamageWidth"><procedure>DamageWidth</procedure></A> (&lt;* UNUSED *&gt; self : Width_PN; caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageWidth;

PROCEDURE <A NAME="PushWidth"><procedure>PushWidth</procedure></A> (self  : Width_PN;
                     state : GraphicsState.T;
                     pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RealPropPrivate.Stack),
         val   = NARROW (pv, RealProp.Val).val DO
      IF stack.top # val THEN
        state.setLineWidth (val);
      END;
      stack.push (val);
    END;
  END PushWidth;

PROCEDURE <A NAME="PopWidth"><procedure>PopWidth</procedure></A> (self : Width_PN; state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RealPropPrivate.Stack) DO
      state.setLineWidth (stack.pop ());
    END;
  END PopWidth;
</PRE>***************************************************************************
 Type_PN                                                                   
***************************************************************************

<P><PRE>TYPE
  Type_PN = LineTypeProp.Name OBJECT
  OVERRIDES
    damage := DamageType;
    push   := PushType;
    pop    := PopType;
  END;

PROCEDURE <A NAME="DamageType"><procedure>DamageType</procedure></A> (&lt;* UNUSED *&gt; self : Type_PN; caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageType;

PROCEDURE <A NAME="PushType"><procedure>PushType</procedure></A> (self  : Type_PN;
                    state : GraphicsState.T;
                    pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], LineTypePropPrivate.Stack),
         val   = NARROW (pv, LineTypeProp.Val).val DO
      IF stack.top # val THEN
        state.setLineType (val);
      END;
      stack.push (val);
    END;
  END PushType;

PROCEDURE <A NAME="PopType"><procedure>PopType</procedure></A> (self : Type_PN; state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], LineTypePropPrivate.Stack) DO
      state.setLineType (stack.pop ());
    END;
  END PopType;
</PRE>***************************************************************************
 Convenience Procedures                                                    
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetColour"><procedure>SetColour</procedure></A> (o : GO.T; v : Color.T) =
  BEGIN
    o.setProp (Colour.bind (ColorProp.NewConst (v)));
  END SetColour;

PROCEDURE <A NAME="SetWidth"><procedure>SetWidth</procedure></A> (o : GO.T; v : REAL) =
  BEGIN
    o.setProp (Width.bind (RealProp.NewConst (v)));
  END SetWidth;

PROCEDURE <A NAME="SetType"><procedure>SetType</procedure></A> (o : GO.T; v : LineTypeProp.Kind) =
  BEGIN
    o.setProp (Type.bind (LineTypeProp.NewConst (v)));
  END SetType;

PROCEDURE <A NAME="SetPoint1"><procedure>SetPoint1</procedure></A> (o : GO.T; v : Point3.T) =
  BEGIN
    o.setProp (Point1.bind (PointProp.NewConst (v)));
  END SetPoint1;

PROCEDURE <A NAME="SetPoint2"><procedure>SetPoint2</procedure></A> (o : GO.T; v : Point3.T) =
  BEGIN
    o.setProp (Point2.bind (PointProp.NewConst (v)));
  END SetPoint2;
</PRE>***************************************************************************
 Module body                                                               
***************************************************************************

<P><PRE>BEGIN
  Colour := NEW (Colour_PN).init (Color.White);
  Width  := NEW (Width_PN).init (1.0);
  Type   := NEW (Type_PN).init (LineTypeProp.Kind.Solid);
  Point1 := NEW (PointProp.Name).init (Point3.T {0.0, 0.0, 0.0});
  Point2 := NEW (PointProp.Name).init (Point3.T {1.0, 0.0, 0.0});
END LineGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
