<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/LineTypeProp.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/LineTypeProp.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sun May 22 11:14:24 PDT 1994 by najork                   

<P>
<P><PRE>INTERFACE <interface><A HREF="LineTypeProp.m3">LineTypeProp</A></interface>;

IMPORT <A HREF="AnimHandle.i3">AnimHandle</A>, <A HREF="Prop.i3">Prop</A>;

TYPE
  Kind = {Solid, Dashed, Dotted, DashDot};
</PRE><BLOCKQUOTE><EM> <CODE>Kind</CODE> enumerates the four possible ways a line can be stroked: solid, 
   dashed, dotted, or alternatingly dashed and dotted. These are the four 
   stroking styles that are supported by PEX; OpenGL has a more general way 
   of defining stroke styles. Therefore, it is possible that we will extend 
   this interface once OpenGL is available to us. </EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="LineTypeProp.m3#Name">Name</A> &lt;: PublicName;
  PublicName = Prop.Name OBJECT
  METHODS
    bind (v : Val) : Prop.T;
  END;

  <A HREF="LineTypeProp.m3#Val">Val</A> &lt;: PublicVal;
  PublicVal = Prop.Val OBJECT
    beh : Beh;
  METHODS
    init (beh : Beh) : Val;
    get () : Kind RAISES {Prop.BadMethod};
    value (time : LONGREAL) : Kind RAISES {Prop.BadMethod};
  END;

  <A HREF="LineTypeProp.m3#Beh">Beh</A> &lt;: PublicBeh;
  PublicBeh = Prop.Beh OBJECT
  METHODS
    init () : Beh;
  END;

  <A HREF="LineTypeProp.m3#ConstBeh">ConstBeh</A> &lt;: PublicConstBeh;
  PublicConstBeh = Beh OBJECT
  METHODS
    init (p : Kind) : ConstBeh;
    set (p : Kind);
  END;

  <A HREF="LineTypeProp.m3#SyncBeh">SyncBeh</A> &lt;: PublicSyncBeh;
  PublicSyncBeh = Beh OBJECT
  METHODS
    init (ah : AnimHandle.T; p : Kind) : SyncBeh;
    addRequest (r : Request) RAISES {Prop.BadInterval};
  (* shortcuts for particular instances of &quot;addRequest&quot; *)
    change (p : Kind; start := 0.0) RAISES {Prop.BadInterval};
  END;

  <A HREF="LineTypeProp.m3#AsyncBeh">AsyncBeh</A> &lt;: PublicAsyncBeh;
  PublicAsyncBeh = Beh OBJECT
  METHODS
    init () : AsyncBeh;
    compute (time : LONGREAL) : Kind RAISES {Prop.BadMethod};
  END;

  <A HREF="LineTypeProp.m3#DepBeh">DepBeh</A> &lt;: PublicDepBeh;
  PublicDepBeh = Beh OBJECT
  METHODS
    init () : DepBeh;
    compute (time : LONGREAL) : Kind RAISES {Prop.BadMethod};
  END;

  <A HREF="LineTypeProp.m3#Request">Request</A> &lt;: PublicRequest;
  PublicRequest = Prop.Request OBJECT
  METHODS
    init (start, dur : REAL) : Request;
    value (startkind : Kind; reltime : REAL) : Kind RAISES {Prop.BadMethod};
  END;

PROCEDURE <A HREF="LineTypeProp.m3#NewConst">NewConst</A> (p : Kind) : Val;
PROCEDURE <A HREF="LineTypeProp.m3#NewSync">NewSync</A> (ah : AnimHandle.T; p : Kind) : Val;
PROCEDURE <A HREF="LineTypeProp.m3#NewAsync">NewAsync</A> (b : AsyncBeh) : Val;
PROCEDURE <A HREF="LineTypeProp.m3#NewDep">NewDep</A> (b : DepBeh) : Val;

END LineTypeProp.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
