<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/MarkerGO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/MarkerGO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P> A <CODE>MarkerGO.T</CODE> is a geometric object describing a marker. 

<P><PRE>INTERFACE <interface><A HREF="MarkerGO.m3">MarkerGO</A></interface>;

IMPORT <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="ColorProp.i3">ColorProp</A>, <A HREF="GO.i3">GO</A>, <A HREF="MarkerTypeProp.i3">MarkerTypeProp</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="PointProp.i3">PointProp</A>, <A HREF="RealProp.i3">RealProp</A>;

TYPE
  <A HREF="MarkerGO.m3#T">T</A> &lt;: Public;
  Public = GO.T OBJECT
  METHODS
    init () : T;
  END;
</PRE><BLOCKQUOTE><EM> <CODE>m.init()</CODE> initializes <CODE>m</CODE>, and returns it. The location of the marker 
   is determined by the property <CODE>Center</CODE>. </EM></BLOCKQUOTE><PRE>

VAR
  Center : PointProp.Name;
  Colour : ColorProp.Name;
  Scale  : RealProp.Name;
  Type   : MarkerTypeProp.Name;
</PRE> In addition to the properties observed by all \type{GO}{T}'s, there are 
   some additional properties that are observed by <CODE>MarkerGO.T</CODE>'s:
<P>
   <CODE>Center</CODE> is the name of a point property that describes the point indicated
   by the marker. If no <CODE>Center</CODE> property is specified, the marker is drawn at
   the origin. 
<P>
   <CODE>Colour</CODE> is the name of a color property that describes the color of the 
   marker. If no <CODE>Colour</CODE> property is specified, the marker is drawn in white.
<P>
   <CODE>Scale</CODE> is the name of a real property that describes the scale of the 
   marker. If no <CODE>Scale</CODE> property is specified, the marker is drawn with 
   scale 1.
<P>
   <CODE>Type</CODE> is the name of a marker type property that describes the type of 
   the marker (dot, cross, circle, asterisk, or X). If no <CODE>Type</CODE> property
   is specified, the marker is drawn as an asterisk. 

<P><PRE>PROCEDURE <A HREF="MarkerGO.m3#New">New</A> (p : Point3.T) : T;
</PRE><BLOCKQUOTE><EM> <CODE>New(p)</CODE> creates a new marker and returns it. It also attaches the 
   property <CODE>(Center,PointProp.NewConst(p))</CODE> to the new marker. </EM></BLOCKQUOTE><PRE>
</PRE> The following four procedures provide sugaring to attach the
   <CODE>Center</CODE>, <CODE>Colour</CODE>, <CODE>Scale</CODE>, and <CODE>Type</CODE> properties to geometric objects: 

<P><PRE>PROCEDURE <A HREF="MarkerGO.m3#SetCenter">SetCenter</A> (o : GO.T; v : Point3.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetCenter(o,p)</CODE>is equivalent to
   <CODE>o.setProp(Center.bind(PointProp.NewConst(p)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MarkerGO.m3#SetColour">SetColour</A> (o : GO.T; v : Color.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetColour(o,c)</CODE> is equivalent to
   <CODE>o.setProp(Colour.bind(ColorProp.NewConst(c)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MarkerGO.m3#SetScale">SetScale</A> (o : GO.T; v : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetScale(o,r)</CODE> is equivalent to
   <CODE>o.setProp(Scale.bind(RealProp.NewConst(r)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MarkerGO.m3#SetType">SetType</A> (o : GO.T; v : MarkerTypeProp.Kind);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetType(o,t)</CODE> is equivalent to
   <CODE>o.setProp(Type.bind(MarkerTypeProp.NewConst(t)))</CODE>. </EM></BLOCKQUOTE><PRE>

END MarkerGO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
