<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/MarkerGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/MarkerGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P><PRE>MODULE <module>MarkerGO</module> EXPORTS <A HREF="MarkerGO.i3"><implements>MarkerGO</A></implements>, <A HREF="MarkerGOProxy.i3"><implements>MarkerGOProxy</A></implements>;

IMPORT <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="ColorProp.i3">ColorProp</A>, <A HREF="ColorPropPrivate.i3">ColorPropPrivate</A>, <A HREF="GO.i3">GO</A>, <A HREF="GOPrivate.i3">GOPrivate</A>, <A HREF="GraphicsState.i3">GraphicsState</A>,
       <A HREF="GraphicsStatePrivate.i3">GraphicsStatePrivate</A>, <A HREF="MarkerTypeProp.i3">MarkerTypeProp</A>, <A HREF="MarkerTypePropPrivate.i3">MarkerTypePropPrivate</A>,
       <A HREF="Prop.i3">Prop</A>, <A HREF="PropPrivate.i3">PropPrivate</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="PointProp.i3">PointProp</A>, <A HREF="PointPropPrivate.i3">PointPropPrivate</A>, <A HREF="RealProp.i3">RealProp</A>,
       <A HREF="RealPropPrivate.i3">RealPropPrivate</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
  OVERRIDES
    init              := Init;
    draw              := Draw;
    damageIfDependent := DamageIfDependent;
    needsTransparency := NeedsTransparency;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(self : T) : T =
  BEGIN
    EVAL GO.T.init (self);

    IF MkProxyT # NIL AND self.proxy = NIL THEN
      MkProxyT (self);
    END;

    RETURN self;
  END Init;

PROCEDURE <A NAME="Draw"><procedure>Draw</procedure></A> (self : T; state : GraphicsState.T) =
  BEGIN
    state.push (self);
    WITH center = Center.getState (state) DO
      state.drawMarker (center);
      (*** The bounding sphere of every GO must have size &gt; 0 ***)
      state.growBoundingVolume (center, 1.0e-10);
    END;

    self.damaged := FALSE;
    state.pop (self);
  END Draw;

PROCEDURE <A NAME="DamageIfDependent"><procedure>DamageIfDependent</procedure></A> (self : T; pn : Prop.Name) =
  BEGIN
    IF pn = Center THEN
      self.damaged := TRUE;
    END;
  END DamageIfDependent;

PROCEDURE <A NAME="NeedsTransparency"><procedure>NeedsTransparency</procedure></A>(&lt;* UNUSED *&gt; self : T;
                            &lt;* UNUSED *&gt; t    : REAL) : BOOLEAN =
  BEGIN
    RETURN FALSE;
  END NeedsTransparency;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (p : Point3.T) : T =
  VAR
    marker := NEW (T).init ();
  BEGIN
    SetCenter (marker, p);
    RETURN marker;
  END New;
</PRE>***************************************************************************
 Colour_PN                                                                 
***************************************************************************

<P><PRE>TYPE
  Colour_PN = ColorProp.Name OBJECT
  OVERRIDES
    damage  := DamageColour;
    push    := PushColour;
    pop     := PopColour;
  END;

PROCEDURE <A NAME="DamageColour"><procedure>DamageColour</procedure></A> (&lt;* UNUSED *&gt; self : Colour_PN; caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageColour;

PROCEDURE <A NAME="PushColour"><procedure>PushColour</procedure></A> (self  : Colour_PN;
                      state : GraphicsState.T;
                      pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], ColorPropPrivate.Stack),
         val   = NARROW (pv, ColorProp.Val).val DO
      IF stack.top # val THEN
        state.setMarkerColor (val);
      END;
      stack.push (val);
    END;
  END PushColour;

PROCEDURE <A NAME="PopColour"><procedure>PopColour</procedure></A> (self : Colour_PN; state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], ColorPropPrivate.Stack) DO
      state.setMarkerColor (stack.pop ());
    END;
  END PopColour;
</PRE>***************************************************************************
 Scale_PN                                                                  
***************************************************************************

<P><PRE>TYPE
  Scale_PN = RealProp.Name OBJECT
  OVERRIDES
    damage  := DamageScale;
    push    := PushScale;
    pop     := PopScale;
  END;

PROCEDURE <A NAME="DamageScale"><procedure>DamageScale</procedure></A> (&lt;* UNUSED *&gt; self : Scale_PN; caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageScale;

PROCEDURE <A NAME="PushScale"><procedure>PushScale</procedure></A> (self  : Scale_PN;
                     state : GraphicsState.T;
                     pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RealPropPrivate.Stack),
         val   = NARROW (pv, RealProp.Val).val DO
      IF stack.top # val THEN
        state.setMarkerScale (val);
      END;
      stack.push (val);
    END;
  END PushScale;

PROCEDURE <A NAME="PopScale"><procedure>PopScale</procedure></A> (self : Scale_PN; state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], RealPropPrivate.Stack) DO
      state.setMarkerScale (stack.pop ());
    END;
  END PopScale;
</PRE>***************************************************************************
 Type_PN                                                                   
***************************************************************************

<P><PRE>TYPE
  Type_PN = MarkerTypeProp.Name OBJECT
  OVERRIDES
    damage  := DamageType;
    push    := PushType;
    pop     := PopType;
  END;

PROCEDURE <A NAME="DamageType"><procedure>DamageType</procedure></A> (&lt;* UNUSED *&gt; self : Type_PN; caller : GO.T) =
  BEGIN
    caller.damaged := TRUE;
  END DamageType;

PROCEDURE <A NAME="PushType"><procedure>PushType</procedure></A> (self  : Type_PN;
                    state : GraphicsState.T;
                    pv    : Prop.Val) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], MarkerTypePropPrivate.Stack),
         val   = NARROW (pv, MarkerTypeProp.Val).val DO
      IF stack.top # val THEN
        state.setMarkerType (val);
      END;
      stack.push (val);
    END;
  END PushType;

PROCEDURE <A NAME="PopType"><procedure>PopType</procedure></A> (self : Type_PN; state : GraphicsState.T) =
  BEGIN
    WITH stack = NARROW (state.stacks[self.id], MarkerTypePropPrivate.Stack) DO
      state.setMarkerType (stack.pop ());
    END;
  END PopType;
</PRE>***************************************************************************
 Convenience Procedures                                                    
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetCenter"><procedure>SetCenter</procedure></A> (o : GO.T; v : Point3.T) =
  BEGIN
    o.setProp (Center.bind (PointProp.NewConst (v)));
  END SetCenter;

PROCEDURE <A NAME="SetColour"><procedure>SetColour</procedure></A> (o : GO.T; v : Color.T) =
  BEGIN
    o.setProp (Colour.bind (ColorProp.NewConst (v)));
  END SetColour;

PROCEDURE <A NAME="SetScale"><procedure>SetScale</procedure></A> (o : GO.T; v : REAL) =
  BEGIN
    o.setProp (Scale.bind (RealProp.NewConst (v)));
  END SetScale;

PROCEDURE <A NAME="SetType"><procedure>SetType</procedure></A> (o : GO.T; v : MarkerTypeProp.Kind) =
  BEGIN
    o.setProp (Type.bind (MarkerTypeProp.NewConst (v)));
  END SetType;
</PRE>***************************************************************************
 Module Body                                                               
***************************************************************************

<P><PRE>BEGIN
  Center := NEW (PointProp.Name).init (Point3.T {0.0, 0.0, 0.0});
  Colour := NEW (Colour_PN).init (Color.White);
  Scale  := NEW (Scale_PN).init (1.0);
  Type   := NEW (Type_PN).init (MarkerTypeProp.Kind.Asterisk);
END MarkerGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
