<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/Matrix4.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/Matrix4.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Wed Mar 16 21:47:10 PST 1994 by najork                   

<P>
<P><PRE>INTERFACE <interface><A HREF="Matrix4.m3">Matrix4</A></interface>;

IMPORT <A HREF="Point3.i3">Point3</A>;

TYPE T   = ARRAY [0 .. 3] OF Row;
     Row = ARRAY [0 .. 3] OF REAL;

CONST Id = T {Row {1.0, 0.0, 0.0, 0.0},
              Row {0.0, 1.0, 0.0, 0.0},
              Row {0.0, 0.0, 1.0, 0.0},
              Row {0.0, 0.0, 0.0, 1.0}};

PROCEDURE <A HREF="Matrix4.m3#Multiply">Multiply</A> (READONLY M, N : T) : T;

PROCEDURE <A HREF="Matrix4.m3#Identity">Identity</A> () : T;
PROCEDURE <A HREF="Matrix4.m3#Translate">Translate</A> (READONLY M : T; x, y, z : REAL) : T;
PROCEDURE <A HREF="Matrix4.m3#Scale">Scale</A> (READONLY M : T; x, y, z : REAL) : T;
PROCEDURE <A HREF="Matrix4.m3#RotateX">RotateX</A> (READONLY M : T; theta : REAL) : T;
PROCEDURE <A HREF="Matrix4.m3#RotateY">RotateY</A> (READONLY M : T; theta : REAL) : T;
PROCEDURE <A HREF="Matrix4.m3#RotateZ">RotateZ</A> (READONLY M : T; theta : REAL) : T;
PROCEDURE <A HREF="Matrix4.m3#TransformPoint3">TransformPoint3</A> (READONLY M : T; READONLY p : Point3.T) : Point3.T;

PROCEDURE <A HREF="Matrix4.m3#TransformUnitCube">TransformUnitCube</A> (p, a, b, c : Point3.T) : T;
</PRE> This function is useful to map prototypes of geometric objects
   (circles, spheres, disks, cylinders, etc) onto actual instances.
   <CODE>TransformUnitCube(p,a,b,c)</CODE> returns a matrix <CODE>M</CODE>, such that
\begin{verbatim}
   TransformPoint3(M,Point3.T{0.0,0.0,0.0}) = p
   TransformPoint3(M,Point3.T{1.0,0.0,0.0}) = a
   TransformPoint3(M,Point3.T{0.0,1.0,0.0}) = b
   TransformPoint3(M,Point3.T{0.0,0.0,1.0}) = c
\end{verbatim}
<P>
   The above 4 equations over points define a system of linear equations, 
   which can be solved statically (i.e.\ no gaussian elimination is needed 
   at run time). So, calls to <CODE>TransformUnitCube</CODE> are very cheap.


<P><PRE>PROCEDURE <A HREF="Matrix4.m3#UnitSphereMaxSquishFactor">UnitSphereMaxSquishFactor</A> (READONLY M : T) : REAL;

EXCEPTION Error;

PROCEDURE <A HREF="Matrix4.m3#Decomp">Decomp</A> (M : T; VAR tx, ty, tz, s : REAL) : T RAISES {Error};
</PRE><BLOCKQUOTE><EM> <CODE>Decompose(M,tx,ty,tz,s,angX,angY,angZ)</CODE> takes a matrix <CODE>M</CODE>, which must 
   have been constructed by using only translations, rotations, and uniform(!)
   scalings, and returns values <CODE>tx</CODE>, <CODE>ty</CODE>, <CODE>tz</CODE>, <CODE>s</CODE>, and <CODE>R</CODE> such that 
   <CODE>M = T(tx,ty,tz) S(s) R</CODE> holds. If the initial matrix <CODE>M</CODE> was indeed 
   valid, then <CODE>R</CODE> is an orthogonal matrix. If <CODE>M</CODE> was not valid, then
   <CODE>Error</CODE> is raised. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Matrix4.m3#Transpose">Transpose</A> (READONLY M : T) : T;
</PRE><BLOCKQUOTE><EM> <CODE>Transpose(M)</CODE> takes a matrix <CODE>M</CODE> and returns its transpose. Note that 
   for an orthonormal matrix, its transpose is also its inverse. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Matrix4.m3#Equal">Equal</A> (READONLY A, B : T) : BOOLEAN;

PROCEDURE <A HREF="Matrix4.m3#Orthonormal">Orthonormal</A> (READONLY M : T) : BOOLEAN;
</PRE><BLOCKQUOTE><EM> <CODE>Orthonormal(M)</CODE> is true if the columns of <CODE>M</CODE> form an orthonormal basis. </EM></BLOCKQUOTE><PRE>

END Matrix4.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
