<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/MouseCB.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/MouseCB.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Fri Feb 18 09:37:37 PST 1994 by najork                   

<P>
<P> In accordance with the terminology used by Trestle, we refer to mouse 
   button transitions as to {\em mouse events}. A mouse event is represented
   by a record <CODE>MouseCB.Rec</CODE>.
<P>
   A {\em mouse event callback object} is an object which has one
   method, <CODE>invoke</CODE>. Each geometric object has a stack of mouse callback
   objects. When a mouse event <CODE>mr</CODE> is relayed to a particular geometric
   <CODE>o</CODE>, the the message <CODE>cb.invoke(mr)</CODE> is sent to the top callback
   object on <CODE>o</CODE>'s mouse callback stack (if <CODE>o</CODE>'s mouse callback stack is
   empty, the event is simply dropped). It is <CODE>cb</CODE>'s reponsibility to
   perform whatever action is appropriate in the current context. 

<P><PRE>INTERFACE <interface><A HREF="MouseCB.m3">MouseCB</A></interface>;

IMPORT <A HREF="CB.i3">CB</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="MouseCB.m3#T">T</A> &lt;: Public;
  Public = ProxiedObj.T OBJECT
  METHODS
    init () : T;
    invoke (mr : Rec) RAISES {CB.BadMethod};
  END;
</PRE><BLOCKQUOTE><EM> <CODE>MouseCB.T</CODE> is the abstract class of mouse callback objects. If <CODE>o</CODE> is a 
   geometric object, <CODE>c</CODE> is the top object in its mouse callback stack, and 
   a mouse event <CODE>mr</CODE> gets relayed to <CODE>o</CODE>, then <CODE>cb.invoke(mr)</CODE> will be called.
   It is up to the user to create subclasses of <CODE>MouseCB.T</CODE> that handle
   mouse events in a given context appropriately. </EM></BLOCKQUOTE><PRE>

  Rec = RECORD
    pos2D       : Point.T;
    whatChanged : VBT.Button;
    modifiers   : VBT.Modifiers;
    clickType   : VBT.ClickType;
  END;
</PRE><BLOCKQUOTE><EM> <CODE>MouseCB.Rec</CODE> is a record type containing information about a mouse event.
   <CODE>pos2D</CODE> is the position of the mouse when the button transition occurred.
   <CODE>whatChanged</CODE> is the button that went up or down.
   <CODE>modifiers</CODE> is the set of modifiers (Shift, Control, Mouse Buttons, etc.) 
   that was active when the transition took place.
   <CODE>clickType</CODE> indicates whether the button went down or up, and whether 
   any other button was already or still down.
<P>
   {\em NOTE: There is a fair chance that I will add other fields to <CODE>Rec</CODE>,
   once we have gained more experience with event handling. So far, I pretty
   much mimick (part of) what is there in <CODE>VBT.MouseRec</CODE>.} </EM></BLOCKQUOTE><PRE>

END MouseCB.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
