<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/OrthoCameraGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/OrthoCameraGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Mon Feb 14 16:01:56 PST 1994 by najork                   

<P>
<P><PRE>UNSAFE MODULE <module>OrthoCameraGO</module> EXPORTS <A HREF="OrthoCameraGO.i3"><implements>OrthoCameraGO</A></implements>, <A HREF="OrthoCameraGOProxy.i3"><implements>OrthoCameraGOProxy</A></implements>;

IMPORT <A HREF="CameraGO.i3">CameraGO</A>, <A HREF="CameraGOPrivate.i3">CameraGOPrivate</A>, <A HREF="GO.i3">GO</A>, <A HREF="GOPrivate.i3">GOPrivate</A>, <A HREF="GraphicsState.i3">GraphicsState</A>,
       <A HREF="GraphicsStatePex.i3">GraphicsStatePex</A>, <A HREF="Matrix4.i3">Matrix4</A>, <A HREF="Mth.i3">Mth</A>, <A HREF="../../PEX/src/PEX.i3">PEX</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="PointProp.i3">PointProp</A>,
       <A HREF="PointPropPrivate.i3">PointPropPrivate</A>, <A HREF="Prop.i3">Prop</A>, <A HREF="RealProp.i3">RealProp</A>, <A HREF="RealPropPrivate.i3">RealPropPrivate</A>, <A HREF="TransformPropPrivate.i3">TransformPropPrivate</A>;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (from, to, up : Point3.T; height : REAL) : T =
  VAR
    cam := NEW (T).init ();
  BEGIN
    cam.setProp (CameraGO.From.bind (PointProp.NewConst (from)));
    cam.setProp (CameraGO.To.bind (PointProp.NewConst (to)));
    cam.setProp (CameraGO.Up.bind (PointProp.NewConst (up)));
    cam.setProp (Height.bind (RealProp.NewConst (height)));
    RETURN cam;
  END New;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
    lookat   : PEX.pexMatrix;
    aspect   : REAL;
    height   : REAL;
  OVERRIDES
    init := Init;
    draw := Draw;
    view := View;
    damageIfDependent := DamageIfDependent;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T) : T =
  BEGIN
    EVAL CameraGO.T.init (self);

    IF MkProxyT # NIL AND self.proxy = NIL THEN
      MkProxyT (self);
    END;

    RETURN self;
  END Init;

PROCEDURE <A NAME="DamageIfDependent"><procedure>DamageIfDependent</procedure></A> (self : T; pn : Prop.Name) =
  BEGIN
    IF pn = CameraGO.From OR pn = CameraGO.To OR pn = CameraGO.Up OR
       pn = CameraGO.Aspect OR pn = Height OR pn = GO.Transform THEN
      self.damaged := TRUE;
    END;
  END DamageIfDependent;

PROCEDURE <A NAME="Draw"><procedure>Draw</procedure></A> (self : T; state : GraphicsState.T) =
  VAR
    from : Point3.T;
    to   : Point3.T;
    up   : Point3.T;
  BEGIN
    IF self.damaged THEN
      state.push (self);

      WITH tm = GO.Transform.getState (state) DO
        from := Matrix4.TransformPoint3 (tm, CameraGO.From.getState (state));
        to   := Matrix4.TransformPoint3 (tm, CameraGO.To.getState (state));
        up   := Matrix4.TransformPoint3 (tm, CameraGO.Up.getState (state));
        EVAL PEX.PEXLookatViewMatrix (ADR (from), ADR (to), ADR (up),
                                      ADR (self.lookat));
      END;
      (* If the transformation state contains a non-uniform matrix,
         the viewing parallelepiped might be distorted. In this case,
         it is not possible to determine a correct value for height ... *)

      self.flag   := TRUE;
      self.aspect := CameraGO.Aspect.getState (state);
      self.height := Height.getState (state);

      self.damaged := FALSE;
      state.pop (self);
    END;
  END Draw;

PROCEDURE <A NAME="View"><procedure>View</procedure></A> (self : T; state : GraphicsState.T) =
  VAR
    near : REAL;
    far  : REAL;
    view : PEX.pxlViewEntry;
  BEGIN
    self.flag := FALSE;

    view.clipFlags := 0;
    view.orientation := self.lookat;

    (*** map the bounding sphere into viewing coordinates ***)
    WITH bs = state.getBoundingVolume(),
         tm = self.lookat,
         center = Point3.T {
                      tm[0][0] * bs.center.x + tm[0][1] * bs.center.y +
                      tm[0][2] * bs.center.z + tm[0][3],
                      tm[1][0] * bs.center.x + tm[1][1] * bs.center.y +
                      tm[1][2] * bs.center.z + tm[1][3],
                      tm[2][0] * bs.center.x + tm[2][1] * bs.center.y +
                      tm[2][2] * bs.center.z + tm[2][3]},
         radius = bs.radius * Mth.sqrt (tm[0][0] * tm[0][0] +
                                        tm[1][0] * tm[1][0] +
                                        tm[2][0] * tm[2][0]) DO
      near := center.z + radius;
      far  := center.z - radius;
    END;

    (*** Compute the projection matrix. ***)
      EVAL PEX.PEXOrthoProjMatrix (FLOAT (self.height, LONGREAL),
                                   FLOAT (self.aspect, LONGREAL),
                                   FLOAT (near, LONGREAL),
                                   FLOAT (far, LONGREAL),
                                   ADR   (view.mapping));

    (* Install the view in the view lookup table, and write
       its index into the camera output command buffer. *)

    PEX.PEXSetTableEntries (state.disp, state.viewLut, PEX.PEXViewLUT, 1, 1,
                            ADR (view));
    PEX.PEXSetViewIndex (state.camOcBuf, 1);
  END View;
</PRE>***************************************************************************
 Module body                                                               
***************************************************************************

<P>
<P><PRE>BEGIN
  Height := NEW (RealProp.Name).init (10.0);
END OrthoCameraGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
