<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/PerspCameraGO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/PerspCameraGO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Thu Feb 10 11:51:21 PST 1994 by najork                   

<P> A <CODE>PerspCameraGO.T</CODE> is a perspective camera, i.e.\ a camera which shows 
   a scene from a certain point (and depicts perspective relations naturally).
   The volume of space observed by such a camera forms an (infinitely high) 
   pyramid. The shape of the pyramid is determined by the following parameters:
   \begin{itemize}
   \item The position of the camera (which determines the tip of the pyramid)
   \item A point on the central viewing axis (which determines the vertical
         axis of the pyramid)
   \item The up-vector (which rotates the pyramid around its vertical axis)
   \item The field of vision (the angle between the ``up'' and the ``down''
         wall of the pyramid)
   \item The aspect ratio (the ratio between height and width of any
         cross-section of the pyramid)
   \end{itemize}
<P>
   The figure below illustrates the role of the parameters:
   <P>
   \begin{center}
   \begin{tabular}{c}
   \psfig{figure=images/PerspCamera.ps,width=4in,silent=} 
   \end{tabular}
   \end{center}


<P><PRE>INTERFACE <interface><A HREF="PerspCameraGO.m3">PerspCameraGO</A></interface>;

IMPORT <A HREF="CameraGO.i3">CameraGO</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="RealProp.i3">RealProp</A>;

TYPE
  <A HREF="PerspCameraGO.m3#T">T</A> &lt;: Public;
  Public = CameraGO.T OBJECT
  METHODS
    init () : T;
  END;
</PRE><BLOCKQUOTE><EM> <CODE>pc.init()</CODE> initializes a new perspective camera and returns it. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="PerspCameraGO.m3#New">New</A> (from, to, up : Point3.T; fovy : REAL) : T;
</PRE><BLOCKQUOTE><EM> <CODE>New(from,to,up,fovy)</CODE> creates a new perspective camera <CODE>cam</CODE> and 
   returns it. It also attaches the following properties to <CODE>cam</CODE>:
   \begin{verbatim}
      (CameraGO.From,PointProp.NewConst(from))
      (CameraGO.To,PointProp.NewConst(to))
      (CameraGO.Up,PointProp.NewConst(up))
      (CameraGO.Aspect,RealProp.NewConst(1.0))
      (Fovy,RealProp.NewConst(fovy))
   \end{verbatim}
</EM></BLOCKQUOTE><PRE>

VAR
  Fovy : RealProp.Name;
</PRE><BLOCKQUOTE><EM> In addition to the properties observed by all \type{GO}{T}'s and 
   \type{CameraGO}{T}'s, there is one additional property that is observed 
   by <CODE>PerspCameraGO.T</CODE>'s. 
   <CODE>Fovy</CODE> is the name of a property that determines the field-of-vision,
   i.e.\ the angle (in degree radians) between the ``up'' and the ``down''
   wall of the pyramid; it associates with a property value of type 
   \type{RealProp}{Val}. The angle between ``left'' and ``right'' wall is 
   determined by the aspect ratio. </EM></BLOCKQUOTE><PRE>

END PerspCameraGO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
