<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/Point3.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/Point3.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P> A <CODE>Point3.T</CODE> is a point in 3-space. It is represented as a record 
   with three components, <CODE>x</CODE>, <CODE>y</CODE>, and <CODE>z</CODE>, all holding real values. 

<P><PRE>INTERFACE <interface><A HREF="Point3.m3">Point3</A></interface>;

TYPE
  T = RECORD
    x,y,z : REAL;
  END;

CONST
  Origin = T {0.0, 0.0, 0.0};
  Min    = T {FIRST(REAL), FIRST(REAL), FIRST(REAL)};
  Max    = T {LAST (REAL), LAST (REAL), LAST (REAL)};
</PRE><BLOCKQUOTE><EM> <CODE>Origin</CODE> is the origin of the coordinate system. <CODE>Min</CODE> and <CODE>Max</CODE> are used 
   in bounding box calculations to represent imaginary smallest and largest
   points. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point3.m3#Plus">Plus</A> (a, b : T) : T;
</PRE><BLOCKQUOTE><EM> <CODE>Plus(a,b)</CODE> returns the sum of the points <CODE>a</CODE> and <CODE>b</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point3.m3#Minus">Minus</A> (a, b : T) : T;
</PRE><BLOCKQUOTE><EM> <CODE>Minus(a,b)</CODE> returns the difference between <CODE>a</CODE> and <CODE>b</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point3.m3#TimesScalar">TimesScalar</A> (a : T; x : REAL) : T;
</PRE><BLOCKQUOTE><EM> <CODE>TimesScalar(a,s)</CODE> returns <CODE>a</CODE> with each component 
   multiplied with the scalar value <CODE>s</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point3.m3#MidPoint">MidPoint</A> (a, b : T) : T;
</PRE><BLOCKQUOTE><EM> <CODE>MidPoint(a,b)</CODE> returns the point in the middle between <CODE>a</CODE> and <CODE>b</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point3.m3#Distance">Distance</A> (a, b : T) : REAL;
</PRE><BLOCKQUOTE><EM> <CODE>Distance(a,b)</CODE> returns the distance between <CODE>a</CODE> and <CODE>b</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point3.m3#ToText">ToText</A> (a : T) : TEXT;
</PRE><BLOCKQUOTE><EM> <CODE>ToText(a)</CODE> returns a textual representation of <CODE>a</CODE>; for example,
   <CODE>ToText(T{2.0,3.0,5.0})</CODE> returns the text <CODE>(2.0,3.0,5.0)</CODE> .</EM></BLOCKQUOTE><PRE>
</PRE> The remaining operations interpret their arguments as vectors, not as
   points. The vector <CODE>a</CODE> is the vector going from the origin to point <CODE>a</CODE>. 

<P><PRE>PROCEDURE <A HREF="Point3.m3#Length">Length</A> (a : T) : REAL;
</PRE><BLOCKQUOTE><EM> <CODE>Length(a)</CODE> returns the length of the vector <CODE>a</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point3.m3#DotProduct">DotProduct</A> (a, b : T) : REAL;
</PRE><BLOCKQUOTE><EM> Returns the dot product of <CODE>a</CODE> and <CODE>b</CODE>. See [Foley] p. 1094ff for an 
   explanation of the geometric significance of dot products. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point3.m3#CrossProduct">CrossProduct</A> (a, b : T) : T;
</PRE><BLOCKQUOTE><EM> Returns the cross product of <CODE>a</CODE> and <CODE>b</CODE>. See [Foley] p. 1104ff for an 
   explanation of the geometric significance of cross products. One important
   property is that $a \times b$ is orthogonal to the plane described by the
   vectors <CODE>a</CODE> and <CODE>b</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point3.m3#OrthoVector">OrthoVector</A> (a : T) : T;
</PRE><BLOCKQUOTE><EM> Returns a unit vector which is orthogonal to <CODE>n</CODE>. There are infinitely many
   such vectors, <CODE>OrthoVector</CODE> will return one of them. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Point3.m3#ScaleToLen">ScaleToLen</A> (a : T; len : REAL) : T;
</PRE><BLOCKQUOTE><EM> Returns a vector parallel to <CODE>a</CODE> with length <CODE>len</CODE>. </EM></BLOCKQUOTE><PRE>

END Point3.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
