<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/Point3.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/Point3.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P><PRE>MODULE <module><implements><A HREF="Point3.i3">Point3</A></implements></module>;

IMPORT <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../arith/src/Math.i3">Math</A>, <A HREF="Mth.i3">Mth</A>, <A HREF="../../os/src/Common/Process.i3">Process</A>;

PROCEDURE <A NAME="Plus"><procedure>Plus</procedure></A> (a, b : T) : T =
  BEGIN
    RETURN T{a.x + b.x, a.y + b.y, a.z + b.z};
  END Plus;

PROCEDURE <A NAME="Minus"><procedure>Minus</procedure></A> (a, b : T) : T =
  BEGIN
    RETURN T{a.x - b.x, a.y - b.y, a.z - b.z};
  END Minus;

PROCEDURE <A NAME="TimesScalar"><procedure>TimesScalar</procedure></A> (a : T; x : REAL) : T =
  BEGIN
    RETURN T{a.x * x, a.y * x, a.z * x};
  END TimesScalar;

PROCEDURE <A NAME="MidPoint"><procedure>MidPoint</procedure></A> (a, b : T) : T =
  BEGIN
    RETURN T {a.x + (b.x - a.x) / 2.0,
              a.y + (b.y - a.y) / 2.0,
              a.z + (b.z - a.z) / 2.0};
  END MidPoint;

PROCEDURE <A NAME="Distance"><procedure>Distance</procedure></A> (a, b : T) : REAL =
  BEGIN
    WITH dx = b.x - a.x, dy = b.y - a.y, dz = b.z - a.z DO
      RETURN FLOAT (Math.sqrt (FLOAT (dx * dx + dy * dy + dz * dz, LONGREAL)));
    END;
  END Distance;

PROCEDURE <A NAME="ToText"><procedure>ToText</procedure></A> (a : T) : TEXT =
  BEGIN
    RETURN &quot;(&quot; &amp; Fmt.Real (a.x) &amp;
           &quot;,&quot; &amp; Fmt.Real (a.y) &amp;
           &quot;,&quot; &amp; Fmt.Real (a.z) &amp;
           &quot;)&quot;;
  END ToText;

PROCEDURE <A NAME="Length"><procedure>Length</procedure></A> (p : T) : REAL =
  BEGIN
    RETURN Mth.sqrt (p.x * p.x + p.y * p.y + p.z * p.z);
  END Length;

PROCEDURE <A NAME="DotProduct"><procedure>DotProduct</procedure></A> (a, b : T) : REAL =
  BEGIN
    RETURN a.x * b.x + a.y * b.y + a.z * b.z;
  END DotProduct;

PROCEDURE <A NAME="CrossProduct"><procedure>CrossProduct</procedure></A> (a, b : T) : T =
  BEGIN
    RETURN T {a.y * b.z - a.z * b.y,
              a.z * b.x - a.x * b.z,
              a.x * b.y - a.y * b.x};
  END CrossProduct;

PROCEDURE <A NAME="OrthoVector"><procedure>OrthoVector</procedure></A> (n : T) : T =
  (* We are looking for a unit vector &quot;m&quot; that is orthogonal to &quot;n&quot;. So, we
     have the following two equations to start with:
     (1) &quot;m&quot; orthogonal &quot;n&quot;, so &quot;DotProduct(m,n)&quot; = 0,
         so m.x * n.x + m.y * n.y + m.z * n.z = 0
     (2) &quot;m&quot; is a unit vector, so sqrt(m.x^2 + m.y^2 + m.z^2) = 1
     So we have 3 unknowns (m.x, m.y, and m.z) and 3 equations, leaving us
     with one degree of freedom.
     If n.x # 0, and we set m.z to 0, we can solve the system to:
        m.xx = 1 / sqrt(1 + (n.x^2 / n.y^2))
        m.y = - (n.x / n.y) / sqrt(1 + (n.x^2 / n.y^2))
     The cases for n.y # 0 and n.z = 0 are similar.
     Passing n = Origin is a fatal error.
  *)
  BEGIN
    IF n.x # 0.0 THEN
      WITH p = n.y / n.x, sub = 1.0 / Mth.sqrt (1.0 + p * p) DO
        RETURN T {-p * sub, sub, 0.0};
      END;
    ELSIF n.y # 0.0 THEN
      WITH p = n.x / n.y, sub = 1.0 / Mth.sqrt (1.0 + p * p) DO
        RETURN T {sub, -p * sub, 0.0};
      END;
    ELSIF n.z # 0.0 THEN
      WITH p = n.x / n.z, sub = 1.0 / Mth.sqrt (1.0 + p * p) DO
        RETURN T {sub, 0.0, -p * sub};
      END;
    ELSE
      Process.Crash (&quot;Fatal Error: called OrthoVector(Origin) \n&quot;);
      RETURN Origin;      (* ... only to suppress compiler warnings *)
    END;
  END OrthoVector;

PROCEDURE <A NAME="ScaleToLen"><procedure>ScaleToLen</procedure></A> (p : T; len : REAL) : T =
  BEGIN
    WITH l = len / Mth.sqrt (p.x * p.x + p.y * p.y + p.z * p.z) DO
      RETURN T {p.x * l, p.y * l, p.z * l};
    END;
  END ScaleToLen;

BEGIN
END Point3.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
