<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/PointLightGO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/PointLightGO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Fri Feb  4 15:25:53 PST 1994 by najork                   

<P>
<P> A <CODE>PointLightGO.T</CODE> is a geometric object that describes a point-shaped 
   light source which is emitting light uniformly into all directions. The
   amount of light that falls onto another geometric object depends on the 
   distance between this object and the light source. This phenomenon is 
   referred to as {\em attenuation}. 
<P>
   The underlying graphics system (PEX or OpenGL) uses the following formula
   to compute the attenuation: Let\\
   $L_p$ : Position of the light source \\
   $O_p$ : position of (some part of) an object \\
   $C_0$ : Constant attenuation coefficieny \\
   $C_1$ : Linear attenuation coefficieny \\
   Then the overall color attenuation factor $L_a$ for the light hitting the
   object at point $O_p$ is:
   \[ \frac{1}{C_0 + C_1 | O_p - L_p | } \]
<P>
   This attenuation model is supported by both PEX and OpenGL (in hardware). 
   Note, however, that it does not capure real-world attenuation, which
   behaves like this:
   \[ L_a = \frac{1}{| O_p - L_p |^2 } \]
<P>
   OpenGL supports a third, quadratic, attenuation coefficient; PEX, however,
   does not. As lighting computation is (and, for efficiency reasons, must be)
   supported by the graphics hardware, and as right now PEX is the only API 
   to our hardware, we are stuck with its simplistic model.


<P><PRE>INTERFACE <interface><A HREF="PointLightGO.m3">PointLightGO</A></interface>;

IMPORT <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="GO.i3">GO</A>, <A HREF="LightGO.i3">LightGO</A>, <A HREF="PointProp.i3">PointProp</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="RealProp.i3">RealProp</A>;

TYPE
  <A HREF="PointLightGO.m3#T">T</A> &lt;: Public;
  Public = LightGO.T OBJECT
  METHODS
    init () : T;
  END;
</PRE><BLOCKQUOTE><EM> <CODE>l.init()</CODE> initializes a new point light source <CODE>l</CODE> and returns it. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="PointLightGO.m3#New">New</A> (c : Color.T; origin : Point3.T; att0, att1 : REAL) : T;
</PRE><BLOCKQUOTE><EM> <CODE>New(c,origin,att0,att1)</CODE> initializes a new point light source <CODE>l</CODE> 
   and returns it. It also attaches the following properties to <CODE>l</CODE>:
   \begin{verbatim}
      (LightGO.Colour,ColourProp.NewConst(c)) 
      (LightGO.Switch,BooleanProp.NewConst(TRUE))
      (Origin,PointProp.NewConst(dir))
      (Attenuation0,RealProp.NewConst(att0))
      (Attenuation1,RealProp.NewConst(att1))
   \end{verbatim}
</EM></BLOCKQUOTE><PRE>

VAR
  Origin       : PointProp.Name;
  Attenuation0 : RealProp.Name;
  Attenuation1 : RealProp.Name;
</PRE><BLOCKQUOTE><EM> In addition to the properties observed by all \type{GO}{T}'s and 
   \type{LightGO}{T}'s, there are three additional properties that are 
   observed by <CODE>PointLightGO.T</CODE>'s. 
   <CODE>Origin</CODE> is the name of a property that determines the origin 
   of the light emitted by the light sources; it associates with a property 
   value of type \type{PointProp}{Val}. 
   <CODE>Attenuation0</CODE> is the name of a property that determines the attenuation 
   coefficient $C_0$; it associates with a property value of type 
   \type{RealProp}{Val}. 
   <CODE>Attenuation1</CODE> is the name of a property that determines the attenuation 
   coefficient $C_1$; it associates with a property value of type 
   \type{RealProp}{Val}. 
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="PointLightGO.m3#SetOrigin">SetOrigin</A> (o : GO.T; origin : Point3.T);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetOrigin(o,origin)</CODE> is equivalent to 
   <CODE>o.setProp(Origin.bind(PointProp.NewConst(origin)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="PointLightGO.m3#SetAttenuation0">SetAttenuation0</A> (o : GO.T; att : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetAttenuation0(o,att)</CODE> is equivalent to 
   <CODE>o.setProp(Attenuation0.bind(RealProp.NewConst(att)))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="PointLightGO.m3#SetAttenuation1">SetAttenuation1</A> (o : GO.T; att : REAL);
</PRE><BLOCKQUOTE><EM> The expression <CODE>SetAttenuation1(o,att)</CODE> is equivalent to 
   <CODE>o.setProp(Attenuation1.bind(RealProp.NewConst(att)))</CODE>. </EM></BLOCKQUOTE><PRE>

END PointLightGO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
