<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/PointLightGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/PointLightGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Thu Feb 10 09:11:51 PST 1994 by najork                   

<P>
<P><PRE>UNSAFE MODULE <module>PointLightGO</module> EXPORTS <A HREF="PointLightGO.i3"><implements>PointLightGO</A></implements>, <A HREF="PointLightGOProxy.i3"><implements>PointLightGOProxy</A></implements>;

IMPORT <A HREF="AuxG.i3">AuxG</A>, <A HREF="BooleanPropPrivate.i3">BooleanPropPrivate</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="ColorPropPrivate.i3">ColorPropPrivate</A>, <A HREF="GO.i3">GO</A>, <A HREF="GOPrivate.i3">GOPrivate</A>,
       <A HREF="GraphicsState.i3">GraphicsState</A>, <A HREF="GraphicsStatePex.i3">GraphicsStatePex</A>, <A HREF="LightGO.i3">LightGO</A>, <A HREF="../../PEX/src/PEX.i3">PEX</A>, <A HREF="Point3.i3">Point3</A>,
       <A HREF="PointProp.i3">PointProp</A>, <A HREF="PointPropPrivate.i3">PointPropPrivate</A>, <A HREF="Prop.i3">Prop</A>, <A HREF="RealProp.i3">RealProp</A>, <A HREF="RealPropPrivate.i3">RealPropPrivate</A>,
       <A HREF="TransformPropPrivate.i3">TransformPropPrivate</A>;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (c : Color.T; p : Point3.T; att0, att1 : REAL) : T =
  VAR
    light := NEW (T).init ();
  BEGIN
    LightGO.SetColour (light, c);
    LightGO.SetSwitch (light, TRUE);
    SetOrigin (light, p);
    SetAttenuation0 (light, att0);
    SetAttenuation1 (light, att1);
    RETURN light;
  END New;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
  OVERRIDES
    init              := Init;
    draw              := Draw;
    damageIfDependent := DamageIfDependent;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T) : T =
  BEGIN
    EVAL GO.T.init (self);

    IF MkProxyT # NIL AND self.proxy = NIL THEN
      MkProxyT (self);
    END;

    RETURN self;
  END Init;

PROCEDURE <A NAME="DamageIfDependent"><procedure>DamageIfDependent</procedure></A> (self : T; pn : Prop.Name) =
  BEGIN
    IF pn = LightGO.Switch OR pn = LightGO.Colour OR pn = GO.Transform OR
       pn = Origin OR pn = Attenuation0 OR pn = Attenuation1 THEN
      self.damaged := TRUE;
    END;
  END DamageIfDependent;

PROCEDURE <A NAME="Draw"><procedure>Draw</procedure></A> (self : T; state : GraphicsState.T) =
  VAR
    color : Color.T;
    p     : Point3.T;
    att0  : REAL;
    att1  : REAL;
    light : PEX.pxlLightEntry;
    tm    : PEX.pexMatrix;
  BEGIN
    state.push (self);

    (* Get the current light status from the state. If the switch is off,
       we don't need to do anything *)
    IF LightGO.Switch.getState (state) THEN

      (* Get the current point light parameters from the state *)
      color := LightGO.Colour.getState (state);
      p     := Origin.getState (state);
      att0  := Attenuation0.getState (state);
      att1  := Attenuation1.getState (state);

      (* Get the current value of the transformation property. *)
      tm := GO.Transform.getState (state);

      (* Transform the origin into world coordinate space. *)

      &lt;* ASSERT tm[3][0] = 0.0 AND tm[3][1] = 0.0 AND
                tm[3][2] = 0.0 AND tm[3][3] = 1.0 *&gt;

      p := Point3.T {
               tm[0][0] * p.x + tm[0][1] * p.y + tm[0][2] * p.z + tm[0][3],
               tm[1][0] * p.x + tm[1][1] * p.y + tm[1][2] * p.z + tm[1][3],
               tm[2][0] * p.x + tm[2][1] * p.y + tm[2][2] * p.z + tm[2][3]};

      (* Build a PEX light structure *)
      light.lightType    := PEX.PEXLightWcsPoint;
      light.lightColour  := AuxG.MkRgbFloatColour (color);
      light.point        := p;
      light.attenuation1 := att0;
      light.attenuation2 := att1;

      (* Add the light to the graphics state's light set *)
      state.addLight (light);
    END;

    self.damaged := FALSE;
    state.pop (self);
  END Draw;
</PRE>***************************************************************************
 Convenience Procedures                                                    
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetOrigin"><procedure>SetOrigin</procedure></A> (o : GO.T; v : Point3.T) =
  BEGIN
    o.setProp (Origin.bind (PointProp.NewConst (v)));
  END SetOrigin;

PROCEDURE <A NAME="SetAttenuation0"><procedure>SetAttenuation0</procedure></A> (o : GO.T; v : REAL) =
  BEGIN
    o.setProp (Attenuation0.bind (RealProp.NewConst (v)));
  END SetAttenuation0;

PROCEDURE <A NAME="SetAttenuation1"><procedure>SetAttenuation1</procedure></A> (o : GO.T; v : REAL) =
  BEGIN
    o.setProp (Attenuation1.bind (RealProp.NewConst (v)));
  END SetAttenuation1;

BEGIN
  Origin       := NEW (PointProp.Name).init (Point3.T {0.0, 0.0, 0.0});
  Attenuation0 := NEW (RealProp.Name).init (1.0);
  Attenuation1 := NEW (RealProp.Name).init (1.0);
END PointLightGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
