<HTML>
<HEAD>
<TITLE>SRC Modula-3: anim3D/src/PolygonGO.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>anim3D/src/PolygonGO.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> Created by Marc Najork                                                    

<P>
<P> A <CODE>PolygonGO.T</CODE> is a geometric object that describes a polygon. 

<P><PRE>INTERFACE <interface><A HREF="PolygonGO.m3">PolygonGO</A></interface>;

IMPORT <A HREF="GO.i3">GO</A>, <A HREF="Point3.i3">Point3</A>, <A HREF="PointProp.i3">PointProp</A>, <A HREF="SurfaceGO.i3">SurfaceGO</A>;

TYPE <A HREF="PolygonGO.m3#T">T</A> &lt;: SurfaceGO.T;

PROCEDURE <A HREF="PolygonGO.m3#NewStatic">NewStatic</A> (READONLY pts : ARRAY OF Point3.T;
                     s := GO.Shape.Unknown) : T;
</PRE><BLOCKQUOTE><EM> Creates a new polygon <CODE>pg</CODE> and returns it. <CODE>pg</CODE> is defined by the array of 
   points <CODE>pts</CODE>. <CODE>s</CODE> is a ``shape hint'', i.e.\ a hint whether the polygon is 
   convex, non-convex, or complex. Refer to the \interface{GO} interface 
   for details on shape hints. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="PolygonGO.m3#New">New</A> (READONLY pts : ARRAY OF PointProp.Val;
               s := GO.Shape.Unknown) : T;
</PRE><BLOCKQUOTE><EM> Creates a new polygon <CODE>pg</CODE> and returns it. The point property values in 
   <CODE>pts</CODE> are used as the corner points of the polygon. The optional argument 
   <CODE>s</CODE> indicates the shape of the polygon. </EM></BLOCKQUOTE><PRE>
</PRE> {\sl 
     Note: Things would be even more general if we could dynamically add 
     points to a polygon or remove them. One idea would be to introduce 
     a new property value <CODE>PointSequenceProp.Val</CODE>, which contains an array 
     of <CODE>PointProp.Val</CODE>'s. <CODE>PointSequence</CODE> should be non-animatable, but 
     provide methods to access its elements. For <CODE>QuadMeshGO.T</CODE>'s, there 
     should be similar types <CODE>PointField</CODE> and <CODE>ColorField</CODE>.
   } 

<P><PRE>END PolygonGO.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
